/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ExcludeCompilerOutputPolicy
implements DirectoryIndexExcludePolicy {
    private final Project myProject;

    public ExcludeCompilerOutputPolicy(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean isExcludeRoot(VirtualFile file) {
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.myProject);
        if (ExcludeCompilerOutputPolicy.isEqualWithFileOrUrl(file, compilerProjectExtension.getCompilerOutput(), compilerProjectExtension.getCompilerOutputUrl())) {
            return true;
        }
        for (Module m : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            CompilerModuleExtension rm = CompilerModuleExtension.getInstance((Module)m);
            if (ExcludeCompilerOutputPolicy.isEqualWithFileOrUrl(file, rm.getCompilerOutputPath(), rm.getCompilerOutputUrl())) {
                return true;
            }
            if (!ExcludeCompilerOutputPolicy.isEqualWithFileOrUrl(file, rm.getCompilerOutputPathForTests(), rm.getCompilerOutputUrlForTests())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExcludeRootForModule(@NotNull Module module, VirtualFile excludeRoot) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ExcludeCompilerOutputPolicy", "isExcludeRootForModule"));
        }
        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
        return Comparing.equal((Object)compilerModuleExtension.getCompilerOutputPath(), (Object)excludeRoot) || Comparing.equal((Object)compilerModuleExtension.getCompilerOutputPathForTests(), (Object)excludeRoot);
    }

    @Override
    @NotNull
    public VirtualFile[] getExcludeRootsForProject() {
        VirtualFile outputPath = CompilerProjectExtension.getInstance((Project)this.myProject).getCompilerOutput();
        if (outputPath != null) {
            VirtualFile[] virtualFileArray = new VirtualFile[]{outputPath};
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ExcludeCompilerOutputPolicy", "getExcludeRootsForProject"));
            }
            return virtualFileArray;
        }
        if (VirtualFile.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ExcludeCompilerOutputPolicy", "getExcludeRootsForProject"));
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public VirtualFilePointer[] getExcludeRootsForModule(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/ExcludeCompilerOutputPolicy", "getExcludeRootsForModule"));
        }
        ArrayList result = new ArrayList();
        CompilerModuleExtension extension = (CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            if (VirtualFilePointer.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ExcludeCompilerOutputPolicy", "getExcludeRootsForModule"));
            }
            return VirtualFilePointer.EMPTY_ARRAY;
        }
        if (extension.isCompilerOutputPathInherited()) {
            ContainerUtil.addIfNotNull(result, (Object)CompilerProjectExtension.getInstance((Project)this.myProject).getCompilerOutputPointer());
        } else {
            if (!extension.isExcludeOutput()) {
                if (VirtualFilePointer.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ExcludeCompilerOutputPolicy", "getExcludeRootsForModule"));
                }
                return VirtualFilePointer.EMPTY_ARRAY;
            }
            ContainerUtil.addIfNotNull(result, (Object)extension.getCompilerOutputPointer());
            ContainerUtil.addIfNotNull(result, (Object)extension.getCompilerOutputForTestsPointer());
        }
        VirtualFilePointer[] virtualFilePointerArray = result.isEmpty() ? VirtualFilePointer.EMPTY_ARRAY : result.toArray(new VirtualFilePointer[result.size()]);
        if (virtualFilePointerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ExcludeCompilerOutputPolicy", "getExcludeRootsForModule"));
        }
        return virtualFilePointerArray;
    }

    private static boolean isEqualWithFileOrUrl(VirtualFile file, VirtualFile fileToCompareWith, String url) {
        return fileToCompareWith != null ? Comparing.equal((Object)fileToCompareWith, (Object)file) : url != null && FileUtil.pathsEqual((String)url, (String)file.getUrl());
    }
}

