/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootAdapter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectionQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class DirectoryIndexImpl
extends DirectoryIndex {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.DirectoryIndexImpl");
    private static final boolean CHECK = ApplicationManager.getApplication().isUnitTestMode();
    private static final TObjectHashingStrategy<int[]> INT_ARRAY_STRATEGY = new TObjectHashingStrategy<int[]>(){

        public int computeHashCode(int[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(int[] o1, int[] o2) {
            return Arrays.equals(o1, o2);
        }
    };
    private final ManagingFS myPersistence;
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private final DirectoryIndexExcludePolicy[] myExcludePolicies;
    private volatile IndexState myState;
    private volatile boolean myInitialized;
    private volatile boolean myDisposed;
    private final PackageSink mySink;
    private static final boolean ourUseRootIndexOnly = Registry.is((String)"directory.index.use.root.index");
    private static final boolean ourCompareImplementations = Registry.is((String)"directory.index.compare.implementations");
    private volatile RootIndex myRootIndex;
    private static final int MAX_DEPTH_TO_COUNT = 20;
    private static final int DIRECTORIES_CHANGED_THRESHOLD = 50;

    public DirectoryIndexImpl(@NotNull ManagingFS managingFS, @NotNull Project project, @NotNull StartupManager startupManager) {
        if (managingFS == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "<init>"));
        }
        if (startupManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "<init>"));
        }
        this.myState = new IndexState();
        this.myInitialized = false;
        this.myDisposed = false;
        this.mySink = new PackageSink();
        this.myRootIndex = null;
        this.myPersistence = managingFS;
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect((Disposable)project);
        this.myExcludePolicies = (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.myProject);
        startupManager.registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                DirectoryIndexImpl.this.initialize();
            }
        });
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                DirectoryIndexImpl.this.myDisposed = true;
                DirectoryIndexImpl.this.myState.multiDirPackages.clear();
                DirectoryIndexImpl.this.myState.myDirToInfoMap.clear();
                DirectoryIndexImpl.this.myState.myDirToPackageName.clear();
                DirectoryIndexImpl.this.myState.myExcludeRootsMap.clear();
                DirectoryIndexImpl.this.myState.myPackageNameToDirsMap.clear();
                DirectoryIndexImpl.this.myState.myProjectExcludeRoots.clear();
                DirectoryIndexImpl.this.myState.myRootTypeId.clear();
                DirectoryIndexImpl.this.myState.myRootTypes.clear();
                DirectoryIndexImpl.this.myRootIndex = null;
            }
        });
    }

    public void initialize() {
        this.subscribeToFileChanges();
        if (this.myInitialized) {
            LOG.error("Directory index is already initialized.");
            return;
        }
        if (this.myDisposed) {
            LOG.error("Directory index is already disposed for this project");
            return;
        }
        this.myInitialized = true;
        long l = System.currentTimeMillis();
        this.doInitialize();
        LOG.info("Directory index initialized in " + (System.currentTimeMillis() - l) + " ms, indexed " + this.myState.myDirToInfoMap.size() + " directories");
        this.markContentRootsForRefresh();
    }

    private void subscribeToFileChanges() {
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener.Adapter(){

            public void fileTypesChanged(FileTypeEvent event) {
                DirectoryIndexImpl.this.doInitialize();
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootAdapter(){

            public void rootsChanged(ModuleRootEvent event) {
                DirectoryIndexImpl.this.doInitialize();
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyVirtualFileListener());
    }

    private void markContentRootsForRefresh() {
        Module[] modules;
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            VirtualFile[] contentRoots;
            for (VirtualFile contentRoot : contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (!(contentRoot instanceof NewVirtualFile)) continue;
                ((NewVirtualFile)contentRoot).markDirtyRecursively();
            }
        }
    }

    private void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    private void replaceState(IndexState newState) {
        newState.writable = false;
        this.myState = newState;
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getDirectoriesByPackageName"));
        }
        RootIndex rootIndex = this.getRootIndex();
        if (rootIndex != null) {
            List<VirtualFile> riResult = rootIndex.getDirectoriesByPackageName(packageName, includeLibrarySources);
            if (ourUseRootIndexOnly) {
                CollectionQuery collectionQuery = new CollectionQuery(riResult);
                if (collectionQuery == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getDirectoriesByPackageName"));
                }
                return collectionQuery;
            }
            Query<VirtualFile> standardResult = this.mySink.search(packageName, includeLibrarySources);
            Collection standard = standardResult.findAll();
            if (!new HashSet<VirtualFile>(riResult).equals(new HashSet(standard))) {
                for (VirtualFile file : standard) {
                    String path = file.getPath();
                    if (!path.substring(path.length() - packageName.length()).contains(".")) continue;
                    Query<VirtualFile> query = standardResult;
                    if (query == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getDirectoriesByPackageName"));
                    }
                    return query;
                }
                this.assertConsistentResult(packageName, riResult, standard);
            }
        }
        Query<VirtualFile> query = this.mySink.search(packageName, includeLibrarySources);
        if (query == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getDirectoriesByPackageName"));
        }
        return query;
    }

    @Nullable
    private RootIndex getRootIndex() {
        if (!ourUseRootIndexOnly && !ourCompareImplementations) {
            return null;
        }
        RootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject);
        }
        return rootIndex;
    }

    @Override
    public void checkConsistency() {
        RootIndex rootIndex = this.getRootIndex();
        if (rootIndex != null) {
            rootIndex.checkConsistency();
        }
        if (ourUseRootIndexOnly) {
            return;
        }
        this.doCheckConsistency(false);
        this.doCheckConsistency(true);
    }

    public void assertAncestorConsistent() {
        this.myState.assertAncestorsConsistent();
    }

    private void doCheckConsistency(boolean reverseAllSets) {
        assert (this.myInitialized);
        assert (!this.myDisposed);
        this.myState.assertNotWritable();
        final IndexState oldState = this.myState;
        this.myState.assertAncestorsConsistent();
        this.replaceState(this.myState.copy(null));
        this.myState.writable = true;
        this.myState.doInitialize(reverseAllSets);
        this.myState.writable = false;
        int[] keySet = this.myState.myDirToInfoMap.keys();
        assert (keySet.length == oldState.myDirToInfoMap.keys().length);
        for (int file : keySet) {
            DirectoryInfo info1 = this.myState.getInfo(file);
            DirectoryInfo info2 = oldState.getInfo(file);
            assert (info1 != null);
            assert (info1.equals(info2));
            info1.assertConsistency();
        }
        assert (this.myState.myPackageNameToDirsMap.size() == oldState.myPackageNameToDirsMap.size());
        this.myState.myPackageNameToDirsMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<int[]>(){

            public boolean execute(int[] packageName, int i) {
                int[] dirs = oldState.getDirsForPackage(packageName);
                int[] dirs1 = DirectoryIndexImpl.this.myState.getDirsForPackage(packageName);
                TIntHashSet set1 = new TIntHashSet(dirs);
                TIntHashSet set2 = new TIntHashSet(dirs1);
                assert (set1.equals((Object)set2));
                return true;
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.myInitialized;
    }

    private void doInitialize() {
        this.myRootIndex = null;
        if (ourUseRootIndexOnly) {
            return;
        }
        IndexState newState = new IndexState();
        newState.doInitialize(false);
        this.replaceState(newState);
    }

    private boolean isExcludeRootForModule(@NotNull Module module, VirtualFile excludeRoot) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "isExcludeRootForModule"));
        }
        for (DirectoryIndexExcludePolicy policy : this.myExcludePolicies) {
            if (!policy.isExcludeRootForModule(module, excludeRoot)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static ContentEntry[] getContentEntries(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getContentEntries"));
        }
        ContentEntry[] contentEntryArray = ModuleRootManager.getInstance((Module)module).getContentEntries();
        if (contentEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getContentEntries"));
        }
        return contentEntryArray;
    }

    @NotNull
    private static OrderEntry[] getOrderEntries(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getOrderEntries"));
        }
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        if (orderEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getOrderEntries"));
        }
        return orderEntryArray;
    }

    private static boolean isIgnored(@NotNull VirtualFile f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "isIgnored"));
        }
        return FileTypeRegistry.getInstance().isFileIgnored(f);
    }

    @Override
    public DirectoryInfo getInfoForDirectory(@NotNull VirtualFile dir) {
        DirectoryInfo riInfo;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getInfoForDirectory"));
        }
        this.checkAvailability();
        this.dispatchPendingEvents();
        if (!(dir instanceof NewVirtualFile)) {
            return null;
        }
        RootIndex rootIndex = this.getRootIndex();
        DirectoryInfo directoryInfo = riInfo = rootIndex != null ? rootIndex.getInfoForDirectory(dir) : null;
        if (ourUseRootIndexOnly) {
            return riInfo;
        }
        DirectoryInfo standardResult = this.myState.getInfo(((NewVirtualFile)dir).getId());
        this.assertConsistentResult(dir, riInfo, standardResult);
        if (standardResult != riInfo && standardResult.equals(riInfo) && rootIndex != null) {
            rootIndex.cacheInfos(dir, dir, standardResult);
        }
        return standardResult;
    }

    private <T> T assertConsistentResult(@NotNull Object arg, @Nullable T rootIndexResult, T standardResult) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "assertConsistentResult"));
        }
        if (ourCompareImplementations && !Comparing.equal(rootIndexResult, standardResult)) {
            String msg = "DirectoryIndex differs from RootIndex at " + arg + "\nriInfo         =  " + rootIndexResult + "\nstandardResult =  " + standardResult + "\nRoot model:";
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                msg = msg + "\nModule " + module.getName();
                for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                    msg = msg + "\n  Content " + contentEntry.getFile();
                    for (VirtualFile file : contentEntry.getSourceFolderFiles()) {
                        msg = msg + "\n    Source " + file;
                    }
                    for (VirtualFile file : contentEntry.getExcludeFolderFiles()) {
                        msg = msg + "\n    Excluded " + file;
                    }
                }
            }
            for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.myProject)) {
                for (ContentEntry contentEntry : directoryIndexExcludePolicy.getExcludeRootsForProject()) {
                    msg = msg + "\nProject exclude " + contentEntry;
                }
            }
            LOG.error(msg);
        }
        return standardResult;
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getSourceRootType"));
        }
        if (info.isInModuleSource()) {
            JpsModuleSourceRootType<?> riType;
            RootIndex rootIndex = this.getRootIndex();
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = riType = rootIndex != null ? rootIndex.getSourceRootType(info) : null;
            if (ourUseRootIndexOnly) {
                return riType;
            }
            return this.assertConsistentResult(info, riType, this.myState.getRootTypeById(info.getSourceRootTypeId()));
        }
        return null;
    }

    @Override
    public boolean isProjectExcludeRoot(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "isProjectExcludeRoot"));
        }
        this.checkAvailability();
        if (!(dir instanceof NewVirtualFile)) {
            return false;
        }
        if (ourUseRootIndexOnly) {
            return this.getRootIndex().isProjectExcludeRoot(dir);
        }
        boolean standardResult = this.myState.myProjectExcludeRoots.contains(((NewVirtualFile)dir).getId());
        return standardResult;
    }

    private VirtualFile findFileById(int dir) {
        return this.myPersistence.findFileById(dir);
    }

    @Override
    public String getPackageName(@NotNull VirtualFile dir) {
        String riResult;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "getPackageName"));
        }
        this.checkAvailability();
        if (!(dir instanceof NewVirtualFile)) {
            return null;
        }
        RootIndex rootIndex = this.getRootIndex();
        String string = riResult = rootIndex != null ? rootIndex.getPackageName(dir) : null;
        if (ourUseRootIndexOnly) {
            return riResult;
        }
        return this.assertConsistentResult(dir, riResult, this.myState.getPackageNameForDirectory((NewVirtualFile)dir));
    }

    private static String decodePackageName(@NotNull int[] interned) {
        if (interned == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "decodePackageName"));
        }
        if (interned.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(interned[0]);
        for (int i = 1; i < interned.length; ++i) {
            if (i > 1) {
                result.append('.');
            }
            result.append(FileNameCache.getVFileName(interned[i]));
        }
        return result.toString();
    }

    private static int[] internPackageName(@Nullable String packageName, @Nullable TObjectIntHashMap<String> alreadyEnumerated) {
        if (packageName == null) {
            return null;
        }
        if (packageName.isEmpty()) {
            return ArrayUtil.EMPTY_INT_ARRAY;
        }
        int dotCount = StringUtil.countChars((CharSequence)packageName, (char)'.');
        int[] result = new int[dotCount + 2];
        result[0] = packageName.length();
        int tokenStart = 0;
        int tokenIndex = 0;
        while (tokenStart < packageName.length()) {
            int internedId;
            int tokenEnd = packageName.indexOf(46, tokenStart);
            if (tokenEnd < 0) {
                tokenEnd = packageName.length();
            }
            String nextName = packageName.substring(tokenStart, tokenEnd);
            int n = internedId = alreadyEnumerated != null ? alreadyEnumerated.get((Object)nextName) : 0;
            if (internedId == 0) {
                internedId = FileNameCache.storeName(nextName);
                if (alreadyEnumerated != null) {
                    alreadyEnumerated.put((Object)nextName, internedId);
                }
            }
            result[tokenIndex + 1] = internedId;
            tokenStart = tokenEnd + 1;
            ++tokenIndex;
        }
        return result;
    }

    private void checkAvailability() {
        if (!this.myInitialized) {
            LOG.error("Directory index is not initialized yet for " + this.myProject);
        }
        if (this.myDisposed) {
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }

    @Nullable
    private static String getPackageNameForSubdir(String parentPackageName, String subdirName) {
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.isEmpty() ? subdirName : parentPackageName + "." + subdirName;
    }

    private static boolean isValid(@NotNull NewVirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "isValid"));
        }
        return root.getId() > 0;
    }

    @NotNull
    private static OrderEntry[] toSortedArray(@NotNull Collection<OrderEntry> entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "toSortedArray"));
        }
        if (entries.isEmpty()) {
            if (OrderEntry.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "toSortedArray"));
            }
            return OrderEntry.EMPTY_ARRAY;
        }
        OrderEntry[] result = entries.toArray(new OrderEntry[entries.size()]);
        Arrays.sort(result, DirectoryInfo.BY_OWNER_MODULE);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "toSortedArray"));
        }
        return result;
    }

    private void assertAncestor(@NotNull DirectoryInfo info, @NotNull VirtualFile root, int myId) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "assertAncestor"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl", "assertAncestor"));
        }
        VirtualFile myFile = this.findFileById(myId);
        assert (myFile.getFileSystem() == root.getFileSystem()) : myFile.getFileSystem() + ", " + root.getFileSystem() + "; my file: " + myFile + "; root: " + root + "; " + myFile.getParent().getPath().equals(root.getPath());
        assert (VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)myFile, (boolean)false)) : "my file: " + myFile + " (" + ((NewVirtualFile)myFile).getId() + ")" + myFile.getClass() + " - " + System.identityHashCode(myFile) + "; root: " + root + " (" + ((NewVirtualFile)root).getId() + ")" + root.getClass() + " - " + System.identityHashCode(root) + "; equalsToParent:" + (myFile.getParent() == null ? "" : myFile.getParent().getPath()).equals(root.getPath()) + "; equalsToRoot:" + myFile.equals(root) + "; equalsToRootPath:" + myFile.getPath().equals(root.getPath()) + "; my contentRoot: " + info.getContentRoot() + "; my sourceRoot: " + info.getSourceRoot() + "; my classRoot: " + info.getLibraryClassRoot() + "; path is substring: " + FileUtil.isAncestor((String)root.getPath(), (String)myFile.getPath(), (boolean)false);
    }

    public static boolean isLargeVfsChange(List<? extends VFileEvent> events) {
        boolean largeChange;
        int directoriesRemoved = 0;
        int directoriesCreated = 0;
        for (VFileEvent vFileEvent : events) {
            VirtualFile file;
            if (vFileEvent instanceof VFileDeleteEvent) {
                file = vFileEvent.getFile();
                if (file == null || !file.isDirectory()) continue;
                directoriesRemoved += 1 + DirectoryIndexImpl.countDirectories(file, 20);
                continue;
            }
            if (!(vFileEvent instanceof VFileCreateEvent) || ((file = vFileEvent.getFile()) == null || !file.isDirectory()) && (file != null || !((VFileCreateEvent)vFileEvent).isDirectory())) continue;
            directoriesCreated += 1 + DirectoryIndexImpl.countDirectories(file, 20);
        }
        boolean bl = largeChange = directoriesCreated + directoriesRemoved > 50;
        if (largeChange) {
            LOG.info("Too many directories created / deleted: " + directoriesCreated + "," + directoriesRemoved);
        }
        return largeChange;
    }

    private static int countDirectories(@Nullable VirtualFile file, int depth) {
        if (!(file instanceof NewVirtualFile)) {
            return 0;
        }
        int counter = 0;
        for (VirtualFile child : ((NewVirtualFile)file).iterInDbChildren()) {
            if (!child.isDirectory()) continue;
            counter += 1 + (depth > 0 ? DirectoryIndexImpl.countDirectories(child, depth - 1) : 0);
        }
        return counter;
    }

    static /* synthetic */ TObjectHashingStrategy access$4200() {
        return INT_ARRAY_STRATEGY;
    }

    private class IndexState {
        private final TIntObjectHashMap<Set<String>> myExcludeRootsMap = new TIntObjectHashMap();
        private final TIntHashSet myProjectExcludeRoots = new TIntHashSet();
        private final TIntObjectHashMap<DirectoryInfo> myDirToInfoMap = new TIntObjectHashMap();
        private final TObjectIntHashMap<int[]> myPackageNameToDirsMap = new TObjectIntHashMap(DirectoryIndexImpl.access$4200());
        private final List<int[]> multiDirPackages = new ArrayList(Arrays.asList(new int[][]{{-1}}));
        private final TIntObjectHashMap<int[]> myDirToPackageName = new TIntObjectHashMap();
        private final TObjectIntHashMap<JpsModuleSourceRootType<?>> myRootTypeId = new TObjectIntHashMap();
        private final List<JpsModuleSourceRootType<?>> myRootTypes = new ArrayList();
        private volatile boolean writable = true;

        private IndexState() {
        }

        @Nullable
        private int[] getDirsForPackage(@NotNull int[] packageName) {
            int[] nArray;
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "getDirsForPackage"));
            }
            this.assertNotWritable();
            int i = this.myPackageNameToDirsMap.get((Object)packageName);
            if (i == 0) {
                nArray = null;
            } else if (i > 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = i;
            } else {
                nArray = this.multiDirPackages.get(-i);
            }
            return nArray;
        }

        private void removeDirFromPackage(@NotNull int[] packageName, int dirId) {
            int[] oldPackageDirs;
            int[] nArray;
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "removeDirFromPackage"));
            }
            this.assertWritable();
            int i = this.myPackageNameToDirsMap.get((Object)packageName);
            if (i == 0) {
                nArray = null;
            } else if (i > 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = i;
            } else {
                nArray = oldPackageDirs = this.multiDirPackages.get(-i);
            }
            assert (oldPackageDirs != null);
            int index = ArrayUtil.find((int[])oldPackageDirs, (int)dirId);
            assert (index != -1);
            if ((oldPackageDirs = ArrayUtil.remove((int[])oldPackageDirs, (int)index)).length == 0) {
                this.myPackageNameToDirsMap.remove((Object)packageName);
                if (i < 0) {
                    this.multiDirPackages.set(-i, null);
                }
            } else {
                assert (i < 0) : i;
                this.multiDirPackages.set(-i, oldPackageDirs);
            }
        }

        private void addDirToPackage(@NotNull int[] packageName, int dirId) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "addDirToPackage"));
            }
            this.assertWritable();
            assert (dirId > 0);
            int i = this.myPackageNameToDirsMap.get((Object)packageName);
            if (i < 0) {
                int[] nArray;
                int[] ids = this.multiDirPackages.get(-i);
                if (ids == null) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = dirId;
                } else {
                    nArray = ArrayUtil.append((int[])ids, (int)dirId);
                }
                int[] newIds = nArray;
                this.multiDirPackages.set(-i, newIds);
            } else if (i > 0) {
                int newIndex = this.multiDirPackages.size();
                this.multiDirPackages.add(new int[]{i, dirId});
                this.myPackageNameToDirsMap.put((Object)packageName, -newIndex);
            } else {
                this.myPackageNameToDirsMap.put((Object)packageName, dirId);
            }
        }

        @NotNull
        private DirectoryInfo getOrCreateDirInfo(int dirId) {
            DirectoryInfo info = this.getInfo(dirId);
            if (info == null) {
                info = DirectoryInfo.createNew();
                this.storeInfo(info, dirId);
            }
            DirectoryInfo directoryInfo = info;
            if (directoryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "getOrCreateDirInfo"));
            }
            return directoryInfo;
        }

        @Nullable
        private DirectoryInfo getInfo(int fileId) {
            return (DirectoryInfo)this.myDirToInfoMap.get(fileId);
        }

        private void storeInfo(@NotNull DirectoryInfo info, int id) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "storeInfo"));
            }
            this.assertWritable();
            if (CHECK) {
                VirtualFile file = DirectoryIndexImpl.this.findFileById(id);
                VirtualFile contentRoot = info.getContentRoot();
                if (file != null && contentRoot != null) assert (VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) : "File: " + file + "; Content root: " + contentRoot;
            }
            assert (id > 0) : id;
            this.myDirToInfoMap.put(id, (Object)info);
        }

        private void assertAncestorsConsistent() {
            if (CHECK) {
                this.myDirToInfoMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<DirectoryInfo>(){

                    public boolean execute(int id, DirectoryInfo info) {
                        VirtualFile sourceRoot;
                        VirtualFile file = DirectoryIndexImpl.this.findFileById(id);
                        if (file == null) {
                            return true;
                        }
                        VirtualFile contentRoot = info.getContentRoot();
                        if (contentRoot != null) {
                            DirectoryIndexImpl.this.assertAncestor(info, contentRoot, id);
                        }
                        if ((sourceRoot = info.getSourceRoot()) != null) {
                            DirectoryIndexImpl.this.assertAncestor(info, sourceRoot, id);
                            if (contentRoot != null) assert (VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)sourceRoot, (boolean)false)) : contentRoot + ";" + sourceRoot;
                        }
                        return true;
                    }
                });
            }
        }

        private void fillMapWithModuleContent(@NotNull NewVirtualFile root, final Module module, final NewVirtualFile contentRoot, final @Nullable ProgressIndicator progress) {
            int contentRootId;
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithModuleContent"));
            }
            this.assertWritable();
            if (!DirectoryIndexImpl.isValid(root)) {
                return;
            }
            int n = contentRootId = contentRoot == null ? 0 : contentRoot.getId();
            if (contentRoot != null) assert (VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)root, (boolean)false)) : "Root: " + root + "; contentRoot: " + contentRoot;
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new DirectoryVisitor(){

                @Override
                protected DirectoryInfo updateInfo(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$2", "updateInfo"));
                    }
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (IndexState.this.isExcluded(contentRootId, file)) {
                        return null;
                    }
                    if (DirectoryIndexImpl.isIgnored(file)) {
                        return null;
                    }
                    DirectoryInfo info = IndexState.this.getOrCreateDirInfo(((NewVirtualFile)file).getId());
                    if (info.getModule() != null) {
                        DirectoryInfo parentInfo;
                        VirtualFile dir = file.getParent();
                        DirectoryInfo directoryInfo = parentInfo = dir == null ? null : IndexState.this.getInfo(((NewVirtualFile)dir).getId());
                        if (parentInfo == null || !info.getModule().equals(parentInfo.getModule())) {
                            return null;
                        }
                    }
                    return info;
                }

                @Override
                protected void afterChildrenVisited(@NotNull VirtualFile file, @NotNull DirectoryInfo info) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$2", "afterChildrenVisited"));
                    }
                    if (info == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$2", "afterChildrenVisited"));
                    }
                    IndexState.this.with(((NewVirtualFile)file).getId(), info, module, (VirtualFile)contentRoot, null, null, 0, null);
                }
            });
        }

        @NotNull
        private DirectoryInfo with(int id, @NotNull DirectoryInfo info, Module module, VirtualFile contentRoot, VirtualFile sourceRoot, VirtualFile libraryClassRoot, int sourceRootTypeData, OrderEntry[] orderEntries) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "with"));
            }
            if (contentRoot != null) {
                DirectoryIndexImpl.this.assertAncestor(info, contentRoot, id);
            }
            if (sourceRoot instanceof NewVirtualFile) {
                VirtualFile root;
                VirtualFile virtualFile = root = contentRoot == null ? info.getContentRoot() : contentRoot;
                if (root != null) {
                    DirectoryIndexImpl.this.assertAncestor(info, root, ((NewVirtualFile)sourceRoot).getId());
                }
            }
            DirectoryInfo newInfo = info.with(module, contentRoot, sourceRoot, libraryClassRoot, sourceRootTypeData, orderEntries);
            this.storeInfo(newInfo, id);
            DirectoryInfo directoryInfo = newInfo;
            if (directoryInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "with"));
            }
            return directoryInfo;
        }

        @Nullable
        private String getPackageNameForDirectory(NewVirtualFile dir) {
            int[] interned = (int[])this.myDirToPackageName.get(dir.getId());
            return interned == null ? null : DirectoryIndexImpl.decodePackageName(interned);
        }

        private boolean isExcluded(int root, @NotNull VirtualFile dir) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "isExcluded"));
            }
            if (root == 0) {
                return false;
            }
            Set excludes = (Set)this.myExcludeRootsMap.get(root);
            return excludes != null && excludes.contains(dir.getUrl());
        }

        private void initModuleContents(@NotNull Module module, boolean reverseAllSets, @NotNull ProgressIndicator progress) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initModuleContents"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initModuleContents"));
            }
            this.assertWritable();
            progress.checkCanceled();
            progress.setText2(ProjectBundle.message((String)"project.index.processing.module.content.progress", (Object[])new Object[]{module.getName()}));
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            Object[] contentRoots = rootManager.getContentRoots();
            if (reverseAllSets) {
                contentRoots = (VirtualFile[])ArrayUtil.reverseArray((Object[])contentRoots);
            }
            for (Object contentRoot : contentRoots) {
                if (!(contentRoot instanceof NewVirtualFile)) continue;
                this.fillMapWithModuleContent((NewVirtualFile)contentRoot, module, (NewVirtualFile)contentRoot, progress);
            }
        }

        private void initModuleSources(@NotNull Module module, boolean reverseAllSets, @NotNull ProgressIndicator progress, @Nullable TObjectIntHashMap<String> interned) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initModuleSources"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initModuleSources"));
            }
            this.assertWritable();
            progress.checkCanceled();
            progress.setText2(ProjectBundle.message((String)"project.index.processing.module.sources.progress", (Object[])new Object[]{module.getName()}));
            Object[] contentEntries = DirectoryIndexImpl.getContentEntries(module);
            if (reverseAllSets) {
                contentEntries = (ContentEntry[])ArrayUtil.reverseArray((Object[])contentEntries);
            }
            for (Object contentEntry : contentEntries) {
                VirtualFile contentRoot = contentEntry.getFile();
                Object[] sourceFolders = contentEntry.getSourceFolders();
                if (reverseAllSets) {
                    sourceFolders = (SourceFolder[])ArrayUtil.reverseArray((Object[])sourceFolders);
                }
                for (Object sourceFolder : sourceFolders) {
                    VirtualFile dir = sourceFolder.getFile();
                    if (!(dir instanceof NewVirtualFile) || !(contentRoot instanceof NewVirtualFile)) continue;
                    int rootTypeId = this.getRootTypeId((SourceFolder)sourceFolder);
                    this.fillMapWithModuleSource(module, (NewVirtualFile)contentRoot, (NewVirtualFile)dir, sourceFolder.getPackagePrefix(), (NewVirtualFile)dir, rootTypeId, progress, interned);
                }
            }
        }

        private int getRootTypeId(@NotNull SourceFolder sourceFolder) {
            if (sourceFolder == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "getRootTypeId"));
            }
            JpsModuleSourceRootType rootType = sourceFolder.getRootType();
            if (this.myRootTypeId.containsKey((Object)rootType)) {
                return this.myRootTypeId.get((Object)rootType);
            }
            int id = this.myRootTypes.size();
            if (id > 63) {
                LOG.error("Too many different types of module source roots (" + id + ") registered: " + this.myRootTypes);
            }
            this.myRootTypes.add(rootType);
            this.myRootTypeId.put((Object)rootType, id);
            return id;
        }

        @Nullable
        private JpsModuleSourceRootType<?> getRootTypeById(int id) {
            if (id >= this.myRootTypes.size()) {
                return null;
            }
            return this.myRootTypes.get(id);
        }

        private void fillMapWithModuleSource(final @NotNull Module module, final @NotNull NewVirtualFile contentRoot, final @NotNull NewVirtualFile dir, final @NotNull String packageName, final @NotNull NewVirtualFile sourceRoot, final int rootTypeId, final @Nullable ProgressIndicator progress, final @Nullable TObjectIntHashMap<String> interned) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithModuleSource"));
            }
            if (contentRoot == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithModuleSource"));
            }
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithModuleSource"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithModuleSource"));
            }
            if (sourceRoot == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithModuleSource"));
            }
            this.assertWritable();
            if (!DirectoryIndexImpl.isValid(dir)) {
                return;
            }
            assert (VfsUtilCore.isAncestor((VirtualFile)sourceRoot, (VirtualFile)dir, (boolean)false)) : "SourceRoot: " + sourceRoot + " (" + sourceRoot.getFileSystem() + "); dir: " + dir + " (" + dir.getFileSystem() + ")";
            VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new DirectoryVisitor(){
                private final Stack<String> myPackages = new Stack();

                @Override
                protected DirectoryInfo updateInfo(@NotNull VirtualFile file) {
                    int id;
                    DirectoryInfo info;
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$3", "updateInfo"));
                    }
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if ((info = IndexState.this.getInfo(id = ((NewVirtualFile)file).getId())) == null) {
                        return null;
                    }
                    if (!module.equals(info.getModule())) {
                        return null;
                    }
                    if (!contentRoot.equals(info.getContentRoot())) {
                        return null;
                    }
                    if (info.isInModuleSource() && IndexState.this.isAnotherRoot(id)) {
                        return null;
                    }
                    assert (VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)false)) : "dir: " + dir + " (" + dir.getFileSystem() + "); file: " + file + " (" + file.getFileSystem() + ")";
                    int flag = DirectoryInfo.createSourceRootTypeData(true, info.isInLibrarySource(), rootTypeId);
                    info = IndexState.this.with(id, info, null, null, (VirtualFile)sourceRoot, null, flag, null);
                    String currentPackage = this.myPackages.isEmpty() ? packageName : DirectoryIndexImpl.getPackageNameForSubdir((String)this.myPackages.peek(), file.getName());
                    this.myPackages.push((Object)currentPackage);
                    IndexState.this.setPackageName(id, DirectoryIndexImpl.internPackageName(currentPackage, (TObjectIntHashMap<String>)interned));
                    return info;
                }

                @Override
                protected void afterChildrenVisited(@NotNull VirtualFile file, @NotNull DirectoryInfo info) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$3", "afterChildrenVisited"));
                    }
                    if (info == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$3", "afterChildrenVisited"));
                    }
                    super.afterChildrenVisited(file, info);
                    this.myPackages.pop();
                }
            });
        }

        private boolean isAnotherRoot(int id) {
            return this.myDirToPackageName.get(id) == ArrayUtil.EMPTY_INT_ARRAY;
        }

        private void initLibrarySources(@NotNull Module module, @NotNull ProgressIndicator progress, @Nullable TObjectIntHashMap<String> interned, Map<Library, TIntHashSet> libraryExcludedRoots) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initLibrarySources"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initLibrarySources"));
            }
            this.assertWritable();
            progress.checkCanceled();
            progress.setText2(ProjectBundle.message((String)"project.index.processing.library.sources.progress", (Object[])new Object[]{module.getName()}));
            for (OrderEntry orderEntry : DirectoryIndexImpl.getOrderEntries(module)) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                VirtualFile[] sourceRoots = ((LibraryOrSdkOrderEntry)orderEntry).getRootFiles(OrderRootType.SOURCES);
                TIntHashSet excludedRoots = this.getExcludedRootsOfLibrary((LibraryOrSdkOrderEntry)orderEntry, libraryExcludedRoots);
                for (VirtualFile sourceRoot : sourceRoots) {
                    if (!(sourceRoot instanceof NewVirtualFile)) continue;
                    this.fillMapWithLibrarySources((NewVirtualFile)sourceRoot, "", (NewVirtualFile)sourceRoot, progress, interned, excludedRoots);
                }
            }
        }

        private void fillMapWithLibrarySources(final @NotNull NewVirtualFile dir, final @Nullable String packageName, final @NotNull NewVirtualFile sourceRoot, final @Nullable ProgressIndicator progress, final @Nullable TObjectIntHashMap<String> interned, final @Nullable TIntHashSet excludedRoots) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithLibrarySources"));
            }
            if (sourceRoot == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithLibrarySources"));
            }
            this.assertWritable();
            if (!DirectoryIndexImpl.isValid(dir)) {
                return;
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor<String>(new VirtualFileVisitor.Option[0]){
                {
                    super(x0);
                    this.setValueForChildren(packageName);
                }

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$4", "visitFile"));
                    }
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    int dirId = ((NewVirtualFile)file).getId();
                    if (!file.isDirectory() && dirId != dir.getId() || DirectoryIndexImpl.isIgnored(file)) {
                        return false;
                    }
                    if (excludedRoots != null && excludedRoots.contains(dirId)) {
                        return false;
                    }
                    DirectoryInfo info = IndexState.this.getOrCreateDirInfo(dirId);
                    if (info.isInLibrarySource() && IndexState.this.isAnotherRoot(dirId)) {
                        return false;
                    }
                    int data = DirectoryInfo.createSourceRootTypeData(info.isInModuleSource(), true, info.getSourceRootTypeId());
                    IndexState.this.with(dirId, info, null, null, (VirtualFile)sourceRoot, null, data, null);
                    String packageName2 = (String)this.getCurrentValue();
                    String newPackageName = Comparing.equal((Object)file, (Object)dir) ? packageName2 : DirectoryIndexImpl.getPackageNameForSubdir(packageName2, file.getName());
                    IndexState.this.setPackageName(dirId, DirectoryIndexImpl.internPackageName(newPackageName, (TObjectIntHashMap<String>)interned));
                    this.setValueForChildren(newPackageName);
                    return true;
                }
            });
        }

        private void initLibraryClasses(@NotNull Module module, @NotNull ProgressIndicator progress, @Nullable TObjectIntHashMap<String> interned, @Nullable Map<Library, TIntHashSet> libraryExcludedRoots) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initLibraryClasses"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initLibraryClasses"));
            }
            this.assertWritable();
            progress.checkCanceled();
            progress.setText2(ProjectBundle.message((String)"project.index.processing.library.classes.progress", (Object[])new Object[]{module.getName()}));
            for (OrderEntry orderEntry : DirectoryIndexImpl.getOrderEntries(module)) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                VirtualFile[] classRoots = ((LibraryOrSdkOrderEntry)orderEntry).getRootFiles(OrderRootType.CLASSES);
                TIntHashSet excludedRoots = this.getExcludedRootsOfLibrary((LibraryOrSdkOrderEntry)orderEntry, libraryExcludedRoots);
                for (VirtualFile classRoot : classRoots) {
                    if (!(classRoot instanceof NewVirtualFile)) continue;
                    this.fillMapWithLibraryClasses((NewVirtualFile)classRoot, "", (NewVirtualFile)classRoot, progress, interned, excludedRoots);
                }
            }
        }

        private void fillMapWithLibraryClasses(final @NotNull NewVirtualFile dir, final @NotNull String packageName, final @NotNull NewVirtualFile classRoot, final @Nullable ProgressIndicator progress, final @Nullable TObjectIntHashMap<String> interned, final TIntHashSet excludedRoots) {
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithLibraryClasses"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithLibraryClasses"));
            }
            if (classRoot == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithLibraryClasses"));
            }
            this.assertWritable();
            if (!DirectoryIndexImpl.isValid(dir)) {
                return;
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor<String>(new VirtualFileVisitor.Option[0]){
                {
                    super(x0);
                    this.setValueForChildren(packageName);
                }

                public boolean visitFile(@NotNull VirtualFile file) {
                    String childPackageName;
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$5", "visitFile"));
                    }
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (!file.isDirectory() && !Comparing.equal((Object)file, (Object)dir) || DirectoryIndexImpl.isIgnored(file)) {
                        return false;
                    }
                    int dirId = ((NewVirtualFile)file).getId();
                    if (excludedRoots != null && excludedRoots.contains(dirId)) {
                        return false;
                    }
                    DirectoryInfo info = IndexState.this.getOrCreateDirInfo(dirId);
                    if (info.hasLibraryClassRoot() && IndexState.this.isAnotherRoot(dirId)) {
                        return false;
                    }
                    info = IndexState.this.with(dirId, info, null, null, null, (VirtualFile)classRoot, 0, null);
                    String packageName2 = (String)this.getCurrentValue();
                    String string = childPackageName = Comparing.equal((Object)file, (Object)dir) ? packageName2 : DirectoryIndexImpl.getPackageNameForSubdir(packageName2, file.getName());
                    if (!info.isInModuleSource() && !info.isInLibrarySource()) {
                        IndexState.this.setPackageName(dirId, DirectoryIndexImpl.internPackageName(childPackageName, (TObjectIntHashMap<String>)interned));
                    }
                    this.setValueForChildren(childPackageName);
                    return true;
                }
            });
        }

        @Nullable
        private TIntHashSet getExcludedRootsOfLibrary(LibraryOrSdkOrderEntry orderEntry, Map<Library, TIntHashSet> libraryExcludedRoots) {
            Library library;
            if (orderEntry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)orderEntry).getLibrary()) != null) {
                TIntHashSet cached = libraryExcludedRoots.get(library);
                if (cached != null) {
                    return cached;
                }
                VirtualFile[] files = ((LibraryEx)library).getExcludedRoots();
                if (files.length > 0) {
                    TIntHashSet set = new TIntHashSet();
                    for (VirtualFile file : files) {
                        if (!(file instanceof NewVirtualFile)) continue;
                        set.add(((NewVirtualFile)file).getId());
                    }
                    libraryExcludedRoots.put(library, set);
                    return set;
                }
            }
            return null;
        }

        private void initOrderEntries(@NotNull Module module, @NotNull MultiMap<VirtualFile, OrderEntry> depEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries, @NotNull ProgressIndicator progress) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initOrderEntries"));
            }
            if (depEntries == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initOrderEntries"));
            }
            if (libClassRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initOrderEntries"));
            }
            if (libSourceRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initOrderEntries"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initOrderEntries"));
            }
            this.assertWritable();
            for (OrderEntry orderEntry : DirectoryIndexImpl.getOrderEntries(module)) {
                VirtualFile[] sourceRoots;
                if (orderEntry instanceof ModuleOrderEntry) {
                    VirtualFile[] sourceRoots2;
                    Module depModule = ((ModuleOrderEntry)orderEntry).getModule();
                    if (depModule != null) {
                        VirtualFile[] importedClassRoots = OrderEnumerator.orderEntries((Module)depModule).exportedOnly().recursively().classes().usingCache().getRoots();
                        for (VirtualFile importedClassRoot : importedClassRoots) {
                            depEntries.putValue((Object)importedClassRoot, (Object)orderEntry);
                        }
                    }
                    for (VirtualFile sourceRoot : sourceRoots2 = orderEntry.getFiles(OrderRootType.SOURCES)) {
                        depEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                    }
                    continue;
                }
                if (orderEntry instanceof ModuleSourceOrderEntry) {
                    OrderEntry[] oneEntryList = new OrderEntry[]{orderEntry};
                    Module entryModule = orderEntry.getOwnerModule();
                    for (VirtualFile sourceRoot : sourceRoots = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getSourceRoots()) {
                        if (!(sourceRoot instanceof NewVirtualFile)) continue;
                        this.fillMapWithOrderEntries((NewVirtualFile)sourceRoot, oneEntryList, entryModule, null, null, null, progress);
                    }
                    continue;
                }
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry)) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] classRoots = entry.getRootFiles(OrderRootType.CLASSES);
                for (VirtualFile classRoot : classRoots) {
                    libClassRootEntries.putValue((Object)classRoot, (Object)orderEntry);
                }
                for (VirtualFile sourceRoot : sourceRoots = entry.getRootFiles(OrderRootType.SOURCES)) {
                    libSourceRootEntries.putValue((Object)sourceRoot, (Object)orderEntry);
                }
            }
        }

        private void fillMapWithOrderEntries(@NotNull MultiMap<VirtualFile, OrderEntry> depEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libClassRootEntries, @NotNull MultiMap<VirtualFile, OrderEntry> libSourceRootEntries, @NotNull ProgressIndicator progress) {
            Collection entries;
            VirtualFile vRoot;
            if (depEntries == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithOrderEntries"));
            }
            if (libClassRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithOrderEntries"));
            }
            if (libSourceRootEntries == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithOrderEntries"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithOrderEntries"));
            }
            this.assertWritable();
            for (Map.Entry mapEntry : depEntries.entrySet()) {
                vRoot = (VirtualFile)mapEntry.getKey();
                entries = (Collection)mapEntry.getValue();
                if (!(vRoot instanceof NewVirtualFile)) continue;
                this.fillMapWithOrderEntries((NewVirtualFile)vRoot, DirectoryIndexImpl.toSortedArray(entries), null, null, null, null, progress);
            }
            for (Map.Entry mapEntry : libClassRootEntries.entrySet()) {
                vRoot = (VirtualFile)mapEntry.getKey();
                entries = (Collection)mapEntry.getValue();
                if (!(vRoot instanceof NewVirtualFile)) continue;
                this.fillMapWithOrderEntries((NewVirtualFile)vRoot, DirectoryIndexImpl.toSortedArray(entries), null, (NewVirtualFile)vRoot, null, null, progress);
            }
            for (Map.Entry mapEntry : libSourceRootEntries.entrySet()) {
                vRoot = (VirtualFile)mapEntry.getKey();
                entries = (Collection)mapEntry.getValue();
                if (!(vRoot instanceof NewVirtualFile)) continue;
                this.fillMapWithOrderEntries((NewVirtualFile)vRoot, DirectoryIndexImpl.toSortedArray(entries), null, null, (NewVirtualFile)vRoot, null, progress);
            }
        }

        private void setPackageName(int dirId, @Nullable int[] newPackageName) {
            this.assertWritable();
            int[] oldPackageName = (int[])this.myDirToPackageName.get(dirId);
            if (oldPackageName != null) {
                this.removeDirFromPackage(oldPackageName, dirId);
            }
            if (newPackageName == null) {
                this.myDirToPackageName.remove(dirId);
            } else {
                this.addDirToPackage(newPackageName, dirId);
                this.myDirToPackageName.put(dirId, (Object)newPackageName);
            }
        }

        private void fillMapWithOrderEntries(final @NotNull NewVirtualFile root, final @NotNull OrderEntry[] orderEntries, final @Nullable Module module, final @Nullable NewVirtualFile libraryClassRoot, final @Nullable NewVirtualFile librarySourceRoot, final @Nullable DirectoryInfo parentInfo, final @Nullable ProgressIndicator progress) {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithOrderEntries"));
            }
            if (orderEntries == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "fillMapWithOrderEntries"));
            }
            this.assertWritable();
            if (!DirectoryIndexImpl.isValid(root)) {
                return;
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
                private final Stack<OrderEntry[]> myEntries;
                {
                    super(x0);
                    this.myEntries = new Stack();
                }

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$6", "visitFile"));
                    }
                    if (progress != null) {
                        progress.checkCanceled();
                    }
                    if (!file.isDirectory() && !file.equals(root) || DirectoryIndexImpl.isIgnored(file)) {
                        return false;
                    }
                    int fileId = ((NewVirtualFile)file).getId();
                    DirectoryInfo info = IndexState.this.getInfo(fileId);
                    if (info == null) {
                        return false;
                    }
                    if (module != null ? info.getModule() != module || !info.isInModuleSource() : (libraryClassRoot != null ? !libraryClassRoot.equals(info.getLibraryClassRoot()) || info.isInModuleSource() : librarySourceRoot != null && (!info.isInLibrarySource() || !librarySourceRoot.equals(info.getSourceRoot()) || info.hasLibraryClassRoot()))) {
                        return false;
                    }
                    OrderEntry[] oldParentEntries = this.myEntries.isEmpty() ? null : (OrderEntry[])this.myEntries.peek();
                    OrderEntry[] oldEntries = info.getOrderEntries();
                    this.myEntries.push((Object)oldEntries);
                    OrderEntry[] newOrderEntries = info.calcNewOrderEntries(orderEntries, parentInfo, oldParentEntries);
                    IndexState.this.with(fileId, info, null, null, null, null, 0, newOrderEntries);
                    return true;
                }

                public void afterChildrenVisited(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$6", "afterChildrenVisited"));
                    }
                    this.myEntries.pop();
                }
            });
        }

        private void doInitialize(boolean reverseAllSets) {
            this.assertWritable();
            this.assertAncestorsConsistent();
            ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
            if (progress == null) {
                progress = new EmptyProgressIndicator();
            }
            progress.pushState();
            progress.checkCanceled();
            progress.setText(ProjectBundle.message((String)"project.index.scanning.files.progress", (Object[])new Object[0]));
            Object[] modules = ModuleManager.getInstance((Project)DirectoryIndexImpl.this.myProject).getModules();
            if (reverseAllSets) {
                modules = (Module[])ArrayUtil.reverseArray((Object[])modules);
            }
            this.initExcludedDirMap((Module[])modules, progress);
            for (Object module : modules) {
                this.initModuleContents((Module)module, reverseAllSets, progress);
            }
            TObjectIntHashMap interned = new TObjectIntHashMap(100);
            IdentityHashMap<Library, TIntHashSet> libraryExcludedRoots = new IdentityHashMap<Library, TIntHashSet>();
            for (Object module : modules) {
                this.initModuleSources((Module)module, reverseAllSets, progress, (TObjectIntHashMap<String>)interned);
                this.initLibrarySources((Module)module, progress, (TObjectIntHashMap<String>)interned, libraryExcludedRoots);
                this.initLibraryClasses((Module)module, progress, (TObjectIntHashMap<String>)interned, libraryExcludedRoots);
            }
            progress.checkCanceled();
            progress.setText2("");
            this.assertAncestorsConsistent();
            MultiMap depEntries = new MultiMap();
            MultiMap libClassRootEntries = new MultiMap();
            MultiMap libSourceRootEntries = new MultiMap();
            for (Object module : modules) {
                this.initOrderEntries((Module)module, (MultiMap<VirtualFile, OrderEntry>)depEntries, (MultiMap<VirtualFile, OrderEntry>)libClassRootEntries, (MultiMap<VirtualFile, OrderEntry>)libSourceRootEntries, progress);
            }
            this.fillMapWithOrderEntries((MultiMap<VirtualFile, OrderEntry>)depEntries, (MultiMap<VirtualFile, OrderEntry>)libClassRootEntries, (MultiMap<VirtualFile, OrderEntry>)libSourceRootEntries, progress);
            this.internDirectoryInfos();
            progress.popState();
        }

        private void internDirectoryInfos() {
            this.assertWritable();
            THashMap diInterner = new THashMap();
            THashMap oeInterner = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<OrderEntry[]>(){

                public int computeHashCode(OrderEntry[] object) {
                    return Arrays.hashCode(object);
                }

                public boolean equals(OrderEntry[] o1, OrderEntry[] o2) {
                    return Arrays.equals(o1, o2);
                }
            });
            this.assertAncestorsConsistent();
            this.myDirToInfoMap.transformValues((TObjectFunction)new TObjectFunction<DirectoryInfo, DirectoryInfo>((Map)diInterner, (Map)oeInterner){
                final /* synthetic */ Map val$diInterner;
                final /* synthetic */ Map val$oeInterner;
                {
                    this.val$diInterner = map;
                    this.val$oeInterner = map2;
                }

                public DirectoryInfo execute(DirectoryInfo info) {
                    DirectoryInfo interned = (DirectoryInfo)this.val$diInterner.get(info);
                    if (interned == null) {
                        OrderEntry[] entries = info.getOrderEntries();
                        OrderEntry[] internedEntries = (OrderEntry[])this.val$oeInterner.get(entries);
                        if (internedEntries == null) {
                            this.val$oeInterner.put(entries, entries);
                        } else if (internedEntries != entries) {
                            info = info.withInternedEntries(internedEntries);
                        }
                        interned = info;
                        this.val$diInterner.put(info, interned);
                    }
                    return interned;
                }
            });
            this.assertAncestorsConsistent();
        }

        private void initExcludedDirMap(@NotNull Module[] modules, ProgressIndicator progress) {
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "initExcludedDirMap"));
            }
            this.assertWritable();
            progress.checkCanceled();
            progress.setText2(ProjectBundle.message((String)"project.index.building.exclude.roots.progress", (Object[])new Object[0]));
            for (Module module : modules) {
                for (ContentEntry contentEntry : DirectoryIndexImpl.getContentEntries(module)) {
                    VirtualFile contentRoot = contentEntry.getFile();
                    if (!(contentRoot instanceof NewVirtualFile)) continue;
                    for (VirtualFile excludeRoot : contentEntry.getExcludeFolderFiles()) {
                        if (!(excludeRoot instanceof NewVirtualFile) || FileUtil.startsWith((String)excludeRoot.getUrl(), (String)contentRoot.getUrl())) continue;
                        if (DirectoryIndexImpl.this.isExcludeRootForModule(module, excludeRoot)) {
                            this.putForFileAndAllAncestors((NewVirtualFile)excludeRoot, excludeRoot.getUrl());
                        }
                        this.myProjectExcludeRoots.add(((NewVirtualFile)excludeRoot).getId());
                    }
                    for (String url : contentEntry.getExcludeFolderUrls()) {
                        this.putForFileAndAllAncestors((NewVirtualFile)contentRoot, url);
                    }
                }
            }
            for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : DirectoryIndexImpl.this.myExcludePolicies) {
                for (ContentEntry contentEntry : directoryIndexExcludePolicy.getExcludeRootsForProject()) {
                    if (!(contentEntry instanceof NewVirtualFile)) continue;
                    this.putForFileAndAllAncestors((NewVirtualFile)contentEntry, contentEntry.getUrl());
                    this.myProjectExcludeRoots.add(((NewVirtualFile)contentEntry).getId());
                }
            }
        }

        private void putForFileAndAllAncestors(NewVirtualFile file, String value) {
            this.assertWritable();
            TIntObjectHashMap<Set<String>> map = this.myExcludeRootsMap;
            while (file != null) {
                int id = file.getId();
                Set set = (Set)map.get(id);
                if (set == null) {
                    set = new THashSet();
                    map.put(id, (Object)set);
                }
                set.add(value);
                file = file.getParent();
            }
        }

        private void assertWritable() {
            assert (this.writable);
        }

        private void assertNotWritable() {
            assert (!this.writable);
        }

        @NotNull
        private IndexState copy(final @Nullable TIntProcedure idFilter) {
            this.assertNotWritable();
            final IndexState copy = new IndexState();
            this.myExcludeRootsMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Set<String>>(){

                public boolean execute(int id, Set<String> urls) {
                    if (idFilter == null || idFilter.execute(id)) {
                        copy.myExcludeRootsMap.put(id, (Object)new THashSet(urls));
                    }
                    return true;
                }
            });
            copy.myProjectExcludeRoots.addAll(this.myProjectExcludeRoots.toArray());
            this.myDirToInfoMap.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<DirectoryInfo>(){

                public boolean execute(int id, DirectoryInfo info) {
                    if (idFilter == null || idFilter.execute(id)) {
                        copy.storeInfo(info, id);
                    }
                    return true;
                }
            });
            copy.multiDirPackages.clear();
            for (int[] dirs : this.multiDirPackages) {
                if (dirs == null) {
                    dirs = ArrayUtil.EMPTY_INT_ARRAY;
                }
                int[] filtered = ContainerUtil.filter((int[])dirs, (TIntProcedure)new TIntProcedure(){

                    public boolean execute(int id) {
                        return id == -1 || copy.getInfo(id) != null && (idFilter == null || idFilter.execute(id));
                    }
                });
                copy.multiDirPackages.add(filtered);
            }
            this.myPackageNameToDirsMap.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<int[]>(){

                public boolean execute(int[] name, int id) {
                    if (id > 0) {
                        if (copy.getInfo(id) == null) {
                            id = 0;
                        }
                    } else if (id < 0 && ((int[])copy.multiDirPackages.get(-id)).length == 0) {
                        id = 0;
                    }
                    if (id != 0 && (idFilter == null || idFilter.execute(id))) {
                        copy.myPackageNameToDirsMap.put((Object)name, id);
                    }
                    return true;
                }
            });
            this.myDirToPackageName.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<int[]>(){

                public boolean execute(int id, int[] name) {
                    if (idFilter == null || idFilter.execute(id)) {
                        copy.myDirToPackageName.put(id, (Object)name);
                    }
                    return true;
                }
            });
            copy.myRootTypes.addAll(this.myRootTypes);
            this.myRootTypeId.forEachEntry(new TObjectIntProcedure<JpsModuleSourceRootType<?>>(){

                public boolean execute(JpsModuleSourceRootType<?> root, int id) {
                    copy.myRootTypeId.put(root, id);
                    return true;
                }
            });
            IndexState indexState = copy;
            if (indexState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState", "copy"));
            }
            return indexState;
        }

        private abstract class DirectoryVisitor
        extends VirtualFileVisitor {
            private final Stack<DirectoryInfo> myDirectoryInfoStack;

            private DirectoryVisitor() {
                super(new VirtualFileVisitor.Option[0]);
                this.myDirectoryInfoStack = new Stack();
            }

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$DirectoryVisitor", "visitFile"));
                }
                if (!file.isDirectory()) {
                    return false;
                }
                DirectoryInfo info = this.updateInfo(file);
                if (info != null) {
                    this.myDirectoryInfoStack.push((Object)info);
                    return true;
                }
                return false;
            }

            public void afterChildrenVisited(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$DirectoryVisitor", "afterChildrenVisited"));
                }
                this.afterChildrenVisited(file, (DirectoryInfo)this.myDirectoryInfoStack.pop());
            }

            @Nullable
            protected abstract DirectoryInfo updateInfo(@NotNull VirtualFile var1);

            protected void afterChildrenVisited(@NotNull VirtualFile file, @NotNull DirectoryInfo info) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$DirectoryVisitor", "afterChildrenVisited"));
                }
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$IndexState$DirectoryVisitor", "afterChildrenVisited"));
                }
            }
        }
    }

    private class PackageSink
    extends QueryFactory<VirtualFile, Pair<IndexState, List<VirtualFile>>> {
        private final Condition<VirtualFile> IS_VALID = new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                return virtualFile.isValid();
            }
        };

        private PackageSink() {
            this.registerExecutor((QueryExecutor)new QueryExecutor<VirtualFile, Pair<IndexState, List<VirtualFile>>>(){

                public boolean execute(@NotNull Pair<IndexState, List<VirtualFile>> stateAndDirs, @NotNull Processor<VirtualFile> consumer) {
                    if (stateAndDirs == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$PackageSink$2", "execute"));
                    }
                    if (consumer == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$PackageSink$2", "execute"));
                    }
                    for (VirtualFile dir : (List)stateAndDirs.second) {
                        DirectoryInfo info = (DirectoryInfo)((IndexState)stateAndDirs.first).myDirToInfoMap.get(((NewVirtualFile)dir).getId());
                        assert (info != null);
                        if (info.isInLibrarySource() && !info.isInModuleSource() && !info.hasLibraryClassRoot() || consumer.process((Object)dir)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        public Query<VirtualFile> search(@NotNull String packageName, boolean includeLibrarySources) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$PackageSink", "search"));
            }
            DirectoryIndexImpl.this.checkAvailability();
            DirectoryIndexImpl.this.dispatchPendingEvents();
            IndexState state = DirectoryIndexImpl.this.myState;
            int[] allDirs = state.getDirsForPackage(DirectoryIndexImpl.internPackageName(packageName, (TObjectIntHashMap<String>)null));
            if (allDirs == null) {
                allDirs = ArrayUtil.EMPTY_INT_ARRAY;
            }
            ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(allDirs.length);
            for (int dir : allDirs) {
                VirtualFile file = DirectoryIndexImpl.this.findFileById(dir);
                if (file == null) continue;
                files.add(file);
            }
            CollectionQuery query = includeLibrarySources ? new CollectionQuery(files) : this.createQuery(Pair.create((Object)state, files));
            return new FilteredQuery((Query)query, this.IS_VALID);
        }
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter
    implements BulkFileListener {
        private final Key<int[]> FILES_TO_RELEASE_KEY = Key.create((String)"DirectoryIndexImpl.MyVirtualFileListener.FILES_TO_RELEASE_KEY");
        private boolean myBatchChangePlanned;

        private MyVirtualFileListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "fileCreated"));
            }
            VirtualFile file = event.getFile();
            if (!file.isDirectory()) {
                return;
            }
            VirtualFile parent = file.getParent();
            if (!(parent instanceof NewVirtualFile)) {
                return;
            }
            DirectoryInfo existing = DirectoryIndexImpl.this.myState.getInfo(((NewVirtualFile)file).getId());
            assert (existing == null) : file + " -> " + existing;
            IndexState newState = this.updateStateWithNewFile((NewVirtualFile)file, (NewVirtualFile)parent);
            DirectoryIndexImpl.this.replaceState(newState);
        }

        @NotNull
        private IndexState updateStateWithNewFile(@NotNull NewVirtualFile file, @NotNull NewVirtualFile parent) {
            OrderEntry[] entries;
            String newDirPackageName;
            IndexState originalState;
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "updateStateWithNewFile"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "updateStateWithNewFile"));
            }
            IndexState state = originalState = DirectoryIndexImpl.this.myState;
            int parentId = parent.getId();
            DirectoryInfo parentInfo = originalState.getInfo(parentId);
            if (parentInfo != null) {
                DirectoryIndexImpl.this.assertAncestor(parentInfo, (VirtualFile)parent, parentId);
            }
            String fileUrl = file.getUrl();
            for (Module module : ModuleManager.getInstance((Project)DirectoryIndexImpl.this.myProject).getModules()) {
                for (ContentEntry contentRoot : DirectoryIndexImpl.getContentEntries(module)) {
                    VirtualFile f;
                    String rel;
                    String contentRootUrl;
                    VirtualFile contFile;
                    if (parentInfo != null && (contFile = contentRoot.getFile()) != null && contFile.equals(parentInfo.getContentRoot()) || !FileUtil.startsWith((String)(contentRootUrl = contentRoot.getUrl()), (String)fileUrl) || (rel = FileUtil.getRelativePath((String)fileUrl, (String)contentRootUrl, (char)'/')) == null || !((f = file.findFileByRelativePath(rel)) instanceof NewVirtualFile)) continue;
                    if (state == originalState) {
                        state = state.copy(null);
                    }
                    state.fillMapWithModuleContent((NewVirtualFile)f, module, (NewVirtualFile)f, null);
                }
            }
            for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : DirectoryIndexImpl.this.myExcludePolicies) {
                if (!directoryIndexExcludePolicy.isExcludeRoot((VirtualFile)file)) continue;
                if (parentInfo == null || parentInfo.getContentRoot() == null) {
                    if (state == originalState) {
                        state = state.copy(null);
                    }
                    state.myProjectExcludeRoots.add(file.getId());
                }
                IndexState indexState = state;
                if (indexState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "updateStateWithNewFile"));
                }
                return indexState;
            }
            if (parentInfo == null) {
                IndexState indexState = state;
                if (indexState == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "updateStateWithNewFile"));
                }
                return indexState;
            }
            Module module = parentInfo.getModule();
            if (state == originalState) {
                state = state.copy(null);
            }
            VirtualFile parentContentRoot = parentInfo.getContentRoot();
            state.fillMapWithModuleContent(file, module, (NewVirtualFile)parentContentRoot, null);
            String parentPackage = state.getPackageNameForDirectory(parent);
            TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
            if (module != null && parentInfo.isInModuleSource()) {
                newDirPackageName = DirectoryIndexImpl.getPackageNameForSubdir(parentPackage, file.getName());
                state.fillMapWithModuleSource(module, (NewVirtualFile)parentContentRoot, file, newDirPackageName, (NewVirtualFile)parentInfo.getSourceRoot(), parentInfo.getSourceRootTypeId(), null, (TObjectIntHashMap<String>)tObjectIntHashMap);
            }
            if (parentInfo.hasLibraryClassRoot()) {
                newDirPackageName = DirectoryIndexImpl.getPackageNameForSubdir(parentPackage, file.getName());
                state.fillMapWithLibraryClasses(file, newDirPackageName, (NewVirtualFile)parentInfo.getLibraryClassRoot(), null, (TObjectIntHashMap<String>)tObjectIntHashMap, null);
            }
            if (parentInfo.isInLibrarySource()) {
                newDirPackageName = DirectoryIndexImpl.getPackageNameForSubdir(parentPackage, file.getName());
                state.fillMapWithLibrarySources(file, newDirPackageName, (NewVirtualFile)parentInfo.getSourceRoot(), null, (TObjectIntHashMap<String>)tObjectIntHashMap, null);
            }
            if ((entries = parentInfo.getOrderEntries()).length != 0) {
                state.fillMapWithOrderEntries(file, entries, null, null, null, parentInfo, null);
            }
            IndexState indexState = state;
            if (indexState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "updateStateWithNewFile"));
            }
            return indexState;
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "beforeFileDeletion"));
            }
            VirtualFile file = event.getFile();
            if (!file.isDirectory()) {
                return;
            }
            if (DirectoryIndexImpl.this.myState.getInfo(((NewVirtualFile)file).getId()) == null) {
                return;
            }
            TIntArrayList list = new TIntArrayList();
            this.addDirsRecursively(DirectoryIndexImpl.this.myState, list, file);
            file.putUserData(this.FILES_TO_RELEASE_KEY, (Object)list.toNativeArray());
        }

        private void addDirsRecursively(@NotNull IndexState state, @NotNull TIntArrayList list, @NotNull VirtualFile dir) {
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "addDirsRecursively"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "addDirsRecursively"));
            }
            if (dir == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "addDirsRecursively"));
            }
            if (!(dir instanceof NewVirtualFile)) {
                return;
            }
            int id = ((NewVirtualFile)dir).getId();
            if (state.getInfo(id) == null) {
                return;
            }
            list.add(id);
            for (VirtualFile child : ((NewVirtualFile)dir).getCachedChildren()) {
                if (!child.isDirectory()) continue;
                this.addDirsRecursively(state, list, child);
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "fileDeleted"));
            }
            VirtualFile file = event.getFile();
            final int[] list = (int[])file.getUserData(this.FILES_TO_RELEASE_KEY);
            if (list == null) {
                return;
            }
            IndexState copy = null;
            for (int id : list) {
                if (DirectoryIndexImpl.this.myState.getInfo(id) == null) continue;
                if (copy == null) {
                    copy = DirectoryIndexImpl.this.myState.copy(new TIntProcedure(){

                        public boolean execute(int fid) {
                            return ArrayUtil.indexOf((int[])list, (int)fid) == -1;
                        }
                    });
                }
                copy.myDirToInfoMap.remove(id);
                copy.setPackageName(id, null);
            }
            if (copy != null) {
                DirectoryIndexImpl.this.replaceState(copy);
            }
            DirectoryIndexImpl.this.myState.assertAncestorsConsistent();
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "fileMoved"));
            }
            VirtualFile file = event.getFile();
            if (file.isDirectory()) {
                DirectoryIndexImpl.this.doInitialize();
            }
            DirectoryIndexImpl.this.myState.assertAncestorsConsistent();
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName()) && (file = event.getFile()).isDirectory()) {
                DirectoryIndexImpl.this.doInitialize();
            }
            DirectoryIndexImpl.this.myState.assertAncestorsConsistent();
        }

        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "before"));
            }
            if (ourUseRootIndexOnly) {
                return;
            }
            this.myBatchChangePlanned = false;
            boolean willDoBatchUpdate = DirectoryIndexImpl.isLargeVfsChange(events);
            if (willDoBatchUpdate) {
                this.myBatchChangePlanned = true;
                LOG.info("will rebuild index state");
            } else {
                for (VFileEvent vFileEvent : events) {
                    BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)this, (VFileEvent)vFileEvent);
                }
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$MyVirtualFileListener", "after"));
            }
            RootIndex rootIndex = DirectoryIndexImpl.this.myRootIndex;
            if (rootIndex != null && !rootIndex.handleAfterEvent(events)) {
                DirectoryIndexImpl.this.myRootIndex = null;
            }
            if (ourUseRootIndexOnly) {
                return;
            }
            if (this.myBatchChangePlanned) {
                this.myBatchChangePlanned = false;
                long started = System.currentTimeMillis();
                DirectoryIndexImpl.this.doInitialize();
                LOG.info("Rebuilt indexstate for " + (System.currentTimeMillis() - started));
            } else {
                for (VFileEvent vFileEvent : events) {
                    BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)this, (VFileEvent)vFileEvent);
                }
            }
        }
    }
}

