/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumeratorSettings;
import com.intellij.openapi.roots.OrderRootType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OrderEnumerationHandler {
    public static final ExtensionPointName<Factory> EP_NAME = ExtensionPointName.create((String)"com.intellij.orderEnumerationHandlerFactory");

    @NotNull
    public AddDependencyType shouldAddDependency(@NotNull OrderEntry orderEntry, @NotNull OrderEnumeratorSettings settings) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/OrderEnumerationHandler", "shouldAddDependency"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/OrderEnumerationHandler", "shouldAddDependency"));
        }
        AddDependencyType addDependencyType = AddDependencyType.DEFAULT;
        if (addDependencyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/OrderEnumerationHandler", "shouldAddDependency"));
        }
        return addDependencyType;
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return false;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return true;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return true;
    }

    public boolean addCustomRootsForLibrary(@NotNull OrderEntry forOrderEntry, @NotNull OrderRootType type, @NotNull Collection<String> urls) {
        if (forOrderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/OrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/roots/OrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/roots/OrderEnumerationHandler", "addCustomRootsForLibrary"));
        }
        return false;
    }

    public static enum AddDependencyType {
        ADD,
        DO_NOT_ADD,
        DEFAULT;

    }

    public static abstract class Factory {
        public abstract boolean isApplicable(@NotNull Project var1);

        public abstract boolean isApplicable(@NotNull Module var1);

        public abstract OrderEnumerationHandler createHandler(@Nullable Module var1);
    }
}

