/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.libraries.Library;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryDependencyScopeSuggester {
    public static final ExtensionPointName<LibraryDependencyScopeSuggester> EP_NAME = ExtensionPointName.create((String)"com.intellij.library.dependencyScopeSuggester");

    @Nullable
    public abstract DependencyScope getDefaultDependencyScope(@NotNull Library var1);

    @NotNull
    public static DependencyScope getDefaultScope(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/roots/LibraryDependencyScopeSuggester", "getDefaultScope"));
        }
        for (LibraryDependencyScopeSuggester suggester : (LibraryDependencyScopeSuggester[])EP_NAME.getExtensions()) {
            DependencyScope scope = suggester.getDefaultDependencyScope(library);
            if (scope == null) continue;
            DependencyScope dependencyScope = scope;
            if (dependencyScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/LibraryDependencyScopeSuggester", "getDefaultScope"));
            }
            return dependencyScope;
        }
        DependencyScope dependencyScope = DependencyScope.COMPILE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/LibraryDependencyScopeSuggester", "getDefaultScope"));
        }
        return dependencyScope;
    }
}

