/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl.convertors;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class Convertor34 {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.impl.convertors.Convertor34");
    @NonNls
    public static final String PROJECT_ROOT_MANAGER = "ProjectRootManager";
    @NonNls
    public static final String PROJECT_ROOT_MANAGER_CLASS = "com.intellij.openapi.projectRoots.ProjectRootManager";
    private static final String SOURCE_ROOTS_NOT_UNDER_PROJECT_ROOTS = ProjectBundle.message((String)"project.convert.source.roots.not.under.project.roots.error", (Object[])new Object[0]);
    private static final String JAVA_DOC_ROOTS_CANNOT_BE_CONVERTED = ProjectBundle.message((String)"project.convert.javadoc.paths.error", (Object[])new Object[0]);
    private static final String MULTIPLE_OUTPUT_PATHS = ProjectBundle.message((String)"project.convert.multiple.output.paths.error", (Object[])new Object[0]);

    public static void execute(Element root, String filePath, @Nullable ArrayList<String> conversionProblems) {
        if (filePath == null) {
            return;
        }
        if (conversionProblems == null) {
            conversionProblems = new ArrayList();
        }
        Convertor34.convertProjectFile(root, filePath, conversionProblems);
    }

    public static String convertLibraryTable34(Element root, String filePath) {
        if (filePath == null) {
            return null;
        }
        Element libraryTable = Convertor34.findNamedChild(root, "component", "ProjectLibraryTable");
        if (libraryTable == null) {
            return null;
        }
        Element applicationLibraryTable = new Element("component");
        applicationLibraryTable.setAttribute("name", "libraryTable");
        List oldLibraries = libraryTable.getChildren("library");
        for (int i = 0; i < oldLibraries.size(); ++i) {
            Element oldLibrary = (Element)oldLibraries.get(i);
            Element newLibrary = Convertor34.convertLibrary(oldLibrary);
            applicationLibraryTable.addContent(newLibrary);
        }
        String ioFilePath = filePath.replace('/', File.separatorChar);
        String parentPath = new File(ioFilePath).getParent();
        if (parentPath == null) {
            parentPath = ".";
        }
        parentPath = parentPath + "/applicationLibraries.xml";
        Element newRoot = new Element("application");
        newRoot.addContent(applicationLibraryTable);
        Document libraryTableDocument = new Document(newRoot);
        try {
            JDOMUtil.writeDocument((Document)libraryTableDocument, (String)parentPath, (String)"\n");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
        return parentPath;
    }

    private static Element convertLibrary(Element oldLibrary) {
        Element library = new Element("library");
        Element nameChild = oldLibrary.getChild("name");
        LOG.assertTrue(nameChild != null);
        library.setAttribute("name", nameChild.getAttributeValue("value"));
        Convertor34.processLibraryRootContainer(oldLibrary, library, "CLASSES", "classPath");
        Convertor34.processLibraryRootContainer(oldLibrary, library, "JAVADOC", "javadocPath");
        Convertor34.processLibraryRootContainer(oldLibrary, library, "SOURCES", "sourcePath");
        return library;
    }

    private static void processLibraryRootContainer(Element oldLibrary, Element library, String newElementType, String oldElementType) {
        Element elementCLASSES = new Element(newElementType);
        Element rootsElement = oldLibrary.getChild("roots");
        Element classPath = rootsElement.getChild(oldElementType);
        if (classPath != null) {
            Convertor34.processRootTypeElement(classPath, new SimpleRootProcessor(elementCLASSES));
        }
        library.addContent(elementCLASSES);
    }

    private static void convertProjectFile(Element root, String filePath, ArrayList<String> conversionProblems) {
        Element rootComponent = null;
        List components = root.getChildren("component");
        for (Object component1 : components) {
            Element component = (Element)component1;
            if (!Convertor34.isProjectRootManager(component)) continue;
            rootComponent = component;
        }
        if (rootComponent == null) {
            return;
        }
        Element module = Convertor34.createModule(root);
        String moduleFilePath = filePath.substring(0, filePath.lastIndexOf(46)) + ".iml";
        Element moduleRootComponent = Convertor34.convertProjectRootManager(rootComponent, conversionProblems);
        module.addContent(moduleRootComponent);
        Document moduleDoc = new Document(module);
        try {
            JDOMUtil.writeDocument((Document)moduleDoc, (String)moduleFilePath, (String)"\n");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(moduleFilePath));
        rootComponent.setAttribute("name", PROJECT_ROOT_MANAGER);
        rootComponent.setAttribute("version", "4");
        Element moduleManager = new Element("component");
        moduleManager.setAttribute("name", "ProjectModuleManager");
        Convertor34.addModule(moduleFilePath, moduleManager);
        String moduleFile = new File(moduleFilePath).getName();
        Convertor34.convertWebApps(moduleManager, root, rootComponent, moduleFile.substring(0, moduleFile.lastIndexOf(46)));
        root.addContent(moduleManager);
    }

    private static Element createModule(Element root) {
        Element module = new Element("module");
        module.setAttribute("version", "4");
        String relativePaths = root.getAttributeValue("relativePaths");
        if (relativePaths != null) {
            module.setAttribute("relativePaths", relativePaths);
        }
        return module;
    }

    private static void convertWebApps(Element moduleManager, Element projectElement, Element projectRootManager, String mainModule) {
        Element webRootContainer = Convertor34.findNamedChild(projectElement, "component", "WebRootContainer");
        if (webRootContainer == null) {
            return;
        }
        List roots = webRootContainer.getChildren("root");
        for (Element root : roots) {
            String moduleName;
            String name = root.getAttributeValue("name");
            String url = root.getAttributeValue("url");
            if (name == null || url == null) continue;
            String filepath = VirtualFileManager.extractPath((String)url);
            VirtualFile moduleDirectory = LocalFileSystem.getInstance().findFileByPath(filepath);
            if (moduleDirectory == null) continue;
            Element module = Convertor34.createModule(projectElement);
            module.setAttribute("type", "J2EE_WEB_MODULE");
            Element rootManager = Convertor34.createWebModuleRootManager(module, moduleDirectory, projectRootManager, mainModule);
            module.addContent(rootManager);
            Element buildComponent = Convertor34.createWebModuleBuildComponent();
            module.addContent(buildComponent);
            Element moduleProperties = Convertor34.createWebModuleProperties(moduleDirectory);
            module.addContent(moduleProperties);
            Document moduleDocument = new Document(module);
            String string = moduleName = !"".equals(name) ? name : moduleDirectory.getName();
            if (moduleName.equals(mainModule)) {
                moduleName = "web" + moduleName;
            }
            try {
                final String modulePath = moduleDirectory.getPath() + "/" + moduleName + ".iml";
                JDOMUtil.writeDocument((Document)moduleDocument, (String)modulePath, (String)"\n");
                Convertor34.addModule(modulePath, moduleManager);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(modulePath));
                    }
                });
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static void addSetting(Element parent, String name, String value) {
        Element option = new Element("setting");
        option.setAttribute("name", name);
        option.setAttribute("value", value);
        parent.addContent(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element createWebModuleProperties(VirtualFile moduleDirectory) {
        Element component = new Element("component");
        component.setAttribute("name", "WebModuleProperties");
        try {
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(new File(moduleDirectory.getPath(), "WEB-INF/web.xml")));
                writer.write(FileTemplateManager.getInstance().getJ2eeTemplate("web.2_3.xml").getText());
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        Element webRoots = new Element("webroots");
        component.addContent(webRoots);
        Element root = new Element("root");
        webRoots.addContent(root);
        root.setAttribute("url", moduleDirectory.getUrl());
        root.setAttribute("relative", "/");
        return component;
    }

    private static Element createWebModuleBuildComponent() {
        Element component = new Element("component");
        component.setAttribute("name", "WebModuleBuildComponent");
        Convertor34.addSetting(component, "EXPLODED_URL", "file://$MODULE_DIR$");
        Convertor34.addSetting(component, "EXPLODED_ENABLED", "true");
        return component;
    }

    private static Element createWebModuleRootManager(Element module, VirtualFile moduleDirectory, Element projectRootManager, String mainModule) {
        VirtualFile lib;
        String jdkName;
        Element newModuleRootManager = new Element("component");
        newModuleRootManager.setAttribute("name", "NewModuleRootManager");
        Element jdk = projectRootManager.getChild("jdk");
        if (jdk != null && (jdkName = jdk.getAttributeValue("name")) != null) {
            Element orderEntry = new Element("orderEntry");
            orderEntry.setAttribute("type", "jdk");
            orderEntry.setAttribute("jdkName", jdkName);
            newModuleRootManager.addContent(orderEntry);
        }
        Element orderEntry = new Element("orderEntry");
        orderEntry.setAttribute("type", "module");
        orderEntry.setAttribute("module-name", mainModule);
        newModuleRootManager.addContent(orderEntry);
        Element output = new Element("output");
        output.setAttribute("url", "file://" + Convertor34.getModulePath("classes", moduleDirectory.getPath()));
        newModuleRootManager.addContent(output);
        Element content = new Element("content");
        content.setAttribute("url", "file://" + Convertor34.getModulePath("", moduleDirectory.getPath()));
        newModuleRootManager.addContent(content);
        VirtualFile classesDir = moduleDirectory.findFileByRelativePath("WEB-INF/classes");
        if (classesDir != null) {
            Element classes = Convertor34.createLibraryEntry(classesDir, module, moduleDirectory);
            newModuleRootManager.addContent(classes);
        }
        if ((lib = moduleDirectory.findFileByRelativePath("WEB-INF/lib")) != null) {
            for (VirtualFile virtualFile : lib.getChildren()) {
                Element libEntry = Convertor34.createLibraryEntry(virtualFile, module, moduleDirectory);
                newModuleRootManager.addContent(libEntry);
            }
        }
        return newModuleRootManager;
    }

    private static Element createLibraryEntry(VirtualFile file, Element module, VirtualFile moduleDirectory) {
        String path = file.getPath().substring(moduleDirectory.getPath().length() + 1);
        if (file.getFileSystem() instanceof JarFileSystem) {
            path = path + "!/";
        }
        Element orderEntry = new Element("orderEntry");
        orderEntry.setAttribute("type", "module-library");
        Element library = new Element("library");
        orderEntry.addContent(library);
        Element classes = new Element("CLASSES");
        library.addContent(classes);
        Element root = new Element("root");
        root.setAttribute("url", "file://" + Convertor34.getModulePath(path, moduleDirectory.getPath()));
        classes.addContent(root);
        return orderEntry;
    }

    private static String getModulePath(String path, String moduleDirectory) {
        return "".equals(path) ? moduleDirectory : moduleDirectory + "/" + path;
    }

    private static void addModule(String moduleFilePath, Element moduleManager) {
        Element moduleEntry = new Element("module");
        String moduleVfsPath = moduleFilePath.replace(File.separatorChar, '/');
        moduleEntry.setAttribute("filepath", moduleVfsPath);
        moduleEntry.setAttribute("fileurl", "file://" + moduleVfsPath);
        Element modulesEntry = moduleManager.getChild("modules");
        if (modulesEntry == null) {
            modulesEntry = new Element("modules");
            moduleManager.addContent(modulesEntry);
        }
        modulesEntry.addContent(moduleEntry);
    }

    private static Element convertProjectRootManager(Element projectRootManager, ArrayList<String> conversionProblems) {
        return new ProjectToModuleConverter(projectRootManager, conversionProblems).getModuleRootManager();
    }

    private static void processRoot(Element root, RootElementProcessor processor) {
        LOG.assertTrue("root".equals(root.getName()));
        String type = root.getAttributeValue("type");
        LOG.assertTrue(type != null);
        if ("simple".equals(type)) {
            processor.processSimpleRoot(root);
        } else if ("output".equals(type)) {
            processor.processOutputRoot(root);
        } else if ("jdk".equals(type)) {
            processor.processJdkRoot(root);
        } else if ("excludedOutput".equals(type)) {
            processor.processExcludedOutputRoot(root);
        } else if ("library".equals(type)) {
            processor.processLibraryRoot(root);
        } else if ("ejb".equals(type)) {
            processor.processEjbRoot(root);
        } else if ("composite".equals(type)) {
            List children = root.getChildren("root");
            for (int i = 0; i < children.size(); ++i) {
                Element element = (Element)children.get(i);
                Convertor34.processRoot(element, processor);
            }
        } else {
            LOG.error("Unknown root type: " + type);
        }
    }

    private static void processRootTypeElement(Element rootTypeElement, RootElementProcessor rootProcessor) {
        if (rootTypeElement == null) {
            return;
        }
        List children = rootTypeElement.getChildren("root");
        for (int i = 0; i < children.size(); ++i) {
            Element element = (Element)children.get(i);
            Convertor34.processRoot(element, rootProcessor);
        }
    }

    private static boolean isProjectRootManager(Element component) {
        String compName = component.getAttributeValue("name");
        String compClass = component.getAttributeValue("class");
        return compName != null && compName.equals(PROJECT_ROOT_MANAGER) || compClass != null && compClass.equals(PROJECT_ROOT_MANAGER_CLASS);
    }

    private static Element findNamedChild(Element root, String name, String nameAttributeValue) {
        List children = root.getChildren(name);
        for (int i = 0; i < children.size(); ++i) {
            Element e = (Element)children.get(i);
            if (!nameAttributeValue.equals(e.getAttributeValue("name"))) continue;
            return e;
        }
        return null;
    }

    private static class SimpleRootProcessor
    extends EmptyRootProcessor {
        private final Element myTargetElement;

        public SimpleRootProcessor(Element targetElement) {
            this.myTargetElement = targetElement;
        }

        @Override
        public void processSimpleRoot(Element root) {
            String url = root.getAttributeValue("url");
            Element newRoot = new Element("root");
            newRoot.setAttribute("url", url);
            this.myTargetElement.addContent(newRoot);
        }

        @Override
        public void processEjbRoot(Element root) {
        }

        @Override
        protected String classId() {
            return "SimpleRootProcessor";
        }
    }

    private static class ProjectToModuleConverter {
        private final Element myProjectRootManager;
        private final Element myModuleRootManager;
        private final ArrayList<String> myProjectRoots;
        private final List<String> mySourceFolders;
        private final ArrayList<String> myExcludeFolders;
        private final ArrayList<String> myDetectedProblems;

        private ProjectToModuleConverter(Element projectRootManager, ArrayList<String> problems) {
            String enabled;
            Element excludeOutput;
            this.myProjectRootManager = projectRootManager;
            this.myModuleRootManager = new Element("component");
            this.myModuleRootManager.setAttribute("name", "NewModuleRootManager");
            this.myProjectRoots = new ArrayList();
            this.myDetectedProblems = problems;
            Element projectPath = projectRootManager.getChild("projectPath");
            if (projectPath != null) {
                Convertor34.processRootTypeElement(projectPath, new ProjectRootProcessor());
            }
            Collections.sort(this.myProjectRoots);
            for (int i = 0; i < this.myProjectRoots.size(); ++i) {
                String path = this.myProjectRoots.get(i);
                int next = i + 1;
                while (next < this.myProjectRoots.size() && this.myProjectRoots.get(next).startsWith(path)) {
                    this.myProjectRoots.remove(next);
                }
            }
            Element sourcePath = projectRootManager.getChild("sourcePath");
            this.mySourceFolders = new ArrayList<String>();
            Convertor34.processRootTypeElement(sourcePath, new SourceRootProcessor());
            Element excludePath = projectRootManager.getChild("excludePath");
            this.myExcludeFolders = new ArrayList();
            Convertor34.processRootTypeElement(excludePath, new ExcludeRootsProcessor());
            Element javadocPath = projectRootManager.getChild("javadocPath");
            Convertor34.processRootTypeElement(javadocPath, new JavaDocRootProcessor());
            Element patternExcludeFolder = new Element("excludeFolder");
            Element patternSourceFolder = new Element("sourceFolder");
            patternSourceFolder.setAttribute("isTestSource", "false");
            Map<String, List<String>> contentToSource = ProjectToModuleConverter.dispatchFolders(this.myProjectRoots, this.mySourceFolders);
            Map<String, List<String>> contentToExclude = ProjectToModuleConverter.dispatchFolders(this.myProjectRoots, this.myExcludeFolders);
            for (String root : this.myProjectRoots) {
                Element contentElement = new Element("content");
                contentElement.setAttribute("url", root);
                ProjectToModuleConverter.createFolders(contentElement, patternSourceFolder, contentToSource.get(root));
                ProjectToModuleConverter.createFolders(contentElement, patternExcludeFolder, contentToExclude.get(root));
                this.myModuleRootManager.addContent(contentElement);
            }
            Element classPath = projectRootManager.getChild("classPath");
            Convertor34.processRootTypeElement(classPath, new ClassPathRootProcessor());
            Element projectElement = (Element)this.myProjectRootManager.getParent();
            Element compilerConfigurationElement = Convertor34.findNamedChild(projectElement, "component", "CompilerConfiguration");
            if (compilerConfigurationElement != null) {
                Element outputMode;
                String attributeValue;
                String path;
                Element option = Convertor34.findNamedChild(compilerConfigurationElement, "option", "DEFAULT_OUTPUT_PATH");
                String string = path = option == null ? null : option.getAttributeValue("value");
                if (path != null) {
                    String url = "file://" + path;
                    Element outputElement = new Element("output");
                    outputElement.setAttribute("url", url);
                    this.myModuleRootManager.addContent(outputElement);
                    Element outputTestElement = new Element("output-test");
                    outputTestElement.setAttribute("url", url);
                    this.myModuleRootManager.addContent(outputTestElement);
                }
                String string2 = attributeValue = (outputMode = Convertor34.findNamedChild(compilerConfigurationElement, "option", "OUTPUT_MODE")) != null ? outputMode.getAttributeValue("value") : "";
                if ("multiple".equals(attributeValue)) {
                    this.addProblem(MULTIPLE_OUTPUT_PATHS);
                }
            }
            if ((excludeOutput = this.myProjectRootManager.getChild("exclude_output")) != null && ("yes".equals(enabled = excludeOutput.getAttributeValue("enabled")) || "true".equals(enabled))) {
                this.myModuleRootManager.addContent(new Element("exclude-output"));
            }
        }

        private static void createFolders(Element contentElement, Element patternFolderElement, List<String> folders) {
            for (String folder : folders) {
                Element folderElement = patternFolderElement.clone();
                folderElement.setAttribute("url", folder);
                contentElement.addContent(folderElement);
            }
        }

        private static Map<String, List<String>> dispatchFolders(ArrayList<String> projectRoots, List<String> folders) {
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            for (String root : projectRoots) {
                ArrayList<String> foldersForRoot = new ArrayList<String>();
                result.put(root, foldersForRoot);
                for (String folder : folders) {
                    if (!folder.startsWith(root)) continue;
                    foldersForRoot.add(folder);
                }
                Collections.sort(foldersForRoot);
            }
            return result;
        }

        public Element getModuleRootManager() {
            return this.myModuleRootManager;
        }

        private void addProblem(String description) {
            if (!this.myDetectedProblems.contains(description)) {
                this.myDetectedProblems.add(description);
            }
        }

        private class ClassPathRootProcessor
        extends EmptyRootProcessor {
            private ClassPathRootProcessor() {
            }

            @Override
            public void processSimpleRoot(Element root) {
                Element orderEntry = new Element("orderEntry");
                orderEntry.setAttribute("type", "module-library");
                Element libraryElement = new Element("library");
                Element classesElement = new Element("CLASSES");
                Element rootElement = new Element("root");
                rootElement.setAttribute(root.getAttribute("url").clone());
                classesElement.addContent(rootElement);
                libraryElement.addContent(classesElement);
                orderEntry.addContent(libraryElement);
                ProjectToModuleConverter.this.myModuleRootManager.addContent(orderEntry);
            }

            @Override
            public void processJdkRoot(Element root) {
                Element orderEntry = new Element("orderEntry");
                orderEntry.setAttribute("type", "jdk");
                orderEntry.setAttribute("jdkName", root.getAttributeValue("name"));
                ProjectToModuleConverter.this.myModuleRootManager.addContent(orderEntry);
            }

            @Override
            public void processLibraryRoot(Element root) {
                String libraryName = root.getAttributeValue("name");
                Element orderEntry = new Element("orderEntry");
                orderEntry.setAttribute("type", "library");
                orderEntry.setAttribute("name", libraryName);
                orderEntry.setAttribute("level", "application");
                ProjectToModuleConverter.this.myModuleRootManager.addContent(orderEntry);
            }

            @Override
            public void processEjbRoot(Element root) {
            }

            @Override
            protected String classId() {
                return "ClassPathProcessor";
            }

            @Override
            public void processOutputRoot(Element root) {
                Element orderEntry = new Element("orderEntry");
                orderEntry.setAttribute("type", "sourceFolder");
                ProjectToModuleConverter.this.myModuleRootManager.addContent(orderEntry);
            }
        }

        private class ExcludeRootsProcessor
        extends EmptyRootProcessor {
            private ExcludeRootsProcessor() {
            }

            @Override
            public void processSimpleRoot(Element root) {
                String url = root.getAttributeValue("url");
                for (int i = 0; i < ProjectToModuleConverter.this.myProjectRoots.size(); ++i) {
                    String projectRoot = (String)ProjectToModuleConverter.this.myProjectRoots.get(i);
                    if (!url.startsWith(projectRoot)) continue;
                    ProjectToModuleConverter.this.myExcludeFolders.add(url);
                }
            }

            @Override
            public void processEjbRoot(Element root) {
            }

            @Override
            protected String classId() {
                return "ExcludeRootsProcessor";
            }

            @Override
            public void processJdkRoot(Element root) {
            }

            @Override
            public void processExcludedOutputRoot(Element root) {
            }
        }

        private class SourceRootProcessor
        extends EmptyRootProcessor {
            private SourceRootProcessor() {
            }

            @Override
            public void processSimpleRoot(Element root) {
                String url = root.getAttributeValue("url");
                boolean found = false;
                for (int i = 0; i < ProjectToModuleConverter.this.myProjectRoots.size(); ++i) {
                    String projectPath = (String)ProjectToModuleConverter.this.myProjectRoots.get(i);
                    if (url.startsWith(projectPath)) {
                        ProjectToModuleConverter.this.mySourceFolders.add(url);
                        found = true;
                        break;
                    }
                    if (!projectPath.startsWith(url)) continue;
                    ProjectToModuleConverter.this.myProjectRoots.remove(i);
                    ProjectToModuleConverter.this.myProjectRoots.add(i, url);
                    ProjectToModuleConverter.this.mySourceFolders.add(url);
                    found = true;
                    break;
                }
                if (!found) {
                    ProjectToModuleConverter.this.addProblem(SOURCE_ROOTS_NOT_UNDER_PROJECT_ROOTS);
                }
            }

            @Override
            public void processJdkRoot(Element root) {
            }

            @Override
            public void processLibraryRoot(Element root) {
            }

            @Override
            public void processEjbRoot(Element root) {
            }

            @Override
            protected String classId() {
                return "SourceRootProcessor";
            }
        }

        private class ProjectRootProcessor
        extends EmptyRootProcessor {
            private ProjectRootProcessor() {
            }

            @Override
            public void processSimpleRoot(Element root) {
                String value = root.getAttributeValue("url");
                ProjectToModuleConverter.this.myProjectRoots.add(value);
            }

            @Override
            public void processEjbRoot(Element root) {
            }

            @Override
            protected String classId() {
                return "ProjectRootProcessor";
            }
        }

        private class JavaDocRootProcessor
        extends EmptyRootProcessor {
            private JavaDocRootProcessor() {
            }

            @Override
            protected void cannotProcess(Element root) {
                ProjectToModuleConverter.this.addProblem(JAVA_DOC_ROOTS_CANNOT_BE_CONVERTED);
            }

            @Override
            protected String classId() {
                return "JavaDocRootProcessor";
            }
        }
    }

    private static abstract class EmptyRootProcessor
    implements RootElementProcessor {
        private EmptyRootProcessor() {
        }

        @Override
        public void processSimpleRoot(Element root) {
            this.cannotProcess(root);
        }

        @Override
        public void processJdkRoot(Element root) {
            this.cannotProcess(root);
        }

        @Override
        public void processOutputRoot(Element root) {
            this.cannotProcess(root);
        }

        @Override
        public void processExcludedOutputRoot(Element root) {
            this.cannotProcess(root);
        }

        @Override
        public void processLibraryRoot(Element root) {
            this.cannotProcess(root);
        }

        @Override
        public void processEjbRoot(Element root) {
            this.cannotProcess(root);
        }

        protected void cannotProcess(Element root) {
            LOG.error("Cannot process roots of type " + root.getAttributeValue("type") + " in " + this.classId());
        }

        protected abstract String classId();
    }

    private static interface RootElementProcessor {
        public void processSimpleRoot(Element var1);

        public void processJdkRoot(Element var1);

        public void processOutputRoot(Element var1);

        public void processExcludedOutputRoot(Element var1);

        public void processLibraryRoot(Element var1);

        public void processEjbRoot(Element var1);
    }
}

