/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.ProjectPathMacroManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.project.impl.ProjectStoreClassProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.util.Function;
import com.intellij.util.TimedReference;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public class ProjectImpl
extends PlatformComponentManagerImpl
implements ProjectEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.project.impl.ProjectImpl");
    private static final String PLUGIN_SETTINGS_ERROR = "Plugin Settings Error";
    public static final String NAME_FILE = ".name";
    public static Key<Long> CREATION_TIME = Key.create((String)"ProjectImpl.CREATION_TIME");
    private ProjectManager myManager;
    private volatile IProjectStore myComponentStore;
    private MyProjectManagerListener myProjectManagerListener;
    private final AtomicBoolean mySavingInProgress;
    public boolean myOptimiseTestLoadSpeed;
    private String myName;
    private String myOldName;

    protected ProjectImpl(@NotNull ProjectManager manager, @NotNull String filePath, boolean optimiseTestLoadSpeed, @Nullable String projectName) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectImpl", "<init>"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectImpl", "<init>"));
        }
        super((ComponentManager)ApplicationManager.getApplication(), "Project " + (projectName == null ? filePath : projectName));
        this.mySavingInProgress = new AtomicBoolean(false);
        this.putUserData(CREATION_TIME, System.nanoTime());
        this.getPicoContainer().registerComponentInstance(Project.class, (Object)this);
        if (!this.isDefault()) {
            this.getStateStore().setProjectFilePath(filePath);
        }
        this.myOptimiseTestLoadSpeed = optimiseTestLoadSpeed;
        this.myManager = manager;
        String string = this.myName = projectName == null ? this.getStateStore().getProjectName() : projectName;
        if (!this.isDefault() && projectName != null && this.getStateStore().getStorageScheme().equals((Object)StorageScheme.DIRECTORY_BASED)) {
            this.myOldName = "";
        }
    }

    @Override
    public void setProjectName(@NotNull String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectImpl", "setProjectName"));
        }
        if (!projectName.equals(this.myName)) {
            this.myOldName = this.myName;
            this.myName = projectName;
            StartupManager.getInstance((Project)this).runWhenProjectIsInitialized((Runnable)new DumbAwareRunnable(){

                public void run() {
                    if (ProjectImpl.this.isDisposed()) {
                        return;
                    }
                    JFrame frame = WindowManager.getInstance().getFrame((Project)ProjectImpl.this);
                    String title = FrameTitleBuilder.getInstance().getProjectTitle(ProjectImpl.this);
                    if (frame != null && title != null) {
                        frame.setTitle(title);
                    }
                }
            });
        }
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectImpl", "bootstrapPicoContainer"));
        }
        Extensions.instantiateArea((String)"IDEA_PROJECT", (AreaInstance)this, null);
        super.bootstrapPicoContainer(name);
        MutablePicoContainer picoContainer = this.getPicoContainer();
        final ProjectStoreClassProvider projectStoreClassProvider = (ProjectStoreClassProvider)picoContainer.getComponentInstanceOfType(ProjectStoreClassProvider.class);
        picoContainer.registerComponentImplementation(ProjectPathMacroManager.class);
        picoContainer.registerComponent(new ComponentAdapter(){
            ComponentAdapter myDelegate;

            public ComponentAdapter getDelegate() {
                if (this.myDelegate == null) {
                    Class<? extends IComponentStore> storeClass = projectStoreClassProvider.getProjectStoreClass(ProjectImpl.this.isDefault());
                    this.myDelegate = new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter(storeClass, storeClass, null, true));
                }
                return this.myDelegate;
            }

            public Object getComponentKey() {
                return IComponentStore.class;
            }

            public Class getComponentImplementation() {
                return this.getDelegate().getComponentImplementation();
            }

            public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException {
                return this.getDelegate().getComponentInstance(container);
            }

            public void verify(PicoContainer container) throws PicoIntrospectionException {
                this.getDelegate().verify(container);
            }

            public void accept(PicoVisitor visitor) {
                visitor.visitComponentAdapter((ComponentAdapter)this);
                this.getDelegate().accept(visitor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public IProjectStore getStateStore() {
        IProjectStore componentStore = this.myComponentStore;
        if (componentStore != null) {
            IProjectStore iProjectStore = componentStore;
            if (iProjectStore != null) return iProjectStore;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getStateStore"));
        }
        ProjectImpl projectImpl = this;
        // MONITORENTER : projectImpl
        componentStore = this.myComponentStore;
        if (componentStore == null) {
            this.myComponentStore = componentStore = (IProjectStore)this.getPicoContainer().getComponentInstance(IComponentStore.class);
        }
        IProjectStore iProjectStore = componentStore;
        // MONITOREXIT : projectImpl
        if (iProjectStore != null) return iProjectStore;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getStateStore"));
    }

    @Override
    public void initializeComponent(Object component, boolean service) {
        ProgressIndicator indicator;
        if (!service && (indicator = ProjectImpl.getProgressIndicator()) != null) {
            indicator.setIndeterminate(false);
            indicator.setFraction((double)this.getPercentageOfComponentsLoaded());
        }
        this.getStateStore().initComponent(component, service);
    }

    public boolean isOpen() {
        return ProjectManagerEx.getInstanceEx().isProjectOpened(this);
    }

    public boolean isInitialized() {
        return this.isOpen() && !this.isDisposed() && StartupManagerEx.getInstanceEx(this).startupActivityPassed();
    }

    public void loadProjectComponents() {
        IdeaPluginDescriptor[] plugins;
        for (IdeaPluginDescriptor plugin : plugins = PluginManagerCore.getPlugins()) {
            if (PluginManagerCore.shouldSkipPlugin(plugin)) continue;
            this.loadComponentsConfiguration(plugin.getProjectComponents(), (PluginDescriptor)plugin, this.isDefault());
        }
    }

    @NotNull
    public String getProjectFilePath() {
        String string = this.getStateStore().getProjectFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getProjectFilePath"));
        }
        return string;
    }

    public VirtualFile getProjectFile() {
        return this.getStateStore().getProjectFile();
    }

    public VirtualFile getBaseDir() {
        return this.getStateStore().getProjectBaseDir();
    }

    public String getBasePath() {
        return this.getStateStore().getProjectBasePath();
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getName"));
        }
        return string;
    }

    @NonNls
    public String getPresentableUrl() {
        if (this.myName == null) {
            return null;
        }
        return this.getStateStore().getPresentableUrl();
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        String str = this.getPresentableUrl();
        if (str == null) {
            str = this.getName();
        }
        String prefix = this.getStateStore().getStorageScheme() == StorageScheme.DIRECTORY_BASED ? "" : this.getName();
        String string = prefix + Integer.toHexString(str.hashCode());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getLocationHash"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getWorkspaceFile() {
        return this.getStateStore().getWorkspaceFile();
    }

    @Override
    public boolean isOptimiseTestLoadSpeed() {
        return this.myOptimiseTestLoadSpeed;
    }

    @Override
    public void setOptimiseTestLoadSpeed(boolean optimiseTestLoadSpeed) {
        this.myOptimiseTestLoadSpeed = optimiseTestLoadSpeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        ProgressIndicator progressIndicator;
        long start = System.currentTimeMillis();
        ProgressIndicator progressIndicator2 = progressIndicator = this.isDefault() ? null : ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.pushState();
        }
        super.init();
        if (progressIndicator != null) {
            progressIndicator.popState();
        }
        long time = System.currentTimeMillis() - start;
        LOG.info(this.getComponentConfigurations().length + " project components initialized in " + time + " ms");
        ((ProjectLifecycleListener)this.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).projectComponentsInitialized((Project)this);
        ProjectImpl projectImpl = this;
        synchronized (projectImpl) {
            this.myProjectManagerListener = new MyProjectManagerListener();
            this.myManager.addProjectManagerListener((Project)this, (ProjectManagerListener)this.myProjectManagerListener);
        }
    }

    public boolean isToSaveProjectName() {
        VirtualFile baseDir;
        IProjectStore stateStore;
        if (!this.isDefault() && (stateStore = this.getStateStore()).getStorageScheme().equals((Object)StorageScheme.DIRECTORY_BASED) && (baseDir = stateStore.getProjectBaseDir()) != null && baseDir.isValid()) {
            return this.myOldName != null && !this.myOldName.equals(this.getName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (ApplicationManagerEx.getApplicationEx().isDoNotSave()) {
            return;
        }
        if (!this.mySavingInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            VirtualFile ideaDir;
            IProjectStore stateStore;
            VirtualFile baseDir;
            if (this.isToSaveProjectName() && (baseDir = (stateStore = this.getStateStore()).getProjectBaseDir()) != null && baseDir.isValid() && (ideaDir = baseDir.findChild(".idea")) != null && ideaDir.isValid() && ideaDir.isDirectory()) {
                File nameFile = new File(ideaDir.getPath(), NAME_FILE);
                try {
                    FileUtil.writeToFile((File)nameFile, (byte[])this.getName().getBytes("UTF-8"), (boolean)false);
                    this.myOldName = null;
                }
                catch (IOException e) {
                    LOG.info("Unable to store project name to: " + nameFile.getPath());
                }
                RecentProjectsManagerBase.getInstance().clearNameCache();
            }
            StoreUtil.doSave(this.getStateStore());
        }
        catch (IComponentStore.SaveCancelledException e) {
            LOG.info((Throwable)e);
        }
        catch (PluginException e) {
            PluginManagerCore.disablePlugin(e.getPluginId().getIdString());
            Notification notification = new Notification(PLUGIN_SETTINGS_ERROR, "Unable to save plugin settings!", "<p>The plugin <i>" + e.getPluginId() + "</i> failed to save settings and has been disabled. Please restart " + ApplicationNamesInfo.getInstance().getFullProductName() + "</p>" + (ApplicationManagerEx.getApplicationEx().isInternal() ? "<p>" + StringUtil.getThrowableText((Throwable)e) + "</p>" : ""), NotificationType.ERROR);
            Notifications.Bus.notify((Notification)notification, (Project)this);
            LOG.info("Unable to save plugin settings", (Throwable)e);
        }
        catch (IOException e) {
            MessagesEx.error(this, ProjectBundle.message((String)"project.save.error", (Object[])new Object[]{e.getMessage()})).showLater();
            LOG.info("Error saving project", (Throwable)e);
        }
        finally {
            this.mySavingInProgress.set(false);
            ((ProjectEx.ProjectSaved)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProjectEx.ProjectSaved.TOPIC)).saved(this);
        }
    }

    @Override
    public synchronized void dispose() {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        assert (application.isWriteAccessAllowed());
        LOG.assertTrue(application.isUnitTestMode() || !ProjectManagerEx.getInstanceEx().isProjectOpened(this));
        LOG.assertTrue(!this.isDisposed());
        if (this.myProjectManagerListener != null) {
            this.myManager.removeProjectManagerListener((Project)this, (ProjectManagerListener)this.myProjectManagerListener);
        }
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        this.myManager = null;
        this.myProjectManagerListener = null;
        this.myComponentStore = null;
        super.dispose();
        if (!application.isDisposed()) {
            ((ProjectLifecycleListener)application.getMessageBus().syncPublisher(ProjectLifecycleListener.TOPIC)).afterProjectClosed((Project)this);
        }
        TimedReference.disposeTimed();
    }

    private void projectOpened() {
        ProjectComponent[] components;
        for (ProjectComponent component : components = this.getComponents(ProjectComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Throwable e) {
                LOG.error(component.toString(), e);
            }
        }
    }

    private void projectClosed() {
        ArrayList<ProjectComponent> components = new ArrayList<ProjectComponent>(Arrays.asList(this.getComponents(ProjectComponent.class)));
        Collections.reverse(components);
        for (ProjectComponent component : components) {
            try {
                component.projectClosed();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectImpl", "getExtensions"));
        }
        Object[] objectArray = Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/impl/ProjectImpl", "getExtensions"));
        }
        return objectArray;
    }

    public String getDefaultName() {
        return this.isDefault() ? this.myName : this.getStateStore().getProjectName();
    }

    @Override
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getArea((AreaInstance)this).getPicoContainer();
    }

    public boolean isDefault() {
        return false;
    }

    @Override
    public void checkUnknownMacros(boolean showDialog) {
        final IProjectStore stateStore = this.getStateStore();
        TrackingPathMacroSubstitutor[] substitutors = stateStore.getSubstitutors();
        HashSet<String> unknownMacros = new HashSet<String>();
        for (TrackingPathMacroSubstitutor substitutor : substitutors) {
            unknownMacros.addAll(substitutor.getUnknownMacros(null));
        }
        if (!(unknownMacros.isEmpty() || showDialog && !ProjectMacrosUtil.checkMacros(this, new HashSet<String>(unknownMacros)))) {
            PathMacros pathMacros = PathMacros.getInstance();
            HashSet<String> macros2invalidate = new HashSet<String>(unknownMacros);
            Iterator it = macros2invalidate.iterator();
            while (it.hasNext()) {
                String macro = (String)it.next();
                String value = pathMacros.getValue(macro);
                if (value != null && !value.trim().isEmpty() || pathMacros.isIgnoredMacroName(macro)) continue;
                it.remove();
            }
            if (!macros2invalidate.isEmpty()) {
                final HashSet<String> components = new HashSet<String>();
                for (TrackingPathMacroSubstitutor substitutor : substitutors) {
                    components.addAll(substitutor.getComponents(macros2invalidate));
                }
                if (stateStore.isReloadPossible(components)) {
                    UnknownMacroNotification[] notifications;
                    for (TrackingPathMacroSubstitutor substitutor : substitutors) {
                        substitutor.invalidateUnknownMacros(macros2invalidate);
                    }
                    for (UnknownMacroNotification notification : notifications = (UnknownMacroNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnknownMacroNotification.class, (Project)this)) {
                        if (!macros2invalidate.containsAll(notification.getMacros())) continue;
                        notification.expire();
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            stateStore.reinitComponents(components, true);
                        }
                    });
                } else if (Messages.showYesNoDialog((Project)this, (String)"Component could not be reloaded. Reload project?", (String)"Configuration Changed", (Icon)Messages.getQuestionIcon()) == 0) {
                    ProjectManagerEx.getInstanceEx().reloadProject(this);
                }
            }
        }
    }

    @NonNls
    public String toString() {
        return "Project" + (this.isDisposed() ? " (Disposed" + (this.temporarilyDisposed ? " temporarily" : "") + ")" : (this.isDefault() ? "" : " '" + this.getPresentableUrl() + "'")) + (this.isDefault() ? " (Default)" : "") + " " + this.myName;
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    public static void dropUnableToSaveProjectNotification(@NotNull Project project, VirtualFile[] readOnlyFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectImpl", "dropUnableToSaveProjectNotification"));
        }
        UnableToSaveProjectNotification[] notifications = (UnableToSaveProjectNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnableToSaveProjectNotification.class, project);
        if (notifications.length == 0) {
            Notifications.Bus.notify((Notification)new UnableToSaveProjectNotification(project, readOnlyFiles), (Project)project);
        }
    }

    public static class UnableToSaveProjectNotification
    extends Notification {
        private Project myProject;
        private final String[] myFileNames;

        private UnableToSaveProjectNotification(@NotNull Project project, VirtualFile[] readOnlyFiles) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectImpl$UnableToSaveProjectNotification", "<init>"));
            }
            super("Project Settings", "Could not save project!", UnableToSaveProjectNotification.buildMessage(), NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/impl/ProjectImpl$UnableToSaveProjectNotification$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/impl/ProjectImpl$UnableToSaveProjectNotification$1", "hyperlinkUpdate"));
                    }
                    UnableToSaveProjectNotification unableToSaveProjectNotification = (UnableToSaveProjectNotification)notification;
                    Project _project = unableToSaveProjectNotification.getProject();
                    notification.expire();
                    if (_project != null && !_project.isDisposed()) {
                        _project.save();
                    }
                }
            });
            this.myProject = project;
            this.myFileNames = (String[])ContainerUtil.map((Object[])readOnlyFiles, (Function)new Function<VirtualFile, String>(){

                public String fun(VirtualFile file) {
                    return file.getPresentableUrl();
                }
            }, (Object[])new String[readOnlyFiles.length]);
        }

        public String[] getFileNames() {
            return this.myFileNames;
        }

        private static String buildMessage() {
            return "<p>Unable to save project files. Please ensure project files are writable and you have permissions to modify them. <a href=\"\">Try to save project again</a>.</p>";
        }

        public Project getProject() {
            return this.myProject;
        }

        public void expire() {
            this.myProject = null;
            super.expire();
        }
    }

    private class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectOpened(Project project) {
            LOG.assertTrue(project == ProjectImpl.this);
            ProjectImpl.this.projectOpened();
        }

        public void projectClosed(Project project) {
            LOG.assertTrue(project == ProjectImpl.this);
            ProjectImpl.this.projectClosed();
        }
    }
}

