/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.CacheUpdateSession;
import com.intellij.openapi.project.FileContentQueue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class CacheUpdateRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.CacheUpdateRunner");
    private static final int PROC_COUNT = Runtime.getRuntime().availableProcessors();
    private final Project myProject;
    private final Collection<CacheUpdater> myUpdaters;
    private CacheUpdateSession mySession;

    CacheUpdateRunner(Project project, Collection<CacheUpdater> updaters) {
        this.myProject = project;
        this.myUpdaters = updaters;
    }

    public int queryNeededFiles(ProgressIndicator indicator) {
        if (this.mySession == null) {
            this.mySession = new CacheUpdateSession(this.myUpdaters, indicator);
        }
        return this.mySession.getFilesToUpdate().size();
    }

    public int getNumberOfPendingUpdateJobs(ProgressIndicator indicator) {
        if (this.mySession == null) {
            this.mySession = new CacheUpdateSession(this.myUpdaters, indicator);
        }
        return this.mySession.getNumberOfPendingUpdateJobs();
    }

    public void processFiles(final @NotNull ProgressIndicator indicator, boolean processInReadAction) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/CacheUpdateRunner", "processFiles"));
        }
        try {
            indicator.checkCanceled();
            FileContentQueue queue = new FileContentQueue();
            Collection<VirtualFile> files = this.mySession.getFilesToUpdate();
            final double total = files.size();
            queue.queue(files, indicator);
            Consumer<VirtualFile> progressUpdater = new Consumer<VirtualFile>(){
                final Set<VirtualFile> processed = new THashSet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void consume(VirtualFile virtualFile) {
                    indicator.checkCanceled();
                    Set<VirtualFile> set = this.processed;
                    synchronized (set) {
                        this.processed.add(virtualFile);
                        indicator.setFraction((double)this.processed.size() / total);
                        if (ApplicationManager.getApplication().isInternal()) {
                            indicator.setText2(virtualFile.getPresentableUrl());
                        }
                    }
                }
            };
            while (!this.myProject.isDisposed()) {
                indicator.checkCanceled();
                if (!this.processSomeFilesWhileUserIsInactive(queue, progressUpdater, processInReadAction)) continue;
            }
            if (this.myProject.isDisposed()) {
                indicator.cancel();
                indicator.checkCanceled();
            }
        }
        catch (ProcessCanceledException e) {
            this.mySession.canceled();
            throw e;
        }
    }

    public void updatingDone() {
        try {
            this.mySession.updatingDone();
        }
        catch (ProcessCanceledException e) {
            this.mySession.canceled();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processSomeFilesWhileUserIsInactive(@NotNull FileContentQueue queue, @NotNull Consumer<VirtualFile> progressUpdater, boolean processInReadAction) {
        if (queue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        if (progressUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/CacheUpdateRunner", "processSomeFilesWhileUserIsInactive"));
        }
        final ProgressIndicatorBase innerIndicator = new ProgressIndicatorBase(){

            @Override
            protected boolean isCancelable() {
                return true;
            }
        };
        ApplicationAdapter canceller = new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                innerIndicator.cancel();
            }
        };
        Application application = ApplicationManager.getApplication();
        application.addApplicationListener((ApplicationListener)canceller);
        AtomicBoolean isFinished = new AtomicBoolean();
        try {
            int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
            if (threadsCount <= 0) {
                threadsCount = Math.max(1, Math.min(PROC_COUNT - 1, 4));
            }
            if (threadsCount == 1) {
                MyRunnable process = new MyRunnable(innerIndicator, queue, isFinished, progressUpdater, processInReadAction);
                ProgressManager.getInstance().runProcess((Runnable)process, (ProgressIndicator)innerIndicator);
            } else {
                AtomicBoolean[] finishedRefs = new AtomicBoolean[threadsCount];
                Future[] futures = new Future[threadsCount];
                for (int i = 0; i < threadsCount; ++i) {
                    AtomicBoolean ref;
                    finishedRefs[i] = ref = new AtomicBoolean();
                    MyRunnable process = new MyRunnable(innerIndicator, queue, ref, progressUpdater, processInReadAction);
                    futures[i] = ApplicationManager.getApplication().executeOnPooledThread(CacheUpdateRunner.getProcessWrapper(process));
                }
                isFinished.set(CacheUpdateRunner.waitForAll(finishedRefs, futures));
            }
        }
        finally {
            application.removeApplicationListener((ApplicationListener)canceller);
        }
        return isFinished.get();
    }

    private static boolean waitForAll(@NotNull AtomicBoolean[] finishedRefs, @NotNull Future<?>[] futures) {
        if (finishedRefs == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/CacheUpdateRunner", "waitForAll"));
        }
        if (futures == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/CacheUpdateRunner", "waitForAll"));
        }
        try {
            for (Future<?> future : futures) {
                future.get();
            }
            boolean allFinished = true;
            for (AtomicBoolean ref : finishedRefs) {
                if (ref.get()) continue;
                allFinished = false;
                break;
            }
            return allFinished;
        }
        catch (Throwable throwable) {
            LOG.error(throwable);
            return false;
        }
    }

    private static Runnable getProcessWrapper(final Runnable process) {
        return ApplicationManager.getApplication().isReadAccessAllowed() ? new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean old = ApplicationImpl.setExceptionalThreadWithReadAccessFlag(true);
                try {
                    process.run();
                }
                finally {
                    ApplicationImpl.setExceptionalThreadWithReadAccessFlag(old);
                }
            }
        } : process;
    }

    private class MyRunnable
    implements Runnable {
        private final ProgressIndicatorBase myInnerIndicator;
        private final FileContentQueue myQueue;
        private final AtomicBoolean myFinished;
        private final Consumer<VirtualFile> myProgressUpdater;
        private final boolean myProcessInReadAction;

        public MyRunnable(@NotNull ProgressIndicatorBase innerIndicator, @NotNull FileContentQueue queue, @NotNull AtomicBoolean finished, Consumer<VirtualFile> progressUpdater, boolean processInReadAction) {
            if (innerIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (queue == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (finished == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            if (progressUpdater == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/project/CacheUpdateRunner$MyRunnable", "<init>"));
            }
            this.myInnerIndicator = innerIndicator;
            this.myQueue = queue;
            this.myFinished = finished;
            this.myProgressUpdater = progressUpdater;
            this.myProcessInReadAction = processInReadAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!CacheUpdateRunner.this.myProject.isDisposed() && !this.myInnerIndicator.isCanceled()) {
                try {
                    final FileContent fileContent = this.myQueue.take(this.myInnerIndicator);
                    if (fileContent == null) {
                        this.myFinished.set(Boolean.TRUE);
                        return;
                    }
                    final Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            MyRunnable.this.myInnerIndicator.checkCanceled();
                            if (!CacheUpdateRunner.this.myProject.isDisposed()) {
                                VirtualFile file = fileContent.getVirtualFile();
                                MyRunnable.this.myProgressUpdater.consume((Object)file);
                                CacheUpdateRunner.this.mySession.processFile(fileContent);
                            }
                        }
                    };
                    try {
                        ProgressManager.getInstance().runProcess(new Runnable(){

                            @Override
                            public void run() {
                                if (MyRunnable.this.myProcessInReadAction) {
                                    ApplicationManager.getApplication().runReadAction(action);
                                } else {
                                    action.run();
                                }
                            }
                        }, (ProgressIndicator)ProgressWrapper.wrap(this.myInnerIndicator));
                    }
                    catch (ProcessCanceledException e) {
                        this.myQueue.pushback(fileContent);
                        return;
                    }
                    finally {
                        this.myQueue.release(fileContent);
                    }
                }
                catch (ProcessCanceledException e) {
                    return;
                }
            }
            return;
        }
    }
}

