/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.util.containers.HashMap;
import javax.swing.SwingUtilities;

public class StatusBarProgress
extends ProgressIndicatorBase {
    private final HashMap<StatusBarEx, Pair<String, String>> myStatusBar2SavedText = new HashMap();

    public StatusBarProgress() {
        super(true);
    }

    @Override
    public void start() {
        super.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    return;
                }
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                if (projects.length == 0) {
                    projects = new Project[]{null};
                }
                for (Project project : projects) {
                    StatusBarEx statusBar = (StatusBarEx)windowManager.getStatusBar(project);
                    if (statusBar == null) continue;
                    String info = statusBar.getInfo();
                    if (info == null) {
                        info = "";
                    }
                    StatusBarProgress.this.myStatusBar2SavedText.put((Object)statusBar, (Object)new Pair((Object)info, (Object)info));
                }
            }
        });
    }

    @Override
    public void stop() {
        super.stop();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (StatusBarEx statusBar : StatusBarProgress.this.myStatusBar2SavedText.keySet()) {
                    String textToRestore = StatusBarProgress.this.updateRestoreText(statusBar);
                    statusBar.setInfo(textToRestore);
                }
                StatusBarProgress.this.myStatusBar2SavedText.clear();
            }
        });
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.update();
    }

    @Override
    public void setFraction(double fraction) {
        super.setFraction(fraction);
        this.update();
    }

    private void update() {
        String text;
        if (!this.isRunning()) {
            text = "";
        } else {
            text = this.getText();
            double fraction = this.getFraction();
            if (fraction > 0.0) {
                text = text + " " + (int)(fraction * 100.0 + 0.5) + "%";
            }
        }
        final String text1 = text;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (StatusBarEx statusBarEx : StatusBarProgress.this.myStatusBar2SavedText.keySet()) {
                    StatusBarProgress.this.setStatusBarText(statusBarEx, text1);
                }
            }
        });
    }

    private void setStatusBarText(StatusBarEx statusBar, String text) {
        this.updateRestoreText(statusBar);
        Pair textsPair = (Pair)this.myStatusBar2SavedText.get((Object)statusBar);
        this.myStatusBar2SavedText.put((Object)statusBar, (Object)Pair.create((Object)textsPair.first, (Object)text));
        statusBar.setInfo(text);
    }

    private String updateRestoreText(StatusBarEx statusBar) {
        Pair textsPair = (Pair)this.myStatusBar2SavedText.get((Object)statusBar);
        String info = statusBar.getInfo();
        if (info == null) {
            info = "";
        }
        if (!((String)textsPair.getSecond()).equals(info)) {
            this.myStatusBar2SavedText.put((Object)statusBar, (Object)Pair.create((Object)info, (Object)textsPair.second));
        }
        return (String)textsPair.getFirst();
    }
}

