/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWrapper
extends AbstractProgressIndicatorBase {
    private final ProgressIndicator myOriginal;

    protected ProgressWrapper(@NotNull ProgressIndicator original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/util/ProgressWrapper", "<init>"));
        }
        this.myOriginal = original;
    }

    @Override
    public boolean isCanceled() {
        return this.myOriginal.isCanceled();
    }

    @NotNull
    public ProgressIndicator getOriginalProgressIndicator() {
        ProgressIndicator progressIndicator = this.myOriginal;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressWrapper", "getOriginalProgressIndicator"));
        }
        return progressIndicator;
    }

    @Nullable
    public static ProgressWrapper wrap(@Nullable ProgressIndicator indicator) {
        return indicator == null || indicator instanceof ProgressWrapper ? (ProgressWrapper)indicator : new ProgressWrapper(indicator);
    }

    public static ProgressIndicator unwrap(ProgressIndicator indicator) {
        return indicator instanceof ProgressWrapper ? ((ProgressWrapper)indicator).getOriginalProgressIndicator() : indicator;
    }
}

