/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ReadTask;
import org.jetbrains.annotations.NotNull;

public class ProgressIndicatorUtils {
    private ProgressIndicatorUtils() {
    }

    @NotNull
    public static ProgressIndicator forceWriteActionPriority(final @NotNull ProgressIndicator progress, @NotNull Disposable builder) {
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                if (progress.isRunning()) {
                    progress.cancel();
                }
            }
        }, builder);
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "forceWriteActionPriority"));
        }
        return progressIndicator;
    }

    public static void runWithWriteActionPriority(final @NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runWithWriteActionPriority"));
        }
        ProgressIndicatorUtils.runWithWriteActionPriority(new ReadTask(){

            @Override
            public void computeInReadAction(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$2", "computeInReadAction"));
                }
                action.run();
            }

            @Override
            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/util/ProgressIndicatorUtils$2", "onCanceled"));
                }
            }
        });
    }

    public static void runWithWriteActionPriority(@NotNull ReadTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "runWithWriteActionPriority"));
        }
        ProgressIndicatorUtils.runWithWriteActionPriority(new ProgressIndicatorBase(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithWriteActionPriority(final ProgressIndicator progressIndicator, final ReadTask task) {
        ApplicationAdapter listener = new ApplicationAdapter(){

            public void beforeWriteActionStart(Object action) {
                progressIndicator.cancel();
            }
        };
        final Application application = ApplicationManager.getApplication();
        try {
            application.addApplicationListener((ApplicationListener)listener);
            ProgressManager.getInstance().runProcess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        application.runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                task.computeInReadAction(progressIndicator);
                            }
                        });
                    }
                    catch (ProcessCanceledException processCanceledException) {
                    }
                    finally {
                        if (progressIndicator.isCanceled()) {
                            task.onCanceled(progressIndicator);
                        }
                    }
                }
            }, progressIndicator);
        }
        finally {
            application.removeApplicationListener((ApplicationListener)listener);
        }
    }

    public static void scheduleWithWriteActionPriority(@NotNull ReadTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/progress/util/ProgressIndicatorUtils", "scheduleWithWriteActionPriority"));
        }
        ProgressIndicatorUtils.scheduleWithWriteActionPriority(new ProgressIndicatorBase(), task);
    }

    public static void scheduleWithWriteActionPriority(final ProgressIndicator indicator, final ReadTask task) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ProgressIndicatorUtils.runWithWriteActionPriority(indicator, task);
            }
        });
    }
}

