/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.NonDefaultProjectConfigurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableWrapper
implements SearchableConfigurable {
    private static final ConfigurableWrapper[] EMPTY_ARRAY = new ConfigurableWrapper[0];
    private static final NullableFunction<ConfigurableEP<Configurable>, Configurable> CONFIGURABLE_FUNCTION = new NullableFunction<ConfigurableEP<Configurable>, Configurable>(){

        public Configurable fun(ConfigurableEP<Configurable> ep) {
            return ConfigurableWrapper.wrapConfigurable(ep);
        }
    };
    private static final Logger LOG = Logger.getInstance(ConfigurableWrapper.class);
    private final ConfigurableEP myEp;
    private UnnamedConfigurable myConfigurable;

    @Nullable
    public static <T extends UnnamedConfigurable> T wrapConfigurable(ConfigurableEP<T> ep) {
        if (ep.displayName != null || ep.key != null) {
            return (T)(ep.children != null || ep.childrenEPName != null || ep.dynamic ? new CompositeWrapper((ConfigurableEP)ep, new Configurable[0]) : new ConfigurableWrapper(ep));
        }
        return (T)ep.createConfigurable();
    }

    public static <T extends UnnamedConfigurable> List<T> createConfigurables(ExtensionPointName<? extends ConfigurableEP<T>> name) {
        return ContainerUtil.mapNotNull((Object[])name.getExtensions(), (Function)new NullableFunction<ConfigurableEP<T>, T>(){

            public T fun(ConfigurableEP<T> ep) {
                return ConfigurableWrapper.wrapConfigurable(ep);
            }
        });
    }

    public static boolean isNoScroll(Configurable configurable) {
        return configurable instanceof Configurable.NoScroll || configurable instanceof ConfigurableWrapper && ((ConfigurableWrapper)configurable).getConfigurable() instanceof Configurable.NoScroll;
    }

    public static boolean isNonDefaultProject(Configurable configurable) {
        return configurable instanceof NonDefaultProjectConfigurable || configurable instanceof ConfigurableWrapper && ((ConfigurableWrapper)configurable).myEp.nonDefaultProject;
    }

    private ConfigurableWrapper(ConfigurableEP ep) {
        this.myEp = ep;
    }

    public UnnamedConfigurable getConfigurable() {
        if (this.myConfigurable == null) {
            this.myConfigurable = this.myEp.createConfigurable();
            if (this.myConfigurable == null) {
                LOG.error("Can't instantiate configurable for " + this.myEp);
            }
        }
        return this.myConfigurable;
    }

    @Nls
    public String getDisplayName() {
        return this.myEp.getDisplayName();
    }

    @Nullable
    public String getHelpTopic() {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof Configurable ? ((Configurable)configurable).getHelpTopic() : null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.getConfigurable().createComponent();
    }

    public boolean isModified() {
        return this.getConfigurable().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getConfigurable().apply();
    }

    public void reset() {
        this.getConfigurable().reset();
    }

    public void disposeUIResources() {
        this.getConfigurable().disposeUIResources();
    }

    @NotNull
    public String getId() {
        String string = this.myEp.id == null ? this.myEp.instanceClass : this.myEp.id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableWrapper", "getId"));
        }
        return string;
    }

    public String getParentId() {
        return this.myEp.parentId;
    }

    public ConfigurableWrapper addChild(Configurable configurable) {
        return new CompositeWrapper(this.myEp, new Configurable[]{configurable});
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Nullable
    public Runnable enableSearch(String option) {
        UnnamedConfigurable configurable = this.getConfigurable();
        return configurable instanceof SearchableConfigurable ? ((SearchableConfigurable)configurable).enableSearch(option) : null;
    }

    private static class CompositeWrapper
    extends ConfigurableWrapper
    implements Configurable.Composite {
        private Configurable[] myKids;

        private CompositeWrapper(ConfigurableEP ep, Configurable ... kids) {
            super(ep);
            ExtensionPoint childrenEP;
            Object[] extensions;
            if (ep.dynamic) {
                kids = ((Configurable.Composite)this.getConfigurable()).getConfigurables();
            } else if (ep.children != null) {
                kids = (Configurable[])ContainerUtil.mapNotNull((Object[])ep.getChildren(), (Function)new NullableFunction<ConfigurableEP, ConfigurableWrapper>(){

                    public ConfigurableWrapper fun(ConfigurableEP ep) {
                        return ep.isAvailable() ? (ConfigurableWrapper)ConfigurableWrapper.wrapConfigurable(ep) : null;
                    }
                }, (Object[])EMPTY_ARRAY);
            }
            if (ep.childrenEPName != null && (extensions = (childrenEP = Extensions.getArea((AreaInstance)ep.getProject()).getExtensionPoint(ep.childrenEPName)).getExtensions()).length > 0) {
                if (extensions[0] instanceof ConfigurableEP) {
                    Object[] children = (Configurable[])ContainerUtil.mapNotNull((Object[])((ConfigurableEP[])extensions), (Function)CONFIGURABLE_FUNCTION, (Object[])new Configurable[0]);
                    kids = (Configurable[])ArrayUtil.mergeArrays((Object[])kids, (Object[])children);
                } else {
                    kids = (Configurable[])ArrayUtil.mergeArrays((Object[])kids, (Object[])((Configurable.Composite)this.getConfigurable()).getConfigurables());
                }
            }
            this.myKids = kids;
        }

        public Configurable[] getConfigurables() {
            return this.myKids;
        }

        @Override
        public ConfigurableWrapper addChild(Configurable configurable) {
            this.myKids = (Configurable[])ArrayUtil.append((Object[])this.myKids, (Object)configurable);
            return this;
        }
    }
}

