/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableExtensionPointUtil {
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    public static List<Configurable> buildConfigurablesList(ConfigurableEP<Configurable>[] extensions, Configurable[] components, @Nullable ConfigurableFilter filter) {
        ArrayList<Configurable> result = new ArrayList<Configurable>();
        for (Configurable component : components) {
            if (ConfigurableExtensionPointUtil.isSuppressed(component, filter)) continue;
            result.add(component);
        }
        HashMap<String, ConfigurableWrapper> idToConfigurable = new HashMap<String, ConfigurableWrapper>();
        for (ConfigurableEP<Configurable> ep : extensions) {
            Configurable configurable = ConfigurableWrapper.wrapConfigurable(ep);
            if (ConfigurableExtensionPointUtil.isSuppressed(configurable, filter)) continue;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                idToConfigurable.put(wrapper.getId(), wrapper);
                continue;
            }
            ContainerUtil.addIfNotNull((Object)configurable, result);
        }
        for (String id : idToConfigurable.keySet()) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId == null) continue;
            ConfigurableWrapper parent = (ConfigurableWrapper)idToConfigurable.get(parentId);
            if (parent != null) {
                idToConfigurable.put(parentId, parent.addChild((Configurable)wrapper));
                continue;
            }
            LOG.error("Can't find parent for " + parentId + " (" + wrapper + ")");
        }
        Iterator iterator = idToConfigurable.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            ConfigurableWrapper wrapper = (ConfigurableWrapper)idToConfigurable.get(key);
            if (wrapper.getParentId() == null) continue;
            iterator.remove();
        }
        ContainerUtil.addAll(result, idToConfigurable.values());
        return result;
    }

    private static boolean isSuppressed(Configurable each, ConfigurableFilter filter) {
        return each instanceof Configurable.Assistant || each instanceof OptionalConfigurable && !((OptionalConfigurable)each).needDisplay() || filter != null && !filter.isIncluded(each);
    }

    @NotNull
    public static <T extends Configurable> T findProjectConfigurable(@NotNull Project project, @NotNull Class<T> configurableClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        T t = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])project.getExtensions(Configurable.PROJECT_CONFIGURABLE), configurableClass);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        return t;
    }

    @NotNull
    public static <T extends Configurable> T findApplicationConfigurable(@NotNull Class<T> configurableClass) {
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findApplicationConfigurable"));
        }
        T t = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), configurableClass);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findApplicationConfigurable"));
        }
        return t;
    }

    @NotNull
    private static <T extends Configurable> T findConfigurable(ConfigurableEP<Configurable>[] extensions, Class<T> configurableClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Configurable configurable;
            if (extension.providerClass == null && extension.instanceClass == null && extension.implementationClass == null || !configurableClass.isInstance(configurable = (Configurable)extension.createConfigurable())) continue;
            Configurable configurable2 = (Configurable)configurableClass.cast(configurable);
            if (configurable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findConfigurable"));
            }
            return (T)configurable2;
        }
        throw new IllegalArgumentException("Cannot find configurable of " + configurableClass);
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project, Class<? extends ConfigurableProvider> providerClass) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "createProjectConfigurableForProvider"));
        }
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])project.getExtensions(Configurable.PROJECT_CONFIGURABLE), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(ConfigurableEP<Configurable>[] extensions, Class<? extends ConfigurableProvider> providerClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Class aClass;
            if (extension.providerClass == null || (aClass = extension.findClassNoExceptions(extension.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return (Configurable)extension.createConfigurable();
        }
        return null;
    }
}

