/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.components.impl.stores.StreamProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.options.AbstractSchemesManager;
import com.intellij.openapi.options.CurrentUserHolder;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExtensionProvider;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManagerFactoryImpl;
import com.intellij.openapi.options.SharedScheme;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.UniqueFileNamesProvider;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.UniqueNameGenerator;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesManagerImpl<T extends Scheme, E extends ExternalizableScheme>
extends AbstractSchemesManager<T, E> {
    private static final Logger LOG = Logger.getInstance((String)("#" + SchemesManagerFactoryImpl.class.getName()));
    @NonNls
    private static final String DEFAULT_EXT = ".xml";
    private final Set<String> myDeletedNames;
    private final Set<String> myFilesToDelete;
    @NonNls
    private static final String SHARED_SCHEME = "shared-scheme";
    @NonNls
    private static final String SHARED_SCHEME_ORIGINAL = "shared-scheme-original";
    private static final String NAME = "name";
    @NonNls
    private static final String ORIGINAL_SCHEME_PATH = "original-scheme-path";
    private final String myFileSpec;
    private final SchemeProcessor<E> myProcessor;
    private final RoamingType myRoamingType;
    @NonNls
    private static final String SCHEME_LOCAL_COPY = "scheme-local-copy";
    @NonNls
    private static final String DELETED_XML = "__deleted.xml";
    private final StreamProvider myProvider;
    private final File myBaseDir;
    private VirtualFile myVFSBaseDir;
    private static final String DESCRIPTION = "description";
    private static final boolean EXPORT_IS_AVAILABLE = false;
    private static final String USER = "user";
    private boolean myListenerAdded;
    private Alarm myRefreshAlarm;
    private String mySchemeExtension;
    private boolean myUpgradeExtension;
    private boolean myInsideSave;

    public SchemesManagerImpl(@NotNull String fileSpec, @NotNull SchemeProcessor<E> processor, @NotNull RoamingType roamingType, @Nullable StreamProvider provider, @NotNull File baseDir) {
        if (fileSpec == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (roamingType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/options/SchemesManagerImpl", "<init>"));
        }
        this.myDeletedNames = new LinkedHashSet<String>();
        this.myFilesToDelete = new HashSet();
        this.myListenerAdded = false;
        this.mySchemeExtension = DEFAULT_EXT;
        this.myUpgradeExtension = false;
        this.myInsideSave = false;
        this.myFileSpec = fileSpec;
        this.myProcessor = processor;
        this.myRoamingType = roamingType;
        this.myProvider = provider;
        this.myBaseDir = baseDir;
        if (processor instanceof SchemeExtensionProvider) {
            this.mySchemeExtension = ((SchemeExtensionProvider)processor).getSchemeExtension();
            this.myUpgradeExtension = ((SchemeExtensionProvider)processor).isUpgradeNeeded();
        }
        this.myBaseDir.mkdirs();
        this.addVFSListener();
    }

    @NotNull
    public Collection<E> loadSchemes() {
        if (this.myVFSBaseDir != null) {
            Collection<E> collection = this.doLoad();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "loadSchemes"));
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "loadSchemes"));
        }
        return list;
    }

    private Collection<E> doLoad() {
        this.myDeletedNames.addAll(this.readDeletedSchemeNames());
        LinkedHashMap<String, ExternalizableScheme> read = new LinkedHashMap<String, ExternalizableScheme>();
        for (ExternalizableScheme e : this.readSchemesFromFileSystem()) {
            read.put(e.getName(), e);
        }
        for (ExternalizableScheme e : this.readSchemesFromProviders()) {
            read.put(e.getName(), e);
        }
        Collection result = read.values();
        this.initLoadedSchemes(result);
        return result;
    }

    private void addVFSListener() {
        Application app = ApplicationManager.getApplication();
        if (app == null || this.myListenerAdded) {
            return;
        }
        LocalFileSystem system = LocalFileSystem.getInstance();
        this.myVFSBaseDir = system.findFileByIoFile(this.myBaseDir);
        if (this.myVFSBaseDir == null && !app.isUnitTestMode() && !app.isHeadlessEnvironment()) {
            this.myRefreshAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            this.myRefreshAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    SchemesManagerImpl.this.ensureVFSBaseDir();
                }
            }, 60000, ModalityState.NON_MODAL);
        }
        system.addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl$2", "contentsChanged"));
                }
                SchemesManagerImpl.this.onFileContentChanged(event);
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl$2", "fileCreated"));
                }
                VirtualFile file = event.getFile();
                if (event.getRequestor() == null && SchemesManagerImpl.isFileUnder(file, SchemesManagerImpl.this.myVFSBaseDir) && !SchemesManagerImpl.this.myInsideSave) {
                    ArrayList read = new ArrayList();
                    SchemesManagerImpl.this.readSchemeFromFile(read, file, true);
                    if (!read.isEmpty()) {
                        ExternalizableScheme readScheme = (ExternalizableScheme)read.get(0);
                        SchemesManagerImpl.this.myProcessor.initScheme(readScheme);
                        SchemesManagerImpl.this.myProcessor.onSchemeAdded(readScheme);
                    }
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl$2", "fileDeleted"));
                }
                VirtualFile parent = event.getParent();
                if (event.getRequestor() == null && parent != null && parent.equals(SchemesManagerImpl.this.myVFSBaseDir) && !SchemesManagerImpl.this.myInsideSave) {
                    File ioFile = new File(event.getFileName());
                    ExternalizableScheme scheme = SchemesManagerImpl.this.findSchemeFor(ioFile.getName());
                    Scheme oldCurrentScheme = null;
                    if (scheme != null) {
                        oldCurrentScheme = (Scheme)SchemesManagerImpl.this.getCurrentScheme();
                        ExternalizableScheme t = scheme;
                        SchemesManagerImpl.this.removeScheme(t);
                        SchemesManagerImpl.this.myProcessor.onSchemeDeleted(scheme);
                    }
                    Object newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                    if (oldCurrentScheme != null && newCurrentScheme == null && !SchemesManagerImpl.this.mySchemes.isEmpty()) {
                        SchemesManagerImpl.this.setCurrentSchemeName(((Scheme)SchemesManagerImpl.this.mySchemes.get(0)).getName());
                        newCurrentScheme = SchemesManagerImpl.this.getCurrentScheme();
                    }
                    if (oldCurrentScheme != newCurrentScheme) {
                        SchemesManagerImpl.this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                    }
                }
            }
        });
        this.myListenerAdded = true;
    }

    private void onFileContentChanged(VirtualFileEvent event) {
        VirtualFile file = event.getFile();
        if (event.getRequestor() == null && SchemesManagerImpl.isFileUnder(file, this.myVFSBaseDir) && !this.myInsideSave) {
            File ioFile = new File(file.getPath());
            E scheme = this.findSchemeFor(ioFile.getName());
            ArrayList read = new ArrayList();
            Scheme oldCurrentScheme = null;
            if (scheme != null) {
                oldCurrentScheme = (Scheme)this.getCurrentScheme();
                E t = scheme;
                this.removeScheme(t);
                this.myProcessor.onSchemeDeleted(scheme);
            }
            this.readSchemeFromFile(read, file, true);
            if (!read.isEmpty()) {
                ExternalizableScheme readScheme = (ExternalizableScheme)read.get(0);
                this.myProcessor.initScheme(readScheme);
                this.myProcessor.onSchemeAdded(readScheme);
                Object newCurrentScheme = this.getCurrentScheme();
                if (oldCurrentScheme != null && newCurrentScheme == null) {
                    this.setCurrentSchemeName(readScheme.getName());
                    newCurrentScheme = this.getCurrentScheme();
                }
                if (oldCurrentScheme != newCurrentScheme) {
                    this.myProcessor.onCurrentSchemeChanged(oldCurrentScheme);
                }
            }
        }
    }

    private E findSchemeFor(@NotNull String ioFileName) {
        if (ioFileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl", "findSchemeFor"));
        }
        for (Scheme scheme : this.mySchemes) {
            if (!(scheme instanceof ExternalizableScheme) || !ioFileName.equals(((ExternalizableScheme)scheme).getExternalInfo().getCurrentFileName() + this.mySchemeExtension)) continue;
            return (E)((ExternalizableScheme)scheme);
        }
        return null;
    }

    private static boolean isFileUnder(VirtualFile file, VirtualFile baseDirFile) {
        return file.getParent().equals(baseDirFile);
    }

    private Collection<String> readDeletedSchemeNames() {
        THashSet result = new THashSet();
        if (this.myProvider == null || !this.myProvider.isEnabled()) {
            return result;
        }
        try {
            Document deletedNameDoc = StorageUtil.loadDocument(this.myProvider.loadContent(this.getFileFullPath(DELETED_XML), this.myRoamingType));
            if (deletedNameDoc != null) {
                for (Element child : deletedNameDoc.getRootElement().getChildren()) {
                    String deletedSchemeName = child.getAttributeValue(NAME);
                    if (deletedSchemeName == null) continue;
                    result.add(deletedSchemeName);
                }
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
        return result;
    }

    private void initLoadedSchemes(@NotNull Collection<E> read) {
        if (read == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl", "initLoadedSchemes"));
        }
        for (ExternalizableScheme scheme : read) {
            this.myProcessor.initScheme(scheme);
            this.checkCurrentScheme((Scheme)scheme);
        }
    }

    private Collection<E> readSchemesFromProviders() {
        ArrayList<E> result = new ArrayList<E>();
        if (this.myProvider == null || !this.myProvider.isEnabled()) {
            return result;
        }
        for (String subPath : this.myProvider.listSubFiles(this.myFileSpec, this.myRoamingType)) {
            if (subPath.equals(DELETED_XML)) continue;
            try {
                String currentFileName;
                Document subDocument = StorageUtil.loadDocument(this.myProvider.loadContent(this.getFileFullPath(subPath), this.myRoamingType));
                if (subDocument == null) continue;
                E scheme = this.readScheme(subDocument);
                boolean fileRenamed = false;
                Object existing = this.findSchemeByName(scheme.getName());
                if (existing != null && existing instanceof ExternalizableScheme && (currentFileName = ((ExternalizableScheme)existing).getExternalInfo().getCurrentFileName()) != null && !currentFileName.equals(subPath)) {
                    this.deleteServerFiles(subPath);
                    subPath = currentFileName;
                    fileRenamed = true;
                }
                String fileName = this.checkFileNameIsFree(subPath, scheme.getName());
                if (!fileRenamed && !fileName.equals(subPath)) {
                    this.deleteServerFiles(subPath);
                }
                this.loadScheme(scheme, false, fileName);
                result.add(scheme);
            }
            catch (Exception e) {
                LOG.info("Cannot load data from IDEAServer: " + e.getLocalizedMessage());
            }
        }
        return result;
    }

    private VirtualFile ensureFileText(final String fileName, final byte[] text) throws IOException {
        final IOException[] ex = new IOException[]{null};
        VirtualFile _file = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile file = SchemesManagerImpl.this.myVFSBaseDir.findChild(fileName);
                try {
                    if (file == null) {
                        file = SchemesManagerImpl.this.myVFSBaseDir.createChildData((Object)SchemesManagerImpl.this, fileName);
                    }
                    if (!Arrays.equals(file.contentsToByteArray(), text)) {
                        file.setBinaryContent(text);
                    }
                }
                catch (IOException e) {
                    ex[0] = e;
                }
                return file;
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return _file;
    }

    private String checkFileNameIsFree(String subPath, String schemeName) {
        for (Scheme scheme : this.mySchemes) {
            String fileName;
            ExternalInfo externalInfo;
            String name;
            if (!(scheme instanceof ExternalizableScheme) || (name = (externalInfo = ((ExternalizableScheme)scheme).getExternalInfo()).getCurrentFileName()) == null || !(fileName = name + this.mySchemeExtension).equals(subPath) || Comparing.equal((String)schemeName, (String)scheme.getName())) continue;
            return SchemesManagerImpl.createUniqueFileName(this.collectAllFileNames(), UniqueFileNamesProvider.convertName((String)schemeName));
        }
        return subPath;
    }

    private Collection<String> collectAllFileNames() {
        HashSet result = new HashSet();
        for (Scheme scheme : this.mySchemes) {
            ExternalInfo externalInfo;
            if (!(scheme instanceof ExternalizableScheme) || (externalInfo = ((ExternalizableScheme)scheme).getExternalInfo()).getCurrentFileName() == null) continue;
            result.add((Object)externalInfo.getCurrentFileName());
        }
        return result;
    }

    private static String createUniqueFileName(Collection<String> strings, String schemeName) {
        return UniqueNameGenerator.generateUniqueName((String)schemeName, strings);
    }

    private void loadScheme(E scheme, boolean forceAdd, String name) {
        if (scheme != null && (!this.myDeletedNames.contains(scheme.getName()) || forceAdd)) {
            Object existing = this.findSchemeByName(scheme.getName());
            if (existing != null) {
                if (!Comparing.equal(existing.getClass(), scheme.getClass())) {
                    LOG.warn("'" + scheme.getName() + "' " + existing.getClass().getSimpleName() + " replaced with " + scheme.getClass().getSimpleName());
                }
                this.mySchemes.remove(existing);
                if (this.isExternalizable(existing)) {
                    ExternalizableScheme e = (ExternalizableScheme)existing;
                    this.myProcessor.onSchemeDeleted(e);
                }
            }
            E t = scheme;
            this.addNewScheme(t, true);
            this.saveFileName(name, scheme);
            scheme.getExternalInfo().setPreviouslySavedName(scheme.getName());
        }
    }

    private Collection<E> readSchemesFromFileSystem() {
        ArrayList result = new ArrayList();
        VirtualFile[] files = this.myVFSBaseDir.getChildren();
        if (files != null) {
            for (VirtualFile file : files) {
                this.readSchemeFromFile(result, file, false);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    String msg = "Cannot read directory: " + SchemesManagerImpl.this.myBaseDir.getAbsolutePath() + " directory does not exist";
                    Messages.showErrorDialog((String)msg, (String)"Read Settings");
                }
            });
        }
        return result;
    }

    private boolean canRead(VirtualFile file) {
        if (!file.isDirectory()) {
            String ext = "." + file.getExtension();
            if (DEFAULT_EXT.equalsIgnoreCase(ext) && !DEFAULT_EXT.equals(this.mySchemeExtension) && this.myUpgradeExtension) {
                return this.myVFSBaseDir.findChild(file.getName() + this.mySchemeExtension) == null;
            }
            if (this.mySchemeExtension.equalsIgnoreCase(ext)) {
                return true;
            }
        }
        return false;
    }

    private void readSchemeFromFile(Collection<E> result, final VirtualFile file, boolean forceAdd) {
        if (this.canRead(file)) {
            try {
                Document document;
                try {
                    document = JDOMUtil.loadDocument((InputStream)file.getInputStream());
                }
                catch (JDOMException e) {
                    try {
                        File initialIOFile = new File(this.myBaseDir, file.getName());
                        if (initialIOFile.isFile()) {
                            FileUtil.copy((File)initialIOFile, (File)new File(this.myBaseDir, file.getName() + ".copy"));
                        }
                    }
                    catch (IOException e1) {
                        LOG.info((Throwable)e1);
                    }
                    LOG.info("Error reading file " + file.getPath() + ": " + e.getLocalizedMessage());
                    throw e;
                }
                E scheme = this.readScheme(document);
                if (scheme != null) {
                    String suggestedName;
                    if (scheme.getName() == null && !"_".equals(suggestedName = FileUtil.getNameWithoutExtension((String)file.getName()))) {
                        scheme.setName(suggestedName);
                    }
                    this.loadScheme(scheme, forceAdd, file.getName());
                    result.add(scheme);
                }
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String msg = "Cannot read scheme " + file.getName() + "  from '" + SchemesManagerImpl.this.myFileSpec + "': " + e.getLocalizedMessage();
                        LOG.info(msg, (Throwable)e);
                        Messages.showErrorDialog((String)msg, (String)"Load Settings");
                    }
                });
            }
        }
    }

    @Nullable
    private E readScheme(Document subDocument) throws InvalidDataException, IOException, JDOMException {
        Element rootElement = subDocument.getRootElement();
        if (rootElement.getName().equals(SHARED_SCHEME)) {
            String schemeName = rootElement.getAttributeValue(NAME);
            String schemePath = rootElement.getAttributeValue(ORIGINAL_SCHEME_PATH);
            Document sharedDocument = SchemesManagerImpl.loadGlobalScheme(schemePath);
            if (sharedDocument != null) {
                E result = this.readScheme(sharedDocument);
                if (result != null) {
                    this.renameScheme(result, schemeName);
                    result.getExternalInfo().setOriginalPath(schemePath);
                    result.getExternalInfo().setIsImported(true);
                }
                return result;
            }
            Element localCopyElement = subDocument.getRootElement().getChild(SCHEME_LOCAL_COPY);
            if (localCopyElement != null) {
                Element firstChild = (Element)localCopyElement.getChildren().get(0);
                return (E)this.myProcessor.readScheme(new Document(firstChild.clone()));
            }
            return null;
        }
        if (rootElement.getName().equals(SHARED_SCHEME_ORIGINAL)) {
            SharedSchemeData schemeData = SchemesManagerImpl.unwrap(subDocument);
            ExternalizableScheme scheme = this.myProcessor.readScheme(schemeData.original);
            if (scheme != null) {
                this.renameScheme(scheme, schemeData.name);
            }
            return (E)scheme;
        }
        return (E)this.myProcessor.readScheme(subDocument);
    }

    @Nullable
    private static Document loadGlobalScheme(String schemePath) throws IOException {
        StreamProvider provider = SchemesManagerImpl.getProvider();
        return provider != null && provider.isEnabled() ? StorageUtil.loadDocument(provider.loadContent(schemePath, RoamingType.GLOBAL)) : null;
    }

    private void saveFileName(String fileName, E schemeKey) {
        if (StringUtil.endsWithIgnoreCase((String)fileName, (String)this.mySchemeExtension)) {
            fileName = fileName.substring(0, fileName.length() - this.mySchemeExtension.length());
        } else if (StringUtil.endsWithIgnoreCase((String)fileName, (String)DEFAULT_EXT)) {
            fileName = fileName.substring(0, fileName.length() - DEFAULT_EXT.length());
        }
        schemeKey.getExternalInfo().setCurrentFileName(fileName);
    }

    private static long computeHashValue(Document document) {
        return JDOMUtil.getTreeHash((Document)document);
    }

    @Nullable
    private Document writeSchemeToDocument(E scheme) throws WriteExternalException {
        if (this.isShared((Scheme)scheme)) {
            String originalPath = scheme.getExternalInfo().getOriginalPath();
            if (originalPath != null) {
                Element root = new Element(SHARED_SCHEME);
                root.setAttribute(NAME, scheme.getName());
                root.setAttribute(ORIGINAL_SCHEME_PATH, originalPath);
                Element localCopy = new Element(SCHEME_LOCAL_COPY);
                localCopy.addContent(this.myProcessor.writeScheme(scheme).getRootElement().clone());
                root.addContent(localCopy);
                return new Document(root);
            }
            return null;
        }
        return this.myProcessor.writeScheme(scheme);
    }

    public void updateConfigFilesFromStreamProviders() {
    }

    @NotNull
    public Collection<SharedScheme<E>> loadSharedSchemes(Collection<T> currentSchemeList) {
        StreamProvider provider = SchemesManagerImpl.getProvider();
        if (provider == null || !provider.isEnabled()) {
            List<SharedScheme<E>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "loadSharedSchemes"));
            }
            return list;
        }
        THashSet names = new THashSet(this.getAllSchemeNames(currentSchemeList));
        THashMap result = new THashMap();
        for (String subPath : provider.listSubFiles(this.myFileSpec, RoamingType.GLOBAL)) {
            try {
                Document subDocument = StorageUtil.loadDocument(provider.loadContent(this.getFileFullPath(subPath), RoamingType.GLOBAL));
                if (subDocument == null) continue;
                SharedSchemeData original = SchemesManagerImpl.unwrap(subDocument);
                ExternalizableScheme scheme = this.myProcessor.readScheme(original.original);
                if (this.alreadyShared(subPath, currentSchemeList)) continue;
                String schemeName = original.name;
                String uniqueName = UniqueNameGenerator.generateUniqueName((String)("[shared] " + schemeName), (Collection)names);
                this.renameScheme(scheme, uniqueName);
                schemeName = uniqueName;
                scheme.getExternalInfo().setOriginalPath(this.getFileFullPath(subPath));
                scheme.getExternalInfo().setIsImported(true);
                result.put(schemeName, new SharedScheme(original.user == null ? "unknown" : original.user, original.description, scheme));
            }
            catch (Exception e) {
                LOG.debug("Cannot load data from IDEAServer: " + e.getLocalizedMessage());
            }
        }
        for (SharedScheme t : result.values()) {
            this.myProcessor.initScheme(t.getScheme());
        }
        Collection<SharedScheme<E>> collection = result.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "loadSharedSchemes"));
        }
        return collection;
    }

    @NotNull
    private static SharedSchemeData unwrap(@NotNull Document subDocument) {
        SharedSchemeData result;
        if (subDocument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl", "unwrap"));
        }
        Element rootElement = subDocument.getRootElement();
        String name = rootElement.getAttributeValue(NAME);
        if (rootElement.getName().equals(SHARED_SCHEME_ORIGINAL)) {
            String description = rootElement.getAttributeValue(DESCRIPTION);
            String user = rootElement.getAttributeValue(USER);
            Document original = new Document(((Element)rootElement.getChildren().iterator().next()).clone());
            result = new SharedSchemeData(original, name, user, description);
        } else {
            Document original = subDocument;
            result = new SharedSchemeData(original, name, null, null);
        }
        SharedSchemeData sharedSchemeData = result;
        if (sharedSchemeData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/SchemesManagerImpl", "unwrap"));
        }
        return sharedSchemeData;
    }

    private boolean alreadyShared(String subPath, Collection<T> currentSchemeList) {
        for (Scheme t : currentSchemeList) {
            ExternalInfo info;
            if (!(t instanceof ExternalizableScheme) || !(info = ((ExternalizableScheme)t).getExternalInfo()).isIsImported() || !this.getFileFullPath(subPath).equals(info.getOriginalPath())) continue;
            return true;
        }
        return false;
    }

    private String getFileFullPath(String subPath) {
        return this.myFileSpec + "/" + subPath;
    }

    public void exportScheme(@NotNull E scheme, String name, String description) throws WriteExternalException, IOException {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl", "exportScheme"));
        }
        StreamProvider provider = SchemesManagerImpl.getProvider();
        if (provider == null) {
            return;
        }
        Document document = this.myProcessor.writeScheme(scheme);
        if (document != null) {
            String fileSpec = this.getFileFullPath(UniqueFileNamesProvider.convertName((String)scheme.getName())) + this.mySchemeExtension;
            if (!provider.isApplicable(fileSpec, RoamingType.GLOBAL)) {
                return;
            }
            Document wrapped = SchemesManagerImpl.wrap(document, name, description);
            if (provider instanceof CurrentUserHolder) {
                wrapped = wrapped.clone();
                String userName = ((CurrentUserHolder)provider).getCurrentUserName();
                if (userName != null) {
                    wrapped.getRootElement().setAttribute(USER, userName);
                }
            }
            StorageUtil.doSendContent(provider, fileSpec, wrapped, RoamingType.GLOBAL, false);
        }
    }

    private static Document wrap(@NotNull Document original, @NotNull String name, @NotNull String description) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl", "wrap"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/options/SchemesManagerImpl", "wrap"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/options/SchemesManagerImpl", "wrap"));
        }
        Element sharedElement = new Element(SHARED_SCHEME_ORIGINAL);
        sharedElement.setAttribute(NAME, name);
        sharedElement.setAttribute(DESCRIPTION, description);
        sharedElement.addContent(original.getRootElement().clone());
        return new Document(sharedElement);
    }

    public boolean isImportAvailable() {
        return SchemesManagerImpl.getProvider() != null;
    }

    @Nullable
    private static StreamProvider getProvider() {
        StreamProvider provider = ((ApplicationImpl)ApplicationManager.getApplication()).getStateStore().getStateStorageManager().getStreamProvider();
        return provider == null || !provider.isEnabled() ? null : provider;
    }

    public boolean isExportAvailable() {
        return false;
    }

    public boolean isShared(Scheme scheme) {
        return scheme instanceof ExternalizableScheme && ((ExternalizableScheme)scheme).getExternalInfo().isIsImported();
    }

    @Override
    public void save() throws WriteExternalException {
        if (this.myRefreshAlarm != null) {
            this.myRefreshAlarm.cancelAllRequests();
            this.myRefreshAlarm = null;
        }
        if (this.myVFSBaseDir == null) {
            this.ensureVFSBaseDir();
        }
        if (this.myVFSBaseDir != null) {
            this.doSave();
        }
    }

    private void ensureVFSBaseDir() {
        this.myBaseDir.mkdirs();
        ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable.IgnoreDocumentRunnable(){

            public void run() {
                VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(SchemesManagerImpl.this.myBaseDir);
                SchemesManagerImpl.this.myVFSBaseDir = dir;
                if (dir != null) {
                    dir.getChildren();
                    ((NewVirtualFile)dir).markDirtyRecursively();
                    dir.refresh(false, true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave() throws WriteExternalException {
        this.myInsideSave = true;
        try {
            ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable.IgnoreDocumentRunnable(){

                public void run() {
                    ((NewVirtualFile)SchemesManagerImpl.this.myVFSBaseDir).markDirtyRecursively();
                    SchemesManagerImpl.this.myVFSBaseDir.refresh(false, true);
                }
            });
            final List schemes = this.getAllSchemes();
            this.myBaseDir.mkdirs();
            final UniqueFileNamesProvider fileNameProvider = new UniqueFileNamesProvider();
            this.reserveUsingFileNames(schemes, fileNameProvider);
            final WriteExternalException[] ex = new WriteExternalException[1];
            ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable.IgnoreDocumentRunnable(){

                public void run() {
                    SchemesManagerImpl.this.deleteFilesFromDeletedSchemes();
                    try {
                        SchemesManagerImpl.this.saveSchemes(schemes, fileNameProvider);
                    }
                    catch (WriteExternalException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                throw ex[0];
            }
            if (this.myDeletedNames.isEmpty()) {
                this.deleteServerFiles(DELETED_XML);
            } else if (this.myProvider != null && this.myProvider.isEnabled()) {
                StorageUtil.sendContent(this.myProvider, this.getFileFullPath(DELETED_XML), this.createDeletedDocument(), this.myRoamingType, true);
            }
        }
        finally {
            this.myInsideSave = false;
        }
    }

    public File getRootDirectory() {
        return this.myBaseDir;
    }

    private void deleteFilesFromDeletedSchemes() {
        for (String deletedName : this.myFilesToDelete) {
            this.deleteLocalAndServerFiles(deletedName + this.mySchemeExtension);
            if (DEFAULT_EXT.equals(this.mySchemeExtension)) continue;
            this.deleteLocalAndServerFiles(deletedName + DEFAULT_EXT);
        }
        this.myFilesToDelete.clear();
    }

    private void deleteLocalAndServerFiles(String fileName) {
        VirtualFile file = this.myVFSBaseDir.findChild(fileName);
        if (file != null) {
            try {
                file.delete((Object)this);
            }
            catch (IOException e) {
                LOG.info("Cannot delete file " + file.getPath() + ": " + e.getLocalizedMessage());
            }
        }
        this.deleteServerFiles(fileName);
    }

    private void deleteServerFiles(String fileName) {
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            StorageUtil.deleteContent(this.myProvider, this.getFileFullPath(fileName), this.myRoamingType);
        }
    }

    private void saveSchemes(Collection<T> schemes, UniqueFileNamesProvider fileNameProvider) throws WriteExternalException {
        for (Scheme scheme : schemes) {
            if (!this.isExternalizable(scheme)) continue;
            final ExternalizableScheme eScheme = (ExternalizableScheme)scheme;
            eScheme.getExternalInfo().setPreviouslySavedName(eScheme.getName());
            if (!this.myProcessor.shouldBeSaved(eScheme)) continue;
            String fileName = this.getFileNameForScheme(fileNameProvider, eScheme);
            try {
                Document document = this.writeSchemeToDocument(eScheme);
                if (document == null) continue;
                long newHash = SchemesManagerImpl.computeHashValue(document);
                Long oldHash = eScheme.getExternalInfo().getHash();
                this.saveIfNeeded(eScheme, fileName, document, newHash, oldHash);
            }
            catch (IOException e) {
                Application app = ApplicationManager.getApplication();
                if (app.isUnitTestMode() || app.isCommandLine()) {
                    LOG.error("Cannot write scheme " + fileName + " in '" + this.myFileSpec + "': " + e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
                app.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)("Cannot save scheme '" + eScheme.getName() + ": " + e.getLocalizedMessage()), (String)"Save Settings");
                    }
                });
            }
        }
    }

    private String getFileNameForScheme(UniqueFileNamesProvider fileNameProvider, E scheme) {
        String fileName;
        if (scheme.getExternalInfo().getCurrentFileName() != null) {
            fileName = scheme.getExternalInfo().getCurrentFileName();
            fileNameProvider.reserveFileName(fileName);
        } else {
            fileName = fileNameProvider.suggestName(scheme.getName());
        }
        return fileName + this.mySchemeExtension;
    }

    private void saveIfNeeded(E schemeKey, String fileName, Document document, long newHash, Long oldHash) throws IOException {
        if (oldHash == null || newHash != oldHash || this.myVFSBaseDir.findChild(fileName) == null) {
            this.ensureFileText(fileName, StorageUtil.documentToBytes(document, true).toByteArray());
            schemeKey.getExternalInfo().setHash(newHash);
            this.saveFileName(fileName, schemeKey);
            this.saveOnServer(fileName, document);
        }
    }

    private void saveOnServer(String fileName, Document document) {
        if (this.myProvider != null && this.myProvider.isEnabled()) {
            StorageUtil.sendContent(this.myProvider, this.getFileFullPath(fileName), document, this.myRoamingType, true);
        }
    }

    private void reserveUsingFileNames(Collection<T> schemes, UniqueFileNamesProvider fileNameProvider) {
        fileNameProvider.reserveFileName(DELETED_XML);
        for (Scheme scheme : schemes) {
            ExternalInfo info;
            String fileName;
            if (!(scheme instanceof ExternalizableScheme) || (fileName = (info = ((ExternalizableScheme)scheme).getExternalInfo()).getCurrentFileName()) == null) continue;
            if (Comparing.equal((String)info.getPreviouslySavedName(), (String)scheme.getName())) {
                fileNameProvider.reserveFileName(fileName);
                continue;
            }
            this.myFilesToDelete.add(fileName);
            info.setCurrentFileName(null);
        }
    }

    private Document createDeletedDocument() {
        Element root = new Element("deleted-schemes");
        Document result = new Document(root);
        for (String deletedName : this.myDeletedNames) {
            Element child = new Element("scheme");
            root.addContent(child);
            child.setAttribute(NAME, deletedName);
        }
        return result;
    }

    @Override
    protected void onSchemeDeleted(Scheme toDelete) {
        if (toDelete instanceof ExternalizableScheme) {
            ExternalInfo info = ((ExternalizableScheme)toDelete).getExternalInfo();
            String previouslyUsedName = info.getPreviouslySavedName();
            if (previouslyUsedName != null) {
                this.myDeletedNames.add(previouslyUsedName);
            }
            if (info.getCurrentFileName() != null) {
                this.myFilesToDelete.add(info.getCurrentFileName());
            }
        }
    }

    @Override
    protected void onSchemeAdded(T scheme) {
        this.myDeletedNames.remove(scheme.getName());
        if (scheme instanceof ExternalizableScheme) {
            ((ExternalizableScheme)scheme).getExternalInfo().setPreviouslySavedName(scheme.getName());
        }
    }

    private static class SharedSchemeData {
        @NotNull
        private final Document original;
        private final String name;
        private final String user;
        private final String description;

        private SharedSchemeData(@NotNull Document original, String name, String user, String description) {
            if (original == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/options/SchemesManagerImpl$SharedSchemeData", "<init>"));
            }
            this.original = original;
            this.name = name;
            this.user = user;
            this.description = description;
        }
    }
}

