/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.StripedLockIntObjectConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class ModuleScopeProviderImpl
implements ModuleScopeProvider {
    private final Module myModule;
    private final StripedLockIntObjectConcurrentHashMap<GlobalSearchScope> myScopeCache;
    private GlobalSearchScope myModuleWithDependentsScope;
    private GlobalSearchScope myModuleTestsWithDependentsScope;

    public ModuleScopeProviderImpl(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "<init>"));
        }
        this.myScopeCache = new StripedLockIntObjectConcurrentHashMap();
        this.myModule = module;
    }

    @NotNull
    public GlobalSearchScope getCachedScope(@ModuleWithDependenciesScope.ScopeConstant int options) {
        GlobalSearchScope scope = (GlobalSearchScope)this.myScopeCache.get(options);
        if (scope == null) {
            scope = new ModuleWithDependenciesScope(this.myModule, options);
            this.myScopeCache.put(options, (Object)scope);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getCachedScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(9);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(1 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(11);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleWithLibrariesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(13);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(32);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleContentScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(36);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleContentWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(7 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleWithDependenciesAndLibrariesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope scope = this.myModuleWithDependentsScope;
        if (scope == null) {
            this.myModuleWithDependentsScope = scope = new ModuleWithDependentsScope(this.myModule, false);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        GlobalSearchScope scope = this.myModuleTestsWithDependentsScope;
        if (scope == null) {
            this.myModuleTestsWithDependentsScope = scope = new ModuleWithDependentsScope(this.myModule, true);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleTestsWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(6 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleScopeProviderImpl", "getModuleRuntimeScope"));
        }
        return globalSearchScope;
    }

    @Override
    public void clearCache() {
        this.myScopeCache.clear();
        this.myModuleWithDependentsScope = null;
        this.myModuleTestsWithDependentsScope = null;
    }
}

