/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.components.impl.PlatformComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IModuleStore;
import com.intellij.openapi.components.impl.stores.ModuleStoreImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.ModuleScopeProviderImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;

public class ModuleImpl
extends PlatformComponentManagerImpl
implements ModuleEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleImpl");
    @NotNull
    private final Project myProject;
    private boolean isModuleAdded;
    @NonNls
    private static final String OPTION_WORKSPACE = "workspace";
    public static final Object MODULE_RENAMING_REQUESTOR = new Object();
    private String myName;
    private String myModuleType;
    private IModuleStore myComponentStore;
    private final ModuleScopeProvider myModuleScopeProvider;

    public ModuleImpl(@NotNull String filePath, @NotNull Project project) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/module/impl/ModuleImpl", "<init>"));
        }
        super((ComponentManager)project, "Module " + ModuleImpl.moduleNameByFileName(PathUtil.getFileName((String)filePath)));
        this.getPicoContainer().registerComponentInstance(Module.class, (Object)this);
        this.myProject = project;
        this.myModuleScopeProvider = new ModuleScopeProviderImpl(this);
        this.init(filePath);
    }

    @Override
    protected void bootstrapPicoContainer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl", "bootstrapPicoContainer"));
        }
        Extensions.instantiateArea((String)"IDEA_MODULE", (AreaInstance)this, (AreaInstance)((AreaInstance)this.getParentComponentManager()));
        super.bootstrapPicoContainer(name);
        this.getPicoContainer().registerComponentImplementation(IComponentStore.class, ModuleStoreImpl.class);
        this.getPicoContainer().registerComponentImplementation(ModulePathMacroManager.class);
    }

    @NotNull
    public synchronized IModuleStore getStateStore() {
        if (this.myComponentStore == null) {
            this.myComponentStore = (IModuleStore)this.getPicoContainer().getComponentInstance(IComponentStore.class);
        }
        IModuleStore iModuleStore = this.myComponentStore;
        if (iModuleStore == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getStateStore"));
        }
        return iModuleStore;
    }

    @Override
    public void initializeComponent(Object component, boolean service) {
        this.getStateStore().initComponent(component, service);
    }

    private void init(String filePath) {
        this.getStateStore().setModuleFilePath(filePath);
        this.myName = ModuleImpl.moduleNameByFileName(PathUtil.getFileName((String)filePath));
        MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this);
    }

    @Override
    public void loadModuleComponents() {
        IdeaPluginDescriptor[] plugins;
        for (IdeaPluginDescriptor plugin : plugins = PluginManagerCore.getPlugins()) {
            if (PluginManagerCore.shouldSkipPlugin(plugin)) continue;
            this.loadComponentsConfiguration(plugin.getModuleComponents(), (PluginDescriptor)plugin, false);
        }
    }

    @Override
    protected boolean isComponentSuitable(Map<String, String> options) {
        if (!super.isComponentSuitable(options)) {
            return false;
        }
        if (options == null) {
            return true;
        }
        Set<String> optionNames = options.keySet();
        for (String optionName : optionNames) {
            if (Comparing.equal((String)OPTION_WORKSPACE, (String)optionName) || ModuleImpl.parseOptionValue(options.get(optionName)).contains(this.getOptionValue(optionName))) continue;
            return false;
        }
        return true;
    }

    private static List<String> parseOptionValue(String optionValue) {
        if (optionValue == null) {
            return new ArrayList<String>(0);
        }
        return Arrays.asList(optionValue.split(";"));
    }

    @Nullable
    public VirtualFile getModuleFile() {
        return this.getStateStore().getModuleFile();
    }

    @Override
    public void rename(String newName) {
        this.myName = newName;
        VirtualFile file = this.getStateStore().getModuleFile();
        try {
            if (file != null) {
                ClasspathStorage.moduleRenamed(this, newName);
                file.rename(MODULE_RENAMING_REQUESTOR, newName + ".iml");
                this.getStateStore().setModuleFilePath(VfsUtilCore.virtualToIoFile((VirtualFile)file).getCanonicalPath());
                return;
            }
            File oldFile = new File(this.getModuleFilePath());
            File parentFile = oldFile.getParentFile();
            File newFile = new File(parentFile, newName + ".iml");
            this.getStateStore().setModuleFilePath(newFile.getCanonicalPath());
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    @NotNull
    public String getModuleFilePath() {
        String string = this.getStateStore().getModuleFilePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleFilePath"));
        }
        return string;
    }

    @Override
    public synchronized void dispose() {
        this.isModuleAdded = false;
        this.disposeComponents();
        Extensions.disposeArea((AreaInstance)this);
        this.myComponentStore = null;
        super.dispose();
    }

    @Override
    public void projectOpened() {
        for (ModuleComponent component : this.getComponents(ModuleComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void projectClosed() {
        ArrayList<ModuleComponent> components = new ArrayList<ModuleComponent>(Arrays.asList(this.getComponents(ModuleComponent.class)));
        Collections.reverse(components);
        for (ModuleComponent component : components) {
            try {
                component.projectClosed();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getName"));
        }
        return string;
    }

    public boolean isLoaded() {
        return this.isModuleAdded;
    }

    @Override
    public void moduleAdded() {
        this.isModuleAdded = true;
        for (ModuleComponent component : this.getComponents(ModuleComponent.class)) {
            component.moduleAdded();
        }
    }

    public void setOption(@NotNull String optionName, @NotNull String optionValue) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl", "setOption"));
        }
        if (optionValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/module/impl/ModuleImpl", "setOption"));
        }
        if ("type".equals(optionName)) {
            this.myModuleType = optionValue;
        }
        this.getStateStore().setOption(optionName, optionValue);
    }

    public void clearOption(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl", "clearOption"));
        }
        if ("type".equals(optionName)) {
            this.myModuleType = null;
        }
        this.getStateStore().clearOption(optionName);
    }

    public String getOptionValue(@NotNull String optionName) {
        if (optionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl", "getOptionValue"));
        }
        if ("type".equals(optionName)) {
            if (this.myModuleType == null) {
                this.myModuleType = this.getStateStore().getOptionValue(optionName);
            }
            return this.myModuleType;
        }
        return this.getStateStore().getOptionValue(optionName);
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleWithLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleContentScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleContentWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleWithDependenciesAndLibrariesScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleTestsWithDependentsScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getModuleRuntimeScope"));
        }
        return globalSearchScope;
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public String toString() {
        if (this.myName == null) {
            return "Module (not initialized)";
        }
        return "Module: '" + this.getName() + "'";
    }

    private static String moduleNameByFileName(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl", "moduleNameByFileName"));
        }
        return StringUtil.trimEnd((String)fileName, (String)".iml");
    }

    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl", "getExtensions"));
        }
        Object[] objectArray = Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/ModuleImpl", "getExtensions"));
        }
        return objectArray;
    }

    @Override
    protected boolean logSlowComponents() {
        return super.logSlowComponents() || ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    @Override
    protected MutablePicoContainer createPicoContainer() {
        return Extensions.getArea((AreaInstance)this).getPicoContainer();
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile moduleFile;
            String moduleFilePath;
            String parentPath;
            String ancestorPath;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl$MyVirtualFileListener", "propertyChanged"));
            }
            if (!ModuleImpl.this.isModuleAdded) {
                return;
            }
            Object requestor = event.getRequestor();
            if (MODULE_RENAMING_REQUESTOR.equals(requestor)) {
                return;
            }
            if (!"name".equals(event.getPropertyName())) {
                return;
            }
            VirtualFile parent = event.getParent();
            if (parent != null && VfsUtilCore.isAncestor((File)new File(ancestorPath = (parentPath = parent.getPath()) + "/" + event.getOldValue()), (File)new File(moduleFilePath = ModuleImpl.this.getModuleFilePath()), (boolean)true)) {
                String newValue = (String)event.getNewValue();
                String relativePath = FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/');
                String newFilePath = parentPath + "/" + newValue + "/" + relativePath;
                this.setModuleFilePath(moduleFilePath, newFilePath);
            }
            if ((moduleFile = ModuleImpl.this.getModuleFile()) == null) {
                return;
            }
            if (moduleFile.equals(event.getFile())) {
                String oldName = ModuleImpl.this.myName;
                ModuleImpl.this.myName = ModuleImpl.moduleNameByFileName(moduleFile.getName());
                ModuleManagerImpl.getInstanceImpl(ModuleImpl.this.getProject()).fireModuleRenamedByVfsEvent(ModuleImpl.this, oldName);
            }
        }

        private void setModuleFilePath(String moduleFilePath, String newFilePath) {
            ClasspathStorage.modulePathChanged(ModuleImpl.this, newFilePath);
            ModifiableModuleModel modifiableModel = ModuleManagerImpl.getInstanceImpl(ModuleImpl.this.getProject()).getModifiableModel();
            modifiableModel.setModuleFilePath((Module)ModuleImpl.this, moduleFilePath, newFilePath);
            modifiableModel.commit();
            ModuleImpl.this.getStateStore().setModuleFilePath(newFilePath);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            String moduleFilePath;
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/module/impl/ModuleImpl$MyVirtualFileListener", "fileMoved"));
            }
            VirtualFile oldParent = event.getOldParent();
            VirtualFile newParent = event.getNewParent();
            String dirName = event.getFileName();
            String ancestorPath = oldParent.getPath() + "/" + dirName;
            if (VfsUtilCore.isAncestor((File)new File(ancestorPath), (File)new File(moduleFilePath = ModuleImpl.this.getModuleFilePath()), (boolean)true)) {
                String relativePath = FileUtil.getRelativePath((String)ancestorPath, (String)moduleFilePath, (char)'/');
                this.setModuleFilePath(moduleFilePath, newParent.getPath() + "/" + dirName + "/" + relativePath);
            }
        }
    }
}

