/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.ProjectScope;
import gnu.trove.THashSet;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    @NotNull
    public String getUniqueVirtualFilePath(Project project, VirtualFile file) {
        String fileName = file.getName();
        THashSet filesWithSameName = FilenameIndex.getVirtualFilesByName(project, fileName, ProjectScope.getProjectScope((Project)project));
        THashSet setOfFilesWithTheSameName = new THashSet(filesWithSameName);
        for (VirtualFile openFile : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            if (!openFile.getName().equals(fileName)) continue;
            setOfFilesWithTheSameName.add((Object)openFile);
        }
        filesWithSameName = setOfFilesWithTheSameName;
        if (filesWithSameName.size() > 1 && filesWithSameName.contains(file)) {
            String path = project.getBasePath();
            path = path == null ? "" : FileUtil.toSystemIndependentName((String)path);
            UniqueNameBuilder builder = new UniqueNameBuilder(path, File.separator, 25);
            for (VirtualFile virtualFile : filesWithSameName) {
                builder.addPath((Object)virtualFile, virtualFile.getPath());
            }
            String string = UniqueVFilePathBuilderImpl.getEditorTabText(file, builder, UISettings.getInstance().HIDE_KNOWN_EXTENSION_IN_TABS);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl", "getUniqueVirtualFilePath"));
            }
            return string;
        }
        String string = file.getPresentableName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl", "getUniqueVirtualFilePath"));
        }
        return string;
    }

    public static <T> String getEditorTabText(T key, UniqueNameBuilder<T> builder, boolean hideKnownExtensionInTabs) {
        String withoutExtension;
        String result = builder.getShortPath(key);
        if (hideKnownExtensionInTabs && StringUtil.isNotEmpty((String)(withoutExtension = FileUtil.getNameWithoutExtension((String)result))) && !withoutExtension.endsWith(builder.getSeparator())) {
            return withoutExtension;
        }
        return result;
    }
}

