/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class TrailingSpacesStripper
extends FileDocumentManagerAdapter {
    public static final Key<String> OVERRIDE_STRIP_TRAILING_SPACES_KEY = Key.create((String)"OVERRIDE_TRIM_TRAILING_SPACES_KEY");
    public static final Key<Boolean> OVERRIDE_ENSURE_NEWLINE_KEY = Key.create((String)"OVERRIDE_ENSURE_NEWLINE_KEY");
    private final Set<Document> myDocumentsToStripLater = new THashSet();

    public void beforeAllDocumentsSaving() {
        THashSet documentsToStrip = new THashSet(this.myDocumentsToStripLater);
        this.myDocumentsToStripLater.clear();
        for (Document document : documentsToStrip) {
            this.strip(document);
        }
    }

    public void beforeDocumentSaving(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/TrailingSpacesStripper", "beforeDocumentSaving"));
        }
        this.strip(document);
    }

    private void strip(final Document document) {
        int end;
        int start;
        boolean inChangedLinesOnly;
        boolean success;
        boolean ensureEOL;
        if (!document.isWritable()) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile file = fileDocumentManager.getFile(document);
        if (file == null || !file.isValid()) {
            return;
        }
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings == null) {
            return;
        }
        String overrideStripTrailingSpacesData = (String)file.getUserData(OVERRIDE_STRIP_TRAILING_SPACES_KEY);
        Boolean overrideEnsureNewlineData = (Boolean)file.getUserData(OVERRIDE_ENSURE_NEWLINE_KEY);
        String stripTrailingSpaces = overrideStripTrailingSpacesData != null ? overrideStripTrailingSpacesData : settings.getStripTrailingSpaces();
        final boolean doStrip = !stripTrailingSpaces.equals("None");
        boolean bl = ensureEOL = overrideEnsureNewlineData != null ? overrideEnsureNewlineData.booleanValue() : settings.isEnsureNewLineAtEOF();
        if (doStrip && !(success = TrailingSpacesStripper.stripIfNotCurrentLine(document, inChangedLinesOnly = !stripTrailingSpaces.equals("Whole")))) {
            this.myDocumentsToStripLater.add(document);
        }
        int lines = document.getLineCount();
        if (ensureEOL && lines > 0 && (start = document.getLineStartOffset(lines - 1)) != (end = document.getLineEndOffset(lines - 1))) {
            final CharSequence content = document.getCharsSequence();
            ApplicationManager.getApplication().runWriteAction((Runnable)new DocumentRunnable(document, null){

                public void run() {
                    CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                        @Override
                        public void run() {
                            if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)content.subSequence(start, end)) && doStrip) {
                                document.deleteString(start, end);
                            } else {
                                document.insertString(end, (CharSequence)"\n");
                            }
                        }
                    });
                }
            });
        }
    }

    public void clearLineModificationFlags(@NotNull Document document) {
        int[] caretLines;
        boolean inChangedLinesOnly;
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/TrailingSpacesStripper", "clearLineModificationFlags"));
        }
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (!(document instanceof DocumentImpl)) {
            return;
        }
        Component focusOwner = IdeFocusManager.getGlobalInstance().getFocusOwner();
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        boolean isDisposeInProgress = ApplicationManager.getApplication().isDisposeInProgress();
        Editor activeEditor = isDisposeInProgress ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        boolean isVirtualSpaceEnabled = activeEditor == null || activeEditor.getSettings().isVirtualSpace();
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings == null) {
            return;
        }
        String stripTrailingSpaces = settings.getStripTrailingSpaces();
        boolean doStrip = !stripTrailingSpaces.equals("None");
        boolean bl = inChangedLinesOnly = !stripTrailingSpaces.equals("Whole");
        if (activeEditor != null && inChangedLinesOnly && doStrip && !isVirtualSpaceEnabled) {
            List carets = activeEditor.getCaretModel().getAllCarets();
            caretLines = new int[carets.size()];
            for (int i = 0; i < carets.size(); ++i) {
                Caret caret = (Caret)carets.get(i);
                caretLines[i] = caret.getLogicalPosition().line;
            }
        } else {
            caretLines = ArrayUtil.EMPTY_INT_ARRAY;
        }
        ((DocumentImpl)document).clearLineModificationFlagsExcept(caretLines);
    }

    public static boolean stripIfNotCurrentLine(Document document, boolean inChangedLinesOnly) {
        boolean markAsNeedsStrippingLater;
        boolean isVirtualSpaceEnabled;
        if (document instanceof DocumentWindow) {
            document = ((DocumentWindow)document).getDelegate();
        }
        if (!(document instanceof DocumentImpl)) {
            return true;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(IdeFocusManager.getGlobalInstance().getFocusOwner());
        boolean isDisposeInProgress = ApplicationManager.getApplication().isDisposeInProgress();
        Editor activeEditor = isDisposeInProgress ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        boolean bl = isVirtualSpaceEnabled = activeEditor == null || activeEditor.getSettings().isVirtualSpace();
        if (activeEditor != null && activeEditor.getCaretModel().supportsMultipleCarets()) {
            List carets = activeEditor.getCaretModel().getAllCarets();
            ArrayList<VisualPosition> visualCarets = new ArrayList<VisualPosition>(carets.size());
            ArrayList<Integer> caretOffsets = new ArrayList<Integer>(carets.size());
            for (Caret caret : carets) {
                visualCarets.add(caret.getVisualPosition());
                caretOffsets.add(caret.getOffset());
            }
            markAsNeedsStrippingLater = ((DocumentImpl)document).stripTrailingSpaces(activeEditor.getProject(), inChangedLinesOnly, isVirtualSpaceEnabled, caretOffsets);
            if (!ShutDownTracker.isShutdownHookRunning()) {
                final Iterator visualCaretIterator = visualCarets.iterator();
                activeEditor.getCaretModel().runForEachCaret(new CaretAction(){

                    public void perform(Caret caret) {
                        if (visualCaretIterator.hasNext()) {
                            caret.moveToVisualPosition((VisualPosition)visualCaretIterator.next());
                        }
                    }
                });
            }
        } else {
            VisualPosition visualCaret = activeEditor == null ? null : activeEditor.getCaretModel().getVisualPosition();
            int caretLine = activeEditor == null ? -1 : activeEditor.getCaretModel().getLogicalPosition().line;
            int caretOffset = activeEditor == null ? -1 : activeEditor.getCaretModel().getOffset();
            Project project = activeEditor == null ? null : activeEditor.getProject();
            markAsNeedsStrippingLater = ((DocumentImpl)document).stripTrailingSpaces(project, inChangedLinesOnly, isVirtualSpaceEnabled, caretLine, caretOffset);
            if (!ShutDownTracker.isShutdownHookRunning() && activeEditor != null) {
                activeEditor.getCaretModel().moveToVisualPosition(visualCaret);
            }
        }
        return !markAsNeedsStrippingLater;
    }

    public void documentDeleted(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/TrailingSpacesStripper", "documentDeleted"));
        }
        this.myDocumentsToStripLater.remove(doc);
    }

    public void unsavedDocumentsDropped() {
        this.myDocumentsToStripLater.clear();
    }
}

