/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.WaverGraphicsDecorator;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.docking.DockManager;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class PsiAwareFileEditorManagerImpl
extends FileEditorManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.text.PsiAwareFileEditorManagerImpl");
    private final PsiManager myPsiManager;
    private final WolfTheProblemSolver myProblemSolver;
    private final MyPsiTreeChangeListener myPsiTreeChangeListener;
    private final WolfTheProblemSolver.ProblemListener myProblemListener;

    public PsiAwareFileEditorManagerImpl(Project project, PsiManager psiManager, WolfTheProblemSolver problemSolver, DockManager dockManager) {
        super(project, dockManager);
        this.myPsiManager = psiManager;
        this.myProblemSolver = problemSolver;
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        this.myProblemListener = new MyProblemListener();
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
    }

    @Override
    public void projectOpened() {
        super.projectOpened();
        this.myPsiManager.addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myProblemSolver.addProblemListener(this.myProblemListener);
    }

    @Override
    public Color getFileColor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl", "getFileColor"));
        }
        Color color = super.getFileColor(file);
        if (this.myProblemSolver.isProblemFile(file)) {
            return ColorUtil.toAlpha((Color)color, (int)WaverGraphicsDecorator.WAVE_ALPHA_KEY);
        }
        return color;
    }

    @Override
    public boolean isProblem(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl", "isProblem"));
        }
        return this.myProblemSolver.isProblemFile(file);
    }

    @Override
    public String getFileTooltipText(VirtualFile file) {
        StringBuilder tooltipText = new StringBuilder();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.getProject());
        if (module != null) {
            tooltipText.append("[");
            tooltipText.append(module.getName());
            tooltipText.append("] ");
        }
        tooltipText.append(FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl()));
        return tooltipText.toString();
    }

    @Override
    protected Editor getOpenedEditor(Editor editor, boolean focusEditor) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = editor.getDocument();
        PsiFile psiFile = documentManager.getPsiFile(document);
        if (!focusEditor || documentManager.isUncommited(document)) {
            return editor;
        }
        return InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile);
    }

    private class MyProblemListener
    extends WolfTheProblemSolver.ProblemListener {
        private MyProblemListener() {
        }

        public void problemsAppeared(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener", "problemsAppeared"));
            }
            this.updateFile(file);
        }

        public void problemsDisappeared(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener", "problemsDisappeared"));
            }
            this.updateFile(file);
        }

        public void problemsChanged(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyProblemListener", "problemsChanged"));
            }
            this.updateFile(file);
        }

        private void updateFile(VirtualFile file) {
            PsiAwareFileEditorManagerImpl.this.queueUpdateFile(file);
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "propertyChanged"));
            }
            if ("roots".equals(e.getPropertyName())) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                VirtualFile[] openFiles = PsiAwareFileEditorManagerImpl.this.getOpenFiles();
                for (int i = openFiles.length - 1; i >= 0; --i) {
                    VirtualFile file = openFiles[i];
                    LOG.assertTrue(file != null);
                    PsiAwareFileEditorManagerImpl.this.updateFileIcon(file);
                }
            }
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childAdded"));
            }
            this.doChange(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childRemoved"));
            }
            this.doChange(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childReplaced"));
            }
            this.doChange(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childMoved"));
            }
            this.doChange(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileEditor/impl/PsiAwareFileEditorManagerImpl$MyPsiTreeChangeListener", "childrenChanged"));
            }
            this.doChange(event);
        }

        private void doChange(PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile file = psiFile.getVirtualFile();
            if (file == null) {
                return;
            }
            FileEditor[] editors = PsiAwareFileEditorManagerImpl.this.getAllEditors(file);
            if (editors.length == 0) {
                return;
            }
            VirtualFile currentFile = PsiAwareFileEditorManagerImpl.this.getCurrentFile();
            if (currentFile != null && Comparing.equal((Object)psiFile.getVirtualFile(), (Object)currentFile)) {
                PsiAwareFileEditorManagerImpl.this.updateFileIcon(currentFile);
            }
        }
    }
}

