/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class RootFileElement
extends FileElement {
    private VirtualFile[] myFiles;
    private Object[] myChildren;

    public RootFileElement(@NotNull VirtualFile[] files, String name, boolean showFileSystemRoots) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/fileChooser/ex/RootFileElement", "<init>"));
        }
        super(files.length == 1 ? files[0] : null, name);
        this.myFiles = files.length == 0 && showFileSystemRoots ? null : files;
    }

    public Object[] getChildren() {
        if (this.myChildren == null) {
            if (this.myFiles == null) {
                this.myFiles = RootFileElement.getFileSystemRoots();
            }
            ArrayList<FileElement> children = new ArrayList<FileElement>();
            for (VirtualFile file : this.myFiles) {
                if (file == null) continue;
                children.add(new FileElement(file, file.getPresentableUrl()));
            }
            this.myChildren = ArrayUtil.toObjectArray(children);
        }
        return this.myChildren;
    }

    private static VirtualFile[] getFileSystemRoots() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        File[] ioRoots = File.listRoots();
        if (ioRoots != null) {
            for (File root : ioRoots) {
                String path = FileUtil.toSystemIndependentName((String)root.getAbsolutePath());
                VirtualFile file = localFileSystem.findFileByPath(path);
                if (file == null) continue;
                roots.add(file);
            }
        }
        return VfsUtilCore.toVirtualFileArray(roots);
    }
}

