/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolWindowManager {
    public static void handle(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager", "handle"));
        }
        for (final ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            final AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
            settings.subscribe((ExternalSystemSettingsListener)new ExternalSystemSettingsListenerAdapter(){

                public void onProjectsLinked(@NotNull Collection linked) {
                    if (linked == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager$1", "onProjectsLinked"));
                    }
                    if (settings.getLinkedProjectsSettings().size() != 1) {
                        return;
                    }
                    ToolWindow toolWindow = ExternalToolWindowManager.getToolWindow(project, manager.getSystemId());
                    if (toolWindow != null) {
                        toolWindow.setAvailable(true, null);
                    }
                }

                public void onProjectsUnlinked(@NotNull Set linkedProjectPaths) {
                    if (linkedProjectPaths == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager$1", "onProjectsUnlinked"));
                    }
                    if (!settings.getLinkedProjectsSettings().isEmpty()) {
                        return;
                    }
                    final ToolWindow toolWindow = ExternalToolWindowManager.getToolWindow(project, manager.getSystemId());
                    if (toolWindow != null) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                toolWindow.setAvailable(false, null);
                            }
                        });
                    }
                }
            });
        }
    }

    @Nullable
    private static ToolWindow getToolWindow(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager", "getToolWindow"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/ui/ExternalToolWindowManager", "getToolWindow"));
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
        if (toolWindowManager == null) {
            return null;
        }
        ToolWindow result = toolWindowManager.getToolWindow(externalSystemId.getReadableName());
        if (result instanceof ToolWindowImpl) {
            ((ToolWindowImpl)result).ensureContentInitialized();
        }
        return result;
    }
}

