/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNode;
import com.intellij.openapi.externalSystem.service.task.ui.ExternalSystemNodeDescriptor;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTasksTreeModel
extends DefaultTreeModel {
    @NotNull
    private static final Comparator<TreeNode> NODE_COMPARATOR = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode t1, TreeNode t2) {
            Object e1 = ((ExternalSystemNode)t1).getDescriptor().getElement();
            Object e2 = ((ExternalSystemNode)t2).getDescriptor().getElement();
            if (e1 instanceof ExternalProjectPojo) {
                if (e2 instanceof ExternalTaskExecutionInfo) {
                    return 1;
                }
                return ((ExternalProjectPojo)e1).getName().compareTo(((ExternalProjectPojo)e2).getName());
            }
            if (e2 instanceof ExternalProjectPojo) {
                return -1;
            }
            return ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e1).compareTo(ExternalSystemTasksTreeModel.getTaskName((ExternalTaskExecutionInfo)e2));
        }
    };
    @NotNull
    private final ExternalSystemUiAware myUiAware;
    @NotNull
    private final ProjectSystemId myExternalSystemId;

    public ExternalSystemTasksTreeModel(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "<init>"));
        }
        super(new ExternalSystemNode<String>(new ExternalSystemNodeDescriptor<String>("", "", "", null)));
        this.myExternalSystemId = externalSystemId;
        this.myUiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
    }

    private static String getTaskName(@NotNull ExternalTaskExecutionInfo taskInfo) {
        if (taskInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "getTaskName"));
        }
        return (String)taskInfo.getSettings().getTaskNames().get(0);
    }

    @NotNull
    public ExternalSystemNode<ExternalProjectPojo> ensureProjectNodeExists(@NotNull ExternalProjectPojo project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "ensureProjectNodeExists"));
        }
        Object root = this.getRoot();
        for (int i = ((DefaultMutableTreeNode)root).getChildCount() - 1; i >= 0; --i) {
            ExternalProjectPojo pojo;
            TreeNode child = ((ExternalSystemNode)root).getChildAt(i);
            ExternalSystemNodeDescriptor descriptor = ((ExternalSystemNode)child).getDescriptor();
            Object element = descriptor.getElement();
            if (!(element instanceof ExternalProjectPojo) || !(pojo = (ExternalProjectPojo)element).getPath().equals(project.getPath())) continue;
            if (!pojo.getName().equals(project.getName())) {
                pojo.setName(project.getName());
                descriptor.setName(project.getName());
                this.nodeChanged(child);
            }
            TreeNode treeNode = child;
            if (treeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "ensureProjectNodeExists"));
            }
            return treeNode;
        }
        ExternalProjectPojo element = new ExternalProjectPojo(project.getName(), project.getPath());
        ExternalSystemNodeDescriptor<ExternalProjectPojo> descriptor = ExternalSystemTasksTreeModel.descriptor(element, this.myUiAware.getProjectIcon());
        ExternalSystemNode<ExternalProjectPojo> result = new ExternalSystemNode<ExternalProjectPojo>(descriptor);
        this.insertNodeInto(result, (MutableTreeNode)root);
        ExternalSystemNode<ExternalProjectPojo> externalSystemNode = result;
        if (externalSystemNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "ensureProjectNodeExists"));
        }
        return externalSystemNode;
    }

    public void pruneNodes(@NotNull Object payload) {
        if (payload == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "pruneNodes"));
        }
        ArrayDeque<Object> toProcess = new ArrayDeque<Object>();
        toProcess.addFirst(this.getRoot());
        while (!toProcess.isEmpty()) {
            ExternalSystemNode node = (ExternalSystemNode)toProcess.removeLast();
            if (payload.equals(node.getDescriptor().getElement())) {
                this.removeNodeFromParent(node);
                continue;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                toProcess.addFirst(node.getChildAt(i));
            }
        }
    }

    public void ensureSubProjectsStructure(@NotNull ExternalProjectPojo topLevelProject, @NotNull Collection<ExternalProjectPojo> subProjects) {
        if (topLevelProject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "ensureSubProjectsStructure"));
        }
        if (subProjects == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "ensureSubProjectsStructure"));
        }
        ExternalSystemNode<ExternalProjectPojo> topLevelProjectNode = this.ensureProjectNodeExists(topLevelProject);
        HashMap toAdd = ContainerUtilRt.newHashMap();
        for (ExternalProjectPojo subProject : subProjects) {
            toAdd.put(subProject.getPath(), subProject);
        }
        toAdd.remove(topLevelProject.getPath());
        TObjectIntHashMap taskWeights = new TObjectIntHashMap();
        for (int i = 0; i < topLevelProjectNode.getChildCount(); ++i) {
            TreeNode child = topLevelProjectNode.getChildAt(i);
            Object childElement = ((ExternalSystemNode)child).getDescriptor().getElement();
            if (childElement instanceof ExternalTaskExecutionInfo) {
                taskWeights.put(childElement, subProjects.size() + i);
                continue;
            }
            if (toAdd.remove(((ExternalProjectPojo)childElement).getPath()) != null) continue;
            this.removeNodeFromParent((MutableTreeNode)child);
            --i;
        }
        if (!toAdd.isEmpty()) {
            for (Map.Entry entry : toAdd.entrySet()) {
                ExternalProjectPojo element = new ExternalProjectPojo(((ExternalProjectPojo)entry.getValue()).getName(), ((ExternalProjectPojo)entry.getValue()).getPath());
                this.insertNodeInto(new ExternalSystemNode<ExternalProjectPojo>(ExternalSystemTasksTreeModel.descriptor(element, this.myUiAware.getProjectIcon())), topLevelProjectNode);
            }
        }
    }

    public void ensureTasks(@NotNull String externalProjectConfigPath, @NotNull Collection<ExternalTaskPojo> tasks) {
        if (externalProjectConfigPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "ensureTasks"));
        }
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "ensureTasks"));
        }
        if (tasks.isEmpty()) {
            return;
        }
        ExternalSystemNode<ExternalProjectPojo> moduleNode = this.findProjectNode(externalProjectConfigPath);
        if (moduleNode == null) {
            return;
        }
        HashSet toAdd = ContainerUtilRt.newHashSet();
        for (ExternalTaskPojo task : tasks) {
            toAdd.add(this.buildTaskInfo(task));
        }
        for (int i = 0; i < moduleNode.getChildCount(); ++i) {
            TreeNode childNode = moduleNode.getChildAt(i);
            Object element = ((ExternalSystemNode)childNode).getDescriptor().getElement();
            if (!(element instanceof ExternalTaskExecutionInfo) || toAdd.remove(element)) continue;
            this.removeNodeFromParent((MutableTreeNode)childNode);
            --i;
        }
        if (!toAdd.isEmpty()) {
            for (ExternalTaskExecutionInfo taskInfo : toAdd) {
                this.insertNodeInto(new ExternalSystemNode<ExternalTaskExecutionInfo>(ExternalSystemTasksTreeModel.descriptor(taskInfo, taskInfo.getDescription(), this.myUiAware.getTaskIcon())), moduleNode);
            }
        }
    }

    @NotNull
    private ExternalTaskExecutionInfo buildTaskInfo(@NotNull ExternalTaskPojo task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "buildTaskInfo"));
        }
        ExternalSystemTaskExecutionSettings settings = new ExternalSystemTaskExecutionSettings();
        settings.setExternalProjectPath(task.getLinkedExternalProjectPath());
        settings.setTaskNames(Collections.singletonList(task.getName()));
        settings.setTaskDescriptions(Collections.singletonList(task.getDescription()));
        settings.setExternalSystemIdString(this.myExternalSystemId.toString());
        ExternalTaskExecutionInfo externalTaskExecutionInfo = new ExternalTaskExecutionInfo(settings, DefaultRunExecutor.EXECUTOR_ID);
        if (externalTaskExecutionInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "buildTaskInfo"));
        }
        return externalTaskExecutionInfo;
    }

    @Nullable
    private ExternalSystemNode<ExternalProjectPojo> findProjectNode(@NotNull String configPath) {
        if (configPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "findProjectNode"));
        }
        for (int i = ((DefaultMutableTreeNode)this.getRoot()).getChildCount() - 1; i >= 0; --i) {
            TreeNode child = ((ExternalSystemNode)this.getRoot()).getChildAt(i);
            Object childElement = ((ExternalSystemNode)child).getDescriptor().getElement();
            if (childElement instanceof ExternalProjectPojo && ((ExternalProjectPojo)childElement).getPath().equals(configPath)) {
                return child;
            }
            for (int j = ((DefaultMutableTreeNode)child).getChildCount() - 1; j >= 0; --j) {
                TreeNode grandChild = ((ExternalSystemNode)child).getChildAt(j);
                Object grandChildElement = ((ExternalSystemNode)grandChild).getDescriptor().getElement();
                if (!(grandChildElement instanceof ExternalProjectPojo) || !((ExternalProjectPojo)grandChildElement).getPath().equals(configPath)) continue;
                return grandChild;
            }
        }
        return null;
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element, @Nullable Icon icon) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "descriptor"));
        }
        ExternalSystemNodeDescriptor<T> externalSystemNodeDescriptor = ExternalSystemTasksTreeModel.descriptor(element, "", icon);
        if (externalSystemNodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "descriptor"));
        }
        return externalSystemNodeDescriptor;
    }

    @NotNull
    private static <T> ExternalSystemNodeDescriptor<T> descriptor(@NotNull T element, @NotNull String description, @Nullable Icon icon) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "descriptor"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "descriptor"));
        }
        ExternalSystemNodeDescriptor<T> externalSystemNodeDescriptor = new ExternalSystemNodeDescriptor<T>(element, element.toString(), description, icon);
        if (externalSystemNodeDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "descriptor"));
        }
        return externalSystemNodeDescriptor;
    }

    @Override
    @NotNull
    public ExternalSystemNode<?> getRoot() {
        ExternalSystemNode externalSystemNode = (ExternalSystemNode)super.getRoot();
        if (externalSystemNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ExternalSystemTasksTreeModel", "getRoot"));
        }
        return externalSystemNode;
    }

    public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent) {
        int index = ExternalSystemTasksTreeModel.findIndexFor(child, parent);
        super.insertNodeInto(child, parent, index);
    }

    @Override
    public void insertNodeInto(MutableTreeNode child, MutableTreeNode parent, int i) {
        this.insertNodeInto(child, parent);
    }

    private static int findIndexFor(MutableTreeNode child, MutableTreeNode parent) {
        int childCount = parent.getChildCount();
        if (childCount == 0) {
            return 0;
        }
        if (childCount == 1) {
            return NODE_COMPARATOR.compare(child, parent.getChildAt(0)) <= 0 ? 0 : 1;
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child, parent, 0, childCount - 1);
    }

    private static int findIndexFor(MutableTreeNode child, MutableTreeNode parent, int i1, int i2) {
        if (i1 == i2) {
            return NODE_COMPARATOR.compare(child, parent.getChildAt(i1)) <= 0 ? i1 : i1 + 1;
        }
        int half = (i1 + i2) / 2;
        if (NODE_COMPARATOR.compare(child, parent.getChildAt(half)) <= 0) {
            return ExternalSystemTasksTreeModel.findIndexFor(child, parent, i1, half);
        }
        return ExternalSystemTasksTreeModel.findIndexFor(child, parent, half + 1, i2);
    }
}

