/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote.wrapper;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemProjectResolverWrapper;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemTaskManagerWrapper;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemFacadeWrapper<S extends ExternalSystemExecutionSettings>
implements RemoteExternalSystemFacade<S> {
    @NotNull
    private final RemoteExternalSystemFacade<S> myDelegate;
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;

    public ExternalSystemFacadeWrapper(@NotNull RemoteExternalSystemFacade<S> delegate, @NotNull RemoteExternalSystemProgressNotificationManager progressManager) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "<init>"));
        }
        if (progressManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "<init>"));
        }
        this.myDelegate = delegate;
        this.myProgressManager = progressManager;
    }

    @NotNull
    public RemoteExternalSystemFacade<S> getDelegate() {
        RemoteExternalSystemFacade<S> remoteExternalSystemFacade = this.myDelegate;
        if (remoteExternalSystemFacade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "getDelegate"));
        }
        return remoteExternalSystemFacade;
    }

    @Override
    @NotNull
    public RemoteExternalSystemProjectResolver<S> getResolver() throws RemoteException, IllegalStateException {
        ExternalSystemProjectResolverWrapper<S> externalSystemProjectResolverWrapper = new ExternalSystemProjectResolverWrapper<S>(this.myDelegate.getResolver(), this.myProgressManager);
        if (externalSystemProjectResolverWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "getResolver"));
        }
        return externalSystemProjectResolverWrapper;
    }

    @Override
    @NotNull
    public RemoteExternalSystemTaskManager<S> getTaskManager() throws RemoteException {
        ExternalSystemTaskManagerWrapper<S> externalSystemTaskManagerWrapper = new ExternalSystemTaskManagerWrapper<S>(this.myDelegate.getTaskManager(), this.myProgressManager);
        if (externalSystemTaskManagerWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "getTaskManager"));
        }
        return externalSystemTaskManagerWrapper;
    }

    @Override
    public void applySettings(@NotNull S settings) throws RemoteException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "applySettings"));
        }
        this.myDelegate.applySettings(settings);
    }

    @Override
    public void applyProgressManager(@NotNull RemoteExternalSystemProgressNotificationManager progressManager) throws RemoteException {
        if (progressManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "applyProgressManager"));
        }
        this.myDelegate.applyProgressManager(progressManager);
    }

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "isTaskInProgress"));
        }
        return this.myDelegate.isTaskInProgress(id);
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() throws RemoteException {
        Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> map = this.myDelegate.getTasksInProgress();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "getTasksInProgress"));
        }
        return map;
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id) throws RemoteException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/remote/wrapper/ExternalSystemFacadeWrapper", "cancelTask"));
        }
        return this.myDelegate.cancelTask(id);
    }
}

