/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.wizard;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalModuleBuilder;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.ConfigurationException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalModuleSettingsStep<S extends ExternalProjectSettings>
extends ModuleWizardStep {
    @NotNull
    private final AbstractExternalModuleBuilder<S> myExternalModuleBuilder;
    @NotNull
    private final AbstractExternalProjectSettingsControl<S> myControl;
    @Nullable
    private PaintAwarePanel myComponent;

    public ExternalModuleSettingsStep(@NotNull AbstractExternalModuleBuilder<S> externalModuleBuilder, @NotNull AbstractExternalProjectSettingsControl<S> control) {
        if (externalModuleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/wizard/ExternalModuleSettingsStep", "<init>"));
        }
        if (control == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/wizard/ExternalModuleSettingsStep", "<init>"));
        }
        this.myExternalModuleBuilder = externalModuleBuilder;
        this.myControl = control;
    }

    public JComponent getComponent() {
        PaintAwarePanel result = this.myComponent;
        if (result == null) {
            result = new PaintAwarePanel();
            this.myControl.fillUi(result, 0);
            this.myControl.reset(true);
            ExternalSystemUiUtil.fillBottom(result);
            this.myComponent = result;
        }
        return result;
    }

    public boolean validate() throws ConfigurationException {
        if (!super.validate()) {
            return false;
        }
        return this.myControl.validate(this.myExternalModuleBuilder.getExternalProjectSettings());
    }

    public void updateDataModel() {
        this.myControl.apply(this.myExternalModuleBuilder.getExternalProjectSettings());
    }

    public void updateStep() {
        String contentPath = this.myExternalModuleBuilder.getContentEntryPath();
        if (contentPath != null) {
            this.myControl.getInitialSettings().setExternalProjectPath(contentPath);
        }
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myControl.disposeUIResources();
    }
}

