/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ProjectDataManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectDataManager.class.getName()));
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

        @NotNull
        protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
            HashMap result = ContainerUtilRt.newHashMap();
            for (ProjectDataService service : (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions()) {
                List services = (List)result.get(service.getTargetDataKey());
                if (services == null) {
                    services = ContainerUtilRt.newArrayList();
                    result.put(service.getTargetDataKey(), services);
                }
                services.add(service);
            }
            for (List services : result.values()) {
                ExternalSystemApiUtil.orderAwareSort((List)services);
            }
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager$1", "compute"));
            }
            return hashMap;
        }
    };

    public <T> void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project, boolean synchronous) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        Map grouped = ExternalSystemApiUtil.group(nodes);
        for (Map.Entry entry : grouped.entrySet()) {
            ArrayList dummy = ContainerUtilRt.newArrayList();
            for (DataNode node : (List)entry.getValue()) {
                dummy.add(node);
            }
            this.importData((Key)entry.getKey(), dummy, project, synchronous);
        }
    }

    public <T> void importData(@NotNull Key<T> key, @NotNull Collection<DataNode<T>> nodes, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "importData"));
        }
        this.ensureTheDataIsReadyToUse(nodes);
        List services = (List)((Map)this.myServices.getValue()).get(key);
        if (services == null) {
            LOG.warn(String.format("Can't import data nodes '%s'. Reason: no service is registered for key %s. Available services for %s", nodes, key, ((Map)this.myServices.getValue()).keySet()));
        } else {
            for (ProjectDataService service : services) {
                service.importData(nodes, project, synchronous);
            }
        }
        ArrayList children = ContainerUtilRt.newArrayList();
        for (DataNode<T> node : nodes) {
            children.addAll(node.getChildren());
        }
        this.importData(children, project, synchronous);
    }

    private <T> void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<T>> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "ensureTheDataIsReadyToUse"));
        }
        Map servicesByKey = (Map)this.myServices.getValue();
        Stack toProcess = ContainerUtil.newStack(nodes);
        while (!toProcess.isEmpty()) {
            DataNode node = (DataNode)toProcess.pop();
            List services = (List)servicesByKey.get(node.getKey());
            if (services != null) {
                for (ProjectDataService service : services) {
                    node.prepareData(new ClassLoader[]{service.getClass().getClassLoader()});
                }
            }
            for (DataNode dataNode : node.getChildren()) {
                toProcess.push((Object)dataNode);
            }
        }
    }

    public <T> void removeData(@NotNull Key<?> key, @NotNull Collection<T> toRemove, @NotNull Project project, boolean synchronous) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (toRemove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManager", "removeData"));
        }
        List services = (List)((Map)this.myServices.getValue()).get(key);
        for (ProjectDataService service : services) {
            service.removeData(toRemove, project, synchronous);
        }
    }
}

