/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ProjectStructureHelper;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@Order(value=42)
public class ModuleDataService
implements ProjectDataService<ModuleData, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create((String)"MODULE_DATA_KEY");
    private static final Logger LOG = Logger.getInstance((String)("#" + ModuleDataService.class.getName()));
    private static final int PROJECT_INITIALISATION_DELAY_MS = (int)TimeUnit.SECONDS.toMillis(1L);
    private final Alarm myAlarm;
    @NotNull
    private final ProjectStructureHelper myProjectStructureHelper;

    public ModuleDataService(@NotNull ProjectStructureHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "<init>"));
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD);
        this.myProjectStructureHelper = helper;
    }

    @NotNull
    public com.intellij.openapi.externalSystem.model.Key<ModuleData> getTargetDataKey() {
        com.intellij.openapi.externalSystem.model.Key key = ProjectKeys.MODULE;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(final @NotNull Collection<DataNode<ModuleData>> toImport, final @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        if (!project.isInitialized()) {
            this.myAlarm.addRequest((Runnable)new ImportModulesTask(project, toImport, synchronous), PROJECT_INITIALISATION_DELAY_MS);
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                Collection toCreate = ModuleDataService.this.filterExistingModules(toImport, project);
                if (!toCreate.isEmpty()) {
                    ModuleDataService.this.createModules(toCreate, project);
                }
                for (DataNode node : toImport) {
                    Module module = ModuleDataService.this.myProjectStructureHelper.findIdeModule((ModuleData)node.getData(), project);
                    if (module == null) continue;
                    ModuleDataService.syncPaths(module, (ModuleData)node.getData());
                }
            }
        });
    }

    private void createModules(final @NotNull Collection<DataNode<ModuleData>> toCreate, final @NotNull Project project) {
        if (toCreate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "createModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "createModules"));
        }
        this.removeExistingModulesConfigs(toCreate, project);
        Application application = ApplicationManager.getApplication();
        final HashMap moduleMappings = ContainerUtilRt.newHashMap();
        application.runWriteAction(new Runnable(){

            @Override
            public void run() {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                for (DataNode module : toCreate) {
                    this.importModule(moduleManager, (DataNode<ModuleData>)module);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void importModule(@NotNull ModuleManager moduleManager, @NotNull DataNode<ModuleData> module) {
                if (moduleManager == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService$2", "importModule"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService$2", "importModule"));
                }
                ModuleData data = (ModuleData)module.getData();
                Module created = moduleManager.newModule(data.getModuleFilePath(), data.getModuleTypeId());
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)created);
                final ModifiableRootModel moduleRootModel = moduleRootManager.getModifiableModel();
                moduleRootModel.inheritSdk();
                ModuleDataService.setModuleOptions(created, (DataNode<ModuleData>)module);
                RootPolicy<Object> visitor = new RootPolicy<Object>(){

                    public Object visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, Object value) {
                        moduleRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                        return value;
                    }

                    public Object visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, Object value) {
                        moduleRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                        return value;
                    }
                };
                try {
                    for (OrderEntry orderEntry : moduleRootModel.getOrderEntries()) {
                        orderEntry.accept((RootPolicy)visitor, null);
                    }
                }
                finally {
                    moduleRootModel.commit();
                }
                moduleMappings.put(module, created);
            }
        });
    }

    @NotNull
    private Collection<DataNode<ModuleData>> filterExistingModules(@NotNull Collection<DataNode<ModuleData>> modules, @NotNull Project project) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        ArrayList result = ContainerUtilRt.newArrayList();
        for (DataNode<ModuleData> node : modules) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module = this.myProjectStructureHelper.findIdeModule(moduleData, project);
            if (module == null) {
                result.add(node);
                continue;
            }
            ModuleDataService.setModuleOptions(module, node);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "filterExistingModules"));
        }
        return arrayList;
    }

    private void removeExistingModulesConfigs(final @NotNull Collection<DataNode<ModuleData>> nodes, @NotNull Project project) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeExistingModulesConfigs"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeExistingModulesConfigs"));
        }
        if (nodes.isEmpty()) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                LocalFileSystem fileSystem = LocalFileSystem.getInstance();
                for (DataNode node : nodes) {
                    ModuleData data = (ModuleData)node.getData();
                    VirtualFile file = fileSystem.refreshAndFindFileByPath(data.getModuleFilePath());
                    if (file == null) continue;
                    try {
                        file.delete((Object)this);
                    }
                    catch (IOException e) {
                        LOG.warn("Can't remove existing module config file at '" + data.getModuleFilePath() + "'");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncPaths(@NotNull Module module, @NotNull ModuleData data) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "syncPaths"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "syncPaths"));
        }
        ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        CompilerModuleExtension extension = (CompilerModuleExtension)modifiableModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            modifiableModel.dispose();
            LOG.warn(String.format("Can't sync paths for module '%s'. Reason: no compiler extension is found for it", module.getName()));
            return;
        }
        try {
            String testCompileOutputPath;
            String compileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
            if (compileOutputPath != null) {
                extension.setCompilerOutputPath(VfsUtilCore.pathToUrl((String)compileOutputPath));
            }
            if ((testCompileOutputPath = data.getCompileOutputPath(ExternalSystemSourceType.TEST)) != null) {
                extension.setCompilerOutputPathForTests(VfsUtilCore.pathToUrl((String)testCompileOutputPath));
            }
            extension.inheritCompilerOutputPath(data.isInheritProjectCompileOutputPath());
        }
        finally {
            modifiableModel.commit();
        }
    }

    public void removeData(final @NotNull Collection<? extends Module> modules, @NotNull Project project, boolean synchronous) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "removeData"));
        }
        if (modules.isEmpty()) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                for (Module module : modules) {
                    boolean success;
                    if (module.isDisposed()) continue;
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)module.getProject());
                    String path = module.getModuleFilePath();
                    moduleManager.disposeModule(module);
                    File file = new File(path);
                    if (!file.isFile() || (success = file.delete())) continue;
                    LOG.warn("Can't remove module file at '" + path + "'");
                }
            }
        });
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService", "unlinkModuleFromExternalSystem"));
        }
        module.clearOption("external.system.id");
        module.clearOption("external.linked.project.path");
        module.clearOption("external.root.project.path");
    }

    private static void setModuleOptions(Module module, DataNode<ModuleData> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        module.setOption("external.system.id", moduleData.getOwner().toString());
        module.setOption("external.linked.project.path", moduleData.getLinkedExternalProjectPath());
        ProjectData projectData = (ProjectData)moduleDataNode.getData(ProjectKeys.PROJECT);
        module.setOption("external.root.project.path", projectData != null ? projectData.getLinkedExternalProjectPath() : "");
        if (moduleData.getGroup() != null) {
            module.setOption("external.system.module.group", moduleData.getGroup());
        }
        if (moduleData.getVersion() != null) {
            module.setOption("external.system.module.version", moduleData.getVersion());
        }
        module.clearOption("org.jetbrains.idea.maven.project.MavenProjectsManager.isMavenModule");
    }

    private class ImportModulesTask
    implements Runnable {
        private final Project myProject;
        private final Collection<DataNode<ModuleData>> myModules;
        private final boolean mySynchronous;

        ImportModulesTask(@NotNull Project project, Collection<DataNode<ModuleData>> modules, boolean synchronous) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService$ImportModulesTask", "<init>"));
            }
            if (modules == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService$ImportModulesTask", "<init>"));
            }
            this.myProject = project;
            this.myModules = modules;
            this.mySynchronous = synchronous;
        }

        @Override
        public void run() {
            ModuleDataService.this.myAlarm.cancelAllRequests();
            if (!this.myProject.isInitialized()) {
                ModuleDataService.this.myAlarm.addRequest((Runnable)new ImportModulesTask(this.myProject, this.myModules, this.mySynchronous), PROJECT_INITIALISATION_DELAY_MS);
                return;
            }
            ModuleDataService.this.importData(this.myModules, this.myProject, this.mySynchronous);
        }
    }
}

