/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.service.project.ProjectStructureHelper;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.service.project.manage.LibraryDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ModuleDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryOrderEntryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Order(value=42)
public class LibraryDependencyDataService
extends AbstractDependencyDataService<LibraryDependencyData, LibraryOrderEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + LibraryDependencyDataService.class.getName()));
    @NotNull
    private final PlatformFacade myPlatformFacade;
    @NotNull
    private final ProjectStructureHelper myProjectStructureHelper;
    @NotNull
    private final ModuleDataService myModuleManager;
    @NotNull
    private final LibraryDataService myLibraryManager;

    public LibraryDependencyDataService(@NotNull PlatformFacade platformFacade, @NotNull ProjectStructureHelper helper, @NotNull ModuleDataService moduleManager, @NotNull LibraryDataService libraryManager) {
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "<init>"));
        }
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "<init>"));
        }
        if (moduleManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "<init>"));
        }
        if (libraryManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "<init>"));
        }
        this.myPlatformFacade = platformFacade;
        this.myProjectStructureHelper = helper;
        this.myModuleManager = moduleManager;
        this.myLibraryManager = libraryManager;
    }

    @NotNull
    public Key<LibraryDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY_DEPENDENCY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryDependencyData>> toImport, @NotNull Project project, boolean synchronous) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        Map byModule = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.MODULE);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = this.myProjectStructureHelper.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData(), project);
            if (module == null) {
                this.myModuleManager.importData(Collections.singleton(entry.getKey()), project, true);
                module = this.myProjectStructureHelper.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData(), project);
                if (module == null) {
                    LOG.warn(String.format("Can't import library dependencies %s. Reason: target module (%s) is not found at the ide and can't be imported", entry.getValue(), entry.getKey()));
                    continue;
                }
            }
            this.importData((Collection<DataNode<LibraryDependencyData>>)((Collection)entry.getValue()), module, synchronous);
        }
    }

    public void importData(final @NotNull Collection<DataNode<LibraryDependencyData>> nodesToImport, final @NotNull Module module, final boolean synchronous) {
        if (nodesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importData"));
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)module){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() {
                LibraryDependencyDataService.this.importMissingProjectLibraries(module, nodesToImport, synchronous);
                HashMap moduleLibrariesToImport = ContainerUtilRt.newHashMap();
                HashMap projectLibrariesToImport = ContainerUtilRt.newHashMap();
                LinkedHashSet toImport = ContainerUtilRt.newLinkedHashSet();
                boolean hasUnresolved = false;
                for (DataNode dependencyNode : nodesToImport) {
                    LibraryDependencyData dependencyData = (LibraryDependencyData)dependencyNode.getData();
                    LibraryData libraryData = (LibraryData)dependencyData.getTarget();
                    hasUnresolved |= libraryData.isUnresolved();
                    switch (dependencyData.getLevel()) {
                        case MODULE: {
                            if (libraryData.isUnresolved()) break;
                            HashSet paths = ContainerUtilRt.newHashSet();
                            for (String path : libraryData.getPaths(LibraryPathType.BINARY)) {
                                paths.add(ExternalSystemApiUtil.toCanonicalPath((String)path) + dependencyData.getScope().name());
                            }
                            moduleLibrariesToImport.put(paths, dependencyData);
                            toImport.add(dependencyData);
                            break;
                        }
                        case PROJECT: {
                            projectLibrariesToImport.put(libraryData.getInternalName() + dependencyData.getScope().name(), dependencyData);
                            toImport.add(dependencyData);
                        }
                    }
                }
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                ModifiableRootModel moduleRootModel = moduleRootManager.getModifiableModel();
                LibraryTable moduleLibraryTable = moduleRootModel.getModuleLibraryTable();
                LibraryTable libraryTable = LibraryDependencyDataService.this.myPlatformFacade.getProjectLibraryTable(module.getProject());
                try {
                    LibraryDependencyDataService.filterUpToDateAndRemoveObsolete(moduleLibrariesToImport, projectLibrariesToImport, toImport, moduleRootModel, hasUnresolved);
                    if (!toImport.isEmpty()) {
                        LibraryDependencyDataService.this.importMissing(toImport, moduleRootModel, moduleLibraryTable, libraryTable, module);
                    }
                }
                finally {
                    moduleRootModel.commit();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importMissing(@NotNull Set<LibraryDependencyData> toImport, @NotNull ModifiableRootModel moduleRootModel, @NotNull LibraryTable moduleLibraryTable, @NotNull LibraryTable libraryTable, @NotNull Module module) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        if (moduleRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        if (moduleLibraryTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        if (libraryTable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissing"));
        }
        for (LibraryDependencyData dependencyData : toImport) {
            LibraryData libraryData = (LibraryData)dependencyData.getTarget();
            String libraryName = libraryData.getInternalName();
            switch (dependencyData.getLevel()) {
                case MODULE: {
                    LibraryOrderEntry orderEntry;
                    Library moduleLib = moduleLibraryTable.createLibrary(libraryName);
                    Library.ModifiableModel libModel = moduleLib.getModifiableModel();
                    try {
                        Map<OrderRootType, Collection<File>> files = this.myLibraryManager.prepareLibraryFiles(libraryData);
                        this.myLibraryManager.registerPaths(files, libModel, libraryName);
                        orderEntry = moduleRootModel.findLibraryOrderEntry(moduleLib);
                        assert (orderEntry != null);
                        LibraryDependencyDataService.setLibraryScope(orderEntry, moduleLib, module, dependencyData);
                        break;
                    }
                    finally {
                        libModel.commit();
                    }
                }
                case PROJECT: {
                    Library projectLib = libraryTable.getLibraryByName(libraryName);
                    if (projectLib == null) {
                        assert (false);
                        break;
                    }
                    LibraryOrderEntry orderEntry = moduleRootModel.addLibraryEntry(projectLib);
                    LibraryDependencyDataService.setLibraryScope(orderEntry, projectLib, module, dependencyData);
                }
            }
        }
    }

    private static void setLibraryScope(@NotNull LibraryOrderEntry orderEntry, @NotNull Library lib, @NotNull Module module, @NotNull LibraryDependencyData dependencyData) {
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "setLibraryScope"));
        }
        if (lib == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "setLibraryScope"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "setLibraryScope"));
        }
        if (dependencyData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "setLibraryScope"));
        }
        LOG.info(String.format("Adding library dependency '%s' to module '%s'", lib.getName(), module.getName()));
        orderEntry.setExported(dependencyData.isExported());
        orderEntry.setScope(dependencyData.getScope());
        LOG.info(String.format("Configuring library dependency '%s' of module '%s' to be%s exported and have scope %s", lib.getName(), module.getName(), dependencyData.isExported() ? " not" : "", dependencyData.getScope()));
    }

    private static void filterUpToDateAndRemoveObsolete(@NotNull Map<Set<String>, LibraryDependencyData> moduleLibrariesToImport, @NotNull Map<String, LibraryDependencyData> projectLibrariesToImport, @NotNull Set<LibraryDependencyData> toImport, @NotNull ModifiableRootModel moduleRootModel, boolean hasUnresolvedLibraries) {
        if (moduleLibrariesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "filterUpToDateAndRemoveObsolete"));
        }
        if (projectLibrariesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "filterUpToDateAndRemoveObsolete"));
        }
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "filterUpToDateAndRemoveObsolete"));
        }
        if (moduleRootModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "filterUpToDateAndRemoveObsolete"));
        }
        HashSet moduleLibraryKey = ContainerUtilRt.newHashSet();
        for (OrderEntry entry : moduleRootModel.getOrderEntries()) {
            LibraryDependencyData existing;
            if (entry instanceof ModuleLibraryOrderEntryImpl) {
                ModuleLibraryOrderEntryImpl moduleLibraryOrderEntry = (ModuleLibraryOrderEntryImpl)entry;
                Library library = moduleLibraryOrderEntry.getLibrary();
                if (library == null) {
                    LOG.warn("Skipping module-level library entry because it doesn't have backing Library object. Entry: " + entry);
                    continue;
                }
                moduleLibraryKey.clear();
                for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                    moduleLibraryKey.add(ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file) + moduleLibraryOrderEntry.getScope().name());
                }
                existing = moduleLibrariesToImport.remove(moduleLibraryKey);
                if (existing == null) {
                    moduleRootModel.removeOrderEntry(entry);
                    continue;
                }
                toImport.remove(existing);
                continue;
            }
            if (!(entry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            String libraryName = libraryOrderEntry.getLibraryName();
            existing = projectLibrariesToImport.remove(libraryName + libraryOrderEntry.getScope().name());
            if (existing != null) {
                toImport.remove(existing);
                continue;
            }
            if (hasUnresolvedLibraries) continue;
            moduleRootModel.removeOrderEntry(entry);
        }
    }

    private void importMissingProjectLibraries(@NotNull Module module, @NotNull Collection<DataNode<LibraryDependencyData>> nodesToImport, boolean synchronous) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissingProjectLibraries"));
        }
        if (nodesToImport == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDependencyDataService", "importMissingProjectLibraries"));
        }
        LibraryTable libraryTable = this.myPlatformFacade.getProjectLibraryTable(module.getProject());
        ArrayList librariesToImport = ContainerUtilRt.newArrayList();
        for (DataNode<LibraryDependencyData> dataNode : nodesToImport) {
            DataNode libraryNode;
            DataNode projectNode;
            Library library;
            final LibraryDependencyData dependencyData = (LibraryDependencyData)dataNode.getData();
            if (dependencyData.getLevel() != LibraryLevel.PROJECT || (library = libraryTable.getLibraryByName(dependencyData.getInternalName())) != null || (projectNode = dataNode.getDataNode(ProjectKeys.PROJECT)) == null || (libraryNode = ExternalSystemApiUtil.find((DataNode)projectNode, (Key)ProjectKeys.LIBRARY, (BooleanFunction)new BooleanFunction<DataNode<LibraryData>>(){

                public boolean fun(DataNode<LibraryData> node) {
                    return ((LibraryData)node.getData()).equals((Object)dependencyData.getTarget());
                }
            })) == null) continue;
            librariesToImport.add(libraryNode);
        }
        if (!librariesToImport.isEmpty()) {
            this.myLibraryManager.importData(librariesToImport, module.getProject(), synchronous);
        }
    }
}

