/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.service.project.PlatformFacade;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlatformFacadeImpl
implements PlatformFacade {
    @NotNull
    public LibraryTable getProjectLibraryTable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getProjectLibraryTable"));
        }
        LibraryTable libraryTable = ProjectLibraryTable.getInstance(project);
        if (libraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getProjectLibraryTable"));
        }
        return libraryTable;
    }

    @NotNull
    public Collection<Module> getModules(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getModules"));
        }
        List<Module> list = Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getModules"));
        }
        return list;
    }

    @NotNull
    public Collection<OrderEntry> getOrderEntries(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getOrderEntries"));
        }
        List<OrderEntry> list = Arrays.asList(ModuleRootManager.getInstance((Module)module).getOrderEntries());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getOrderEntries"));
        }
        return list;
    }

    @NotNull
    public String getLocalFileSystemPath(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getLocalFileSystemPath"));
        }
        String string = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/PlatformFacadeImpl", "getLocalFileSystemPath"));
        }
        return string;
    }
}

