/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.debugger.impl.GenericDebuggerRunner;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemTaskDebugRunner
extends GenericDebuggerRunner {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExternalSystemTaskDebugRunner.class.getName()));

    @Override
    @NotNull
    public String getRunnerId() {
        if ("ExternalSystemTaskDebugRunner" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskDebugRunner", "getRunnerId"));
        }
        return "ExternalSystemTaskDebugRunner";
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskDebugRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemTaskDebugRunner", "canRun"));
        }
        return profile instanceof ExternalSystemRunConfiguration && DefaultDebugExecutor.EXECUTOR_ID.equals(executorId);
    }

    @Override
    @Nullable
    protected RunContentDescriptor createContentDescriptor(Project project, RunProfileState state, RunContentDescriptor contentToReuse, ExecutionEnvironment env) throws ExecutionException {
        if (state instanceof ExternalSystemRunConfiguration.MyRunnableState) {
            int port = ((ExternalSystemRunConfiguration.MyRunnableState)state).getDebugPort();
            if (port > 0) {
                RemoteConnection connection = new RemoteConnection(true, "127.0.0.1", String.valueOf(port), true);
                return this.attachVirtualMachine(project, state, contentToReuse, env, connection, true);
            }
            LOG.warn("Can't attach debugger to external system task execution. Reason: target debug port is unknown");
        } else {
            LOG.warn(String.format("Can't attach debugger to external system task execution. Reason: invalid run profile state is provided- expected '%s' but got '%s'", ExternalSystemRunConfiguration.MyRunnableState.class.getName(), state.getClass().getName()));
        }
        return null;
    }
}

