/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.action.ExternalActionUtil;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefreshExternalProjectAction
extends AnAction
implements DumbAware,
AnAction.TransparentUpdate {
    public RefreshExternalProjectAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.description", (Object[])new Object[]{"external"}));
    }

    public void update(AnActionEvent e) {
        ExternalActionUtil.MyInfo info = ExternalActionUtil.getProcessingInfo(e.getDataContext());
        e.getPresentation().setEnabled(info.externalProject != null);
    }

    public void actionPerformed(AnActionEvent e) {
        ExternalActionUtil.MyInfo info = ExternalActionUtil.getProcessingInfo(e.getDataContext());
        if (info.settings == null || info.localSettings == null || info.externalProject == null || info.ideProject == null || info.externalSystemId == null) {
            return;
        }
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        if (externalSystemId == null) {
            return;
        }
        final Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final ProjectDataManager projectDataManager = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        ExternalSystemUtil.refreshProject(project, externalSystemId, info.externalProject.getPath(), new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(final @Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

                    public void execute() {
                        ProjectRootManagerEx.getInstanceEx(project).mergeRootsChangesDuring(new Runnable(){

                            @Override
                            public void run() {
                                projectDataManager.importData(externalProject.getKey(), Collections.singleton(externalProject), project, true);
                            }
                        });
                    }
                });
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/action/RefreshExternalProjectAction$1", "onFailure"));
                }
            }
        }, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }
}

