/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;

public class RefreshAllExternalProjectsAction
extends AnAction
implements DumbAware,
AnAction.TransparentUpdate {
    public RefreshAllExternalProjectsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.all.projects.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.all.projects.description", (Object[])new Object[]{"external"}));
    }

    public void update(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String name = StringUtil.join(systemIds, (Function)new Function<ProjectSystemId, String>(){

            public String fun(ProjectSystemId projectSystemId) {
                return projectSystemId.getReadableName();
            }
        }, (String)",");
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.refresh.all.projects.text", (Object[])new Object[]{name}));
        e.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.all.projects.description", (Object[])new Object[]{name}));
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        e.getPresentation().setEnabled(!processingManager.hasTaskOfTypeInProgress(ExternalSystemTaskType.RESOLVE_PROJECT, project));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (ProjectSystemId externalSystemId : systemIds) {
            ExternalSystemUtil.refreshProjects(project, externalSystemId, true);
        }
    }

    private static List<ProjectSystemId> getSystemIds(AnActionEvent e) {
        ArrayList systemIds = ContainerUtil.newArrayList();
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        if (externalSystemId != null) {
            systemIds.add(externalSystemId);
        } else {
            for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                systemIds.add(manager.getSystemId());
            }
        }
        return systemIds;
    }
}

