/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemConfigLocator;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenExternalConfigAction
extends AnAction
implements DumbAware {
    public OpenExternalConfigAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.open.config.text", (Object[])new Object[]{"external"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.open.config.description", (Object[])new Object[]{"external"}));
    }

    public void update(AnActionEvent e) {
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(e.getDataContext());
        if (externalSystemId == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setText(ExternalSystemBundle.message((String)"action.open.config.text", (Object[])new Object[]{externalSystemId.getReadableName()}));
        e.getPresentation().setDescription(ExternalSystemBundle.message((String)"action.open.config.description", (Object[])new Object[]{externalSystemId.getReadableName()}));
        e.getPresentation().setIcon(ExternalSystemUiUtil.getUiAware(externalSystemId).getProjectIcon());
        VirtualFile config = OpenExternalConfigAction.getExternalConfig(e.getDataContext());
        e.getPresentation().setEnabled(config != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return;
        }
        VirtualFile configFile = OpenExternalConfigAction.getExternalConfig(e.getDataContext());
        if (configFile == null) {
            return;
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, configFile);
        FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
    }

    @Nullable
    private static VirtualFile getExternalConfig(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/externalSystem/action/OpenExternalConfigAction", "getExternalConfig"));
        }
        ProjectSystemId externalSystemId = (ProjectSystemId)ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID.getData(context);
        if (externalSystemId == null) {
            return null;
        }
        ExternalProjectPojo projectPojo = (ExternalProjectPojo)ExternalSystemDataKeys.SELECTED_PROJECT.getData(context);
        if (projectPojo == null) {
            return null;
        }
        String path = projectPojo.getPath();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        VirtualFile externalSystemConfigPath = fileSystem.refreshAndFindFileByPath(path);
        if (externalSystemConfigPath == null) {
            return null;
        }
        VirtualFile toOpen = externalSystemConfigPath;
        for (ExternalSystemConfigLocator locator : (ExternalSystemConfigLocator[])ExternalSystemConfigLocator.EP_NAME.getExtensions()) {
            if (!externalSystemId.equals((Object)locator.getTargetExternalSystemId()) || (toOpen = locator.adjust(toOpen)) != null) continue;
            return null;
        }
        return toOpen.isDirectory() ? null : toOpen;
    }
}

