/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import java.awt.Rectangle;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class TextComponentScrollingModel
implements ScrollingModel {
    private final JTextComponent myTextComponent;

    public TextComponentScrollingModel(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/textarea/TextComponentScrollingModel", "<init>"));
        }
        this.myTextComponent = textComponent;
    }

    @NotNull
    public Rectangle getVisibleArea() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public Rectangle getVisibleAreaOnScrollingFinished() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void scrollToCaret(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/textarea/TextComponentScrollingModel", "scrollToCaret"));
        }
        int position = this.myTextComponent.getCaretPosition();
        try {
            Rectangle rectangle = this.myTextComponent.modelToView(position);
            this.myTextComponent.scrollRectToVisible(rectangle);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public void scrollTo(@NotNull LogicalPosition pos, @NotNull ScrollType scrollType) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/textarea/TextComponentScrollingModel", "scrollTo"));
        }
        if (scrollType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/textarea/TextComponentScrollingModel", "scrollTo"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void runActionOnScrollingFinished(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/textarea/TextComponentScrollingModel", "runActionOnScrollingFinished"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void disableAnimation() {
    }

    public void enableAnimation() {
    }

    public int getVerticalScrollOffset() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getHorizontalScrollOffset() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void scrollVertically(int scrollOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void scrollHorizontally(int scrollOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/textarea/TextComponentScrollingModel", "addVisibleAreaListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/textarea/TextComponentScrollingModel", "removeVisibleAreaListener"));
        }
        throw new UnsupportedOperationException("Not implemented");
    }
}

