/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.AbstractMappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingData;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingUtil;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OffsetToLogicalCalculationStrategy
extends AbstractMappingStrategy<LogicalPosition> {
    private int myTargetOffset;

    OffsetToLogicalCalculationStrategy(@NotNull Editor editor, @NotNull SoftWrapsStorage storage, @NotNull List<CacheEntry> cache, @NotNull EditorTextRepresentationHelper representationHelper) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "<init>"));
        }
        if (representationHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "<init>"));
        }
        super(editor, storage, cache, representationHelper);
    }

    public void init(int targetOffset, List<CacheEntry> cache) {
        this.reset();
        this.myTargetOffset = targetOffset;
        Document document = this.myEditor.getDocument();
        if (targetOffset == 0) {
            LogicalPosition eager = new LogicalPosition(0, 0, 0, 0, 0, 0, 0);
            this.setEagerMatch(eager);
            return;
        }
        if (targetOffset >= document.getTextLength()) {
            if (cache.isEmpty()) {
                this.setFirstInitialPosition();
                return;
            }
            CacheEntry lastEntry = cache.get(cache.size() - 1);
            if (lastEntry.endOffset >= targetOffset - 1) {
                EditorPosition position = lastEntry.buildEndLinePosition();
                if (document.getCharsSequence().charAt(document.getTextLength() - 1) == '\n') {
                    position.onNewLine(true);
                }
                this.setEagerMatch(position.buildLogicalPosition());
                return;
            }
        } else if (cache.size() > 0 && cache.get((int)(cache.size() - 1)).endOffset < targetOffset) {
            EditorPosition position = cache.get(cache.size() - 1).buildEndLinePosition();
            position.onNewLine(true);
            this.setInitialPosition(position);
            return;
        }
        int i = MappingUtil.getCacheEntryIndexForOffset(targetOffset, this.myEditor.getDocument(), cache);
        CacheEntry cacheEntry = null;
        if (i >= 0) {
            CacheEntry candidate = cache.get(i);
            if (candidate.endOffset == targetOffset && i < cache.size() - 1 && cache.get((int)(i + 1)).startOffset == targetOffset) {
                EditorPosition position = cache.get(i + 1).buildStartLinePosition();
                SoftWrap softWrap = this.myStorage.getSoftWrap(targetOffset);
                if (softWrap != null) {
                    position.visualColumn = softWrap.getIndentInColumns();
                    position.softWrapColumnDiff += softWrap.getIndentInColumns();
                    this.setEagerMatch(position.buildLogicalPosition());
                }
            } else if (candidate.startOffset <= targetOffset) {
                cacheEntry = candidate;
            }
        } else if (i < -1 && (i = -i - 2) < this.myCache.size()) {
            cacheEntry = (CacheEntry)this.myCache.get(i);
        }
        if (cacheEntry == null) {
            this.setFirstInitialPosition();
        } else if (cacheEntry.startOffset <= targetOffset && cacheEntry.endOffset >= targetOffset) {
            this.setTargetEntry(cacheEntry, true);
        } else {
            this.setInitialPosition(cacheEntry.buildStartLinePosition());
        }
    }

    @Override
    protected LogicalPosition buildIfExceeds(EditorPosition position, int offset) {
        if (this.myTargetOffset >= offset) {
            return null;
        }
        Document document = this.myEditor.getDocument();
        int logicalLine = document.getLineNumber(this.myTargetOffset);
        int linesDiff = logicalLine - position.logicalLine;
        if (linesDiff > 0) {
            int column;
            position.onNewLine();
            position.visualColumn = column = this.myTargetOffset - document.getLineStartOffset(logicalLine);
            position.logicalColumn = column;
        } else {
            int columnsDiff = this.myTargetOffset - position.offset;
            position.logicalColumn += columnsDiff;
            position.visualColumn += columnsDiff;
        }
        position.logicalLine = logicalLine;
        position.offset = this.myTargetOffset;
        return position.buildLogicalPosition();
    }

    @Override
    protected LogicalPosition buildIfExceeds(@NotNull EditorPosition position, @NotNull FoldRegion foldRegion) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "buildIfExceeds"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "buildIfExceeds"));
        }
        if (this.myTargetOffset >= foldRegion.getEndOffset()) {
            return null;
        }
        Document document = this.myEditor.getDocument();
        int targetLogicalLine = document.getLineNumber(this.myTargetOffset);
        if (targetLogicalLine == position.logicalLine) {
            FoldingData cachedData = this.getFoldRegionData(foldRegion);
            int x = 0;
            if (cachedData != null) {
                x = cachedData.startX;
            }
            position.logicalColumn += this.myRepresentationHelper.toVisualColumnSymbolsNumber(document.getCharsSequence(), foldRegion.getStartOffset(), this.myTargetOffset, x);
        } else {
            position.logicalColumn = this.myRepresentationHelper.toVisualColumnSymbolsNumber(document.getCharsSequence(), foldRegion.getStartOffset(), this.myTargetOffset, 0);
            position.softWrapColumnDiff = 0;
            int linesDiff = document.getLineNumber(this.myTargetOffset) - document.getLineNumber(foldRegion.getStartOffset());
            position.logicalLine += linesDiff;
            position.foldedLines += linesDiff;
            position.softWrapLinesBefore += position.softWrapLinesCurrent;
            position.softWrapLinesCurrent = 0;
        }
        position.foldingColumnDiff = position.visualColumn - position.softWrapColumnDiff - position.logicalColumn;
        position.offset = this.myTargetOffset;
        return position.buildLogicalPosition();
    }

    @Override
    @Nullable
    protected LogicalPosition buildIfExceeds(EditorPosition context, TabData tabData) {
        if (tabData.offset == this.myTargetOffset) {
            return context.buildLogicalPosition();
        }
        return null;
    }

    @Override
    @Nullable
    public LogicalPosition processSoftWrap(@NotNull EditorPosition position, SoftWrap softWrap) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "processSoftWrap"));
        }
        position.visualColumn = softWrap.getIndentInColumns();
        position.softWrapColumnDiff += softWrap.getIndentInColumns();
        if (softWrap.getStart() == this.myTargetOffset) {
            return position.buildLogicalPosition();
        }
        return null;
    }

    @Override
    @NotNull
    public LogicalPosition build(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "build"));
        }
        Document document = this.myEditor.getDocument();
        int logicalLine = document.getLineNumber(this.myTargetOffset);
        int linesDiff = logicalLine - position.logicalLine;
        if (linesDiff > 0) {
            int column;
            position.onNewLine();
            position.logicalLine = logicalLine;
            position.logicalColumn = column = this.myTargetOffset - document.getLineStartOffset(logicalLine);
            position.visualColumn = column;
        } else {
            int columnsDiff = this.myTargetOffset - position.offset;
            position.logicalColumn += columnsDiff;
            position.visualColumn += columnsDiff;
        }
        position.offset = this.myTargetOffset;
        LogicalPosition logicalPosition = position.buildLogicalPosition();
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/OffsetToLogicalCalculationStrategy", "build"));
        }
        return logicalPosition;
    }
}

