/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

public class IncrementalCacheUpdateEvent {
    private final int myStartLogicalLine;
    private final int myOldExactStartOffset;
    private final int myOldExactEndOffset;
    private final int myOldStartOffset;
    private final int myOldEndOffset;
    private final int myOldLogicalLinesDiff;
    private final int myNewExactStartOffset;
    private final int myNewExactEndOffset;
    private int myNewStartOffset;
    private int myNewEndOffset;
    private int myNewLogicalLinesDiff;

    public IncrementalCacheUpdateEvent(@NotNull DocumentEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this.myStartLogicalLine = IncrementalCacheUpdateEvent.getLine(event.getOffset(), event.getDocument());
        this.myOldExactStartOffset = this.myNewExactStartOffset = event.getOffset();
        this.myOldExactEndOffset = this.myOldExactStartOffset + event.getOldLength();
        this.myNewExactEndOffset = this.myNewExactStartOffset + event.getNewLength();
        Document document = event.getDocument();
        this.myOldStartOffset = IncrementalCacheUpdateEvent.getLineStartOffset(this.myOldExactStartOffset, document);
        this.myOldEndOffset = IncrementalCacheUpdateEvent.getLineEndOffset(this.myOldExactEndOffset, document);
        this.myOldLogicalLinesDiff = document.getLineNumber(this.myOldExactEndOffset) - document.getLineNumber(this.myOldExactStartOffset);
    }

    public IncrementalCacheUpdateEvent(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this(document, 0, Math.max(0, document.getTextLength() - 1));
    }

    public IncrementalCacheUpdateEvent(@NotNull Document document, int exactStartOffset, int exactEndOffset) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "<init>"));
        }
        this.myStartLogicalLine = IncrementalCacheUpdateEvent.getLine(exactStartOffset, document);
        this.myOldStartOffset = this.myNewStartOffset = exactStartOffset;
        this.myNewExactStartOffset = this.myNewStartOffset;
        this.myOldExactStartOffset = this.myNewStartOffset;
        this.myOldEndOffset = this.myNewEndOffset = exactEndOffset;
        this.myNewExactEndOffset = this.myNewEndOffset;
        this.myOldExactEndOffset = this.myNewEndOffset;
        this.myOldLogicalLinesDiff = document.getLineNumber(this.myOldExactEndOffset) - document.getLineNumber(this.myOldExactStartOffset);
    }

    public void updateNewOffsetsIfNecessary(@NotNull Document document, @NotNull FoldingModel foldingModel) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "updateNewOffsetsIfNecessary"));
        }
        if (foldingModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/IncrementalCacheUpdateEvent", "updateNewOffsetsIfNecessary"));
        }
        this.myNewStartOffset = IncrementalCacheUpdateEvent.getLineStartOffset(this.myNewExactStartOffset, document);
        this.myNewEndOffset = IncrementalCacheUpdateEvent.getLineEndOffset(this.myNewExactEndOffset, document);
        FoldRegion region = foldingModel.getCollapsedRegionAtOffset(this.myNewEndOffset);
        while (region != null) {
            this.myNewEndOffset = IncrementalCacheUpdateEvent.getLineEndOffset(region.getEndOffset(), document);
            region = foldingModel.getCollapsedRegionAtOffset(this.myNewEndOffset);
        }
        this.myNewLogicalLinesDiff = document.getLineNumber(this.myNewExactEndOffset) - document.getLineNumber(this.myNewExactStartOffset);
    }

    public int getExactOffsetsDiff() {
        return this.myNewExactEndOffset - this.myOldExactEndOffset;
    }

    public int getStartLogicalLine() {
        return this.myStartLogicalLine;
    }

    public int getOldExactStartOffset() {
        return this.myOldExactStartOffset;
    }

    public int getOldExactEndOffset() {
        return this.myOldExactEndOffset;
    }

    public int getOldStartOffset() {
        return this.myOldStartOffset;
    }

    public int getOldEndOffset() {
        return this.myOldEndOffset;
    }

    public int getOldLogicalLinesDiff() {
        return this.myOldLogicalLinesDiff;
    }

    public int getOldEndLogicalLine() {
        return this.myStartLogicalLine + this.myOldLogicalLinesDiff;
    }

    public int getNewStartOffset() {
        return this.myNewStartOffset;
    }

    public int getNewEndOffset() {
        return this.myNewEndOffset;
    }

    public int getNewLogicalLinesDiff() {
        return this.myNewLogicalLinesDiff;
    }

    private static int getLine(int offset, Document document) {
        if (offset >= document.getTextLength()) {
            int result = document.getLineCount();
            return result > 0 ? result - 1 : 0;
        }
        return document.getLineNumber(offset);
    }

    private static int getLineStartOffset(int offset, Document document) {
        if (offset > document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineStartOffset(lineNumber);
    }

    private static int getLineEndOffset(int offset, Document document) {
        if (offset >= document.getTextLength()) {
            return offset;
        }
        int lineNumber = document.getLineNumber(offset);
        return document.getLineEndOffset(lineNumber);
    }

    public String toString() {
        return String.format("exact old offsets: %d-%d; recalculation old offsets: %d-%d; exact new offsets: %d-%d; recalculation new offsets: %d-%d; old logical lines diff: %d; new logical lines diff: %d; offset diff: %d", this.myOldExactStartOffset, this.myOldExactEndOffset, this.myOldStartOffset, this.myOldEndOffset, this.myNewExactStartOffset, this.myNewExactEndOffset, this.myNewStartOffset, this.myNewEndOffset, this.getOldLogicalLinesDiff(), this.getNewLogicalLinesDiff(), this.getExactOffsetsDiff());
    }
}

