/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.CompositeDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingData;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingUtil;
import com.intellij.openapi.editor.impl.softwrap.mapping.OffsetToLogicalCalculationStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListener;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapDataProviderKeys;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapsDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabulationDataProvider;
import com.intellij.openapi.editor.impl.softwrap.mapping.VisualToLogicalCalculationStrategy;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingSoftWrapDataMapper
implements SoftWrapDataMapper,
SoftWrapAwareDocumentParsingListener,
Dumpable {
    private static final Logger LOG = Logger.getInstance((String)("#" + CachingSoftWrapDataMapper.class.getName()));
    private static final boolean DEBUG_SOFT_WRAP_PROCESSING = false;
    private final List<CacheEntry> myCache;
    private final List<CacheEntry> myAffectedByUpdateCacheEntries;
    private final List<CacheEntry> myNotAffectedByUpdateTailCacheEntries;
    private final CacheState myBeforeChangeState;
    private final CacheState myAfterChangeState;
    private final OffsetToLogicalCalculationStrategy myOffsetToLogicalStrategy;
    private final VisualToLogicalCalculationStrategy myVisualToLogicalStrategy;
    private final EditorEx myEditor;
    private final SoftWrapsStorage myStorage;
    private final EditorTextRepresentationHelper myRepresentationHelper;
    private final CacheEntry mySearchKey;

    public CachingSoftWrapDataMapper(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage, @NotNull EditorTextRepresentationHelper representationHelper) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "<init>"));
        }
        if (representationHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "<init>"));
        }
        this.myCache = new ArrayList<CacheEntry>();
        this.myAffectedByUpdateCacheEntries = new ArrayList<CacheEntry>();
        this.myNotAffectedByUpdateTailCacheEntries = new ArrayList<CacheEntry>();
        this.myBeforeChangeState = new CacheState();
        this.myAfterChangeState = new CacheState();
        this.myEditor = editor;
        this.myStorage = storage;
        this.myRepresentationHelper = representationHelper;
        this.mySearchKey = new CacheEntry(0, editor, representationHelper);
        this.myOffsetToLogicalStrategy = new OffsetToLogicalCalculationStrategy(editor, storage, this.myCache, representationHelper);
        this.myVisualToLogicalStrategy = new VisualToLogicalCalculationStrategy(editor, storage, this.myCache, representationHelper);
    }

    @Override
    @NotNull
    public LogicalPosition visualToLogical(@NotNull VisualPosition visual) throws IllegalStateException {
        if (visual == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "visualToLogical"));
        }
        if (this.myCache.isEmpty()) {
            LogicalPosition logicalPosition = new LogicalPosition(visual.line, visual.column, 0, 0, 0, 0, 0);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "visualToLogical"));
            }
            return logicalPosition;
        }
        this.myVisualToLogicalStrategy.init(visual, this.myCache);
        LogicalPosition logicalPosition = this.calculate(this.myVisualToLogicalStrategy);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "visualToLogical"));
        }
        return logicalPosition;
    }

    @Override
    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        this.myOffsetToLogicalStrategy.init(offset, this.myCache);
        LogicalPosition logicalPosition = this.calculate(this.myOffsetToLogicalStrategy);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "offsetToLogicalPosition"));
        }
        return logicalPosition;
    }

    @Override
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logical, @NotNull VisualPosition softWrapUnawareVisual) throws IllegalStateException {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "logicalToVisualPosition"));
        }
        if (softWrapUnawareVisual == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "logicalToVisualPosition"));
        }
        if (logical.visualPositionAware) {
            return logical.toVisualPosition();
        }
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        int maxOffset = this.myEditor.logicalPositionToOffset(logical);
        int endIndex = this.myStorage.getSoftWrapIndex(maxOffset);
        if (endIndex < 0) {
            endIndex = -endIndex - 2;
        }
        if (endIndex < 0 || endIndex >= softWraps.size()) {
            return softWrapUnawareVisual;
        }
        int lineDiff = 0;
        int column = -1;
        int targetLogicalLineStartOffset = this.myEditor.logicalPositionToOffset(new LogicalPosition(logical.line, 0));
        for (int i = endIndex; i >= 0; --i) {
            SoftWrap softWrap = softWraps.get(i);
            if (softWrap == null) {
                assert (false);
                continue;
            }
            if (column < 0 && softWrap.getStart() >= targetLogicalLineStartOffset) {
                column = softWrap.getIndentInColumns() + this.myRepresentationHelper.toVisualColumnSymbolsNumber(this.myEditor.getDocument().getCharsSequence(), softWrap.getStart(), maxOffset, softWrap.getIndentInPixels());
                ++lineDiff;
                continue;
            }
            lineDiff += i + 1;
            break;
        }
        int columnToUse = column >= 0 ? column : softWrapUnawareVisual.column;
        return new VisualPosition(softWrapUnawareVisual.line + lineDiff, columnToUse);
    }

    public void release() {
        this.myCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T calculate(@NotNull MappingStrategy<T> strategy) throws IllegalStateException {
        CompositeDataProvider provider;
        if (strategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "calculate"));
        }
        T eagerMatch = strategy.eagerMatch();
        if (eagerMatch != null) {
            return eagerMatch;
        }
        EditorPosition position = strategy.buildInitialPosition();
        FoldingModelEx foldingModel = this.myEditor.getFoldingModel();
        boolean foldingState = foldingModel.isFoldingEnabled();
        foldingModel.setFoldingEnabled(true);
        try {
            provider = new CompositeDataProvider(new SoftWrapsDataProvider(this.myStorage), new FoldingDataProvider(this.myEditor.getFoldingModel().fetchTopLevel()), this.getTabulationDataProvider(position.visualLine));
        }
        finally {
            foldingModel.setFoldingEnabled(foldingState);
        }
        provider.advance(position.offset);
        while (provider.hasData()) {
            Pair data = provider.getData();
            T result = null;
            int sortingKey = provider.getSortingKey();
            if (position.offset <= sortingKey && (result = (T)strategy.advance(position, sortingKey)) != null) {
                return result;
            }
            switch ((SoftWrapDataProviderKeys)((Object)data.first)) {
                case SOFT_WRAP: {
                    result = strategy.processSoftWrap(position, (SoftWrap)data.second);
                    break;
                }
                case COLLAPSED_FOLDING: {
                    result = strategy.processFoldRegion(position, (FoldRegion)data.second);
                    break;
                }
                case TABULATION: {
                    result = strategy.processTabulation(position, (TabData)data.second);
                }
            }
            if (result != null) {
                return result;
            }
            provider.next();
        }
        return strategy.build(position);
    }

    private TabulationDataProvider getTabulationDataProvider(int visualLine) throws IllegalStateException {
        this.mySearchKey.visualLine = visualLine;
        int i = Collections.binarySearch(this.myCache, this.mySearchKey);
        List<TabData> tabs = i >= 0 ? this.myCache.get(i).getTabData() : Collections.emptyList();
        return new TabulationDataProvider(tabs);
    }

    @Override
    public void onVisualLineStart(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onVisualLineStart"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, true);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setLineStartPosition(position);
    }

    @Override
    public void onVisualLineEnd(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onVisualLineEnd"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, false);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setLineEndPosition(position);
    }

    @Override
    public void onCollapsedFoldRegion(@NotNull FoldRegion foldRegion, int x, int visualLine) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onCollapsedFoldRegion"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(visualLine, false);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.store(new FoldingData(foldRegion, x, this.myRepresentationHelper, this.myEditor), foldRegion.getStartOffset());
    }

    @Override
    public void beforeSoftWrapLineFeed(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "beforeSoftWrapLineFeed"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, false);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setLineEndPosition(position);
    }

    @Override
    public void afterSoftWrapLineFeed(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "afterSoftWrapLineFeed"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, true);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.setLineStartPosition(position);
    }

    @Override
    public void revertToOffset(int offset, int visualLine) {
        CacheEntry entry = this.getCacheEntryForVisualLine(visualLine, false);
        if (entry != null) {
            entry.removeAllFoldDataAtOrAfter(offset);
        }
    }

    @Override
    public void onTabulation(@NotNull EditorPosition position, int widthInColumns) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onTabulation"));
        }
        CacheEntry cacheEntry = this.getCacheEntryForVisualLine(position.visualLine, false);
        if (cacheEntry == null) {
            return;
        }
        cacheEntry.storeTabData(new TabData(widthInColumns, position.offset));
    }

    @Override
    public void recalculationEnds() {
    }

    @Nullable
    private CacheEntry getCacheEntryForVisualLine(int visualLine, boolean createIfNecessary) {
        if (!this.myCache.isEmpty()) {
            CacheEntry lastEntry = this.myCache.get(this.myCache.size() - 1);
            if (lastEntry.visualLine == visualLine) {
                return lastEntry;
            }
            if (lastEntry.visualLine < visualLine && createIfNecessary) {
                CacheEntry result = new CacheEntry(visualLine, this.myEditor, this.myRepresentationHelper);
                this.myCache.add(result);
                return result;
            }
        }
        int start = 0;
        int end = this.myCache.size() - 1;
        int cacheEntryIndex = -1;
        while (start <= end) {
            int i = end + start >>> 1;
            CacheEntry cacheEntry = this.myCache.get(i);
            if (cacheEntry.visualLine < visualLine) {
                start = i + 1;
                continue;
            }
            if (cacheEntry.visualLine > visualLine) {
                end = i - 1;
                continue;
            }
            cacheEntryIndex = i;
            break;
        }
        CacheEntry result = null;
        if (cacheEntryIndex < 0) {
            cacheEntryIndex = start;
            if (createIfNecessary) {
                result = new CacheEntry(visualLine, this.myEditor, this.myRepresentationHelper);
                this.myCache.add(cacheEntryIndex, result);
            }
        } else {
            result = this.myCache.get(cacheEntryIndex);
        }
        return result;
    }

    @Override
    public void onCacheUpdateStart(@NotNull IncrementalCacheUpdateEvent event) {
        int startAffectedIndex;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onCacheUpdateStart"));
        }
        this.myAffectedByUpdateCacheEntries.clear();
        this.myNotAffectedByUpdateTailCacheEntries.clear();
        this.myBeforeChangeState.updateByDocumentOffsets(event.getOldStartOffset(), event.getOldEndOffset(), event.getOldLogicalLinesDiff());
        this.myStorage.removeInRange(event.getOldStartOffset(), event.getOldEndOffset());
        this.advanceSoftWrapOffsets(event.getExactOffsetsDiff(), event.getOldEndOffset());
        if (!this.myBeforeChangeState.cacheShouldBeUpdated) {
            return;
        }
        int startTrailingIndex = this.myBeforeChangeState.endCacheEntryIndex;
        startTrailingIndex = startTrailingIndex >= 0 ? ++startTrailingIndex : -startTrailingIndex - 1;
        if (startTrailingIndex < this.myCache.size()) {
            List<CacheEntry> entries = this.myCache.subList(startTrailingIndex, this.myCache.size());
            this.myNotAffectedByUpdateTailCacheEntries.addAll(entries);
            entries.clear();
        }
        if ((startAffectedIndex = this.myBeforeChangeState.startCacheEntryIndex) < 0) {
            startAffectedIndex = -startAffectedIndex - 1;
        }
        if (startAffectedIndex < this.myCache.size()) {
            List<CacheEntry> entries = this.myCache.subList(startAffectedIndex, this.myCache.size());
            this.myAffectedByUpdateCacheEntries.addAll(entries);
            entries.clear();
        }
    }

    @Override
    public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event, boolean normal) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "onRecalculationEnd"));
        }
        int exactOffsetsDiff = event.getExactOffsetsDiff();
        if (normal) {
            this.myAfterChangeState.updateByDocumentOffsets(event.getNewStartOffset(), event.getNewEndOffset(), event.getNewLogicalLinesDiff());
            this.myCache.addAll(this.myNotAffectedByUpdateTailCacheEntries);
        } else {
            this.myAfterChangeState.logicalLines = event.getNewLogicalLinesDiff();
            this.myAfterChangeState.visualLines = event.getNewLogicalLinesDiff();
            this.myAfterChangeState.softWrapLines = 0;
            this.myAfterChangeState.foldedLines = 0;
            this.myCache.addAll(this.myNotAffectedByUpdateTailCacheEntries);
        }
        this.applyStateChange(exactOffsetsDiff);
        if (this.myCache.size() > 1) {
            CacheEntry beforeLast = this.myCache.get(this.myCache.size() - 2);
            CacheEntry last = this.myCache.get(this.myCache.size() - 1);
            if (beforeLast.visualLine == last.visualLine || beforeLast.visualLine + 1 == last.visualLine && last.startOffset - beforeLast.endOffset > 1 || last.startOffset > this.myEditor.getDocument().getTextLength()) {
                String editorState = "";
                if (this.myEditor instanceof EditorImpl) {
                    editorState = ((EditorImpl)this.myEditor).dumpState();
                }
                LOG.error("Detected invalid soft wraps cache update", new String[]{String.format("Event: %s, normal: %b.%n%nTail cache entries: %s%n%nAffected by change cache entries: %s%n%nBefore change state: %s%n%nAfter change state: %s%n%nEditor state: %s", event, normal, this.myNotAffectedByUpdateTailCacheEntries, this.myAffectedByUpdateCacheEntries, this.myBeforeChangeState, this.myAfterChangeState, editorState)});
            }
        }
        this.myAffectedByUpdateCacheEntries.clear();
        this.myNotAffectedByUpdateTailCacheEntries.clear();
        this.myBeforeChangeState.cacheShouldBeUpdated = false;
    }

    @Override
    public void reset() {
        this.myCache.clear();
        this.myAffectedByUpdateCacheEntries.clear();
        this.myNotAffectedByUpdateTailCacheEntries.clear();
    }

    private void dumpCache() {
        DocumentEx document = this.myEditor.getDocument();
        CharSequence text = document.getCharsSequence();
        CachingSoftWrapDataMapper.log("--------------------------------------------------");
        CachingSoftWrapDataMapper.log("|");
        CachingSoftWrapDataMapper.log("| xxxxxxxxx START DUMP. Document:");
        CachingSoftWrapDataMapper.log(text);
        CachingSoftWrapDataMapper.log("-  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -");
        CachingSoftWrapDataMapper.log("xxxxxxxxxx text length: " + text.length() + ", soft wraps: " + this.myStorage.getSoftWraps().size());
        for (int i = 0; i < this.myCache.size(); ++i) {
            CacheEntry entry = this.myCache.get(i);
            if (text.length() <= 0 && i <= 0) continue;
            if (entry.endOffset < entry.startOffset) assert (false);
            if (i > 0 && this.myCache.get((int)(i - 1)).endOffset > entry.startOffset) assert (false);
            try {
                CachingSoftWrapDataMapper.log(String.format("line %d. %d-%d: '%s'", entry.visualLine, entry.startOffset, entry.endOffset, text.subSequence(Math.min(text.length() - 1, entry.startOffset), Math.min(entry.endOffset, text.length() - 1))));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (CacheEntry cacheEntry : this.myCache) {
            if (cacheEntry.startOffset < document.getTextLength() && cacheEntry.startOffset > 0 && text.charAt(cacheEntry.startOffset - 1) != '\n' && this.myStorage.getSoftWrap(cacheEntry.startOffset) == null) assert (false);
        }
        CachingSoftWrapDataMapper.log("\nxxxxxxxxxxxxxxxx Soft wraps: " + this.myStorage.getSoftWraps());
        CachingSoftWrapDataMapper.log("xxxxxxxxxx dump complete. Cache size: " + this.myCache.size() + "\n");
    }

    private void advanceSoftWrapOffsets(int offsetsDiff, int offset) {
        if (offsetsDiff == 0) {
            return;
        }
        int softWrapIndex = this.myStorage.getSoftWrapIndex(offset);
        softWrapIndex = softWrapIndex >= 0 ? ++softWrapIndex : -softWrapIndex - 1;
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        for (int i = softWrapIndex; i < softWraps.size(); ++i) {
            softWraps.get(i).advance(offsetsDiff);
        }
    }

    private void applyStateChange(int offsetsDiff) {
        if (this.myNotAffectedByUpdateTailCacheEntries.isEmpty()) {
            return;
        }
        int visualLinesDiff = this.myAfterChangeState.visualLines - this.myBeforeChangeState.visualLines;
        int logicalLinesDiff = this.myAfterChangeState.logicalLines - this.myBeforeChangeState.logicalLines;
        int softWrappedLinesDiff = this.myAfterChangeState.softWrapLines - this.myBeforeChangeState.softWrapLines;
        int foldedLinesDiff = this.myAfterChangeState.foldedLines - this.myBeforeChangeState.foldedLines;
        for (CacheEntry cacheEntry : this.myNotAffectedByUpdateTailCacheEntries) {
            cacheEntry.visualLine += visualLinesDiff;
            cacheEntry.startLogicalLine += logicalLinesDiff;
            cacheEntry.endLogicalLine += logicalLinesDiff;
            cacheEntry.advance(offsetsDiff);
            cacheEntry.startSoftWrapLinesBefore += softWrappedLinesDiff;
            cacheEntry.endSoftWrapLinesBefore += softWrappedLinesDiff;
            cacheEntry.startFoldedLines += foldedLinesDiff;
            cacheEntry.endFoldedLines += foldedLinesDiff;
        }
    }

    @NotNull
    public String dumpState() {
        String string = this.myCache.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "dumpState"));
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    public void rawAdd(int visualLine, int startOffset, int endOffset, int startLogicalLine, int startLogicalColumn, int endLogicalLine, int endLogicalColumn, int endVisualColumn, @NotNull List<Trinity<Integer, Integer, FoldRegion>> foldRegions, @NotNull List<Pair<Integer, Integer>> tabData) {
        if (foldRegions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "8", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "rawAdd"));
        }
        if (tabData == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "9", "com/intellij/openapi/editor/impl/softwrap/mapping/CachingSoftWrapDataMapper", "rawAdd"));
        }
        CacheEntry entry = new CacheEntry(visualLine, this.myEditor, this.myRepresentationHelper);
        entry.startOffset = startOffset;
        entry.endOffset = endOffset;
        entry.startLogicalLine = startLogicalLine;
        assert (startLogicalLine == this.myEditor.getDocument().getLineNumber(startOffset));
        entry.startLogicalColumn = startLogicalColumn;
        entry.endLogicalLine = endLogicalLine;
        assert (endLogicalLine == this.myEditor.getDocument().getLineNumber(endOffset));
        entry.endLogicalColumn = endLogicalColumn;
        entry.endVisualColumn = endVisualColumn;
        for (Trinity<Integer, Integer, FoldRegion> trinity : foldRegions) {
            FoldingData foldData = new FoldingData((FoldRegion)trinity.third, (Integer)trinity.second, this.myRepresentationHelper, this.myEditor);
            foldData.widthInColumns = (Integer)trinity.first;
            entry.store(foldData, ((FoldRegion)trinity.third).getStartOffset());
        }
        for (Pair pair : tabData) {
            entry.storeTabData(new TabData((Integer)pair.second, (Integer)pair.first));
        }
        this.myCache.add(entry);
    }

    public static void log(Object o) {
    }

    private class CacheState {
        public boolean cacheShouldBeUpdated = true;
        public int visualLines;
        public int logicalLines;
        public int softWrapLines;
        public int foldedLines;
        public int startCacheEntryIndex;
        public int endCacheEntryIndex;

        private CacheState() {
        }

        public void updateByDocumentOffsets(int startOffset, int endOffset, int logicalLinesDiff) {
            this.reset();
            DocumentEx document = CachingSoftWrapDataMapper.this.myEditor.getDocument();
            this.startCacheEntryIndex = MappingUtil.getCacheEntryIndexForOffset(startOffset, document, CachingSoftWrapDataMapper.this.myCache);
            this.endCacheEntryIndex = MappingUtil.getCacheEntryIndexForOffset(endOffset, document, CachingSoftWrapDataMapper.this.myCache);
            this.logicalLines = logicalLinesDiff;
            this.visualLines = logicalLinesDiff;
            this.softWrapLines = CachingSoftWrapDataMapper.this.myStorage.getNumberOfSoftWrapsInRange(startOffset, endOffset);
            this.visualLines += this.softWrapLines;
            if (this.startCacheEntryIndex < 0 && -this.startCacheEntryIndex - 1 >= CachingSoftWrapDataMapper.this.myCache.size()) {
                this.cacheShouldBeUpdated = false;
                return;
            }
            this.foldedLines = 0;
            int startIndex = this.startCacheEntryIndex;
            if (startIndex < 0 && ((startIndex = -startIndex - 1) >= CachingSoftWrapDataMapper.this.myCache.size() || ((CacheEntry)((CachingSoftWrapDataMapper)CachingSoftWrapDataMapper.this).myCache.get((int)startIndex)).startOffset > endOffset)) {
                return;
            }
            int endIndex = this.endCacheEntryIndex;
            if (endIndex < 0) {
                endIndex = -endIndex - 2;
                endIndex = Math.max(0, Math.min(endIndex, CachingSoftWrapDataMapper.this.myCache.size() - 1));
            }
            for (int i = startIndex; i <= endIndex; ++i) {
                CacheEntry cacheEntry = (CacheEntry)CachingSoftWrapDataMapper.this.myCache.get(i);
                this.foldedLines += cacheEntry.endFoldedLines - cacheEntry.startFoldedLines;
            }
            this.visualLines -= this.foldedLines;
        }

        public void reset() {
            this.logicalLines = 0;
            this.visualLines = 0;
            this.softWrapLines = 0;
            this.foldedLines = 0;
            this.endCacheEntryIndex = 0;
            this.cacheShouldBeUpdated = true;
        }

        public String toString() {
            return String.format("visual lines: %d, logical lines: %d, soft wrap lines: %d, fold lines: %d, cache entry indices: [%d;%d]", this.visualLines, this.logicalLines, this.softWrapLines, this.foldedLines, this.startCacheEntryIndex, this.endCacheEntryIndex);
        }
    }
}

