/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingData;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import com.intellij.openapi.util.Ref;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CacheEntry
implements Comparable<CacheEntry>,
Cloneable {
    private static final TIntObjectHashMap<FoldingData> DUMMY = new TIntObjectHashMap();
    public int visualLine;
    public int startLogicalLine;
    public int startLogicalColumn;
    public int startOffset;
    public int startSoftWrapLinesBefore;
    public int startSoftWrapLinesCurrent;
    public int startSoftWrapColumnDiff;
    public int startFoldedLines;
    public int startFoldingColumnDiff;
    public int endOffset;
    public int endLogicalLine;
    public int endLogicalColumn;
    public int endVisualColumn;
    public int endSoftWrapLinesBefore;
    public int endSoftWrapLinesCurrent;
    public int endSoftWrapColumnDiff;
    public int endFoldedLines;
    public int endFoldingColumnDiff;
    public boolean locked;
    private final Editor myEditor;
    private final EditorTextRepresentationHelper myRepresentationHelper;
    private List<TabData> myTabPositions;
    private TIntObjectHashMap<FoldingData> myFoldingData;

    CacheEntry(int visualLine, @NotNull Editor editor, @NotNull EditorTextRepresentationHelper representationHelper) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "<init>"));
        }
        if (representationHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "<init>"));
        }
        this.myTabPositions = Collections.EMPTY_LIST;
        this.myFoldingData = DUMMY;
        this.visualLine = visualLine;
        this.myEditor = editor;
        this.myRepresentationHelper = representationHelper;
    }

    public void setLineStartPosition(@NotNull EditorPosition context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "setLineStartPosition"));
        }
        assert (context.visualColumn == 0);
        this.startLogicalLine = context.logicalLine;
        this.startLogicalColumn = context.logicalColumn;
        this.visualLine = context.visualLine;
        this.startOffset = context.offset;
        this.startSoftWrapLinesBefore = context.softWrapLinesBefore;
        this.startSoftWrapLinesCurrent = context.softWrapLinesCurrent;
        this.startSoftWrapColumnDiff = context.softWrapColumnDiff;
        this.startFoldedLines = context.foldedLines;
        this.startFoldingColumnDiff = context.foldingColumnDiff;
    }

    public void setLineEndPosition(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "setLineEndPosition"));
        }
        this.endOffset = position.offset;
        this.endLogicalLine = position.logicalLine;
        this.endLogicalColumn = position.logicalColumn;
        this.endVisualColumn = position.visualColumn;
        this.endSoftWrapLinesBefore = position.softWrapLinesBefore;
        this.endSoftWrapLinesCurrent = position.softWrapLinesCurrent;
        this.endSoftWrapColumnDiff = position.softWrapColumnDiff;
        this.endFoldedLines = position.foldedLines;
        this.endFoldingColumnDiff = position.foldingColumnDiff;
    }

    public EditorPosition buildStartLinePosition() {
        EditorPosition result = new EditorPosition(this.myEditor, this.myRepresentationHelper);
        result.logicalLine = this.startLogicalLine;
        result.logicalColumn = this.startLogicalColumn;
        result.offset = this.startOffset;
        result.visualLine = this.visualLine;
        result.visualColumn = 0;
        result.softWrapLinesBefore = this.startSoftWrapLinesBefore;
        result.softWrapLinesCurrent = this.startSoftWrapLinesCurrent;
        result.softWrapColumnDiff = this.startSoftWrapColumnDiff;
        result.foldedLines = this.startFoldedLines;
        result.foldingColumnDiff = this.startFoldingColumnDiff;
        return result;
    }

    public EditorPosition buildEndLinePosition() {
        EditorPosition result = new EditorPosition(this.myEditor, this.myRepresentationHelper);
        result.logicalLine = this.endLogicalLine;
        result.logicalColumn = this.endLogicalColumn;
        result.offset = this.endOffset;
        result.visualLine = this.visualLine;
        result.visualColumn = this.endVisualColumn;
        result.softWrapLinesBefore = this.endSoftWrapLinesBefore;
        result.softWrapLinesCurrent = this.endSoftWrapLinesCurrent;
        result.softWrapColumnDiff = this.endSoftWrapColumnDiff;
        result.foldedLines = this.endFoldedLines;
        result.foldingColumnDiff = this.endFoldingColumnDiff;
        return result;
    }

    public void removeAllFoldDataAtOrAfter(final int offset) {
        if (this.myFoldingData == DUMMY || this.myFoldingData.isEmpty()) {
            return;
        }
        this.myFoldingData.retainEntries((TIntObjectProcedure)new TIntObjectProcedure<FoldingData>(){

            public boolean execute(int a, FoldingData b) {
                return a < offset;
            }
        });
    }

    @Nullable
    public FoldingData getFoldingData(final @NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/CacheEntry", "getFoldingData"));
        }
        FoldingData candidate = (FoldingData)this.myFoldingData.get(region.getStartOffset());
        if (candidate != null) {
            return candidate;
        }
        final Ref result = new Ref();
        this.myFoldingData.forEachValue((TObjectProcedure)new TObjectProcedure<FoldingData>(){

            public boolean execute(FoldingData data) {
                if (data.getFoldRegion().equals(region)) {
                    result.set((Object)data);
                    return false;
                }
                return true;
            }
        });
        return (FoldingData)result.get();
    }

    public void store(FoldRegion foldRegion, int startX) {
        this.store(new FoldingData(foldRegion, startX, this.myRepresentationHelper, this.myEditor), foldRegion.getStartOffset());
    }

    public void store(FoldingData foldData, int offset) {
        if (this.myFoldingData == DUMMY) {
            this.myFoldingData = new TIntObjectHashMap();
        }
        this.myFoldingData.put(offset, (Object)foldData);
    }

    public List<TabData> getTabData() {
        return this.myTabPositions;
    }

    public void storeTabData(TabData tabData) {
        if (this.myTabPositions == Collections.EMPTY_LIST) {
            this.myTabPositions = new ArrayList<TabData>();
        }
        this.myTabPositions.add(tabData);
    }

    public void advance(final int offsetDiff) {
        this.startOffset += offsetDiff;
        this.endOffset += offsetDiff;
        for (int i = 0; i < this.myTabPositions.size(); ++i) {
            this.myTabPositions.get((int)i).offset += offsetDiff;
        }
        if (this.myFoldingData.isEmpty()) {
            return;
        }
        final TIntObjectHashMap newFoldingData = new TIntObjectHashMap(this.myFoldingData.size());
        this.myFoldingData.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<FoldingData>(){

            public boolean execute(int offset, FoldingData foldingData) {
                newFoldingData.put(offset + offsetDiff, (Object)foldingData);
                return true;
            }
        });
        this.myFoldingData = newFoldingData;
    }

    public void collapse() {
        this.endOffset = this.startOffset;
        this.endLogicalLine = this.startLogicalLine;
        this.endLogicalColumn = this.startLogicalColumn;
        this.endVisualColumn = 0;
        this.endSoftWrapLinesBefore = this.startSoftWrapLinesBefore;
        this.endSoftWrapLinesCurrent = this.startSoftWrapLinesCurrent;
        this.endSoftWrapColumnDiff = this.startSoftWrapColumnDiff;
        this.endFoldedLines = this.startFoldedLines;
        this.endFoldingColumnDiff = this.startFoldingColumnDiff;
    }

    @Override
    public int compareTo(CacheEntry e) {
        return this.visualLine - e.visualLine;
    }

    public String toString() {
        return String.format("%d - visual line: %d, offsets: %d-%d, logical lines: %d-%d, logical columns: %d-%d, end visual column: %d, fold regions: %s, tab data: %s", System.identityHashCode(this), this.visualLine, this.startOffset, this.endOffset, this.startLogicalLine, this.endLogicalLine, this.startLogicalColumn, this.endLogicalColumn, this.endVisualColumn, Arrays.toString(this.myFoldingData.getValues()), this.myTabPositions);
    }

    protected CacheEntry clone() {
        final CacheEntry result = new CacheEntry(this.visualLine, this.myEditor, this.myRepresentationHelper);
        result.startLogicalLine = this.startLogicalLine;
        result.startLogicalColumn = this.startLogicalColumn;
        result.startOffset = this.startOffset;
        result.startSoftWrapLinesBefore = this.startSoftWrapLinesBefore;
        result.startSoftWrapLinesCurrent = this.startSoftWrapLinesCurrent;
        result.startSoftWrapColumnDiff = this.startSoftWrapColumnDiff;
        result.startFoldedLines = this.startFoldedLines;
        result.startFoldingColumnDiff = this.startFoldingColumnDiff;
        result.endOffset = this.endOffset;
        result.endLogicalLine = this.endLogicalLine;
        result.endLogicalColumn = this.endLogicalColumn;
        result.endVisualColumn = this.endVisualColumn;
        result.endSoftWrapLinesBefore = this.endSoftWrapLinesBefore;
        result.endSoftWrapLinesCurrent = this.endSoftWrapLinesCurrent;
        result.endSoftWrapColumnDiff = this.endSoftWrapColumnDiff;
        result.endFoldedLines = this.endFoldedLines;
        result.endFoldingColumnDiff = this.endFoldingColumnDiff;
        this.myFoldingData.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<FoldingData>(){

            public boolean execute(int offset, FoldingData foldData) {
                result.store(foldData, offset);
                return true;
            }
        });
        for (TabData tabPosition : this.myTabPositions) {
            result.storeTabData(tabPosition);
        }
        return result;
    }
}

