/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CacheEntry;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.FoldingData;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingStrategy;
import com.intellij.openapi.editor.impl.softwrap.mapping.MappingUtil;
import com.intellij.openapi.editor.impl.softwrap.mapping.TabData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractMappingStrategy<T>
implements MappingStrategy<T> {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractMappingStrategy.class.getName()));
    protected final Editor myEditor;
    protected final EditorTextRepresentationHelper myRepresentationHelper;
    protected final SoftWrapsStorage myStorage;
    protected final List<CacheEntry> myCache;
    private EditorPosition myInitialPosition;
    private CacheEntry myTargetEntry;
    private T myEagerMatch;
    private int myLastEntryOffset;

    AbstractMappingStrategy(@NotNull Editor editor, @NotNull SoftWrapsStorage storage, @NotNull List<CacheEntry> cache, @NotNull EditorTextRepresentationHelper representationHelper) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "<init>"));
        }
        if (representationHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "<init>"));
        }
        this.myEditor = editor;
        this.myStorage = storage;
        this.myCache = cache;
        this.myRepresentationHelper = representationHelper;
    }

    @Override
    @Nullable
    public T eagerMatch() {
        return this.myEagerMatch;
    }

    protected void setEagerMatch(@Nullable T eagerMatch) {
        this.myEagerMatch = eagerMatch;
    }

    protected void setFirstInitialPosition() {
        this.myInitialPosition = new EditorPosition(new LogicalPosition(0, 0), 0, this.myEditor, this.myRepresentationHelper);
    }

    @Nullable
    protected CacheEntry getTargetEntry() {
        return this.myTargetEntry;
    }

    protected void setTargetEntry(@NotNull CacheEntry targetEntry, boolean anchorToStart) {
        if (targetEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "setTargetEntry"));
        }
        this.myTargetEntry = targetEntry;
        this.myInitialPosition = anchorToStart ? targetEntry.buildStartLinePosition() : targetEntry.buildEndLinePosition();
    }

    protected void reset() {
        this.myEagerMatch = null;
        this.myTargetEntry = null;
        this.myInitialPosition = null;
        if (!this.myCache.isEmpty()) {
            this.myLastEntryOffset = this.myCache.get((int)(this.myCache.size() - 1)).endOffset;
        }
    }

    protected void setInitialPosition(@NotNull EditorPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "setInitialPosition"));
        }
        this.myInitialPosition = position;
    }

    @Override
    @NotNull
    public EditorPosition buildInitialPosition() {
        EditorPosition editorPosition = this.myInitialPosition;
        if (editorPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "buildInitialPosition"));
        }
        return editorPosition;
    }

    @Nullable
    protected FoldingData getFoldRegionData(@NotNull FoldRegion foldRegion) {
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "getFoldRegionData"));
        }
        int i = MappingUtil.getCacheEntryIndexForOffset(foldRegion.getStartOffset(), this.myEditor.getDocument(), this.myCache);
        if (i < 0 || i >= this.myCache.size()) {
            return null;
        }
        CacheEntry cacheEntry = this.myCache.get(i);
        return cacheEntry.getFoldingData(foldRegion);
    }

    @Override
    public T advance(@NotNull EditorPosition position, int offset) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "advance"));
        }
        Document document = this.myEditor.getDocument();
        if (offset >= this.myLastEntryOffset || offset >= document.getTextLength()) {
            return this.build(position);
        }
        T result = this.buildIfExceeds(position, offset);
        if (result != null) {
            return result;
        }
        int linesDiff = document.getLineNumber(offset) - position.logicalLine;
        position.logicalLine += linesDiff;
        position.visualLine += linesDiff;
        if (linesDiff <= 0) {
            int columnsDiff = offset - position.offset;
            position.visualColumn += columnsDiff;
            position.logicalColumn += columnsDiff;
        } else {
            int column;
            int lineStartOffset = document.getLineStartOffset(position.logicalLine);
            position.visualColumn = column = offset - lineStartOffset;
            position.logicalColumn = column;
        }
        position.offset = offset;
        return null;
    }

    @Nullable
    protected abstract T buildIfExceeds(EditorPosition var1, int var2);

    @Override
    public T processFoldRegion(@NotNull EditorPosition position, @NotNull FoldRegion foldRegion) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "processFoldRegion"));
        }
        if (foldRegion == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "processFoldRegion"));
        }
        T result = this.buildIfExceeds(position, foldRegion);
        if (result != null) {
            return result;
        }
        Document document = this.myEditor.getDocument();
        int endOffsetLogicalLine = document.getLineNumber(foldRegion.getEndOffset());
        int collapsedSymbolsWidthInColumns = -1;
        if (position.logicalLine == endOffsetLogicalLine) {
            FoldingData foldingData = this.getFoldRegionData(foldRegion);
            if (foldingData != null) {
                collapsedSymbolsWidthInColumns = foldingData.getCollapsedSymbolsWidthInColumns();
            } else {
                String details = "";
                if (this.myEditor instanceof EditorImpl) {
                    details = ((EditorImpl)this.myEditor).dumpState();
                }
                LogMessageEx.error(LOG, "Unexpected fold region is found: " + foldRegion, details);
            }
        } else {
            position.softWrapColumnDiff = 0;
            position.softWrapLinesBefore += position.softWrapLinesCurrent;
            position.softWrapLinesCurrent = 0;
        }
        if (collapsedSymbolsWidthInColumns < 0) {
            collapsedSymbolsWidthInColumns = this.myRepresentationHelper.toVisualColumnSymbolsNumber(document.getCharsSequence(), foldRegion.getStartOffset(), foldRegion.getEndOffset(), 0);
        }
        position.advance(foldRegion, collapsedSymbolsWidthInColumns);
        return null;
    }

    @Nullable
    protected abstract T buildIfExceeds(@NotNull EditorPosition var1, @NotNull FoldRegion var2);

    @Override
    public T processTabulation(@NotNull EditorPosition position, TabData tabData) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/mapping/AbstractMappingStrategy", "processTabulation"));
        }
        T result = this.buildIfExceeds(position, tabData);
        if (result != null) {
            return result;
        }
        position.visualColumn += tabData.widthInColumns;
        position.logicalColumn += tabData.widthInColumns;
        ++position.offset;
        return null;
    }

    @Nullable
    protected abstract T buildIfExceeds(EditorPosition var1, TabData var2);
}

