/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapsStorage {
    private final List<SoftWrapImpl> myWraps = new ArrayList<SoftWrapImpl>();
    private final List<SoftWrapImpl> myWrapsView = Collections.unmodifiableList(this.myWraps);
    private final List<SoftWrapChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public boolean isEmpty() {
        return this.myWraps.isEmpty();
    }

    @Nullable
    public SoftWrap getSoftWrap(int offset) {
        int i = this.getSoftWrapIndex(offset);
        return i >= 0 ? this.myWraps.get(i) : null;
    }

    @NotNull
    public List<SoftWrapImpl> getSoftWraps() {
        List<SoftWrapImpl> list = this.myWrapsView;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/softwrap/SoftWrapsStorage", "getSoftWraps"));
        }
        return list;
    }

    public int getSoftWrapIndex(int offset) {
        int start = 0;
        int end = this.myWraps.size() - 1;
        while (start <= end) {
            int i = start + end >>> 1;
            SoftWrap softWrap = this.myWraps.get(i);
            int softWrapOffset = softWrap.getStart();
            if (softWrapOffset > offset) {
                end = i - 1;
                continue;
            }
            if (softWrapOffset < offset) {
                start = i + 1;
                continue;
            }
            return i;
        }
        return -(start + 1);
    }

    public int getNumberOfSoftWrapsInRange(int startOffset, int endOffset) {
        SoftWrap softWrap;
        int startIndex = this.getSoftWrapIndex(startOffset);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex >= this.myWraps.size()) {
            return 0;
        }
        int result = 0;
        for (int endIndex = startIndex; endIndex < this.myWraps.size() && (softWrap = (SoftWrap)this.myWraps.get(endIndex)).getStart() <= endOffset; ++endIndex) {
            ++result;
        }
        return result;
    }

    @Nullable
    public SoftWrap storeOrReplace(SoftWrapImpl softWrap, boolean notifyListeners) {
        int i = this.getSoftWrapIndex(softWrap.getStart());
        if (i >= 0) {
            return this.myWraps.set(i, softWrap);
        }
        i = -i - 1;
        this.myWraps.add(i, softWrap);
        if (notifyListeners) {
            for (int j = 0; j < this.myListeners.size(); ++j) {
                SoftWrapChangeListener listener = this.myListeners.get(j);
                listener.softWrapAdded(softWrap);
            }
        }
        return null;
    }

    public void removeInRange(int startOffset, int endOffset) {
        SoftWrap softWrap;
        int endIndex;
        int startIndex = this.getSoftWrapIndex(startOffset);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex >= this.myWraps.size()) {
            return;
        }
        for (endIndex = startIndex; endIndex < this.myWraps.size() && (softWrap = (SoftWrap)this.myWraps.get(endIndex)).getStart() < endOffset; ++endIndex) {
        }
        if (endIndex > startIndex) {
            this.myWraps.subList(startIndex, endIndex).clear();
            this.notifyListenersAboutRemoval();
        }
    }

    public void removeAll() {
        this.myWraps.clear();
        this.notifyListenersAboutRemoval();
    }

    public boolean addSoftWrapChangeListener(@NotNull SoftWrapChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/SoftWrapsStorage", "addSoftWrapChangeListener"));
        }
        return this.myListeners.add(listener);
    }

    private void notifyListenersAboutRemoval() {
        for (SoftWrapChangeListener listener : this.myListeners) {
            listener.softWrapsRemoved();
        }
    }
}

