/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapApplianceStrategy;
import org.jetbrains.annotations.NotNull;

public class SoftWrapFoldBasedApplianceStrategy
implements SoftWrapApplianceStrategy {
    private final EditorEx myEditor;
    private SoftWrapAppliancePlaces myPlace = SoftWrapAppliancePlaces.MAIN_EDITOR;

    public SoftWrapFoldBasedApplianceStrategy(EditorEx editor) {
        this.myEditor = editor;
    }

    @Override
    public boolean processSoftWraps() {
        return this.myEditor.getFoldingModel().isFoldingEnabled() || this.myPlace == SoftWrapAppliancePlaces.VCS_DIFF;
    }

    public void setCurrentPlace(@NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/softwrap/SoftWrapFoldBasedApplianceStrategy", "setCurrentPlace"));
        }
        this.myPlace = place;
    }
}

