/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.VisualSizeChangeListener;
import com.intellij.openapi.editor.impl.softwrap.CompositeSoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapFoldBasedApplianceStrategy;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapApplianceManager;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareVisualSizeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.reference.SoftReference;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapModelImpl
implements SoftWrapModelEx,
PrioritizedDocumentListener,
DocumentBulkUpdateListener,
FoldingListener,
PropertyChangeListener,
Dumpable,
Disposable {
    public static final String DEBUG_PROPERTY_NAME = "idea.editor.wrap.soft.debug";
    private static final Logger LOG = Logger.getInstance((String)("#" + SoftWrapModelImpl.class.getName()));
    private final OffsetToLogicalTask myOffsetToLogicalTask;
    private final VisualToLogicalTask myVisualToLogicalTask;
    private final LogicalToVisualTask myLogicalToVisualTask;
    private final FoldProcessingEndTask myFoldProcessingEndTask;
    private final List<DocumentListener> myDocumentListeners;
    private final List<SoftWrapChangeListener> mySoftWrapListeners;
    private final List<FoldRegionInfo> myDeferredFoldRegions;
    private final SoftWrapFoldBasedApplianceStrategy myFoldBasedApplianceStrategy;
    private final CachingSoftWrapDataMapper myDataMapper;
    private final SoftWrapsStorage myStorage;
    private final SoftWrapPainter myPainter;
    private final SoftWrapApplianceManager myApplianceManager;
    private final SoftWrapAwareVisualSizeManager myVisualSizeManager;
    private final EditorEx myEditor;
    private SoftReference<Thread> myLastEdt;
    private int myActive;
    private boolean myUseSoftWraps;
    private int myTabWidth;
    private boolean myUpdateInProgress;
    private boolean myBulkUpdateInProgress;
    private boolean myDirty;
    private boolean myForceAdditionalColumns;

    public SoftWrapModelImpl(@NotNull EditorEx editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        this(editor, new SoftWrapsStorage(), new CompositeSoftWrapPainter(editor));
    }

    public SoftWrapModelImpl(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage, @NotNull SoftWrapPainter painter) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        this(editor, storage, painter, new DefaultEditorTextRepresentationHelper(editor));
    }

    public SoftWrapModelImpl(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage, @NotNull SoftWrapPainter painter, @NotNull EditorTextRepresentationHelper representationHelper) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (representationHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        this(editor, storage, painter, representationHelper, new CachingSoftWrapDataMapper(editor, storage, representationHelper));
        this.myApplianceManager.addListener(this.myDataMapper);
    }

    public SoftWrapModelImpl(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage, @NotNull SoftWrapPainter painter, @NotNull EditorTextRepresentationHelper representationHelper, @NotNull CachingSoftWrapDataMapper dataMapper) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (representationHelper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (dataMapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        this(editor, storage, painter, new SoftWrapApplianceManager(storage, editor, painter, representationHelper, dataMapper), dataMapper);
    }

    public SoftWrapModelImpl(@NotNull EditorEx editor, @NotNull SoftWrapsStorage storage, @NotNull SoftWrapPainter painter, @NotNull SoftWrapApplianceManager applianceManager, @NotNull CachingSoftWrapDataMapper dataMapper) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (painter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (applianceManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        if (dataMapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "<init>"));
        }
        this.myOffsetToLogicalTask = new OffsetToLogicalTask();
        this.myVisualToLogicalTask = new VisualToLogicalTask();
        this.myLogicalToVisualTask = new LogicalToVisualTask();
        this.myFoldProcessingEndTask = new FoldProcessingEndTask();
        this.myDocumentListeners = new ArrayList<DocumentListener>();
        this.mySoftWrapListeners = new ArrayList<SoftWrapChangeListener>();
        this.myDeferredFoldRegions = new ArrayList<FoldRegionInfo>();
        this.myLastEdt = new SoftReference(null);
        this.myTabWidth = -1;
        this.myEditor = editor;
        this.myStorage = storage;
        this.myPainter = painter;
        this.myApplianceManager = applianceManager;
        this.myDataMapper = dataMapper;
        this.myFoldBasedApplianceStrategy = new SoftWrapFoldBasedApplianceStrategy(editor);
        this.myVisualSizeManager = new SoftWrapAwareVisualSizeManager(painter);
        this.myDocumentListeners.add(this.myApplianceManager);
        applianceManager.addListener(this.myVisualSizeManager);
        applianceManager.addListener(new SoftWrapAwareDocumentParsingListenerAdapter(){

            @Override
            public void recalculationEnds() {
                for (SoftWrapChangeListener listener : SoftWrapModelImpl.this.mySoftWrapListeners) {
                    listener.recalculationEnds();
                }
            }
        });
        EditorSettings settings = this.myEditor.getSettings();
        this.myUseSoftWraps = settings.isUseSoftWraps();
        editor.addPropertyChangeListener(this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(DocumentBulkUpdateListener.TOPIC, (Object)this);
    }

    public void reinitSettings() {
        boolean softWrapsUsedBefore = this.myUseSoftWraps;
        EditorSettings settings = this.myEditor.getSettings();
        this.myUseSoftWraps = settings.isUseSoftWraps();
        int tabWidthBefore = this.myTabWidth;
        this.myTabWidth = this.getCurrentTabWidth();
        if (this.myUseSoftWraps ^ softWrapsUsedBefore || tabWidthBefore >= 0 && this.myTabWidth != tabWidthBefore) {
            this.myApplianceManager.reset();
            this.myDeferredFoldRegions.clear();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        }
    }

    private int getCurrentTabWidth() {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myEditor.getProject());
        VirtualFile file = this.myEditor.getVirtualFile();
        if (file == null) {
            return -1;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions(file.getFileType());
        return indentOptions.TAB_SIZE;
    }

    @Override
    public boolean isRespectAdditionalColumns() {
        return this.myForceAdditionalColumns || !this.isSoftWrappingEnabled() || this.myApplianceManager.hasLinesWithFailedWrap();
    }

    @Override
    public void forceAdditionalColumnsUsage() {
        this.myForceAdditionalColumns = true;
    }

    public boolean isSoftWrappingEnabled() {
        Thread currentThread;
        if (!this.myUseSoftWraps || this.myEditor.isOneLineMode() || this.myEditor.isPurePaintingMode()) {
            return false;
        }
        Application application = ApplicationManager.getApplication();
        Thread lastEdt = (Thread)this.myLastEdt.get();
        if (lastEdt != (currentThread = Thread.currentThread())) {
            if (application.isDispatchThread()) {
                this.myLastEdt = new SoftReference((Object)currentThread);
            } else {
                this.myLastEdt = new SoftReference(null);
                return false;
            }
        }
        if (application.isUnitTestMode()) {
            return true;
        }
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        return visibleArea.width > 0 && visibleArea.height > 0;
    }

    @Nullable
    public SoftWrap getSoftWrap(int offset) {
        if (!this.isSoftWrappingEnabled()) {
            return null;
        }
        return this.myStorage.getSoftWrap(offset);
    }

    @Override
    public int getSoftWrapIndex(int offset) {
        return this.myStorage.getSoftWrapIndex(offset);
    }

    @NotNull
    public List<? extends SoftWrap> getSoftWrapsForRange(int start, int end) {
        if (!this.isSoftWrappingEnabled() || end < start) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getSoftWrapsForRange"));
            }
            return list;
        }
        List<SoftWrapImpl> softWraps = this.myStorage.getSoftWraps();
        int startIndex = this.myStorage.getSoftWrapIndex(start);
        if (startIndex < 0 && ((startIndex = -startIndex - 1) >= softWraps.size() || ((SoftWrap)softWraps.get(startIndex)).getStart() > end)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getSoftWrapsForRange"));
            }
            return list;
        }
        int endIndex = this.myStorage.getSoftWrapIndex(end);
        if (endIndex >= 0) {
            List<SoftWrapImpl> list = softWraps.subList(startIndex, endIndex + 1);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getSoftWrapsForRange"));
            }
            return list;
        }
        endIndex = -endIndex - 1;
        List<SoftWrapImpl> list = softWraps.subList(startIndex, endIndex);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getSoftWrapsForRange"));
        }
        return list;
    }

    @NotNull
    public List<? extends SoftWrap> getSoftWrapsForLine(int documentLine) {
        if (!this.isSoftWrappingEnabled() || documentLine < 0) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getSoftWrapsForLine"));
            }
            return list;
        }
        DocumentEx document = this.myEditor.getDocument();
        if (documentLine >= document.getLineCount()) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getSoftWrapsForLine"));
            }
            return list;
        }
        int start = document.getLineStartOffset(documentLine);
        int end = document.getLineEndOffset(documentLine);
        List<? extends SoftWrap> list = this.getSoftWrapsForRange(start, end + 1);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getSoftWrapsForLine"));
        }
        return list;
    }

    public int getSoftWrapsIntroducedLinesNumber() {
        if (!this.isSoftWrappingEnabled()) {
            return 0;
        }
        int result = 0;
        FoldingModelEx foldingModel = this.myEditor.getFoldingModel();
        for (SoftWrapImpl softWrap : this.myStorage.getSoftWraps()) {
            if (foldingModel.isOffsetCollapsed(softWrap.getStart())) continue;
            ++result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSoftWrapsIfNecessary() {
        if (!this.isSoftWrappingEnabled()) {
            return;
        }
        ++this.myActive;
        try {
            this.myApplianceManager.registerSoftWrapIfNecessary();
        }
        finally {
            --this.myActive;
        }
    }

    @Override
    public List<? extends SoftWrap> getRegisteredSoftWraps() {
        if (!this.isSoftWrappingEnabled()) {
            return Collections.emptyList();
        }
        return this.myStorage.getSoftWraps();
    }

    public boolean isVisible(SoftWrap softWrap) {
        int start;
        FoldingModelEx foldingModel = this.myEditor.getFoldingModel();
        if (foldingModel.isOffsetCollapsed(start = softWrap.getStart())) {
            return false;
        }
        return start <= 0 || !foldingModel.isOffsetCollapsed(start - 1);
    }

    @Override
    public int paint(@NotNull Graphics g, @NotNull SoftWrapDrawingType drawingType, int x, int y, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "paint"));
        }
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "paint"));
        }
        if (!this.isSoftWrappingEnabled()) {
            return 0;
        }
        return this.myPainter.paint(g, drawingType, x, y, lineHeight);
    }

    @Override
    public int getMinDrawingWidthInPixels(@NotNull SoftWrapDrawingType drawingType) {
        if (drawingType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getMinDrawingWidthInPixels"));
        }
        return this.myPainter.getMinDrawingWidth(drawingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visual) {
        if (visual == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "visualToLogicalPosition"));
        }
        if (this.myBulkUpdateInProgress || this.myUpdateInProgress || !this.prepareToMapping()) {
            LogicalPosition logicalPosition = this.myEditor.visualToLogicalPosition(visual, false);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "visualToLogicalPosition"));
            }
            return logicalPosition;
        }
        ++this.myActive;
        this.myVisualToLogicalTask.input = visual;
        this.executeSafely(this.myVisualToLogicalTask);
        LogicalPosition logicalPosition = this.myVisualToLogicalTask.output;
        LogicalPosition logicalPosition2 = logicalPosition;
        if (logicalPosition2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "visualToLogicalPosition"));
        }
        return logicalPosition2;
        finally {
            --this.myActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        if (this.myBulkUpdateInProgress || this.myUpdateInProgress || !this.prepareToMapping()) {
            LogicalPosition logicalPosition = this.myEditor.offsetToLogicalPosition(offset, false);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "offsetToLogicalPosition"));
            }
            return logicalPosition;
        }
        ++this.myActive;
        this.myOffsetToLogicalTask.input = offset;
        this.executeSafely(this.myOffsetToLogicalTask);
        LogicalPosition logicalPosition = this.myOffsetToLogicalTask.output;
        LogicalPosition logicalPosition2 = logicalPosition;
        if (logicalPosition2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "offsetToLogicalPosition"));
        }
        return logicalPosition2;
        finally {
            --this.myActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public LogicalPosition adjustLogicalPosition(LogicalPosition defaultLogical, int offset) {
        if (this.myBulkUpdateInProgress || this.myUpdateInProgress || !this.prepareToMapping()) {
            LogicalPosition logicalPosition = defaultLogical;
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "adjustLogicalPosition"));
            }
            return logicalPosition;
        }
        ++this.myActive;
        this.myOffsetToLogicalTask.input = offset;
        this.executeSafely(this.myOffsetToLogicalTask);
        LogicalPosition logicalPosition = this.myOffsetToLogicalTask.output;
        LogicalPosition logicalPosition2 = logicalPosition;
        if (logicalPosition2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "adjustLogicalPosition"));
        }
        return logicalPosition2;
        finally {
            --this.myActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public VisualPosition adjustVisualPosition(@NotNull LogicalPosition logical, @NotNull VisualPosition defaultVisual) {
        if (logical == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "adjustVisualPosition"));
        }
        if (defaultVisual == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "adjustVisualPosition"));
        }
        if (this.myBulkUpdateInProgress || this.myUpdateInProgress || !this.prepareToMapping()) {
            VisualPosition visualPosition = defaultVisual;
            if (visualPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "adjustVisualPosition"));
            }
            return visualPosition;
        }
        ++this.myActive;
        this.myLogicalToVisualTask.input = logical;
        this.myLogicalToVisualTask.defaultOutput = defaultVisual;
        this.executeSafely(this.myLogicalToVisualTask);
        VisualPosition visualPosition = this.myLogicalToVisualTask.output;
        VisualPosition visualPosition2 = visualPosition;
        if (visualPosition2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "adjustVisualPosition"));
        }
        return visualPosition2;
        finally {
            --this.myActive;
        }
    }

    private boolean prepareToMapping() {
        boolean useSoftWraps;
        boolean bl = useSoftWraps = this.myActive <= 0 && this.isSoftWrappingEnabled() && this.myEditor.getDocument().getTextLength() > 0 && this.myFoldBasedApplianceStrategy.processSoftWraps();
        if (!useSoftWraps) {
            return useSoftWraps;
        }
        if (this.myDirty) {
            this.myApplianceManager.reset();
            this.myDeferredFoldRegions.clear();
            this.myDirty = false;
        }
        return this.myApplianceManager.recalculateIfNecessary();
    }

    public boolean isInsideSoftWrap(@NotNull VisualPosition visual) {
        if (visual == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "isInsideSoftWrap"));
        }
        return this.isInsideSoftWrap(visual, false);
    }

    public boolean isInsideOrBeforeSoftWrap(@NotNull VisualPosition visual) {
        if (visual == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "isInsideOrBeforeSoftWrap"));
        }
        return this.isInsideSoftWrap(visual, true);
    }

    private boolean isInsideSoftWrap(@NotNull VisualPosition visual, boolean countBeforeSoftWrap) {
        int offsetLineStart;
        if (visual == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "isInsideSoftWrap"));
        }
        if (!this.isSoftWrappingEnabled()) {
            return false;
        }
        SoftWrapModelEx model = this.myEditor.getSoftWrapModel();
        if (!model.isSoftWrappingEnabled()) {
            return false;
        }
        LogicalPosition logical = this.myEditor.visualToLogicalPosition(visual);
        int offset = this.myEditor.logicalPositionToOffset(logical);
        if (offset <= 0) {
            return false;
        }
        SoftWrap softWrap = model.getSoftWrap(offset);
        if (softWrap == null) {
            return false;
        }
        VisualPosition visualAfterSoftWrap = this.myEditor.offsetToVisualPosition(offset);
        if (visualAfterSoftWrap.line == visual.line && visualAfterSoftWrap.column <= visual.column) {
            return false;
        }
        VisualPosition visualBeforeSoftWrap = this.myEditor.offsetToVisualPosition(offset - 1);
        int x = 0;
        LogicalPosition logLineStart = this.myEditor.visualToLogicalPosition(new VisualPosition(visualBeforeSoftWrap.line, 0));
        if (logLineStart.softWrapLinesOnCurrentLogicalLine > 0 && (softWrap = model.getSoftWrap(offsetLineStart = this.myEditor.logicalPositionToOffset(logLineStart))) != null) {
            x = softWrap.getIndentInPixels();
        }
        int width = EditorUtil.textWidthInColumns(this.myEditor, this.myEditor.getDocument().getCharsSequence(), offset - 1, offset, x);
        int softWrapStartColumn = visualBeforeSoftWrap.column + width;
        if (visual.line > visualBeforeSoftWrap.line) {
            return true;
        }
        return countBeforeSoftWrap ? visual.column >= softWrapStartColumn : visual.column > softWrapStartColumn;
    }

    public void beforeDocumentChangeAtCaret() {
        CaretModel caretModel = this.myEditor.getCaretModel();
        VisualPosition visualCaretPosition = caretModel.getVisualPosition();
        if (!this.isInsideSoftWrap(visualCaretPosition)) {
            return;
        }
        SoftWrap softWrap = this.myStorage.getSoftWrap(caretModel.getOffset());
        if (softWrap == null) {
            return;
        }
        this.myEditor.getDocument().replaceString(softWrap.getStart(), softWrap.getEnd(), softWrap.getText());
        caretModel.moveToVisualPosition(visualCaretPosition);
    }

    public void setPlace(@NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "setPlace"));
        }
        this.myFoldBasedApplianceStrategy.setCurrentPlace(place);
    }

    @Override
    public boolean addSoftWrapChangeListener(@NotNull SoftWrapChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "addSoftWrapChangeListener"));
        }
        this.mySoftWrapListeners.add(listener);
        return this.myStorage.addSoftWrapChangeListener(listener);
    }

    public boolean addVisualSizeChangeListener(@NotNull VisualSizeChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "addVisualSizeChangeListener"));
        }
        return this.myVisualSizeManager.addVisualSizeChangeListener(listener);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    public void beforeDocumentChange(DocumentEvent event) {
        if (this.myBulkUpdateInProgress) {
            return;
        }
        this.myUpdateInProgress = true;
        if (!this.isSoftWrappingEnabled()) {
            this.myDirty = true;
            return;
        }
        for (DocumentListener listener : this.myDocumentListeners) {
            listener.beforeDocumentChange(event);
        }
    }

    public void documentChanged(DocumentEvent event) {
        if (this.myBulkUpdateInProgress) {
            return;
        }
        this.myUpdateInProgress = false;
        if (!this.isSoftWrappingEnabled()) {
            return;
        }
        for (DocumentListener listener : this.myDocumentListeners) {
            listener.documentChanged(event);
        }
    }

    @Override
    public void updateStarted(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "updateStarted"));
        }
        if (doc != this.myEditor.getDocument()) {
            return;
        }
        this.myBulkUpdateInProgress = true;
    }

    @Override
    public void updateFinished(@NotNull Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "updateFinished"));
        }
        if (doc != this.myEditor.getDocument()) {
            return;
        }
        this.myBulkUpdateInProgress = false;
        if (!this.isSoftWrappingEnabled()) {
            return;
        }
        this.recalculate();
    }

    @Override
    public void onFoldRegionStateChange(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "onFoldRegionStateChange"));
        }
        this.myUpdateInProgress = true;
        if (!this.isSoftWrappingEnabled() || !region.isValid()) {
            this.myDirty = true;
            return;
        }
        this.myDeferredFoldRegions.add(new FoldRegionInfo(region));
    }

    @Override
    public void onFoldProcessingEnd() {
        this.myUpdateInProgress = false;
        if (!this.isSoftWrappingEnabled()) {
            return;
        }
        this.executeSafely(this.myFoldProcessingEndTask);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("fontSize".equals(evt.getPropertyName())) {
            this.myDirty = true;
        }
    }

    @NotNull
    public CachingSoftWrapDataMapper getDataMapper() {
        CachingSoftWrapDataMapper cachingSoftWrapDataMapper = this.myDataMapper;
        if (cachingSoftWrapDataMapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "getDataMapper"));
        }
        return cachingSoftWrapDataMapper;
    }

    public void dispose() {
        this.release();
    }

    public void release() {
        this.myDataMapper.release();
        this.myApplianceManager.release();
        this.myStorage.removeAll();
        this.myDeferredFoldRegions.clear();
    }

    public void recalculate() {
        this.myApplianceManager.reset();
        this.myStorage.removeAll();
        this.myDeferredFoldRegions.clear();
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.myApplianceManager.recalculateIfNecessary();
    }

    public SoftWrapApplianceManager getApplianceManager() {
        return this.myApplianceManager;
    }

    private void executeSafely(SoftWrapAwareTask task) {
        try {
            task.run(true);
        }
        catch (Throwable e) {
            if (Boolean.getBoolean(DEBUG_PROPERTY_NAME) || ApplicationManager.getApplication().isUnitTestMode()) {
                String info = "";
                if (this.myEditor instanceof EditorImpl) {
                    info = ((EditorImpl)this.myEditor).dumpState();
                }
                LOG.error(String.format("Unexpected exception occurred during performing '%s'", task), e, new String[]{info});
            }
            this.myEditor.getFoldingModel().rebuild();
            this.myDataMapper.release();
            this.myApplianceManager.reset();
            this.myStorage.removeAll();
            this.myApplianceManager.recalculateIfNecessary();
            try {
                task.run(true);
            }
            catch (Throwable e1) {
                String info = "";
                if (this.myEditor instanceof EditorImpl) {
                    info = ((EditorImpl)this.myEditor).dumpState();
                }
                LOG.error(String.format("Can't perform %s even with complete soft wraps cache re-parsing", task), e1, new String[]{info});
                this.myEditor.getSettings().setUseSoftWraps(false);
                task.run(false);
            }
        }
    }

    @NotNull
    public String dumpState() {
        String string = String.format("appliance manager state: %s; soft wraps mapping info: %s", this.myApplianceManager.dumpState(), this.myDataMapper.dumpState());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/SoftWrapModelImpl", "dumpState"));
        }
        return string;
    }

    public String toString() {
        return this.dumpState();
    }

    private static class FoldRegionInfo {
        public final FoldRegion region;
        public final int start;
        public final int end;

        FoldRegionInfo(@NotNull FoldRegion region) {
            if (region == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/SoftWrapModelImpl$FoldRegionInfo", "<init>"));
            }
            this.region = region;
            this.start = region.getStartOffset();
            this.end = region.getEndOffset();
        }
    }

    private class FoldProcessingEndTask
    implements SoftWrapAwareTask {
        private FoldProcessingEndTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(boolean softWrapAware) {
            if (!softWrapAware) {
                return;
            }
            try {
                if (!SoftWrapModelImpl.this.myDirty) {
                    for (FoldRegionInfo info : SoftWrapModelImpl.this.myDeferredFoldRegions) {
                        FoldRegion outerRegion = SoftWrapModelImpl.this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(info.start);
                        if (outerRegion != null && outerRegion != info.region && outerRegion.getStartOffset() <= info.start && outerRegion.getEndOffset() >= info.end) continue;
                        SoftWrapModelImpl.this.myApplianceManager.onFoldRegionStateChange(info.start, info.end);
                    }
                }
            }
            finally {
                SoftWrapModelImpl.this.myDeferredFoldRegions.clear();
            }
            SoftWrapModelImpl.this.myApplianceManager.onFoldProcessingEnd();
        }

        public String toString() {
            return "fold regions state change processing";
        }
    }

    private class LogicalToVisualTask
    implements SoftWrapAwareTask {
        public LogicalPosition input;
        public VisualPosition defaultOutput;
        public VisualPosition output;

        private LogicalToVisualTask() {
        }

        @Override
        public void run(boolean softWrapAware) throws IllegalStateException {
            this.output = softWrapAware ? SoftWrapModelImpl.this.myDataMapper.logicalToVisualPosition(this.input, this.defaultOutput) : this.defaultOutput;
        }

        public String toString() {
            return "mapping from logical position (" + this.input + ") to visual position";
        }
    }

    private class VisualToLogicalTask
    implements SoftWrapAwareTask {
        public VisualPosition input;
        public LogicalPosition output;

        private VisualToLogicalTask() {
        }

        @Override
        public void run(boolean softWrapAware) throws IllegalStateException {
            this.output = softWrapAware ? SoftWrapModelImpl.this.myDataMapper.visualToLogical(this.input) : SoftWrapModelImpl.this.myEditor.visualToLogicalPosition(this.input, false);
        }

        public String toString() {
            return "mapping from visual position (" + this.input + ") to logical position";
        }
    }

    private class OffsetToLogicalTask
    implements SoftWrapAwareTask {
        public int input;
        public LogicalPosition output;

        private OffsetToLogicalTask() {
        }

        @Override
        public void run(boolean softWrapAware) throws IllegalStateException {
            this.output = softWrapAware ? SoftWrapModelImpl.this.myDataMapper.offsetToLogicalPosition(this.input) : SoftWrapModelImpl.this.myEditor.offsetToLogicalPosition(this.input, false);
        }

        public String toString() {
            return "mapping from offset (" + this.input + ") to logical position";
        }
    }

    private static interface SoftWrapAwareTask {
        public void run(boolean var1) throws IllegalStateException;
    }
}

