/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.VisibleEditorsTracker;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.Animator;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollingModelImpl
implements ScrollingModelEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.ScrollingModelImpl");
    private final EditorImpl myEditor;
    private final List<VisibleAreaListener> myVisibleAreaListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private AnimatedScrollingRunnable myCurrentAnimationRequest = null;
    private boolean myAnimationDisabled = false;
    private final DocumentAdapter myDocumentListener;
    private int myAccumulatedXOffset = -1;
    private int myAccumulatedYOffset = -1;
    private boolean myAccumulateViewportChanges;
    private boolean myViewportPositioned;

    public ScrollingModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myEditor.getScrollPane().getViewport().addChangeListener(new ChangeListener(){
            private Rectangle myLastViewRect;

            @Override
            public void stateChanged(ChangeEvent event) {
                Rectangle viewRect = ScrollingModelImpl.this.getVisibleArea();
                VisibleAreaEvent visibleAreaEvent = new VisibleAreaEvent((Editor)ScrollingModelImpl.this.myEditor, this.myLastViewRect, viewRect);
                if (!ScrollingModelImpl.this.myViewportPositioned && viewRect.height > 0) {
                    ScrollingModelImpl.this.myViewportPositioned = true;
                    if (ScrollingModelImpl.this.adjustVerticalOffsetIfNecessary()) {
                        return;
                    }
                }
                this.myLastViewRect = viewRect;
                for (VisibleAreaListener listener : ScrollingModelImpl.this.myVisibleAreaListeners) {
                    listener.visibleAreaChanged(visibleAreaEvent);
                }
            }
        });
        this.myDocumentListener = new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                ScrollingModelImpl.this.cancelAnimatedScrolling(true);
            }
        };
        this.myEditor.getDocument().addDocumentListener((DocumentListener)this.myDocumentListener);
    }

    private boolean adjustVerticalOffsetIfNecessary() {
        int currentOffset;
        int maxY = Math.max(this.myEditor.getLineHeight(), this.myEditor.getDocument().getLineCount() * this.myEditor.getLineHeight());
        int minPreferredY = maxY - this.getVisibleArea().height * 2 / 3;
        int offsetToUse = Math.min(minPreferredY, currentOffset = this.getVerticalScrollOffset());
        if (offsetToUse != currentOffset) {
            this.scrollToOffsets(this.getHorizontalScrollOffset(), offsetToUse);
            return true;
        }
        return false;
    }

    @NotNull
    public Rectangle getVisibleArea() {
        this.assertIsDispatchThread();
        if (this.myEditor.getScrollPane() == null) {
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "getVisibleArea"));
            }
            return rectangle;
        }
        Rectangle rectangle = this.myEditor.getScrollPane().getViewport().getViewRect();
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "getVisibleArea"));
        }
        return rectangle;
    }

    @NotNull
    public Rectangle getVisibleAreaOnScrollingFinished() {
        this.assertIsDispatchThread();
        if (this.myCurrentAnimationRequest != null) {
            Rectangle rectangle = this.myCurrentAnimationRequest.getTargetVisibleArea();
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "getVisibleAreaOnScrollingFinished"));
            }
            return rectangle;
        }
        Rectangle rectangle = this.getVisibleArea();
        if (rectangle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "getVisibleAreaOnScrollingFinished"));
        }
        return rectangle;
    }

    public void scrollToCaret(@NotNull ScrollType scrollType) {
        if (scrollType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "scrollToCaret"));
        }
        this.assertIsDispatchThread();
        LogicalPosition caretPosition = this.myEditor.getCaretModel().getLogicalPosition();
        this.myEditor.validateSize();
        this.scrollTo(caretPosition, scrollType);
    }

    public void scrollTo(@NotNull LogicalPosition pos, @NotNull ScrollType scrollType) {
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "scrollTo"));
        }
        if (scrollType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "scrollTo"));
        }
        this.assertIsDispatchThread();
        if (this.myEditor.getScrollPane() == null) {
            return;
        }
        AnimatedScrollingRunnable canceledThread = this.cancelAnimatedScrolling(false);
        Rectangle viewRect = canceledThread != null ? canceledThread.getTargetVisibleArea() : this.getVisibleArea();
        Point p = this.calcOffsetsToScroll(pos, scrollType, viewRect);
        this.scrollToOffsets(p.x, p.y);
    }

    private void assertIsDispatchThread() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread(this.myEditor.getComponent());
    }

    public void runActionOnScrollingFinished(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "runActionOnScrollingFinished"));
        }
        this.assertIsDispatchThread();
        if (this.myCurrentAnimationRequest != null) {
            this.myCurrentAnimationRequest.addPostRunnable(action);
            return;
        }
        action.run();
    }

    public void disableAnimation() {
        this.myAnimationDisabled = true;
    }

    public void enableAnimation() {
        this.myAnimationDisabled = false;
    }

    private Point calcOffsetsToScroll(LogicalPosition pos, ScrollType scrollType, Rectangle viewRect) {
        int hOffset;
        Point targetLocation = this.myEditor.logicalPositionToXY(pos);
        if (this.myEditor.getSettings().isRefrainFromScrolling() && viewRect.contains(targetLocation) && (scrollType == ScrollType.CENTER || scrollType == ScrollType.CENTER_DOWN || scrollType == ScrollType.CENTER_UP)) {
            scrollType = ScrollType.RELATIVE;
        }
        int spaceWidth = EditorUtil.getSpaceWidth(0, this.myEditor);
        int xInsets = this.myEditor.getSettings().getAdditionalColumnsCount() * spaceWidth;
        int n = hOffset = scrollType == ScrollType.CENTER || scrollType == ScrollType.CENTER_DOWN || scrollType == ScrollType.CENTER_UP ? 0 : viewRect.x;
        if (targetLocation.x < hOffset) {
            hOffset = targetLocation.x - 4 * spaceWidth;
            hOffset = hOffset > 0 ? hOffset : 0;
        } else if (targetLocation.x >= hOffset + viewRect.width) {
            hOffset = targetLocation.x - viewRect.width + xInsets;
        }
        int lineHeight = this.myEditor.getLineHeight();
        int scrollUpBy = viewRect.y - targetLocation.y + (viewRect.height > lineHeight ? lineHeight : 0);
        int scrollDownBy = targetLocation.y - viewRect.y - Math.max(0, viewRect.height - 2 * lineHeight);
        int centerPosition = targetLocation.y - viewRect.height / 3;
        int vOffset = viewRect.y;
        if (scrollType == ScrollType.CENTER) {
            vOffset = centerPosition;
        } else if (scrollType == ScrollType.CENTER_UP) {
            if (scrollUpBy > 0 || scrollDownBy > 0 || vOffset > centerPosition) {
                vOffset = centerPosition;
            }
        } else if (scrollType == ScrollType.CENTER_DOWN) {
            if (scrollUpBy > 0 || scrollDownBy > 0 || vOffset < centerPosition) {
                vOffset = centerPosition;
            }
        } else if (scrollType == ScrollType.RELATIVE) {
            if (scrollUpBy > 0) {
                vOffset = viewRect.y - scrollUpBy;
            } else if (scrollDownBy > 0) {
                vOffset = viewRect.y + scrollDownBy;
            }
        } else if (scrollType == ScrollType.MAKE_VISIBLE && (scrollUpBy > 0 || scrollDownBy > 0)) {
            vOffset = centerPosition;
        }
        JScrollPane scrollPane = this.myEditor.getScrollPane();
        hOffset = Math.max(0, hOffset);
        vOffset = Math.max(0, vOffset);
        hOffset = Math.min(scrollPane.getHorizontalScrollBar().getMaximum() - ScrollingModelImpl.getExtent(scrollPane.getHorizontalScrollBar()), hOffset);
        vOffset = Math.min(scrollPane.getVerticalScrollBar().getMaximum() - ScrollingModelImpl.getExtent(scrollPane.getVerticalScrollBar()), vOffset);
        return new Point(hOffset, vOffset);
    }

    @Nullable
    public JScrollBar getVerticalScrollBar() {
        this.assertIsDispatchThread();
        JScrollPane scrollPane = this.myEditor.getScrollPane();
        return scrollPane.getVerticalScrollBar();
    }

    @Nullable
    public JScrollBar getHorizontalScrollBar() {
        this.assertIsDispatchThread();
        if (this.myEditor.getScrollPane() == null) {
            return null;
        }
        return this.myEditor.getScrollPane().getHorizontalScrollBar();
    }

    public int getVerticalScrollOffset() {
        return ScrollingModelImpl.getOffset(this.getVerticalScrollBar());
    }

    public int getHorizontalScrollOffset() {
        return ScrollingModelImpl.getOffset(this.getHorizontalScrollBar());
    }

    private static int getOffset(JScrollBar scrollBar) {
        return scrollBar == null ? 0 : scrollBar.getValue();
    }

    private static int getExtent(JScrollBar scrollBar) {
        return scrollBar == null ? 0 : scrollBar.getModel().getExtent();
    }

    public void scrollVertically(int scrollOffset) {
        this.scrollToOffsets(this.getHorizontalScrollOffset(), scrollOffset);
    }

    private void _scrollVertically(int scrollOffset) {
        this.assertIsDispatchThread();
        if (this.myEditor.getScrollPane() == null) {
            return;
        }
        this.myEditor.validateSize();
        JScrollBar scrollbar = this.myEditor.getScrollPane().getVerticalScrollBar();
        if (scrollbar.getVisibleAmount() < Math.abs(scrollOffset - scrollbar.getValue()) + 50) {
            this.myEditor.stopOptimizedScrolling();
        }
        scrollbar.setValue(scrollOffset);
    }

    public void scrollHorizontally(int scrollOffset) {
        this.scrollToOffsets(scrollOffset, this.getVerticalScrollOffset());
    }

    private void _scrollHorizontally(int scrollOffset) {
        this.assertIsDispatchThread();
        if (this.myEditor.getScrollPane() == null) {
            return;
        }
        this.myEditor.validateSize();
        JScrollBar scrollbar = this.myEditor.getScrollPane().getHorizontalScrollBar();
        scrollbar.setValue(scrollOffset);
    }

    void scrollToOffsets(int hOffset, int vOffset) {
        if (this.myAccumulateViewportChanges) {
            this.myAccumulatedXOffset = hOffset;
            this.myAccumulatedYOffset = vOffset;
            return;
        }
        this.cancelAnimatedScrolling(false);
        VisibleEditorsTracker editorsTracker = VisibleEditorsTracker.getInstance();
        boolean useAnimation = !this.myEditor.getSettings().isAnimatedScrolling() || this.myAnimationDisabled || UISettings.isRemoteDesktopConnected() ? false : (CommandProcessor.getInstance().getCurrentCommand() == null ? this.myEditor.getComponent().isShowing() : (editorsTracker.getCurrentCommandStart() - editorsTracker.getLastCommandFinish() < 100L ? false : editorsTracker.wasEditorVisibleOnCommandStart(this.myEditor)));
        this.cancelAnimatedScrolling(false);
        if (useAnimation) {
            int startHOffset = this.getHorizontalScrollOffset();
            int startVOffset = this.getVerticalScrollOffset();
            if (startHOffset == hOffset && startVOffset == vOffset) {
                return;
            }
            try {
                this.myCurrentAnimationRequest = new AnimatedScrollingRunnable(startHOffset, startVOffset, hOffset, vOffset);
            }
            catch (NoAnimationRequiredException e) {
                this._scrollHorizontally(hOffset);
                this._scrollVertically(vOffset);
            }
        } else {
            this._scrollHorizontally(hOffset);
            this._scrollVertically(vOffset);
        }
    }

    public void addVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "addVisibleAreaListener"));
        }
        this.myVisibleAreaListeners.add(listener);
    }

    public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/ScrollingModelImpl", "removeVisibleAreaListener"));
        }
        boolean success = this.myVisibleAreaListeners.remove(listener);
        LOG.assertTrue(success);
    }

    public void commandStarted() {
        this.cancelAnimatedScrolling(true);
    }

    @Nullable
    private AnimatedScrollingRunnable cancelAnimatedScrolling(boolean scrollToTarget) {
        AnimatedScrollingRunnable request = this.myCurrentAnimationRequest;
        this.myCurrentAnimationRequest = null;
        if (request != null) {
            request.cancel(scrollToTarget);
        }
        return request;
    }

    public void dispose() {
        this.myEditor.getDocument().removeDocumentListener((DocumentListener)this.myDocumentListener);
    }

    public void beforeModalityStateChanged() {
        this.cancelAnimatedScrolling(true);
    }

    public boolean isScrollingNow() {
        return this.myCurrentAnimationRequest != null;
    }

    @Override
    public void accumulateViewportChanges() {
        this.myAccumulateViewportChanges = true;
    }

    @Override
    public void flushViewportChanges() {
        this.myAccumulateViewportChanges = false;
        if (this.myAccumulatedXOffset >= 0 && this.myAccumulatedYOffset >= 0) {
            this.scrollToOffsets(this.myAccumulatedXOffset, this.myAccumulatedYOffset);
            this.myAccumulatedYOffset = -1;
            this.myAccumulatedXOffset = -1;
            this.cancelAnimatedScrolling(true);
        }
    }

    private static class NoAnimationRequiredException
    extends Exception {
        private NoAnimationRequiredException() {
        }
    }

    private class AnimatedScrollingRunnable {
        private static final int SCROLL_DURATION = 100;
        private static final int SCROLL_INTERVAL = 10;
        private final int myStartHOffset;
        private final int myStartVOffset;
        private final int myEndHOffset;
        private final int myEndVOffset;
        private final int myAnimationDuration;
        private final ArrayList<Runnable> myPostRunnables = new ArrayList();
        private final int myHDist;
        private final int myVDist;
        private final int myMaxDistToScroll;
        private final double myTotalDist;
        private final double myScrollDist;
        private final int myStepCount;
        private final double myPow;
        private final Animator myAnimator;

        public AnimatedScrollingRunnable(int startHOffset, int startVOffset, int endHOffset, int endVOffset) throws NoAnimationRequiredException {
            this.myStartHOffset = startHOffset;
            this.myStartVOffset = startVOffset;
            this.myEndHOffset = endHOffset;
            this.myEndVOffset = endVOffset;
            this.myHDist = Math.abs(this.myEndHOffset - this.myStartHOffset);
            this.myVDist = Math.abs(this.myEndVOffset - this.myStartVOffset);
            this.myMaxDistToScroll = ScrollingModelImpl.this.myEditor.getLineHeight() * 50;
            this.myTotalDist = Math.sqrt((double)this.myHDist * (double)this.myHDist + (double)this.myVDist * (double)this.myVDist);
            this.myScrollDist = Math.min(this.myTotalDist, (double)this.myMaxDistToScroll);
            this.myAnimationDuration = this.calcAnimationDuration();
            if (this.myAnimationDuration < 20) {
                throw new NoAnimationRequiredException();
            }
            this.myStepCount = this.myAnimationDuration / 10 - 1;
            double firstStepTime = 1.0 / (double)this.myStepCount;
            double firstScrollDist = 5.0;
            if (this.myTotalDist > this.myScrollDist) {
                firstScrollDist *= this.myTotalDist / this.myScrollDist;
                firstScrollDist = Math.min(firstScrollDist, (double)(ScrollingModelImpl.this.myEditor.getLineHeight() * 5));
            }
            this.myPow = this.myScrollDist > 0.0 ? this.setupPow(firstStepTime, firstScrollDist / this.myScrollDist) : 1.0;
            this.myAnimator = new Animator("Animated scroller", this.myStepCount, 100, false, true){

                public void paintNow(int frame, int totalFrames, int cycle) {
                    double time = (double)(frame + 1) / (double)totalFrames;
                    double fraction = AnimatedScrollingRunnable.this.timeToFraction(time);
                    int hOffset = (int)((double)AnimatedScrollingRunnable.this.myStartHOffset + (double)(AnimatedScrollingRunnable.this.myEndHOffset - AnimatedScrollingRunnable.this.myStartHOffset) * fraction + 0.5);
                    int vOffset = (int)((double)AnimatedScrollingRunnable.this.myStartVOffset + (double)(AnimatedScrollingRunnable.this.myEndVOffset - AnimatedScrollingRunnable.this.myStartVOffset) * fraction + 0.5);
                    ScrollingModelImpl.this._scrollHorizontally(hOffset);
                    ScrollingModelImpl.this._scrollVertically(vOffset);
                }

                protected void paintCycleEnd() {
                    AnimatedScrollingRunnable.this.finish(true);
                }
            };
            this.myAnimator.resume();
        }

        @NotNull
        public Rectangle getTargetVisibleArea() {
            Rectangle viewRect = ScrollingModelImpl.this.getVisibleArea();
            Rectangle rectangle = new Rectangle(this.myEndHOffset, this.myEndVOffset, viewRect.width, viewRect.height);
            if (rectangle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/ScrollingModelImpl$AnimatedScrollingRunnable", "getTargetVisibleArea"));
            }
            return rectangle;
        }

        public void cancel(boolean scrollToTarget) {
            ScrollingModelImpl.this.assertIsDispatchThread();
            this.finish(scrollToTarget);
        }

        public void addPostRunnable(Runnable runnable) {
            this.myPostRunnables.add(runnable);
        }

        private void finish(boolean scrollToTarget) {
            if (scrollToTarget || !this.myPostRunnables.isEmpty()) {
                ScrollingModelImpl.this._scrollHorizontally(this.myEndHOffset);
                ScrollingModelImpl.this._scrollVertically(this.myEndVOffset);
                this.executePostRunnables();
            }
            Disposer.dispose((Disposable)this.myAnimator);
            if (ScrollingModelImpl.this.myCurrentAnimationRequest == this) {
                ScrollingModelImpl.this.myCurrentAnimationRequest = null;
            }
        }

        private void executePostRunnables() {
            for (Runnable runnable : this.myPostRunnables) {
                runnable.run();
            }
        }

        private double timeToFraction(double time) {
            if (time > 0.5) {
                return 1.0 - this.timeToFraction(1.0 - time);
            }
            double fraction = Math.pow(time * 2.0, this.myPow) / 2.0;
            if (this.myTotalDist > (double)this.myMaxDistToScroll) {
                fraction *= (double)this.myMaxDistToScroll / this.myTotalDist;
            }
            return fraction;
        }

        private double setupPow(double inTime, double moveBy) {
            double pow = Math.log(2.0 * moveBy) / Math.log(2.0 * inTime);
            if (pow < 1.0) {
                pow = 1.0;
            }
            return pow;
        }

        private int calcAnimationDuration() {
            int lineHeight = ScrollingModelImpl.this.myEditor.getLineHeight();
            double lineDist = this.myTotalDist / (double)lineHeight;
            double part = (lineDist - 1.0) / 10.0;
            if (part > 1.0) {
                part = 1.0;
            }
            return (int)(part * 100.0);
        }
    }
}

