/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.RangeHighlighterData;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.MarkupEditorFilter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangeHighlighterImpl
extends RangeMarkerImpl
implements RangeHighlighterEx,
Getter<RangeHighlighterEx> {
    private final RangeHighlighterData data;

    RangeHighlighterImpl(@NotNull MarkupModel model, int start, int end, int layer, @NotNull HighlighterTargetArea target, TextAttributes textAttributes, boolean greedyToLeft, boolean greedyToRight) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "<init>"));
        }
        super((DocumentEx)model.getDocument(), start, end, false);
        this.data = new RangeHighlighterData(model, target, textAttributes){

            @Override
            @NotNull
            public RangeHighlighterEx getRangeHighlighter() {
                RangeHighlighterImpl rangeHighlighterImpl = RangeHighlighterImpl.this;
                if (rangeHighlighterImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterImpl$1", "getRangeHighlighter"));
                }
                return rangeHighlighterImpl;
            }
        };
        this.registerInTree(start, end, greedyToLeft, greedyToRight, layer);
    }

    protected RangeHighlighterData getData() {
        return this.data;
    }

    @Override
    protected void registerInTree(int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        ((MarkupModelEx)this.data.getMarkupModel()).addRangeHighlighter(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    @Override
    protected boolean unregisterInTree() {
        if (!this.isValid()) {
            return false;
        }
        this.getData().getMarkupModel().removeHighlighter((RangeHighlighter)this);
        return true;
    }

    public RangeHighlighterImpl get() {
        return this;
    }

    public TextAttributes getTextAttributes() {
        return this.getData().getTextAttributes();
    }

    @Override
    public void setTextAttributes(@NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "setTextAttributes"));
        }
        this.getData().setTextAttributes(textAttributes);
    }

    @NotNull
    RangeHighlighterData.ChangeResult changeAttributesNoEvents(@NotNull Consumer<RangeHighlighterEx> change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "changeAttributesNoEvents"));
        }
        RangeHighlighterData.ChangeResult changeResult = this.getData().changeAttributesInBatch(change);
        if (changeResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "changeAttributesNoEvents"));
        }
        return changeResult;
    }

    @Override
    public int getLayer() {
        RangeHighlighterTree.RHNode node = (RangeHighlighterTree.RHNode)this.myNode;
        return node == null ? -1 : node.myLayer;
    }

    @NotNull
    public HighlighterTargetArea getTargetArea() {
        HighlighterTargetArea highlighterTargetArea = this.getData().getTargetArea();
        if (highlighterTargetArea == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "getTargetArea"));
        }
        return highlighterTargetArea;
    }

    public LineMarkerRenderer getLineMarkerRenderer() {
        return this.getData().getLineMarkerRenderer();
    }

    public void setLineMarkerRenderer(LineMarkerRenderer renderer) {
        this.getData().setLineMarkerRenderer(renderer);
    }

    public CustomHighlighterRenderer getCustomRenderer() {
        return this.getData().getCustomRenderer();
    }

    public void setCustomRenderer(CustomHighlighterRenderer renderer) {
        this.getData().setCustomRenderer(renderer);
    }

    public GutterIconRenderer getGutterIconRenderer() {
        return this.getData().getGutterIconRenderer();
    }

    public void setGutterIconRenderer(GutterIconRenderer renderer) {
        this.getData().setGutterIconRenderer(renderer);
    }

    public Color getErrorStripeMarkColor() {
        return this.getData().getErrorStripeMarkColor();
    }

    public void setErrorStripeMarkColor(Color color) {
        this.getData().setErrorStripeMarkColor(color);
    }

    public Object getErrorStripeTooltip() {
        return this.getData().getErrorStripeTooltip();
    }

    public void setErrorStripeTooltip(Object tooltipObject) {
        this.getData().setErrorStripeTooltip(tooltipObject);
    }

    public boolean isThinErrorStripeMark() {
        return this.getData().isThinErrorStripeMark();
    }

    public void setThinErrorStripeMark(boolean value) {
        this.getData().setThinErrorStripeMark(value);
    }

    public Color getLineSeparatorColor() {
        return this.getData().getLineSeparatorColor();
    }

    public void setLineSeparatorColor(Color color) {
        this.getData().setLineSeparatorColor(color);
    }

    public void setLineSeparatorRenderer(LineSeparatorRenderer renderer) {
        this.getData().setLineSeparatorRenderer(renderer);
    }

    public LineSeparatorRenderer getLineSeparatorRenderer() {
        return this.getData().getLineSeparatorRenderer();
    }

    public SeparatorPlacement getLineSeparatorPlacement() {
        return this.getData().getLineSeparatorPlacement();
    }

    public void setLineSeparatorPlacement(@Nullable SeparatorPlacement placement) {
        this.getData().setLineSeparatorPlacement(placement);
    }

    public void setEditorFilter(@NotNull MarkupEditorFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "setEditorFilter"));
        }
        this.getData().setEditorFilter(filter);
    }

    @NotNull
    public MarkupEditorFilter getEditorFilter() {
        MarkupEditorFilter markupEditorFilter = this.getData().getEditorFilter();
        if (markupEditorFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/RangeHighlighterImpl", "getEditorFilter"));
        }
        return markupEditorFilter;
    }

    @Override
    public boolean isAfterEndOfLine() {
        return this.getData().isAfterEndOfLine();
    }

    @Override
    public void setAfterEndOfLine(boolean value) {
        this.getData().setAfterEndOfLine(value);
    }

    @Override
    public int getAffectedAreaStartOffset() {
        return this.getData().getAffectedAreaStartOffset();
    }

    @Override
    public int getAffectedAreaEndOffset() {
        return this.getData().getAffectedAreaEndOffset();
    }

    @Override
    public String toString() {
        return "RangeHighlighter: (" + this.getStartOffset() + "," + this.getEndOffset() + "); layer:" + this.getLayer() + "; tooltip: " + this.getData().getErrorStripeTooltip();
    }
}

