/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DisposableIterator;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.SweepProcessor;
import com.intellij.openapi.editor.impl.PersistentRangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterData;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkupModelImpl
extends UserDataHolderBase
implements MarkupModelEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.MarkupModelImpl");
    private final DocumentEx myDocument;
    private RangeHighlighter[] myCachedHighlighters;
    private final List<MarkupModelListener> myListeners;
    private final RangeHighlighterTree myHighlighterTree;

    MarkupModelImpl(@NotNull DocumentEx document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDocument = document;
        this.myHighlighterTree = new RangeHighlighterTree(this.myDocument, this);
    }

    @Override
    public void dispose() {
        this.myHighlighterTree.dispose();
    }

    @NotNull
    public RangeHighlighter addLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        if (this.isNotValidLine(lineNumber)) {
            throw new IndexOutOfBoundsException("lineNumber:" + lineNumber + ". Must be in [0, " + (this.getDocument().getLineCount() - 1) + "]");
        }
        int offset = this.getDocument().getLineStartOffset(lineNumber);
        RangeHighlighter rangeHighlighter = this.addRangeHighlighter(offset, offset, layer, textAttributes, HighlighterTargetArea.LINES_IN_RANGE);
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addLineHighlighter"));
        }
        return rangeHighlighter;
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, TextAttributes textAttributes) {
        if (this.isNotValidLine(lineNumber)) {
            return null;
        }
        int offset = this.getDocument().getLineStartOffset(lineNumber);
        return this.addRangeHighlighter(PersistentRangeHighlighterImpl.create(this, offset, layer, HighlighterTargetArea.LINES_IN_RANGE, textAttributes, false), null);
    }

    private boolean isNotValidLine(int lineNumber) {
        return lineNumber >= this.getDocument().getLineCount() || lineNumber < 0;
    }

    @NotNull
    public RangeHighlighter[] getAllHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCachedHighlighters == null) {
            int size = this.myHighlighterTree.size();
            if (size == 0) {
                if (RangeHighlighter.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "getAllHighlighters"));
                }
                return RangeHighlighter.EMPTY_ARRAY;
            }
            ArrayList list = new ArrayList(size);
            this.myHighlighterTree.process(new CommonProcessors.CollectProcessor(list));
            this.myCachedHighlighters = list.toArray(new RangeHighlighter[list.size()]);
        }
        if (this.myCachedHighlighters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "getAllHighlighters"));
        }
        return this.myCachedHighlighters;
    }

    @Override
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, @Nullable Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighterAndChangeAttributes"));
        }
        return this.addRangeHighlighter(isPersistent ? PersistentRangeHighlighterImpl.create(this, startOffset, layer, targetArea, textAttributes, true) : new RangeHighlighterImpl(this, startOffset, endOffset, layer, targetArea, textAttributes, false, false), changeAttributesAction);
    }

    private RangeHighlighterEx addRangeHighlighter(@NotNull RangeHighlighterImpl highlighter, @Nullable Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        if (changeAttributesAction != null) {
            highlighter.changeAttributesNoEvents(changeAttributesAction);
        }
        this.fireAfterAdded(highlighter);
        return highlighter;
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "changeAttributesInBatch"));
        }
        if (changeAttributesAction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/MarkupModelImpl", "changeAttributesInBatch"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighterData.ChangeResult changed = ((RangeHighlighterImpl)highlighter).changeAttributesNoEvents(changeAttributesAction);
        if (changed != RangeHighlighterData.ChangeResult.NOT_CHANGED) {
            this.fireAttributesChanged(highlighter, changed == RangeHighlighterData.ChangeResult.RENDERERS_CHANGED);
        }
    }

    @Override
    public void addRangeHighlighter(RangeHighlighterEx marker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myHighlighterTree.addInterval(marker, start, end, greedyToLeft, greedyToRight, layer);
    }

    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighter"));
        }
        RangeHighlighterEx rangeHighlighterEx = this.addRangeHighlighterAndChangeAttributes(startOffset, endOffset, layer, textAttributes, targetArea, false, null);
        if (rangeHighlighterEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addRangeHighlighter"));
        }
        return rangeHighlighterEx;
    }

    public void removeHighlighter(@NotNull RangeHighlighter segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "removeHighlighter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        if (!segmentHighlighter.isValid()) {
            return;
        }
        boolean removed = this.myHighlighterTree.removeInterval((RangeHighlighterEx)segmentHighlighter);
        LOG.assertTrue(removed);
    }

    public void removeAllHighlighters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCachedHighlighters = null;
        for (RangeHighlighter highlighter : this.getAllHighlighters()) {
            highlighter.dispose();
        }
        this.myHighlighterTree.clear();
    }

    @NotNull
    public Document getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "getDocument"));
        }
        return documentEx;
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, final @NotNull MarkupModelListener listener) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addMarkupModelListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/MarkupModelImpl", "addMarkupModelListener"));
        }
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                MarkupModelImpl.this.removeMarkupModelListener(listener);
            }
        });
    }

    public void removeMarkupModelListener(@NotNull MarkupModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "removeMarkupModelListener"));
        }
        boolean success = this.myListeners.remove(listener);
        LOG.assertTrue(success);
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "setRangeHighlighterAttributes"));
        }
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/MarkupModelImpl", "setRangeHighlighterAttributes"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((RangeHighlighterEx)highlighter).setTextAttributes(textAttributes);
    }

    @Override
    public void fireAttributesChanged(@NotNull RangeHighlighterEx segmentHighlighter, boolean renderersChanged) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "fireAttributesChanged"));
        }
        for (MarkupModelListener listener : this.myListeners) {
            listener.attributesChanged(segmentHighlighter, renderersChanged);
        }
    }

    @Override
    public void fireAfterAdded(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "fireAfterAdded"));
        }
        for (MarkupModelListener listener : this.myListeners) {
            listener.afterAdded(segmentHighlighter);
        }
    }

    @Override
    public void fireBeforeRemoved(@NotNull RangeHighlighterEx segmentHighlighter) {
        if (segmentHighlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "fireBeforeRemoved"));
        }
        for (MarkupModelListener listener : this.myListeners) {
            listener.beforeRemoved(segmentHighlighter);
        }
    }

    @Override
    public boolean containsHighlighter(final @NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/MarkupModelImpl", "containsHighlighter"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        return !this.myHighlighterTree.processOverlappingWith(highlighter.getStartOffset(), highlighter.getEndOffset(), new Processor<RangeHighlighterEx>(){

            public boolean process(RangeHighlighterEx h) {
                return h.getId() != ((RangeHighlighterEx)highlighter).getId();
            }
        });
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/MarkupModelImpl", "processRangeHighlightersOverlappingWith"));
        }
        return this.myHighlighterTree.processOverlappingWith(start, end, processor);
    }

    @Override
    public boolean processRangeHighlightersOutside(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/MarkupModelImpl", "processRangeHighlightersOutside"));
        }
        return this.myHighlighterTree.processOverlappingWithOutside(start, end, processor);
    }

    @Override
    @NotNull
    public DisposableIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        DisposableIterator<RangeHighlighterEx> disposableIterator = this.myHighlighterTree.overlappingIterator(startOffset, endOffset);
        if (disposableIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/MarkupModelImpl", "overlappingIterator"));
        }
        return disposableIterator;
    }

    @Override
    public boolean sweep(int start, int end, @NotNull SweepProcessor<RangeHighlighterEx> sweepProcessor) {
        if (sweepProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/openapi/editor/impl/MarkupModelImpl", "sweep"));
        }
        return this.myHighlighterTree.sweep(start, end, sweepProcessor);
    }
}

