/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.DisposableIterator;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IterationState {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.IterationState");
    private static final Comparator<RangeHighlighterEx> HIGHLIGHTER_COMPARATOR = new Comparator<RangeHighlighterEx>(){

        @Override
        public int compare(RangeHighlighterEx o1, RangeHighlighterEx o2) {
            Color back2;
            Color fore2;
            TextAttributes a2;
            int result = LayerComparator.INSTANCE.compare(o1, o2);
            if (result != 0) {
                return result;
            }
            TextAttributes a1 = o1.getTextAttributes();
            if (a1 == null ^ (a2 = o2.getTextAttributes()) == null) {
                return a1 == null ? 1 : -1;
            }
            if (a1 == null) {
                return result;
            }
            Color fore1 = a1.getForegroundColor();
            if (fore1 == null ^ (fore2 = a2.getForegroundColor()) == null) {
                return fore1 == null ? 1 : -1;
            }
            Color back1 = a1.getBackgroundColor();
            if (back1 == null ^ (back2 = a2.getBackgroundColor()) == null) {
                return back1 == null ? 1 : -1;
            }
            return result;
        }
    };
    private final TextAttributes myMergedAttributes;
    private final HighlighterIterator myHighlighterIterator;
    private final HighlighterSweep myView;
    private final HighlighterSweep myDoc;
    private int myStartOffset;
    private int myEndOffset;
    private final int myEnd;
    private final int[] mySelectionStarts;
    private final int[] mySelectionEnds;
    private final int[] myVirtualSelectionStarts;
    private final int[] myVirtualSelectionEnds;
    private int myCurrentSelectionIndex;
    private int myCurrentVirtualSelectionIndex;
    private boolean myCurrentLineHasVirtualSelection;
    private int myCurrentPastLineEndBackgroundSegment;
    private Color myCurrentBackgroundColor;
    private final List<RangeHighlighterEx> myCurrentHighlighters;
    private final FoldingModelEx myFoldingModel;
    private FoldRegion myCurrentFold;
    private final TextAttributes myFoldTextAttributes;
    private final TextAttributes mySelectionAttributes;
    private final TextAttributes myCaretRowAttributes;
    private final Color myDefaultBackground;
    private final Color myDefaultForeground;
    private final int myCaretRowStart;
    private final int myCaretRowEnd;
    private final List<TextAttributes> myCachedAttributesList;
    private final DocumentEx myDocument;
    private final EditorEx myEditor;
    private final Color myReadOnlyColor;

    public IterationState(@NotNull EditorEx editor, int start, int end, boolean useCaretAndSelection) {
        boolean hasSelection;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/IterationState", "<init>"));
        }
        this.myMergedAttributes = new TextAttributes();
        this.myCurrentSelectionIndex = 0;
        this.myCurrentVirtualSelectionIndex = 0;
        this.myCurrentHighlighters = new ArrayList<RangeHighlighterEx>();
        this.myCurrentFold = null;
        this.myCachedAttributesList = new ArrayList<TextAttributes>(5);
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myDocument = editor.getDocument();
        this.myStartOffset = start;
        this.myEnd = end;
        this.myEditor = editor;
        LOG.assertTrue(this.myStartOffset <= this.myEnd);
        this.myHighlighterIterator = editor.getHighlighter().createIterator(start);
        boolean bl = hasSelection = useCaretAndSelection && (editor.getCaretModel().supportsMultipleCarets() || editor.getSelectionModel().hasSelection() || editor.getSelectionModel().hasBlockSelection());
        if (!hasSelection) {
            this.mySelectionStarts = ArrayUtilRt.EMPTY_INT_ARRAY;
            this.mySelectionEnds = ArrayUtilRt.EMPTY_INT_ARRAY;
            this.myVirtualSelectionStarts = ArrayUtilRt.EMPTY_INT_ARRAY;
            this.myVirtualSelectionEnds = ArrayUtilRt.EMPTY_INT_ARRAY;
        } else if (editor.getCaretModel().supportsMultipleCarets()) {
            List carets = editor.getCaretModel().getAllCarets();
            this.mySelectionStarts = new int[carets.size()];
            this.mySelectionEnds = new int[carets.size()];
            this.myVirtualSelectionStarts = new int[carets.size()];
            this.myVirtualSelectionEnds = new int[carets.size()];
            for (int i = 0; i < carets.size(); ++i) {
                Caret caret = (Caret)carets.get(i);
                this.mySelectionStarts[i] = caret.getSelectionStart();
                this.mySelectionEnds[i] = caret.getSelectionEnd();
                this.myVirtualSelectionStarts[i] = caret.getSelectionStartPosition().column - editor.offsetToVisualPosition((int)this.mySelectionStarts[i]).column;
                this.myVirtualSelectionEnds[i] = caret.getSelectionEndPosition().column - editor.offsetToVisualPosition((int)this.mySelectionEnds[i]).column;
            }
        } else {
            this.mySelectionStarts = editor.getSelectionModel().getBlockSelectionStarts();
            this.mySelectionEnds = editor.getSelectionModel().getBlockSelectionEnds();
            this.myVirtualSelectionStarts = new int[this.mySelectionStarts.length];
            this.myVirtualSelectionEnds = new int[this.mySelectionEnds.length];
        }
        this.myFoldingModel = editor.getFoldingModel();
        this.myFoldTextAttributes = this.myFoldingModel.getPlaceholderAttributes();
        this.mySelectionAttributes = editor.getSelectionModel().getTextAttributes();
        this.myReadOnlyColor = this.myEditor.getColorsScheme().getColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR);
        CaretModel caretModel = editor.getCaretModel();
        this.myCaretRowAttributes = editor.isRendererMode() ? null : caretModel.getTextAttributes();
        this.myDefaultBackground = editor.getColorsScheme().getDefaultBackground();
        this.myDefaultForeground = editor.getColorsScheme().getDefaultForeground();
        this.myCaretRowStart = caretModel.getVisualLineStart();
        this.myCaretRowEnd = caretModel.getVisualLineEnd();
        MarkupModelEx editorMarkup = editor.getMarkupModel();
        this.myView = new HighlighterSweep(editorMarkup, start, this.myEnd);
        MarkupModelEx docMarkup = (MarkupModelEx)DocumentMarkupModel.forDocument(editor.getDocument(), editor.getProject(), true);
        this.myDoc = new HighlighterSweep(docMarkup, start, this.myEnd);
        this.myEndOffset = this.myStartOffset;
        this.advance();
    }

    public void dispose() {
        this.myView.dispose();
        this.myDoc.dispose();
    }

    private boolean skipHighlighter(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/IterationState", "skipHighlighter"));
        }
        if (!highlighter.isValid() || highlighter.isAfterEndOfLine() || highlighter.getTextAttributes() == null) {
            return true;
        }
        FoldRegion region = this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaStartOffset());
        if (region != null && region == this.myFoldingModel.getCollapsedRegionAtOffset(highlighter.getAffectedAreaEndOffset())) {
            return true;
        }
        return !highlighter.getEditorFilter().avaliableIn((Editor)this.myEditor);
    }

    public void advance() {
        this.myStartOffset = this.myEndOffset;
        this.advanceSegmentHighlighters();
        this.advanceCurrentSelectionIndex();
        this.advanceCurrentVirtualSelectionIndex();
        this.myCurrentFold = this.myFoldingModel.fetchOutermost(this.myStartOffset);
        if (this.myCurrentFold != null) {
            this.myEndOffset = this.myCurrentFold.getEndOffset();
        } else {
            this.myEndOffset = Math.min(this.getHighlighterEnd(this.myStartOffset), this.getSelectionEnd());
            this.myEndOffset = Math.min(this.myEndOffset, this.getMinSegmentHighlightersEnd());
            this.myEndOffset = Math.min(this.myEndOffset, this.getFoldRangesEnd(this.myStartOffset));
            this.myEndOffset = Math.min(this.myEndOffset, this.getCaretEnd(this.myStartOffset));
            this.myEndOffset = Math.min(this.myEndOffset, this.getGuardedBlockEnd(this.myStartOffset));
        }
        this.reinit();
    }

    private int getHighlighterEnd(int start) {
        while (!this.myHighlighterIterator.atEnd()) {
            int end = this.myHighlighterIterator.getEnd();
            if (end > start) {
                return end;
            }
            this.myHighlighterIterator.advance();
        }
        return this.myEnd;
    }

    private int getCaretEnd(int start) {
        if (this.myCaretRowStart > start) {
            return this.myCaretRowStart;
        }
        if (this.myCaretRowEnd > start) {
            return this.myCaretRowEnd;
        }
        return this.myEnd;
    }

    private int getGuardedBlockEnd(int start) {
        List<RangeMarker> blocks = this.myDocument.getGuardedBlocks();
        int min = this.myEnd;
        for (int i = 0; i < blocks.size(); ++i) {
            RangeMarker block = blocks.get(i);
            if (block.getStartOffset() > start) {
                min = Math.min(min, block.getStartOffset());
                continue;
            }
            if (block.getEndOffset() <= start) continue;
            min = Math.min(min, block.getEndOffset());
        }
        return min;
    }

    private void advanceCurrentSelectionIndex() {
        while (this.myCurrentSelectionIndex < this.mySelectionEnds.length && this.myStartOffset >= this.mySelectionEnds[this.myCurrentSelectionIndex]) {
            ++this.myCurrentSelectionIndex;
        }
    }

    private void advanceCurrentVirtualSelectionIndex() {
        while (this.myCurrentVirtualSelectionIndex < this.mySelectionEnds.length && (this.myStartOffset > this.mySelectionEnds[this.myCurrentVirtualSelectionIndex] || this.myVirtualSelectionEnds[this.myCurrentVirtualSelectionIndex] <= 0)) {
            ++this.myCurrentVirtualSelectionIndex;
        }
    }

    private int getSelectionEnd() {
        if (this.myCurrentSelectionIndex >= this.mySelectionStarts.length) {
            return this.myEnd;
        }
        if (this.myStartOffset < this.mySelectionStarts[this.myCurrentSelectionIndex]) {
            return this.mySelectionStarts[this.myCurrentSelectionIndex];
        }
        return this.mySelectionEnds[this.myCurrentSelectionIndex];
    }

    private boolean isInSelection() {
        return this.myCurrentSelectionIndex < this.mySelectionStarts.length && this.myStartOffset >= this.mySelectionStarts[this.myCurrentSelectionIndex];
    }

    private void advanceSegmentHighlighters() {
        this.myDoc.advance();
        this.myView.advance();
        for (int i = this.myCurrentHighlighters.size() - 1; i >= 0; --i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (highlighter.getAffectedAreaEndOffset() > this.myStartOffset) continue;
            this.myCurrentHighlighters.remove(i);
        }
    }

    private int getFoldRangesEnd(int startOffset) {
        int end = this.myEnd;
        FoldRegion[] topLevelCollapsed = this.myFoldingModel.fetchTopLevel();
        if (topLevelCollapsed != null) {
            for (int i = this.myFoldingModel.getLastCollapsedRegionBefore(startOffset) + 1; i >= 0 && i < topLevelCollapsed.length; ++i) {
                int rangeEnd;
                FoldRegion range = topLevelCollapsed[i];
                if (!range.isValid() || (rangeEnd = range.getStartOffset()) <= startOffset) continue;
                if (rangeEnd >= end) break;
                end = rangeEnd;
            }
        }
        return end;
    }

    private int getMinSegmentHighlightersEnd() {
        int end = this.myEnd;
        for (int i = 0; i < this.myCurrentHighlighters.size(); ++i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (highlighter.getAffectedAreaEndOffset() >= end) continue;
            end = highlighter.getAffectedAreaEndOffset();
        }
        end = Math.min(end, this.myDoc.getMinSegmentHighlighterEnd());
        end = Math.min(end, this.myView.getMinSegmentHighlighterEnd());
        return end;
    }

    private void reinit() {
        if (this.myHighlighterIterator.atEnd()) {
            return;
        }
        boolean isInSelection = this.isInSelection();
        boolean isInCaretRow = this.myStartOffset >= this.myCaretRowStart && this.myStartOffset < this.myCaretRowEnd;
        boolean isInGuardedBlock = this.myDocument.getOffsetGuard(this.myStartOffset) != null;
        TextAttributes syntax = this.myHighlighterIterator.getTextAttributes();
        TextAttributes selection = isInSelection ? this.mySelectionAttributes : null;
        TextAttributes caret = isInCaretRow ? this.myCaretRowAttributes : null;
        TextAttributes fold = this.myCurrentFold != null ? this.myFoldTextAttributes : null;
        TextAttributes guard = isInGuardedBlock ? new TextAttributes(null, this.myReadOnlyColor, null, EffectType.BOXED, 0) : null;
        int size = this.myCurrentHighlighters.size();
        if (size > 1) {
            ContainerUtil.quickSort(this.myCurrentHighlighters, HIGHLIGHTER_COMPARATOR);
        }
        for (int i = 0; i < size; ++i) {
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (highlighter.getTextAttributes() != TextAttributes.ERASE_MARKER) continue;
            syntax = null;
        }
        List<TextAttributes> cachedAttributes = this.myCachedAttributesList;
        cachedAttributes.clear();
        int selectionAttributesIndex = -1;
        for (int i = 0; i < size; ++i) {
            TextAttributes textAttributes;
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (highlighter.getLayer() < 6000) {
                if (selectionAttributesIndex < 0) {
                    selectionAttributesIndex = cachedAttributes.size();
                }
                if (selection != null) {
                    cachedAttributes.add(selection);
                    selection = null;
                }
            }
            if (syntax != null && highlighter.getLayer() < 2000) {
                if (fold != null) {
                    cachedAttributes.add(fold);
                    fold = null;
                }
                cachedAttributes.add(syntax);
                syntax = null;
            }
            if (guard != null && highlighter.getLayer() < 3500) {
                cachedAttributes.add(guard);
                guard = null;
            }
            if (caret != null && highlighter.getLayer() < 1000) {
                cachedAttributes.add(caret);
                caret = null;
            }
            if ((textAttributes = highlighter.getTextAttributes()) == null || textAttributes == TextAttributes.ERASE_MARKER) continue;
            cachedAttributes.add(textAttributes);
        }
        if (selectionAttributesIndex < 0) {
            selectionAttributesIndex = cachedAttributes.size();
        }
        if (selection != null) {
            cachedAttributes.add(selection);
        }
        if (fold != null) {
            cachedAttributes.add(fold);
        }
        if (guard != null) {
            cachedAttributes.add(guard);
        }
        if (caret != null) {
            cachedAttributes.add(caret);
        }
        if (syntax != null) {
            cachedAttributes.add(syntax);
        }
        Color fore = null;
        Color back = isInGuardedBlock ? this.myReadOnlyColor : null;
        Color effect = null;
        EffectType effectType = null;
        int fontType = 0;
        boolean selectionBackgroundIsPotentiallyVisible = cachedAttributes.isEmpty();
        for (int i = 0; i < cachedAttributes.size(); ++i) {
            TextAttributes attrs = cachedAttributes.get(i);
            if (fore == null) {
                fore = IterationState.ifDiffers(attrs.getForegroundColor(), this.myDefaultForeground);
            }
            if (back == null) {
                if (isInSelection && i == selectionAttributesIndex || !isInSelection && i >= selectionAttributesIndex) {
                    selectionBackgroundIsPotentiallyVisible = true;
                }
                back = IterationState.ifDiffers(attrs.getBackgroundColor(), this.myDefaultBackground);
            }
            if (fontType == 0) {
                fontType = attrs.getFontType();
            }
            if (effect != null) continue;
            effect = attrs.getEffectColor();
            effectType = attrs.getEffectType();
        }
        if (fore == null) {
            fore = this.myDefaultForeground;
        }
        if (back == null) {
            back = this.myDefaultBackground;
        }
        if (effectType == null) {
            effectType = EffectType.BOXED;
        }
        this.myMergedAttributes.setAttributes(fore, back, effect, null, effectType, fontType);
        this.myCurrentBackgroundColor = back;
        if (selectionBackgroundIsPotentiallyVisible && this.myCurrentVirtualSelectionIndex < this.mySelectionStarts.length && this.myStartOffset == this.mySelectionEnds[this.myCurrentVirtualSelectionIndex]) {
            this.myCurrentLineHasVirtualSelection = true;
            this.myCurrentPastLineEndBackgroundSegment = this.myVirtualSelectionStarts[this.myCurrentVirtualSelectionIndex] > 0 ? 0 : 1;
        } else {
            this.myCurrentLineHasVirtualSelection = false;
            this.myCurrentPastLineEndBackgroundSegment = 0;
        }
    }

    @Nullable
    private static Color ifDiffers(Color c1, Color c2) {
        return Comparing.equal((Object)c1, (Object)c2) ? null : c1;
    }

    public boolean atEnd() {
        return this.myStartOffset >= this.myEnd;
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public TextAttributes getMergedAttributes() {
        TextAttributes textAttributes = this.myMergedAttributes;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/IterationState", "getMergedAttributes"));
        }
        return textAttributes;
    }

    public FoldRegion getCurrentFold() {
        return this.myCurrentFold;
    }

    public boolean hasPastLineEndBackgroundSegment() {
        return this.myCurrentLineHasVirtualSelection && this.myCurrentPastLineEndBackgroundSegment < 2;
    }

    public int getPastLineEndBackgroundSegmentWidth() {
        switch (this.myCurrentPastLineEndBackgroundSegment) {
            case 0: {
                return this.myVirtualSelectionStarts[this.myCurrentVirtualSelectionIndex];
            }
            case 1: {
                return this.myVirtualSelectionEnds[this.myCurrentVirtualSelectionIndex] - this.myVirtualSelectionStarts[this.myCurrentVirtualSelectionIndex];
            }
        }
        return 0;
    }

    @NotNull
    public TextAttributes getPastLineEndBackgroundAttributes() {
        this.myMergedAttributes.setBackgroundColor(this.myCurrentPastLineEndBackgroundSegment == 1 ? this.mySelectionAttributes.getBackgroundColor() : this.myCurrentBackgroundColor);
        TextAttributes textAttributes = this.myMergedAttributes;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/IterationState", "getPastLineEndBackgroundAttributes"));
        }
        return textAttributes;
    }

    public void advanceToNextPastLineEndBackgroundSegment() {
        ++this.myCurrentPastLineEndBackgroundSegment;
    }

    public boolean hasPastFileEndBackgroundSegments() {
        boolean bl = this.myCurrentLineHasVirtualSelection = this.myVirtualSelectionEnds.length > 0 && this.myVirtualSelectionEnds[this.myVirtualSelectionEnds.length - 1] > 0 && this.myEndOffset == this.myEnd && this.mySelectionEnds[this.mySelectionStarts.length - 1] == this.myEndOffset;
        if (this.myCurrentLineHasVirtualSelection) {
            this.myCurrentVirtualSelectionIndex = this.myVirtualSelectionStarts.length - 1;
            this.myCurrentPastLineEndBackgroundSegment = this.myVirtualSelectionStarts[this.myCurrentVirtualSelectionIndex] > 0 ? 0 : 1;
            this.myCurrentBackgroundColor = this.myEndOffset >= this.myCaretRowStart ? this.myCaretRowAttributes.getBackgroundColor() : this.myDefaultBackground;
        }
        return this.myCurrentLineHasVirtualSelection;
    }

    @Nullable
    public Color getPastFileEndBackground() {
        boolean isInCaretRow = this.myEditor.getCaretModel().getLogicalPosition().line >= this.myDocument.getLineCount() - 1;
        Color caret = isInCaretRow && this.myCaretRowAttributes != null ? this.myCaretRowAttributes.getBackgroundColor() : null;
        ContainerUtil.quickSort(this.myCurrentHighlighters, (Comparator)LayerComparator.INSTANCE);
        for (int i = 0; i < this.myCurrentHighlighters.size(); ++i) {
            Color backgroundColor;
            TextAttributes textAttributes;
            RangeHighlighterEx highlighter = this.myCurrentHighlighters.get(i);
            if (caret != null && highlighter.getLayer() < 1000) {
                return caret;
            }
            if (highlighter.getTargetArea() != HighlighterTargetArea.LINES_IN_RANGE || this.myDocument.getLineNumber(highlighter.getEndOffset()) < this.myDocument.getLineCount() - 1 || (textAttributes = highlighter.getTextAttributes()) == null || (backgroundColor = textAttributes.getBackgroundColor()) == null) continue;
            return backgroundColor;
        }
        return caret;
    }

    private static class PushBackIterator<T>
    implements Iterator<T> {
        private final Iterator<T> myDelegate;
        private T myPushedBack;

        PushBackIterator(Iterator<T> delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.myPushedBack != null || this.myDelegate.hasNext();
        }

        @Override
        public T next() {
            if (this.myPushedBack != null) {
                T result = this.myPushedBack;
                this.myPushedBack = null;
                return result;
            }
            return this.myDelegate.next();
        }

        @Override
        public void remove() {
            if (this.myPushedBack == null) {
                this.myDelegate.remove();
            } else {
                this.myPushedBack = null;
            }
        }

        public void pushBack(T element) {
            assert (this.myPushedBack == null) : "Pushed already: " + this.myPushedBack;
            this.myPushedBack = element;
        }
    }

    private static class LayerComparator
    implements Comparator<RangeHighlighterEx> {
        private static final LayerComparator INSTANCE = new LayerComparator();

        private LayerComparator() {
        }

        @Override
        public int compare(RangeHighlighterEx o1, RangeHighlighterEx o2) {
            int layerDiff = o2.getLayer() - o1.getLayer();
            if (layerDiff != 0) {
                return layerDiff;
            }
            int o1Length = o1.getAffectedAreaEndOffset() - o1.getAffectedAreaStartOffset();
            int o2Length = o2.getAffectedAreaEndOffset() - o2.getAffectedAreaStartOffset();
            return o1Length - o2Length;
        }
    }

    private class HighlighterSweep {
        private RangeHighlighterEx myNextHighlighter;
        private final PushBackIterator<RangeHighlighterEx> myIterator;
        private final DisposableIterator<RangeHighlighterEx> myDisposableIterator;

        private HighlighterSweep(MarkupModelEx markupModel, int start, int end) {
            if (markupModel == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/IterationState$HighlighterSweep", "<init>"));
            }
            this.myDisposableIterator = markupModel.overlappingIterator(start, end);
            this.myIterator = new PushBackIterator<RangeHighlighterEx>(this.myDisposableIterator);
            int skipped = 0;
            while (this.myIterator.hasNext()) {
                RangeHighlighterEx highlighter = this.myIterator.next();
                if (!IterationState.this.skipHighlighter(highlighter)) {
                    this.myNextHighlighter = highlighter;
                    break;
                }
                ++skipped;
            }
            if (skipped > Math.min(1000, markupModel.getDocument().getTextLength())) {
                boolean i = false;
            }
        }

        private void advance() {
            if (this.myNextHighlighter != null) {
                if (this.myNextHighlighter.getAffectedAreaStartOffset() > IterationState.this.myStartOffset) {
                    return;
                }
                IterationState.this.myCurrentHighlighters.add(this.myNextHighlighter);
                this.myNextHighlighter = null;
            }
            while (this.myIterator.hasNext()) {
                RangeHighlighterEx highlighter = this.myIterator.next();
                if (IterationState.this.skipHighlighter(highlighter)) continue;
                if (highlighter.getAffectedAreaStartOffset() > IterationState.this.myStartOffset) {
                    this.myNextHighlighter = highlighter;
                    break;
                }
                IterationState.this.myCurrentHighlighters.add(highlighter);
            }
        }

        private int getMinSegmentHighlighterEnd() {
            if (this.myNextHighlighter != null) {
                return this.myNextHighlighter.getAffectedAreaStartOffset();
            }
            return Integer.MAX_VALUE;
        }

        public void dispose() {
            this.myDisposableIterator.dispose();
        }
    }
}

