/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FoldRegionsTree {
    public static final boolean DEBUG = Boolean.getBoolean("idea.editor.debug.folding");
    private FoldRegion[] myCachedVisible;
    private FoldRegion[] myCachedTopLevelRegions;
    private int[] myCachedEndOffsets;
    private int[] myCachedStartOffsets;
    private int[] myCachedFoldedLines;
    int myCachedLastIndex = -1;
    private ArrayList<FoldRegion> myRegions = ContainerUtil.newArrayList();
    private static final Comparator<FoldRegion> BY_END_OFFSET = new Comparator<FoldRegion>(){

        @Override
        public int compare(FoldRegion r1, FoldRegion r2) {
            int end2;
            int end1 = r1.getEndOffset();
            if (end1 < (end2 = r2.getEndOffset())) {
                return -1;
            }
            if (end1 > end2) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<? super FoldRegion> BY_END_OFFSET_REVERSE = Collections.reverseOrder(BY_END_OFFSET);

    FoldRegionsTree() {
    }

    void clear() {
        this.myCachedVisible = null;
        this.myCachedTopLevelRegions = null;
        this.myCachedEndOffsets = null;
        this.myCachedStartOffsets = null;
        this.myCachedFoldedLines = null;
        if (this.myRegions != null) {
            for (FoldRegion region : this.myRegions) {
                region.dispose();
            }
        }
        this.myRegions = new ArrayList();
    }

    private boolean isFoldingEnabledAndUpToDate() {
        return this.isFoldingEnabled() && this.myCachedVisible != null;
    }

    protected abstract boolean isFoldingEnabled();

    protected abstract boolean isBatchFoldingProcessing();

    void rebuild() {
        ArrayList<FoldRegion> topLevels = new ArrayList<FoldRegion>(this.myRegions.size() / 2);
        ArrayList<FoldRegion> visible = new ArrayList<FoldRegion>(this.myRegions.size());
        FoldRegion[] regions = FoldRegionsTree.toFoldArray(this.myRegions);
        FoldRegion currentCollapsed = null;
        for (FoldRegion region : regions) {
            if (!region.isValid()) continue;
            if (currentCollapsed == null || !FoldRegionsTree.contains(currentCollapsed, region)) {
                visible.add(region);
            }
            if (region.isExpanded() || currentCollapsed != null && currentCollapsed.getEndOffset() >= region.getStartOffset()) continue;
            currentCollapsed = region;
            topLevels.add(region);
        }
        this.myCachedTopLevelRegions = FoldRegionsTree.toFoldArray(topLevels);
        this.myCachedVisible = FoldRegionsTree.toFoldArray(visible);
        Arrays.sort(this.myCachedTopLevelRegions, BY_END_OFFSET);
        Arrays.sort(this.myCachedVisible, BY_END_OFFSET_REVERSE);
        this.updateCachedOffsets();
    }

    @NotNull
    private static FoldRegion[] toFoldArray(@NotNull List<FoldRegion> topLevels) {
        if (topLevels == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/impl/FoldRegionsTree", "toFoldArray"));
        }
        FoldRegion[] foldRegionArray = topLevels.isEmpty() ? FoldRegion.EMPTY_ARRAY : topLevels.toArray(new FoldRegion[topLevels.size()]);
        if (foldRegionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FoldRegionsTree", "toFoldArray"));
        }
        return foldRegionArray;
    }

    void updateCachedOffsets() {
        if (!this.isFoldingEnabled()) {
            return;
        }
        if (this.myCachedVisible == null) {
            this.rebuild();
            return;
        }
        for (FoldRegion foldRegion : this.myCachedVisible) {
            if (foldRegion.isValid()) continue;
            this.rebuild();
            return;
        }
        int length = this.myCachedTopLevelRegions.length;
        if (this.myCachedEndOffsets == null || this.myCachedEndOffsets.length != length) {
            if (length != 0) {
                this.myCachedEndOffsets = new int[length];
                this.myCachedStartOffsets = new int[length];
                this.myCachedFoldedLines = new int[length];
            } else {
                this.myCachedEndOffsets = ArrayUtil.EMPTY_INT_ARRAY;
                this.myCachedStartOffsets = ArrayUtil.EMPTY_INT_ARRAY;
                this.myCachedFoldedLines = ArrayUtil.EMPTY_INT_ARRAY;
            }
        }
        int sum = 0;
        for (int i = 0; i < length; ++i) {
            FoldRegion region = this.myCachedTopLevelRegions[i];
            this.myCachedStartOffsets[i] = region.getStartOffset();
            this.myCachedEndOffsets[i] = region.getEndOffset() - 1;
            Document document = region.getDocument();
            this.myCachedFoldedLines[i] = sum += document.getLineNumber(region.getEndOffset()) - document.getLineNumber(region.getStartOffset());
        }
    }

    boolean addRegion(FoldRegion range) {
        FoldRegion region;
        int i;
        FoldRegion foldRegion;
        int fastIndex;
        boolean canUseCachedValue = this.myCachedLastIndex >= this.myRegions.size() ? false : this.myCachedLastIndex != -1 && this.isBatchFoldingProcessing() && this.myRegions.get(this.myCachedLastIndex).getStartOffset() <= range.getStartOffset();
        int n = fastIndex = canUseCachedValue ? this.myCachedLastIndex + 1 : Collections.binarySearch(this.myRegions, range, RangeMarker.BY_START_OFFSET);
        if (fastIndex < 0) {
            fastIndex = -fastIndex - 1;
        }
        if (fastIndex < this.myRegions.size() && TextRange.areSegmentsEqual((Segment)(foldRegion = this.myRegions.get(fastIndex)), (Segment)range)) {
            this.removeRegion(foldRegion);
            return this.addRegion(range);
        }
        for (i = fastIndex - 1; i >= 0 && (region = this.myRegions.get(i)).getEndOffset() >= range.getStartOffset(); --i) {
            if (!region.isValid() || !FoldRegionsTree.intersects(region, range)) continue;
            return false;
        }
        for (i = fastIndex; i < this.myRegions.size(); ++i) {
            region = this.myRegions.get(i);
            if (range.getStartOffset() >= region.getStartOffset() && (range.getStartOffset() != region.getStartOffset() || range.getEndOffset() <= region.getEndOffset())) continue;
            for (int j = i + 1; j < this.myRegions.size(); ++j) {
                FoldRegion next = this.myRegions.get(j);
                if (next.getEndOffset() < range.getEndOffset() || !next.isValid()) continue;
                if (next.getStartOffset() >= range.getStartOffset()) break;
                return false;
            }
            this.myCachedLastIndex = i;
            this.myRegions.add(this.myCachedLastIndex, range);
            return true;
        }
        this.myCachedLastIndex = this.myRegions.size();
        this.myRegions.add(this.myCachedLastIndex, range);
        return true;
    }

    @Nullable
    FoldRegion fetchOutermost(int offset) {
        if (!this.isFoldingEnabledAndUpToDate()) {
            return null;
        }
        int[] starts = this.myCachedStartOffsets;
        int[] ends = this.myCachedEndOffsets;
        if (starts == null || ends == null) {
            return null;
        }
        int start = 0;
        int end = ends.length - 1;
        while (start <= end) {
            int i = (start + end) / 2;
            if (offset < starts[i]) {
                end = i - 1;
                continue;
            }
            if (offset > ends[i]) {
                start = i + 1;
                continue;
            }
            if (this.myCachedStartOffsets[i] != this.myCachedTopLevelRegions[i].getStartOffset()) {
                if (DEBUG) assert (false) : "inconsistent cached fold data detected. Start offsets: " + Arrays.toString(this.myCachedStartOffsets) + ", end offsets: " + Arrays.toString(this.myCachedEndOffsets) + ", top regions: " + Arrays.toString(this.myCachedTopLevelRegions) + ", visible regions: " + Arrays.toString(this.myCachedVisible);
                this.rebuild();
                return this.fetchOutermost(offset);
            }
            return this.myCachedTopLevelRegions[i];
        }
        return null;
    }

    FoldRegion[] fetchVisible() {
        if (!this.isFoldingEnabledAndUpToDate()) {
            return FoldRegion.EMPTY_ARRAY;
        }
        return this.myCachedVisible;
    }

    @Nullable
    FoldRegion[] fetchTopLevel() {
        if (!this.isFoldingEnabledAndUpToDate()) {
            return null;
        }
        return this.myCachedTopLevelRegions;
    }

    private static boolean contains(FoldRegion outer, FoldRegion inner) {
        return outer.getStartOffset() < inner.getStartOffset() && outer.getEndOffset() > inner.getStartOffset();
    }

    private static boolean intersects(FoldRegion r1, FoldRegion r2) {
        int s1 = r1.getStartOffset();
        int s2 = r2.getStartOffset();
        int e1 = r1.getEndOffset();
        int e2 = r2.getEndOffset();
        return s1 == s2 && e1 == e2 || s1 < s2 && s2 < e1 && e1 < e2 || s2 < s1 && s1 < e2 && e2 < e1;
    }

    static boolean contains(FoldRegion region, int offset) {
        return region.getStartOffset() < offset && region.getEndOffset() > offset;
    }

    public FoldRegion[] fetchCollapsedAt(int offset) {
        if (!this.isFoldingEnabledAndUpToDate()) {
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> allCollapsed = new ArrayList<FoldRegion>();
        for (FoldRegion region : this.myRegions) {
            if (region.isExpanded() || !FoldRegionsTree.contains(region, offset)) continue;
            allCollapsed.add(region);
        }
        return FoldRegionsTree.toFoldArray(allCollapsed);
    }

    boolean intersectsRegion(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            return true;
        }
        for (FoldRegion region : this.myRegions) {
            boolean contains2;
            boolean contains1 = FoldRegionsTree.contains(region, startOffset);
            if (contains1 == (contains2 = FoldRegionsTree.contains(region, endOffset))) continue;
            return true;
        }
        return false;
    }

    FoldRegion[] fetchAllRegions() {
        if (!this.isFoldingEnabledAndUpToDate()) {
            return FoldRegion.EMPTY_ARRAY;
        }
        return FoldRegionsTree.toFoldArray(this.myRegions);
    }

    void removeRegion(FoldRegion range) {
        this.myRegions.remove(range);
    }

    int getFoldedLinesCountBefore(int offset) {
        int idx = this.getLastTopLevelIndexBefore(offset);
        if (idx == -1) {
            return 0;
        }
        return this.myCachedFoldedLines[idx];
    }

    public int getLastTopLevelIndexBefore(int offset) {
        int[] endOffsets = this.myCachedEndOffsets;
        if (!this.isFoldingEnabledAndUpToDate() || endOffsets == null) {
            return -1;
        }
        int start = 0;
        int end = endOffsets.length - 1;
        while (start <= end) {
            int i = (start + end) / 2;
            if (offset < endOffsets[i]) {
                end = i - 1;
                continue;
            }
            if (offset > endOffsets[i]) {
                start = i + 1;
                continue;
            }
            return i;
        }
        return end;
    }
}

