/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.util.Key;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterCache {
    private static final Key<WeakReference<EditorHighlighter>> ourSomeEditorSyntaxHighlighter = Key.create((String)"some editor highlighter");

    private EditorHighlighterCache() {
    }

    public static void rememberEditorHighlighterForCachesOptimization(Document document, @NotNull EditorHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/impl/EditorHighlighterCache", "rememberEditorHighlighterForCachesOptimization"));
        }
        document.putUserData(ourSomeEditorSyntaxHighlighter, new WeakReference<EditorHighlighter>(highlighter));
    }

    @Nullable
    public static EditorHighlighter getEditorHighlighterForCachesBuilding(Document document) {
        if (document == null) {
            return null;
        }
        WeakReference editorHighlighterWeakReference = (WeakReference)document.getUserData(ourSomeEditorSyntaxHighlighter);
        EditorHighlighter someEditorHighlighter = (EditorHighlighter)SoftReference.dereference((Reference)editorHighlighterWeakReference);
        if (someEditorHighlighter instanceof LexerEditorHighlighter && ((LexerEditorHighlighter)someEditorHighlighter).isValid()) {
            return someEditorHighlighter;
        }
        document.putUserData(ourSomeEditorSyntaxHighlighter, null);
        return null;
    }
}

