/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;

public class LimitedRangeHighlighterIterator
implements HighlighterIterator {
    private final HighlighterIterator myOriginal;
    private final int myStartOffset;
    private final int myEndOffset;

    public LimitedRangeHighlighterIterator(HighlighterIterator original, int startOffset, int endOffset) {
        this.myOriginal = original;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    public TextAttributes getTextAttributes() {
        return this.myOriginal.getTextAttributes();
    }

    public int getStart() {
        return Math.max(this.myOriginal.getStart(), this.myStartOffset);
    }

    public int getEnd() {
        return Math.min(this.myOriginal.getEnd(), this.myEndOffset);
    }

    public IElementType getTokenType() {
        return this.myOriginal.getTokenType();
    }

    public void advance() {
        this.myOriginal.advance();
    }

    public void retreat() {
        this.myOriginal.retreat();
    }

    public boolean atEnd() {
        return this.myOriginal.atEnd() || this.myOriginal.getStart() >= this.myEndOffset || this.myOriginal.getEnd() <= this.myStartOffset;
    }

    public Document getDocument() {
        return this.myOriginal.getDocument();
    }
}

