/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LexerEditorHighlighter
implements EditorHighlighter,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.ex.util.LexerEditorHighlighter");
    private HighlighterClient myEditor;
    private final Lexer myLexer;
    private final Map<IElementType, TextAttributes> myAttributesMap;
    private final SegmentArrayWithData mySegments;
    private final SyntaxHighlighter myHighlighter;
    private EditorColorsScheme myScheme;
    private final int myInitialState;

    public LexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "<init>"));
        }
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "<init>"));
        }
        this.myAttributesMap = new HashMap<IElementType, TextAttributes>();
        this.myScheme = scheme;
        this.myLexer = highlighter.getHighlightingLexer();
        this.myLexer.start(ArrayUtil.EMPTY_CHAR_SEQUENCE);
        this.myInitialState = this.myLexer.getState();
        this.myHighlighter = highlighter;
        this.mySegments = this.createSegments();
    }

    protected SegmentArrayWithData createSegments() {
        return new SegmentArrayWithData();
    }

    public boolean isPlain() {
        return this.myHighlighter instanceof PlainSyntaxHighlighter;
    }

    @Nullable
    protected final Document getDocument() {
        return this.myEditor != null ? this.myEditor.getDocument() : null;
    }

    public final synchronized boolean checkContentIsEqualTo(CharSequence sequence) {
        Document document = this.getDocument();
        if (document != null) {
            return document.getText().equals(((Object)sequence).toString());
        }
        return false;
    }

    public EditorColorsScheme getScheme() {
        return this.myScheme;
    }

    protected Lexer getLexer() {
        return this.myLexer;
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "setEditor"));
        }
        LOG.assertTrue(this.myEditor == null, (Object)"Highlighters cannot be reused with different editors");
        this.myEditor = editor;
    }

    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "setColorScheme"));
        }
        this.myScheme = scheme;
        this.myAttributesMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int latestValidOffset;
        LexerEditorHighlighter lexerEditorHighlighter = this;
        // MONITORENTER : lexerEditorHighlighter
        Document document = this.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            ((DocumentEx)document).setInBulkUpdate(false);
        }
        if (this.mySegments.getSegmentCount() == 0 && document != null && document.getTextLength() > 0) {
            this.doSetText(document.getCharsSequence());
        }
        HighlighterIteratorImpl highlighterIteratorImpl = new HighlighterIteratorImpl(startOffset <= (latestValidOffset = this.mySegments.getLastValidOffset()) ? startOffset : latestValidOffset);
        // MONITOREXIT : lexerEditorHighlighter
        if (highlighterIteratorImpl != null) return highlighterIteratorImpl;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "createIterator"));
    }

    private int packData(IElementType tokenType, int state) {
        short idx = tokenType.getIndex();
        return state == this.myInitialState ? idx : -idx;
    }

    public boolean isValid() {
        Project project = this.myEditor.getProject();
        return project != null && !project.isDisposed();
    }

    private static boolean isInitialState(int data) {
        return data >= 0;
    }

    protected static IElementType unpackToken(int data) {
        return IElementType.find((short)((short)Math.abs(data)));
    }

    public synchronized void documentChanged(DocumentEvent e) {
        int oldStartIndex;
        int data;
        int startIndex;
        Document document = e.getDocument();
        if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
            this.mySegments.removeAll();
            return;
        }
        if (this.mySegments.getSegmentCount() == 0) {
            this.setText(document.getCharsSequence());
            return;
        }
        CharSequence text = document.getCharsSequence();
        int oldStartOffset = e.getOffset();
        try {
            int segmentIndex = this.mySegments.findSegmentIndex(oldStartOffset) - 2;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IndexOutOfBoundsException(ex.getMessage() + " Lexer: " + this.myLexer);
        }
        for (startIndex = oldStartIndex = Math.max(0, segmentIndex); !LexerEditorHighlighter.isInitialState(data = this.mySegments.getSegmentData(startIndex)) && startIndex != 0; --startIndex) {
        }
        int startOffset = this.mySegments.getSegmentStart(startIndex);
        int newEndOffset = e.getOffset() + e.getNewLength();
        this.myLexer.start(text, startOffset, text.length(), this.myInitialState);
        int lastTokenStart = -1;
        int lastLexerState = -1;
        while (this.myLexer.getTokenType() != null && startIndex < oldStartIndex) {
            int tokenStart = this.myLexer.getTokenStart();
            int lexerState = this.myLexer.getState();
            if (tokenStart == lastTokenStart && lexerState == lastLexerState) {
                throw new IllegalStateException("Error while updating lexer: " + e + " document text: " + document.getText());
            }
            int tokenEnd = this.myLexer.getTokenEnd();
            data = this.packData(this.myLexer.getTokenType(), lexerState);
            if (this.mySegments.getSegmentStart(startIndex) != tokenStart || this.mySegments.getSegmentEnd(startIndex) != tokenEnd || this.mySegments.getSegmentData(startIndex) != data) break;
            ++startIndex;
            this.myLexer.advance();
            lastTokenStart = tokenStart;
            lastLexerState = lexerState;
        }
        startOffset = this.mySegments.getSegmentStart(startIndex);
        int repaintEnd = -1;
        int insertSegmentCount = 0;
        int oldEndIndex = -1;
        SegmentArrayWithData insertSegments = new SegmentArrayWithData();
        while (this.myLexer.getTokenType() != null) {
            int shiftedTokenStart;
            int index;
            int tokenStart = this.myLexer.getTokenStart();
            int lexerState = this.myLexer.getState();
            if (tokenStart == lastTokenStart && lexerState == lastLexerState) {
                throw new IllegalStateException("Error while updating lexer: " + e + " document text: " + document.getText());
            }
            lastTokenStart = tokenStart;
            lastLexerState = lexerState;
            int tokenEnd = this.myLexer.getTokenEnd();
            data = this.packData(this.myLexer.getTokenType(), lexerState);
            if (tokenStart >= newEndOffset && lexerState == this.myInitialState && this.mySegments.getSegmentStart(index = this.mySegments.findSegmentIndex(shiftedTokenStart = tokenStart - e.getNewLength() + e.getOldLength())) == shiftedTokenStart && this.mySegments.getSegmentData(index) == data) {
                repaintEnd = tokenStart;
                oldEndIndex = index;
                break;
            }
            insertSegments.setElementAt(insertSegmentCount, tokenStart, tokenEnd, data);
            ++insertSegmentCount;
            this.myLexer.advance();
        }
        int shift = e.getNewLength() - e.getOldLength();
        if (repaintEnd > 0) {
            while (insertSegmentCount > 0 && oldEndIndex > startIndex && LexerEditorHighlighter.segmentsEqual(this.mySegments, oldEndIndex - 1, insertSegments, insertSegmentCount - 1, shift)) {
                --oldEndIndex;
                repaintEnd = insertSegments.getSegmentStart(--insertSegmentCount);
                insertSegments.remove(insertSegmentCount, insertSegmentCount + 1);
            }
        }
        if (repaintEnd == -1) {
            repaintEnd = text.length();
        }
        if (oldEndIndex < 0) {
            oldEndIndex = this.mySegments.getSegmentCount();
        }
        this.mySegments.shiftSegments(oldEndIndex, shift);
        this.mySegments.replace(startIndex, oldEndIndex, insertSegments);
        if (insertSegmentCount == 0 || oldEndIndex == startIndex + 1 && insertSegmentCount == 1 && data == this.mySegments.getSegmentData(startIndex)) {
            return;
        }
        this.myEditor.repaint(startOffset, repaintEnd);
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    @Override
    public int getPriority() {
        return 80;
    }

    private static boolean segmentsEqual(SegmentArrayWithData a1, int idx1, SegmentArrayWithData a2, int idx2, int offsetShift) {
        return a1.getSegmentStart(idx1) + offsetShift == a2.getSegmentStart(idx2) && a1.getSegmentEnd(idx1) + offsetShift == a2.getSegmentEnd(idx2) && a1.getSegmentData(idx1) == a2.getSegmentData(idx2);
    }

    public HighlighterClient getClient() {
        return this.myEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "setText"));
        }
        LexerEditorHighlighter lexerEditorHighlighter = this;
        synchronized (lexerEditorHighlighter) {
            this.doSetText(text);
        }
    }

    private void doSetText(final CharSequence text) {
        IElementType tokenType;
        TokenProcessor processor = this.createTokenProcessor(0);
        this.myLexer.start(text, 0, text.length(), this.myInitialState);
        this.mySegments.removeAll();
        int i = 0;
        while ((tokenType = this.myLexer.getTokenType()) != null) {
            int data = this.packData(tokenType, this.myLexer.getState());
            processor.addToken(i, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), data, tokenType);
            ++i;
            this.myLexer.advance();
        }
        processor.finish();
        if (this.myEditor != null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new DumbAwareRunnable(){

                public void run() {
                    LexerEditorHighlighter.this.myEditor.repaint(0, text.length());
                }
            });
        }
    }

    protected TokenProcessor createTokenProcessor(int startIndex) {
        return new TokenProcessor();
    }

    protected SyntaxHighlighter getSyntaxHighlighter() {
        return this.myHighlighter;
    }

    private TextAttributes getAttributes(IElementType tokenType) {
        TextAttributes attrs = this.myAttributesMap.get(tokenType);
        if (attrs == null) {
            attrs = this.convertAttributes(this.myHighlighter.getTokenHighlights(tokenType));
            this.myAttributesMap.put(tokenType, attrs);
        }
        return attrs;
    }

    protected TextAttributes convertAttributes(@NotNull TextAttributesKey[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter", "convertAttributes"));
        }
        TextAttributes attrs = this.myScheme.getAttributes(HighlighterColors.TEXT);
        for (TextAttributesKey key : keys) {
            TextAttributes attrs2 = this.myScheme.getAttributes(key);
            if (attrs2 == null) continue;
            attrs = TextAttributes.merge((TextAttributes)attrs, (TextAttributes)attrs2);
        }
        return attrs;
    }

    public SegmentArrayWithData getSegments() {
        return this.mySegments;
    }

    public class HighlighterIteratorImpl
    implements HighlighterIterator {
        private int mySegmentIndex = 0;

        HighlighterIteratorImpl(int startOffset) {
            this.mySegmentIndex = LexerEditorHighlighter.this.mySegments.findSegmentIndex(startOffset);
        }

        public int currentIndex() {
            return this.mySegmentIndex;
        }

        public TextAttributes getTextAttributes() {
            return LexerEditorHighlighter.this.getAttributes(this.getTokenType());
        }

        public int getStart() {
            return LexerEditorHighlighter.this.mySegments.getSegmentStart(this.mySegmentIndex);
        }

        public int getEnd() {
            return LexerEditorHighlighter.this.mySegments.getSegmentEnd(this.mySegmentIndex);
        }

        public IElementType getTokenType() {
            return LexerEditorHighlighter.unpackToken(LexerEditorHighlighter.this.mySegments.getSegmentData(this.mySegmentIndex));
        }

        public void advance() {
            ++this.mySegmentIndex;
        }

        public void retreat() {
            --this.mySegmentIndex;
        }

        public boolean atEnd() {
            return this.mySegmentIndex >= LexerEditorHighlighter.this.mySegments.getSegmentCount() || this.mySegmentIndex < 0;
        }

        public Document getDocument() {
            return LexerEditorHighlighter.this.getDocument();
        }
    }

    protected class TokenProcessor {
        protected TokenProcessor() {
        }

        public void addToken(int i, int startOffset, int endOffset, int data, IElementType tokenType) {
            LexerEditorHighlighter.this.mySegments.setElementAt(i, startOffset, endOffset, data);
        }

        public void finish() {
        }
    }
}

