/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorSettingsExternalizable
implements NamedJDOMExternalizable,
ExportableApplicationComponent,
Cloneable {
    private static final String COMPOSITE_PROPERTY_SEPARATOR = ":";
    private final Set<SoftWrapAppliancePlaces> myPlacesToUseSoftWraps = EnumSet.noneOf(SoftWrapAppliancePlaces.class);
    private OptionSet myOptions = new OptionSet();
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);
    private int myBlockIndent;
    private int myAdditionalLinesCount = 10;
    private int myAdditinalColumnsCount = 20;
    private boolean myLineMarkerAreaShown = true;
    @NonNls
    public static final String STRIP_TRAILING_SPACES_NONE = "None";
    @NonNls
    public static final String STRIP_TRAILING_SPACES_CHANGED = "Changed";
    @NonNls
    public static final String STRIP_TRAILING_SPACES_WHOLE = "Whole";
    @NonNls
    public static final String DEFAULT_FONT_NAME = "Courier";

    public static EditorSettingsExternalizable getInstance() {
        Application app = ApplicationManager.getApplication();
        if (app.isDisposed()) {
            return new EditorSettingsExternalizable();
        }
        return (EditorSettingsExternalizable)app.getComponent(EditorSettingsExternalizable.class);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this.myOptions, (Element)element);
        this.parseRawSoftWraps();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this.myOptions, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DefaultJDOMExternalizer.JDOMFilter(){

            public boolean isAccept(@NotNull Field field) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/ex/EditorSettingsExternalizable$1", "isAccept"));
                }
                return !field.getName().equals("IS_NATIVE2ASCII_FOR_PROPERTIES_FILES") && !field.getName().equals("DEFAULT_PROPERTIES_FILES_CHARSET_NAME");
            }
        });
    }

    private void parseRawSoftWraps() {
        String[] placeNames;
        if (this.myOptions.USE_SOFT_WRAPS == null || this.myOptions.USE_SOFT_WRAPS.isEmpty()) {
            return;
        }
        for (String placeName : placeNames = this.myOptions.USE_SOFT_WRAPS.split(COMPOSITE_PROPERTY_SEPARATOR)) {
            try {
                SoftWrapAppliancePlaces place = SoftWrapAppliancePlaces.valueOf(placeName);
                if (place == SoftWrapAppliancePlaces.VCS_DIFF) continue;
                this.myPlacesToUseSoftWraps.add(place);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        this.storeRawSoftWraps();
    }

    private void storeRawSoftWraps() {
        StringBuilder buffer = new StringBuilder();
        for (SoftWrapAppliancePlaces placeToStore : this.myPlacesToUseSoftWraps) {
            buffer.append((Object)placeToStore).append(COMPOSITE_PROPERTY_SEPARATOR);
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        this.myOptions.USE_SOFT_WRAPS = buffer.toString();
    }

    public String getExternalFileName() {
        return "editor";
    }

    public OptionSet getOptions() {
        return this.myOptions;
    }

    public boolean isRightMarginShown() {
        return this.myOptions.IS_RIGHT_MARGIN_SHOWN;
    }

    public void setRightMarginShown(boolean val) {
        this.myOptions.IS_RIGHT_MARGIN_SHOWN = val;
    }

    public boolean isLineNumbersShown() {
        return this.myOptions.ARE_LINE_NUMBERS_SHOWN;
    }

    public void setLineNumbersShown(boolean val) {
        this.myOptions.ARE_LINE_NUMBERS_SHOWN = val;
    }

    public int getAdditionalLinesCount() {
        return this.myAdditionalLinesCount;
    }

    public void setAdditionalLinesCount(int additionalLinesCount) {
        this.myAdditionalLinesCount = additionalLinesCount;
    }

    public int getAdditinalColumnsCount() {
        return this.myAdditinalColumnsCount;
    }

    public void setAdditionalColumnsCount(int additinalColumnsCount) {
        this.myAdditinalColumnsCount = additinalColumnsCount;
    }

    public boolean isLineMarkerAreaShown() {
        return this.myLineMarkerAreaShown;
    }

    public void setLineMarkerAreaShown(boolean lineMarkerAreaShown) {
        this.myLineMarkerAreaShown = lineMarkerAreaShown;
    }

    public boolean isFoldingOutlineShown() {
        return this.myOptions.IS_FOLDING_OUTLINE_SHOWN;
    }

    public void setFoldingOutlineShown(boolean val) {
        this.myOptions.IS_FOLDING_OUTLINE_SHOWN = val;
    }

    public boolean isBlockCursor() {
        return this.myOptions.IS_BLOCK_CURSOR;
    }

    public void setBlockCursor(boolean val) {
        this.myOptions.IS_BLOCK_CURSOR = val;
    }

    public int getBlockIndent() {
        return this.myBlockIndent;
    }

    public void setBlockIndent(int blockIndent) {
        this.myBlockIndent = blockIndent;
    }

    public boolean isSmartHome() {
        return this.myOptions.SMART_HOME;
    }

    public void setSmartHome(boolean val) {
        this.myOptions.SMART_HOME = val;
    }

    public boolean isUseSoftWraps() {
        return this.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    public boolean isUseSoftWraps(@NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/ex/EditorSettingsExternalizable", "isUseSoftWraps"));
        }
        if (this.myPlacesToUseSoftWraps.contains((Object)place)) {
            return true;
        }
        if (place == SoftWrapAppliancePlaces.VCS_DIFF) {
            return this.myPlacesToUseSoftWraps.contains((Object)SoftWrapAppliancePlaces.MAIN_EDITOR);
        }
        return false;
    }

    public void setUseSoftWraps(boolean use) {
        this.setUseSoftWraps(use, SoftWrapAppliancePlaces.MAIN_EDITOR);
    }

    public void setUseSoftWraps(boolean use, @NotNull SoftWrapAppliancePlaces place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/editor/ex/EditorSettingsExternalizable", "setUseSoftWraps"));
        }
        boolean update = use ^ this.myPlacesToUseSoftWraps.contains((Object)place);
        if (!update) {
            return;
        }
        if (use) {
            this.myPlacesToUseSoftWraps.add(place);
        } else {
            this.myPlacesToUseSoftWraps.remove((Object)place);
        }
        this.storeRawSoftWraps();
    }

    public boolean isUseCustomSoftWrapIndent() {
        return this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT;
    }

    public void setUseCustomSoftWrapIndent(boolean use) {
        this.myOptions.USE_CUSTOM_SOFT_WRAP_INDENT = use;
    }

    public int getCustomSoftWrapIndent() {
        return this.myOptions.CUSTOM_SOFT_WRAP_INDENT;
    }

    public void setCustomSoftWrapIndent(int indent) {
        this.myOptions.CUSTOM_SOFT_WRAP_INDENT = indent;
    }

    public boolean isVirtualSpace() {
        return this.myOptions.IS_VIRTUAL_SPACE;
    }

    public void setVirtualSpace(boolean val) {
        this.myOptions.IS_VIRTUAL_SPACE = val;
    }

    public boolean isCaretInsideTabs() {
        return this.myOptions.IS_CARET_INSIDE_TABS;
    }

    public void setCaretInsideTabs(boolean val) {
        this.myOptions.IS_CARET_INSIDE_TABS = val;
    }

    public boolean isBlinkCaret() {
        return this.myOptions.IS_CARET_BLINKING;
    }

    public void setBlinkCaret(boolean blinkCaret) {
        this.myOptions.IS_CARET_BLINKING = blinkCaret;
    }

    public int getBlinkPeriod() {
        return this.myOptions.CARET_BLINKING_PERIOD;
    }

    public void setBlinkPeriod(int blinkInterval) {
        this.myOptions.CARET_BLINKING_PERIOD = blinkInterval;
    }

    public boolean isEnsureNewLineAtEOF() {
        return this.myOptions.IS_ENSURE_NEWLINE_AT_EOF;
    }

    public void setEnsureNewLineAtEOF(boolean ensure) {
        this.myOptions.IS_ENSURE_NEWLINE_AT_EOF = ensure;
    }

    @StripTrailingSpaces
    public String getStripTrailingSpaces() {
        return this.myOptions.STRIP_TRAILING_SPACES;
    }

    public void setStripTrailingSpaces(@StripTrailingSpaces String stripTrailingSpaces) {
        this.myOptions.STRIP_TRAILING_SPACES = stripTrailingSpaces;
    }

    public boolean isShowQuickDocOnMouseOverElement() {
        return this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT;
    }

    public void setShowQuickDocOnMouseOverElement(boolean show) {
        this.myOptions.SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = show;
    }

    public long getQuickDocOnMouseOverElementDelayMillis() {
        return this.myOptions.QUICK_DOC_ON_MOUSE_OVER_DELAY_MS;
    }

    public void setQuickDocOnMouseOverElementDelayMillis(long delay) throws IllegalArgumentException {
        if (delay <= 0L) {
            throw new IllegalArgumentException(String.format("Non-positive delay for the 'show quick doc on mouse over element' value detected! Expected positive value but got %d", delay));
        }
        this.myOptions.QUICK_DOC_ON_MOUSE_OVER_DELAY_MS = delay;
    }

    public boolean isShowIntentionBulb() {
        return this.myOptions.SHOW_INTENTION_BULB;
    }

    public void setShowIntentionBulb(boolean show) {
        this.myOptions.SHOW_INTENTION_BULB = show;
    }

    public boolean isRefrainFromScrolling() {
        return this.myOptions.REFRAIN_FROM_SCROLLING;
    }

    public void setRefrainFromScrolling(boolean b) {
        this.myOptions.REFRAIN_FROM_SCROLLING = b;
    }

    public Object clone() {
        EditorSettingsExternalizable copy = new EditorSettingsExternalizable();
        copy.myOptions = (OptionSet)this.myOptions.clone();
        copy.myBlockIndent = this.myBlockIndent;
        copy.myAdditionalLinesCount = this.myAdditionalLinesCount;
        copy.myAdditinalColumnsCount = this.myAdditinalColumnsCount;
        copy.myLineMarkerAreaShown = this.myLineMarkerAreaShown;
        return copy;
    }

    @NotNull
    public String getComponentName() {
        if ("EditorSettings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/EditorSettingsExternalizable", "getComponentName"));
        }
        return "EditorSettings";
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/EditorSettingsExternalizable", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = OptionsBundle.message((String)"options.editor.settings.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/EditorSettingsExternalizable", "getPresentableName"));
        }
        return string;
    }

    public boolean isWhitespacesShown() {
        return this.myOptions.IS_WHITESPACES_SHOWN;
    }

    public void setWhitespacesShown(boolean val) {
        this.myOptions.IS_WHITESPACES_SHOWN = val;
    }

    public boolean isAllSoftWrapsShown() {
        return this.myOptions.IS_ALL_SOFTWRAPS_SHOWN;
    }

    public void setAllSoftwrapsShown(boolean val) {
        this.myOptions.IS_ALL_SOFTWRAPS_SHOWN = val;
    }

    public boolean isIndentGuidesShown() {
        return this.myOptions.IS_INDENT_GUIDES_SHOWN;
    }

    public void setIndentGuidesShown(boolean val) {
        this.myOptions.IS_INDENT_GUIDES_SHOWN = val;
    }

    public boolean isSmoothScrolling() {
        return this.myOptions.IS_ANIMATED_SCROLLING;
    }

    public void setSmoothScrolling(boolean val) {
        this.myOptions.IS_ANIMATED_SCROLLING = val;
    }

    public boolean isCamelWords() {
        return this.myOptions.IS_CAMEL_WORDS;
    }

    public void setCamelWords(boolean val) {
        this.myOptions.IS_CAMEL_WORDS = val;
    }

    public boolean isAdditionalPageAtBottom() {
        return this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM;
    }

    public void setAdditionalPageAtBottom(boolean val) {
        this.myOptions.ADDITIONAL_PAGE_AT_BOTTOM = val;
    }

    public boolean isDndEnabled() {
        return this.myOptions.IS_DND_ENABLED;
    }

    public void setDndEnabled(boolean val) {
        this.myOptions.IS_DND_ENABLED = val;
    }

    public boolean isWheelFontChangeEnabled() {
        return this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED;
    }

    public void setWheelFontChangeEnabled(boolean val) {
        this.myOptions.IS_WHEEL_FONTCHANGE_ENABLED = val;
    }

    public boolean isMouseClickSelectionHonorsCamelWords() {
        return this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS;
    }

    public void setMouseClickSelectionHonorsCamelWords(boolean val) {
        this.myOptions.IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = val;
    }

    public boolean isVariableInplaceRenameEnabled() {
        return this.myOptions.RENAME_VARIABLES_INPLACE;
    }

    public void setVariableInplaceRenameEnabled(boolean val) {
        this.myOptions.RENAME_VARIABLES_INPLACE = val;
    }

    public boolean isPreselectRename() {
        return this.myOptions.PRESELECT_RENAME;
    }

    public void setPreselectRename(boolean val) {
        this.myOptions.PRESELECT_RENAME = val;
    }

    public boolean migrateCharsetSettingsTo(EncodingManager encodingManager) {
        if (this.myOptions.DEFAULT_PROPERTIES_FILES_CHARSET_NAME != null) {
            Charset charset = CharsetToolkit.forName((String)this.myOptions.DEFAULT_PROPERTIES_FILES_CHARSET_NAME);
            if (charset != null) {
                encodingManager.setDefaultCharsetForPropertiesFiles(null, charset);
                encodingManager.setNative2AsciiForPropertiesFiles(null, this.myOptions.IS_NATIVE2ASCII_FOR_PROPERTIES_FILES);
            }
            return true;
        }
        return false;
    }

    static @interface StripTrailingSpaces {
    }

    public static class OptionSet
    implements Cloneable {
        public String LINE_SEPARATOR;
        public String USE_SOFT_WRAPS;
        public boolean USE_CUSTOM_SOFT_WRAP_INDENT = false;
        public int CUSTOM_SOFT_WRAP_INDENT = 0;
        public boolean IS_VIRTUAL_SPACE = false;
        public boolean IS_CARET_INSIDE_TABS;
        @NonNls
        public String STRIP_TRAILING_SPACES = "Changed";
        public boolean IS_ENSURE_NEWLINE_AT_EOF = false;
        public boolean SHOW_QUICK_DOC_ON_MOUSE_OVER_ELEMENT = false;
        public long QUICK_DOC_ON_MOUSE_OVER_DELAY_MS = 500L;
        public boolean SHOW_INTENTION_BULB = true;
        public boolean IS_CARET_BLINKING = true;
        public int CARET_BLINKING_PERIOD = 500;
        public boolean IS_RIGHT_MARGIN_SHOWN = true;
        public boolean ARE_LINE_NUMBERS_SHOWN = false;
        public boolean IS_FOLDING_OUTLINE_SHOWN = true;
        public boolean SMART_HOME = true;
        public boolean IS_BLOCK_CURSOR = false;
        public boolean IS_WHITESPACES_SHOWN = false;
        public boolean IS_ALL_SOFTWRAPS_SHOWN = false;
        public boolean IS_INDENT_GUIDES_SHOWN = true;
        public boolean IS_ANIMATED_SCROLLING = true;
        public boolean IS_CAMEL_WORDS = false;
        public boolean ADDITIONAL_PAGE_AT_BOTTOM = false;
        public boolean IS_DND_ENABLED = true;
        public boolean IS_WHEEL_FONTCHANGE_ENABLED = false;
        public boolean IS_MOUSE_CLICK_SELECTION_HONORS_CAMEL_WORDS = true;
        @Deprecated
        public boolean IS_NATIVE2ASCII_FOR_PROPERTIES_FILES;
        @Deprecated
        public String DEFAULT_PROPERTIES_FILES_CHARSET_NAME;
        public boolean RENAME_VARIABLES_INPLACE = true;
        public boolean PRESELECT_RENAME = true;
        public boolean REFRAIN_FROM_SCROLLING = false;
        public boolean SHOW_REFORMAT_DIALOG = true;
        public boolean SHOW_OPIMIZE_IMPORTS_DIALOG = true;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

