/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.DumbAwareAction;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ScrollToTheEndToolbarAction
extends DumbAwareAction {
    private final Editor myEditor;

    public ScrollToTheEndToolbarAction(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/editor/actions/ScrollToTheEndToolbarAction", "<init>"));
        }
        this.myEditor = editor;
        String message = ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]);
        this.getTemplatePresentation().setDescription(message);
        this.getTemplatePresentation().setText(message);
        this.getTemplatePresentation().setIcon(AllIcons.RunConfigurations.Scroll_down);
    }

    public void update(AnActionEvent e) {
        Document document = this.myEditor.getDocument();
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        Dimension size = this.myEditor.getContentComponent().getSize();
        boolean isEndVisible = visibleArea.y + visibleArea.height >= size.height;
        boolean isOnLastLine = document.getLineNumber(caretOffset) == document.getLineCount() - 1;
        e.getPresentation().setEnabled(!isEndVisible || !isOnLastLine);
    }

    public void actionPerformed(AnActionEvent e) {
        EditorUtil.scrollToTheEnd(this.myEditor);
    }
}

